/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.ext.xerces.util;

import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;

public class DatatypeMessageFormatter {
    private static final String BASE_NAME = "org.apache.jena.ext.xerces.impl.msg.DatatypeMessages";
    private static Map<String, String> messageFormats = DatatypeMessageFormatter.messagesMap();

    public static String formatMessage(Locale locale, String key, Object[] arguments) throws MissingResourceException {
        String fmt = messageFormats.getOrDefault(key, null);
        if (fmt == null) {
            String msg = messageFormats.get("BadMessageKey");
            throw new MissingResourceException(key, msg, key);
        }
        if (arguments == null) {
            String msg = messageFormats.get("FormatFailed");
            throw new MissingResourceException(key, msg, key);
        }
        try {
            String msg = MessageFormat.format(fmt, arguments);
            return msg;
        }
        catch (Exception e2) {
            String msg = messageFormats.get("FormatFailed") + " " + fmt;
            throw new MissingResourceException(key, msg, key);
        }
    }

    private static Map<String, String> messagesMap() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("BadMessageKey", "The error message corresponding to the message key can not be found.");
        map.put("FormatFailed", "An internal error occurred while formatting the following message:\n");
        map.put("FieldCannotBeNull", "{0} cannot be called with 'null' parameter.");
        map.put("UnknownField", "{0} called with an unknown field:{1}");
        map.put("InvalidXGCValue-milli", "Year = {0}, Month = {1}, Day = {2}, Hour = {3}, Minute = {4}, Second = {5}, fractionalSecond = {6}, Timezone = {7} , is not a valid representation of an XML Gregorian Calendar value.");
        map.put("InvalidXGCValue-fractional", "Year = {0}, Month = {1}, Day = {2}, Hour = {3}, Minute = {4}, Second = {5}, fractionalSecond = {6}, Timezone = {7} , is not a valid representation of an XML Gregorian Calendar value.");
        map.put("InvalidXGCFields", "Invalid set of fields set for XMLGregorianCalendar");
        map.put("InvalidFractional", "Invalid value {0} for fractional second.");
        map.put("InvalidXGCRepresentation", "\"{0}\" is not a valid representation of an XML Gregorian Calendar value.");
        map.put("InvalidFieldValue", "Invalid value {0} for {1} field.");
        map.put("NegativeField", "{0} field is negative");
        map.put("AllFieldsNull", "All the fields (javax.xml.datatype.DatatypeConstants.Field) are null.");
        map.put("TooLarge", "{0} value \"{1}\" too large to be supported by this implementation");
        return Map.copyOf(map);
    }
}

