/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.expr;

import java.util.Map;
import org.apache.jena.graph.Node;
import org.apache.jena.sparql.algebra.Op;
import org.apache.jena.sparql.algebra.OpAsQuery;
import org.apache.jena.sparql.core.Substitute;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.engine.ExecutionContext;
import org.apache.jena.sparql.engine.QueryIterator;
import org.apache.jena.sparql.engine.binding.Binding;
import org.apache.jena.sparql.engine.binding.BindingLib;
import org.apache.jena.sparql.engine.iterator.QueryIterSingleton;
import org.apache.jena.sparql.engine.iterator.QueryIteratorCheck;
import org.apache.jena.sparql.engine.main.QC;
import org.apache.jena.sparql.expr.Expr;
import org.apache.jena.sparql.expr.ExprFunction;
import org.apache.jena.sparql.expr.ExprList;
import org.apache.jena.sparql.expr.ExprTransform;
import org.apache.jena.sparql.expr.ExprVisitor;
import org.apache.jena.sparql.expr.NodeValue;
import org.apache.jena.sparql.function.FunctionEnv;
import org.apache.jena.sparql.graph.NodeTransform;
import org.apache.jena.sparql.graph.NodeTransformLib;
import org.apache.jena.sparql.syntax.Element;
import org.apache.jena.sparql.syntax.syntaxtransform.ElementTransformSubst;
import org.apache.jena.sparql.syntax.syntaxtransform.ElementTransformer;
import org.apache.jena.sparql.syntax.syntaxtransform.ExprTransformNodeElement;
import org.apache.jena.sparql.syntax.syntaxtransform.NodeTransformSubst;

public abstract class ExprFunctionOp
extends ExprFunction {
    private final Op op;
    private Op opRun = null;
    private Element element;

    protected ExprFunctionOp(String fName, Element el, Op op) {
        super(fName);
        this.op = op;
        this.element = el;
    }

    @Override
    public Expr getArg(int i) {
        return null;
    }

    @Override
    public boolean isGraphPattern() {
        return true;
    }

    @Override
    public Op getGraphPattern() {
        return this.op;
    }

    public Element getElement() {
        if (this.element == null) {
            this.element = OpAsQuery.asElement(this.op);
        }
        return this.element;
    }

    @Override
    public int numArgs() {
        return 0;
    }

    @Override
    public Expr copySubstitute(Binding binding) {
        Op op2 = Substitute.substitute(this.getGraphPattern(), binding);
        Element elt = this.getElement();
        Element elt2 = null;
        if (elt != null) {
            Map<Var, Node> map = BindingLib.bindingToMap(binding);
            NodeTransformSubst nodeTransform = new NodeTransformSubst(map);
            ElementTransformSubst eltTransform = new ElementTransformSubst(nodeTransform);
            ExprTransformNodeElement exprTransform = new ExprTransformNodeElement(nodeTransform, eltTransform);
            elt2 = ElementTransformer.transform(elt, eltTransform, exprTransform);
        }
        return this.copy(elt2, op2);
    }

    @Override
    public Expr applyNodeTransform(NodeTransform nodeTransform) {
        Op op2 = NodeTransformLib.transform(nodeTransform, this.getGraphPattern());
        Element elt = this.getElement();
        Element elt2 = null;
        if (elt != null) {
            ElementTransformSubst eltTransform = new ElementTransformSubst(nodeTransform);
            ExprTransformNodeElement exprTransform = new ExprTransformNodeElement(nodeTransform, eltTransform);
            elt2 = ElementTransformer.transform(elt, eltTransform, exprTransform);
        }
        return this.copy(elt2, op2);
    }

    protected abstract Expr copy(Element var1, Op var2);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final NodeValue eval(Binding binding, FunctionEnv env) {
        ExecutionContext execCxt = ExecutionContext.fromFunctionEnv(env);
        QueryIterSingleton qIter1 = QueryIterSingleton.create(binding, execCxt);
        QueryIterator qIter = QC.execute(this.op, qIter1, execCxt);
        qIter = QueryIteratorCheck.check(qIter, execCxt);
        try {
            NodeValue nodeValue = this.eval(binding, qIter, env);
            return nodeValue;
        }
        finally {
            qIter.close();
        }
    }

    protected abstract NodeValue eval(Binding var1, QueryIterator var2, FunctionEnv var3);

    public abstract ExprFunctionOp copy(ExprList var1, Op var2);

    public abstract ExprFunctionOp copy(ExprList var1, Element var2);

    @Override
    public void visit(ExprVisitor visitor) {
        visitor.visit(this);
    }

    public Expr apply(ExprTransform transform, ExprList args, Op x) {
        return transform.transform(this, args, x);
    }
}

