/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mime4j.parser;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.LinkedList;
import org.apache.james.mime4j.parser.AbstractContentHandler;
import org.apache.james.mime4j.parser.ContentHandler;
import org.apache.james.mime4j.parser.MimeStreamParser;
import org.apache.james.mime4j.parser.TestHandler;
import org.apache.james.mime4j.stream.BodyDescriptor;
import org.apache.james.mime4j.stream.Field;
import org.apache.james.mime4j.stream.MimeConfig;
import org.apache.james.mime4j.util.ByteSequence;
import org.apache.james.mime4j.util.ContentUtil;
import org.junit.Assert;
import org.junit.Test;

public class MimeStreamParserTest {
    @Test
    public void testBoundaryInEpilogue() throws Exception {
        StringBuilder sb = new StringBuilder();
        sb.append("From: foo@bar.com\r\n");
        sb.append("To: someone@else.com\r\n");
        sb.append("Content-type: multipart/something; boundary=myboundary\r\n");
        sb.append("\r\n");
        sb.append("This is the preamble.\r\n");
        sb.append("--myboundary\r\n");
        sb.append("Content-type: text/plain\r\n");
        sb.append("\r\n");
        sb.append("This is the first body.\r\n");
        sb.append("It's completely meaningless.\r\n");
        sb.append("After this line the body ends.\r\n");
        sb.append("\r\n");
        sb.append("--myboundary--\r\n");
        StringBuilder epilogue = new StringBuilder();
        epilogue.append("Content-type: text/plain\r\n");
        epilogue.append("\r\n");
        epilogue.append("This is actually the epilogue but it looks like a second body.\r\n");
        epilogue.append("Yada yada yada.\r\n");
        epilogue.append("\r\n");
        epilogue.append("--myboundary--\r\n");
        epilogue.append("This is still the epilogue.\r\n");
        sb.append(epilogue.toString());
        ByteArrayInputStream bais = new ByteArrayInputStream(sb.toString().getBytes("US-ASCII"));
        final StringBuilder actual = new StringBuilder();
        MimeStreamParser parser = new MimeStreamParser();
        parser.setContentHandler((ContentHandler)new AbstractContentHandler(){

            public void epilogue(InputStream is) throws IOException {
                int b;
                while ((b = is.read()) != -1) {
                    actual.append((char)b);
                }
            }
        });
        parser.parse((InputStream)bais);
        Assert.assertEquals((Object)epilogue.toString(), (Object)actual.toString());
    }

    @Test
    public void testParseOneLineFields() throws Exception {
        StringBuilder sb = new StringBuilder();
        final LinkedList<String> expected = new LinkedList<String>();
        expected.add("From: foo@abr.com");
        sb.append((String)expected.getLast()).append("\r\n");
        expected.add("Subject: A subject");
        sb.append((String)expected.getLast()).append("\r\n");
        MimeStreamParser parser = new MimeStreamParser();
        parser.setContentHandler((ContentHandler)new AbstractContentHandler(){

            public void field(Field field) {
                Assert.assertEquals(expected.removeFirst(), (Object)MimeStreamParserTest.this.decode(field.getRaw()));
            }
        });
        parser.parse((InputStream)new ByteArrayInputStream(sb.toString().getBytes()));
        Assert.assertEquals((long)0L, (long)expected.size());
    }

    @Test
    public void testCRWithoutLFInHeader() throws Exception {
        StringBuilder sb = new StringBuilder();
        final LinkedList<String> expected = new LinkedList<String>();
        expected.add("The-field: This field\r\rcontains CR:s\r\rnot\r\n\tfollowed by LF");
        sb.append((String)expected.getLast()).append("\r\n");
        MimeStreamParser parser = new MimeStreamParser();
        parser.setContentHandler((ContentHandler)new AbstractContentHandler(){

            public void field(Field field) {
                Assert.assertEquals(expected.removeFirst(), (Object)MimeStreamParserTest.this.decode(field.getRaw()));
            }
        });
        parser.parse((InputStream)new ByteArrayInputStream(sb.toString().getBytes()));
        Assert.assertEquals((long)0L, (long)expected.size());
    }

    @Test
    public void testParseMultiLineFields() throws Exception {
        StringBuilder sb = new StringBuilder();
        final LinkedList<String> expected = new LinkedList<String>();
        expected.add("Received: by netmbx.netmbx.de (/\\==/\\ Smail3.1.28.1)\r\n\tfrom mail.cs.tu-berlin.de with smtp\r\n\tid &lt;m0uWPrO-0004wpC&gt;; Wed, 19 Jun 96 18:12 MES");
        sb.append((String)expected.getLast()).append("\r\n");
        expected.add("Subject: A folded subject\r\n Line 2\r\n\tLine 3");
        sb.append((String)expected.getLast()).append("\r\n");
        MimeStreamParser parser = new MimeStreamParser();
        parser.setContentHandler((ContentHandler)new AbstractContentHandler(){

            public void field(Field field) {
                Assert.assertEquals(expected.removeFirst(), (Object)MimeStreamParserTest.this.decode(field.getRaw()));
            }
        });
        parser.parse((InputStream)new ByteArrayInputStream(sb.toString().getBytes()));
        Assert.assertEquals((long)0L, (long)expected.size());
    }

    @Test
    public void testStop() throws Exception {
        final MimeStreamParser parser = new MimeStreamParser();
        TestHandler handler = new TestHandler(){

            @Override
            public void endHeader() {
                super.endHeader();
                parser.stop();
            }
        };
        parser.setContentHandler((ContentHandler)handler);
        String msg = "Subject: Yada yada\r\nFrom: foo@bar.com\r\n\r\nLine 1\r\nLine 2\r\n";
        String expected = "<message>\r\n<header>\r\n<field>\r\nSubject: Yada yada</field>\r\n<field>\r\nFrom: foo@bar.com</field>\r\n</header>\r\n<body>\r\n</body>\r\n</message>\r\n";
        parser.parse((InputStream)new ByteArrayInputStream(msg.getBytes()));
        String result = handler.sb.toString();
        Assert.assertEquals((Object)expected, (Object)result);
    }

    @Test
    public void testInvalidFields() throws Exception {
        StringBuilder sb = new StringBuilder();
        final LinkedList<String> expected = new LinkedList<String>();
        sb.append("From - foo@abr.com\r\n");
        expected.add("From: some@one.com");
        sb.append((String)expected.getLast()).append("\r\n");
        expected.add("Subject: A subject");
        sb.append((String)expected.getLast()).append("\r\n");
        sb.append("A line which should be ignored\r\n");
        MimeStreamParser parser = new MimeStreamParser();
        parser.setContentHandler((ContentHandler)new AbstractContentHandler(){

            public void field(Field field) {
                Assert.assertEquals(expected.removeFirst(), (Object)MimeStreamParserTest.this.decode(field.getRaw()));
            }
        });
        parser.parse((InputStream)new ByteArrayInputStream(sb.toString().getBytes()));
        Assert.assertEquals((long)0L, (long)expected.size());
    }

    @Test
    public void testEmptyStream() throws Exception {
        final LinkedList<String> expected = new LinkedList<String>();
        expected.add("startMessage");
        expected.add("startHeader");
        expected.add("endHeader");
        expected.add("body");
        expected.add("endMessage");
        MimeStreamParser parser = new MimeStreamParser();
        parser.setContentHandler((ContentHandler)new AbstractContentHandler(){

            public void body(BodyDescriptor bd, InputStream is) {
                Assert.assertEquals(expected.removeFirst(), (Object)"body");
            }

            public void endMultipart() {
                Assert.fail((String)"endMultipart shouldn't be called for empty stream");
            }

            public void endBodyPart() {
                Assert.fail((String)"endBodyPart shouldn't be called for empty stream");
            }

            public void endHeader() {
                Assert.assertEquals(expected.removeFirst(), (Object)"endHeader");
            }

            public void endMessage() {
                Assert.assertEquals(expected.removeFirst(), (Object)"endMessage");
            }

            public void field(Field field) {
                Assert.fail((String)"field shouldn't be called for empty stream");
            }

            public void startMultipart(BodyDescriptor bd) {
                Assert.fail((String)"startMultipart shouldn't be called for empty stream");
            }

            public void startBodyPart() {
                Assert.fail((String)"startBodyPart shouldn't be called for empty stream");
            }

            public void startHeader() {
                Assert.assertEquals(expected.removeFirst(), (Object)"startHeader");
            }

            public void startMessage() {
                Assert.assertEquals(expected.removeFirst(), (Object)"startMessage");
            }
        });
        parser.parse((InputStream)new ByteArrayInputStream(new byte[0]));
        Assert.assertEquals((long)0L, (long)expected.size());
    }

    @Test
    public void testEmpyHeader() throws Exception {
        StringBuilder sb = new StringBuilder();
        sb.append("\r\n");
        sb.append("The body is right here\r\n");
        final StringBuilder body = new StringBuilder();
        MimeStreamParser parser = new MimeStreamParser();
        parser.setContentHandler((ContentHandler)new AbstractContentHandler(){

            public void field(Field field) {
                Assert.fail((String)"No fields should be reported");
            }

            public void body(BodyDescriptor bd, InputStream is) throws IOException {
                int b;
                while ((b = is.read()) != -1) {
                    body.append((char)b);
                }
            }
        });
        parser.parse((InputStream)new ByteArrayInputStream(sb.toString().getBytes()));
        Assert.assertEquals((Object)"The body is right here\r\n", (Object)body.toString());
    }

    @Test
    public void testEmptyBody() throws Exception {
        StringBuilder sb = new StringBuilder();
        final LinkedList<String> expected = new LinkedList<String>();
        expected.add("From: some@one.com");
        sb.append((String)expected.getLast()).append("\r\n");
        expected.add("Subject: A subject");
        sb.append((String)expected.getLast()).append("\r\n\r\n");
        MimeStreamParser parser = new MimeStreamParser();
        parser.setContentHandler((ContentHandler)new AbstractContentHandler(){

            public void field(Field field) {
                Assert.assertEquals(expected.removeFirst(), (Object)MimeStreamParserTest.this.decode(field.getRaw()));
            }

            public void body(BodyDescriptor bd, InputStream is) throws IOException {
                Assert.assertEquals((long)-1L, (long)is.read());
            }
        });
        parser.parse((InputStream)new ByteArrayInputStream(sb.toString().getBytes()));
        Assert.assertEquals((long)0L, (long)expected.size());
    }

    @Test
    public void testPrematureEOFAfterFields() throws Exception {
        StringBuilder sb = new StringBuilder();
        final LinkedList<String> expected = new LinkedList<String>();
        expected.add("From: some@one.com");
        sb.append((String)expected.getLast()).append("\r\n");
        expected.add("Subject: A subject");
        sb.append((String)expected.getLast());
        MimeStreamParser parser = new MimeStreamParser();
        parser.setContentHandler((ContentHandler)new AbstractContentHandler(){

            public void field(Field field) {
                Assert.assertEquals(expected.removeFirst(), (Object)MimeStreamParserTest.this.decode(field.getRaw()));
            }
        });
        parser.parse((InputStream)new ByteArrayInputStream(sb.toString().getBytes()));
        Assert.assertEquals((long)0L, (long)expected.size());
        sb = new StringBuilder();
        expected.clear();
        expected.add("From: some@one.com");
        sb.append((String)expected.getLast()).append("\r\n");
        expected.add("Subject: A subject");
        sb.append((String)expected.getLast()).append("\r\n");
        parser = new MimeStreamParser();
        parser.setContentHandler((ContentHandler)new AbstractContentHandler(){

            public void field(Field field) {
                Assert.assertEquals(expected.removeFirst(), (Object)MimeStreamParserTest.this.decode(field.getRaw()));
            }
        });
        parser.parse((InputStream)new ByteArrayInputStream(sb.toString().getBytes()));
        Assert.assertEquals((long)0L, (long)expected.size());
    }

    @Test
    public void testAutomaticContentDecoding() throws Exception {
        MimeStreamParser parser = new MimeStreamParser();
        parser.setContentDecoding(true);
        TestHandler handler = new TestHandler();
        parser.setContentHandler((ContentHandler)handler);
        String msg = "Subject: Yada yada\r\nFrom: foo@bar.com\r\nContent-Type: application/octet-stream\r\nContent-Transfer-Encoding: base64\r\n\r\nV2hvIGF0ZSBteSBjYWtlPwo=";
        String expected = "<message>\r\n<header>\r\n<field>\r\nSubject: Yada yada</field>\r\n<field>\r\nFrom: foo@bar.com</field>\r\n<field>\r\nContent-Type: application/octet-stream</field>\r\n<field>\r\nContent-Transfer-Encoding: base64</field>\r\n</header>\r\n<body>\r\nWho ate my cake?\n</body>\r\n</message>\r\n";
        parser.parse((InputStream)new ByteArrayInputStream(msg.getBytes()));
        String result = handler.sb.toString();
        Assert.assertEquals((Object)expected, (Object)result);
    }

    @Test
    public void testRfc6531() throws Exception {
        MimeStreamParser parser = new MimeStreamParser(MimeConfig.STRICT);
        parser.setContentDecoding(true);
        TestHandler handler = new TestHandler();
        parser.setContentHandler((ContentHandler)handler);
        String msg = "Subject: Na\u00efve Subject\r\nFrom: foo@\u00f8.example\r\nTo: \u00f8@example.com\r\nContent-Type: text/plain; charset=utf-8\r\n\r\nThis sentence ends with the letter x.\r\n";
        String expected = "<message>\r\n<header>\r\n<field>\r\nSubject: Na\u00efve Subject</field>\r\n<field>\r\nFrom: foo@\u00f8.example</field>\r\n<field>\r\nTo: \u00f8@example.com</field>\r\n<field>\r\nContent-Type: text/plain; charset=utf-8</field>\r\n</header>\r\n<body>\r\nThis sentence ends with the letter x.\r\n</body>\r\n</message>\r\n";
        byte[] msgAsUtf8 = msg.getBytes(Charset.forName("utf8"));
        int i = 0;
        while (i + 1 < msgAsUtf8.length && (msgAsUtf8[i] != 195 || msgAsUtf8[i + 1] != 184)) {
            ++i;
        }
        Assert.assertTrue((i < msgAsUtf8.length ? 1 : 0) != 0);
        parser.parse((InputStream)new ByteArrayInputStream(msgAsUtf8));
        String result = handler.sb.toString();
        Assert.assertEquals((Object)expected, (Object)result);
    }

    protected String decode(ByteSequence byteSequence) {
        return ContentUtil.decode((ByteSequence)byteSequence);
    }
}

