/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jspf.executor;

import org.apache.james.jspf.core.DNSLookupContinuation;
import org.apache.james.jspf.core.DNSResponse;
import org.apache.james.jspf.core.DNSService;
import org.apache.james.jspf.core.SPFChecker;
import org.apache.james.jspf.core.SPFCheckerExceptionCatcher;
import org.apache.james.jspf.core.SPFSession;
import org.apache.james.jspf.core.exceptions.SPFResultException;
import org.apache.james.jspf.core.exceptions.TimeoutException;
import org.apache.james.jspf.executor.FutureSPFResult;
import org.apache.james.jspf.executor.SPFExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SynchronousSPFExecutor
implements SPFExecutor {
    private static final Logger LOGGER = LoggerFactory.getLogger(SynchronousSPFExecutor.class);
    private DNSService dnsProbe;

    public SynchronousSPFExecutor(DNSService service) {
        this.dnsProbe = service;
    }

    @Override
    public void execute(SPFSession session, FutureSPFResult result) {
        SPFChecker checker;
        while ((checker = session.popChecker()) != null) {
            LOGGER.debug("Executing checker: {}", (Object)checker);
            try {
                DNSLookupContinuation cont = checker.checkSPF(session);
                while (cont != null) {
                    DNSResponse response;
                    try {
                        response = new DNSResponse(this.dnsProbe.getRecords(cont.getRequest()));
                    }
                    catch (TimeoutException e) {
                        response = new DNSResponse(e);
                    }
                    cont = cont.getListener().onDNSResponse(response, session);
                }
            }
            catch (Exception e2) {
                while (e2 != null) {
                    SPFResultException e2;
                    checker = session.popChecker(c -> c instanceof SPFCheckerExceptionCatcher);
                    if (checker == null) {
                        throw new RuntimeException("SPFCheckerExceptionCatcher implementation not found, session: " + session, e2);
                    }
                    try {
                        ((SPFCheckerExceptionCatcher)((Object)checker)).onException(e2, session);
                        e2 = null;
                    }
                    catch (SPFResultException ex) {
                        e2 = ex;
                    }
                }
            }
        }
        result.setSPFResult(session);
    }
}

