/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.microsoft;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.apache.poi.hssf.extractor.OldExcelExtractor;
import org.apache.tika.exception.TikaException;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.mime.MediaType;
import org.apache.tika.parser.AbstractParser;
import org.apache.tika.parser.ParseContext;
import org.apache.tika.sax.XHTMLContentHandler;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class OldExcelParser
extends AbstractParser {
    private static final long serialVersionUID = 4611820730372823452L;
    private static final Set<MediaType> SUPPORTED_TYPES = Collections.unmodifiableSet(new HashSet<MediaType>(Arrays.asList(MediaType.application("vnd.ms-excel.sheet.4"), MediaType.application("vnd.ms-excel.workspace.4"), MediaType.application("vnd.ms-excel.sheet.3"), MediaType.application("vnd.ms-excel.workspace.3"), MediaType.application("vnd.ms-excel.sheet.2"))));

    protected static void parse(OldExcelExtractor extractor, XHTMLContentHandler xhtml) throws TikaException, IOException, SAXException {
        String line;
        String text = extractor.getText();
        BufferedReader reader = new BufferedReader(new StringReader(text));
        while ((line = reader.readLine()) != null) {
            xhtml.startElement("p");
            xhtml.characters(line);
            xhtml.endElement("p");
        }
    }

    @Override
    public Set<MediaType> getSupportedTypes(ParseContext context) {
        return SUPPORTED_TYPES;
    }

    @Override
    public void parse(InputStream stream, ContentHandler handler, Metadata metadata, ParseContext context) throws IOException, SAXException, TikaException {
        OldExcelExtractor extractor = new OldExcelExtractor(stream);
        XHTMLContentHandler xhtml = new XHTMLContentHandler(handler, metadata);
        xhtml.startDocument();
        OldExcelParser.parse(extractor, xhtml);
        xhtml.endDocument();
    }
}

