/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.servlet;

import java.io.IOException;
import java.util.Properties;
import javax.jcr.Repository;
import javax.jcr.RepositoryException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.jackrabbit.commons.repository.ProxyRepository;
import org.apache.jackrabbit.servlet.ServletRepository;

public abstract class AbstractRepositoryServlet
extends HttpServlet {
    @Override
    public void init() throws ServletException {
        this.getServletContext().setAttribute(this.getAttributeName(), new ProxyRepository(){

            @Override
            protected Repository getRepository() throws RepositoryException {
                return AbstractRepositoryServlet.this.getRepository();
            }
        });
    }

    @Override
    public void destroy() {
        this.getServletContext().removeAttribute(this.getAttributeName());
    }

    protected abstract Repository getRepository() throws RepositoryException;

    protected String getAttributeName() {
        String name = Repository.class.getName();
        return this.getInitParameter(name, name);
    }

    protected String getInitParameter(String name, String def) {
        String value = this.getInitParameter(name);
        if (value == null) {
            value = def;
        }
        return value;
    }

    @Override
    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        ServletRepository repository = new ServletRepository(this);
        String info = request.getPathInfo();
        if (info == null || info.equals("/")) {
            Properties descriptors = new Properties();
            String[] keys = repository.getDescriptorKeys();
            for (int i = 0; i < keys.length; ++i) {
                descriptors.setProperty(keys[i], repository.getDescriptor(keys[i]));
            }
            response.setContentType("text/plain; charset=ISO-8859-1");
            descriptors.store(response.getOutputStream(), this.getAttributeName());
        } else {
            String key = info.substring(1);
            String descriptor = repository.getDescriptor(key);
            if (descriptor != null) {
                response.setContentType("text/plain; charset=UTF-8");
                response.getWriter().write(descriptor);
            } else {
                response.sendError(404, "Repository descriptor " + key + " not found");
            }
        }
    }
}

