/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.rmi.value;

import java.io.ByteArrayInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.math.BigDecimal;
import java.nio.charset.StandardCharsets;
import java.util.Calendar;
import javax.jcr.Binary;
import javax.jcr.PropertyType;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import javax.jcr.ValueFormatException;

@Deprecated
abstract class AbstractValue
implements Value,
Serializable {
    private static final long serialVersionUID = -1989277354799918598L;
    private transient InputStream stream = null;

    AbstractValue() {
    }

    @Override
    public final synchronized InputStream getStream() throws RepositoryException {
        if (this.stream == null) {
            final Binary binary = this.getBinary();
            try {
                this.stream = new FilterInputStream(binary.getStream()){

                    @Override
                    public void close() throws IOException {
                        super.close();
                        binary.dispose();
                    }
                };
            }
            finally {
                if (this.stream == null) {
                    binary.dispose();
                }
            }
        }
        return this.stream;
    }

    @Override
    public Binary getBinary() throws RepositoryException {
        final byte[] value = this.getString().getBytes(StandardCharsets.UTF_8);
        return new Binary(){

            @Override
            public int read(byte[] b, long position) {
                if (position >= (long)value.length) {
                    return -1;
                }
                int p = (int)position;
                int n = Math.min(b.length, value.length - p);
                System.arraycopy(value, p, b, 0, n);
                return n;
            }

            @Override
            public InputStream getStream() {
                return new ByteArrayInputStream(value);
            }

            @Override
            public long getSize() {
                return value.length;
            }

            @Override
            public void dispose() {
            }
        };
    }

    @Override
    public boolean getBoolean() throws ValueFormatException {
        throw this.getValueFormatException("Boolean");
    }

    @Override
    public Calendar getDate() throws ValueFormatException {
        throw this.getValueFormatException("Date");
    }

    @Override
    public BigDecimal getDecimal() throws RepositoryException {
        throw this.getValueFormatException("Decimal");
    }

    @Override
    public double getDouble() throws ValueFormatException {
        throw this.getValueFormatException("Double");
    }

    @Override
    public long getLong() throws ValueFormatException {
        throw this.getValueFormatException("Long");
    }

    protected ValueFormatException getValueFormatException(String destType) {
        return new ValueFormatException("Cannot convert value \"" + this + "\" of type " + PropertyType.nameFromValue(this.getType()) + " to " + destType);
    }

    public boolean equals(Object object) {
        try {
            return object instanceof Value && this.getType() == ((Value)object).getType() && this.getString().equals(((Value)object).getString());
        }
        catch (RepositoryException e) {
            return false;
        }
    }

    public int hashCode() {
        try {
            return this.getType() + this.getString().hashCode();
        }
        catch (RepositoryException e) {
            return this.getType();
        }
    }

    public String toString() {
        try {
            return this.getString();
        }
        catch (RepositoryException e) {
            return PropertyType.nameFromValue(this.getType());
        }
    }
}

