/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.security;

import java.security.Principal;
import javax.jcr.AccessDeniedException;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.UnsupportedRepositoryOperationException;
import javax.jcr.security.AccessControlException;
import javax.jcr.security.AccessControlPolicy;
import javax.jcr.security.AccessControlPolicyIterator;
import javax.jcr.security.Privilege;
import org.apache.jackrabbit.api.security.JackrabbitAccessControlManager;
import org.apache.jackrabbit.api.security.JackrabbitAccessControlPolicy;
import org.apache.jackrabbit.api.security.authorization.PrivilegeManager;
import org.apache.jackrabbit.commons.iterator.AccessControlPolicyIteratorAdapter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractAccessControlManager
implements JackrabbitAccessControlManager {
    private static Logger log = LoggerFactory.getLogger(AbstractAccessControlManager.class);

    @Override
    public Privilege[] getSupportedPrivileges(String absPath) throws PathNotFoundException, RepositoryException {
        this.checkInitialized();
        this.checkValidNodePath(absPath);
        return this.getPrivilegeManager().getRegisteredPrivileges();
    }

    @Override
    public Privilege privilegeFromName(String privilegeName) throws AccessControlException, RepositoryException {
        this.checkInitialized();
        return this.getPrivilegeManager().getPrivilege(privilegeName);
    }

    @Override
    public AccessControlPolicy[] getPolicies(String absPath) throws PathNotFoundException, AccessDeniedException, RepositoryException {
        this.checkInitialized();
        this.checkPermission(absPath, 32);
        log.debug("Implementation does not provide applicable policies -> getPolicy() always returns an empty array.");
        return new AccessControlPolicy[0];
    }

    @Override
    public AccessControlPolicyIterator getApplicablePolicies(String absPath) throws PathNotFoundException, AccessDeniedException, RepositoryException {
        this.checkInitialized();
        this.checkPermission(absPath, 32);
        log.debug("Implementation does not provide applicable policies -> returning empty iterator.");
        return AccessControlPolicyIteratorAdapter.EMPTY;
    }

    @Override
    public void setPolicy(String absPath, AccessControlPolicy policy) throws PathNotFoundException, AccessControlException, AccessDeniedException, RepositoryException {
        this.checkInitialized();
        this.checkPermission(absPath, 64);
        throw new AccessControlException("AccessControlPolicy " + policy + " cannot be applied.");
    }

    @Override
    public void removePolicy(String absPath, AccessControlPolicy policy) throws PathNotFoundException, AccessControlException, AccessDeniedException, RepositoryException {
        this.checkInitialized();
        this.checkPermission(absPath, 64);
        throw new AccessControlException("No AccessControlPolicy has been set through this API -> Cannot be removed.");
    }

    @Override
    public JackrabbitAccessControlPolicy[] getApplicablePolicies(Principal principal) throws AccessDeniedException, AccessControlException, UnsupportedRepositoryOperationException, RepositoryException {
        this.checkInitialized();
        log.debug("Implementation does not provide applicable policies -> returning empty array.");
        return new JackrabbitAccessControlPolicy[0];
    }

    @Override
    public JackrabbitAccessControlPolicy[] getPolicies(Principal principal) throws AccessDeniedException, AccessControlException, UnsupportedRepositoryOperationException, RepositoryException {
        this.checkInitialized();
        log.debug("Implementation does not provide applicable policies -> returning empty array.");
        return new JackrabbitAccessControlPolicy[0];
    }

    protected abstract void checkInitialized() throws IllegalStateException;

    protected abstract void checkPermission(String var1, int var2) throws AccessDeniedException, PathNotFoundException, RepositoryException;

    protected abstract PrivilegeManager getPrivilegeManager() throws RepositoryException;

    protected abstract void checkValidNodePath(String var1) throws PathNotFoundException, RepositoryException;
}

