/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.fs.db;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterInputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import javax.sql.DataSource;
import org.apache.jackrabbit.core.fs.FileSystem;
import org.apache.jackrabbit.core.fs.FileSystemException;
import org.apache.jackrabbit.core.fs.FileSystemPathUtil;
import org.apache.jackrabbit.core.util.db.CheckSchemaOperation;
import org.apache.jackrabbit.core.util.db.ConnectionHelper;
import org.apache.jackrabbit.core.util.db.DbUtility;
import org.apache.jackrabbit.core.util.db.StreamWrapper;
import org.apache.jackrabbit.util.TransientFileFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class DatabaseFileSystem
implements FileSystem {
    private static Logger log = LoggerFactory.getLogger(DatabaseFileSystem.class);
    protected boolean initialized = false;
    protected String schema = "default";
    protected String schemaObjectPrefix = "";
    protected static final int INITIAL_BUFFER_SIZE = 8192;
    private boolean schemaCheckEnabled = true;
    protected ConnectionHelper conHelper;
    protected String selectExistSQL;
    protected String selectFileExistSQL;
    protected String selectFolderExistSQL;
    protected String selectChildCountSQL;
    protected String selectDataSQL;
    protected String selectLastModifiedSQL;
    protected String selectLengthSQL;
    protected String selectFileNamesSQL;
    protected String selectFolderNamesSQL;
    protected String selectFileAndFolderNamesSQL;
    protected String deleteFileSQL;
    protected String deleteFolderSQL;
    protected String insertFileSQL;
    protected String insertFolderSQL;
    protected String updateDataSQL;
    protected String updateLastModifiedSQL;
    protected String copyFileSQL;
    protected String copyFilesSQL;

    public String getSchemaObjectPrefix() {
        return this.schemaObjectPrefix;
    }

    public void setSchemaObjectPrefix(String schemaObjectPrefix) {
        this.schemaObjectPrefix = schemaObjectPrefix.toUpperCase();
    }

    public String getSchema() {
        return this.schema;
    }

    public void setSchema(String schema) {
        this.schema = schema;
    }

    public final boolean isSchemaCheckEnabled() {
        return this.schemaCheckEnabled;
    }

    public final void setSchemaCheckEnabled(boolean enabled) {
        this.schemaCheckEnabled = enabled;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof DatabaseFileSystem) {
            DatabaseFileSystem other = (DatabaseFileSystem)obj;
            return DatabaseFileSystem.equals(this.schema, other.schema) && DatabaseFileSystem.equals(this.schemaObjectPrefix, other.schemaObjectPrefix);
        }
        return false;
    }

    private static boolean equals(Object a, Object b) {
        if (a == null && b == null) {
            return true;
        }
        if (a == null || b == null) {
            return false;
        }
        return a.equals(b);
    }

    public int hashCode() {
        return 0;
    }

    @Override
    public void init() throws FileSystemException {
        if (this.initialized) {
            throw new IllegalStateException("already initialized");
        }
        try {
            this.conHelper = this.createConnectionHelper(this.getDataSource());
            this.schemaObjectPrefix = this.conHelper.prepareDbIdentifier(this.schemaObjectPrefix);
            if (this.isSchemaCheckEnabled()) {
                this.createCheckSchemaOperation().run();
            }
            this.buildSQLStatements();
            this.verifyRootExists();
            this.initialized = true;
        }
        catch (Exception e) {
            String msg = "failed to initialize file system";
            log.error(msg, e);
            throw new FileSystemException(msg, e);
        }
    }

    protected abstract DataSource getDataSource() throws Exception;

    protected ConnectionHelper createConnectionHelper(DataSource dataSrc) throws Exception {
        return new ConnectionHelper(dataSrc, false);
    }

    protected CheckSchemaOperation createCheckSchemaOperation() {
        InputStream in = DatabaseFileSystem.class.getResourceAsStream(this.getSchema() + ".ddl");
        return new CheckSchemaOperation(this.conHelper, in, this.schemaObjectPrefix + "FSENTRY").addVariableReplacement("${schemaObjectPrefix}", this.schemaObjectPrefix);
    }

    @Override
    public void close() throws FileSystemException {
        if (!this.initialized) {
            throw new IllegalStateException("not initialized");
        }
    }

    @Override
    public void createFolder(String folderPath) throws FileSystemException {
        if (!this.initialized) {
            throw new IllegalStateException("not initialized");
        }
        FileSystemPathUtil.checkFormat(folderPath);
        if (this.exists(folderPath)) {
            throw new FileSystemException("file system entry already exists: " + folderPath);
        }
        this.createDeepFolder(folderPath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteFile(String filePath) throws FileSystemException {
        if (!this.initialized) {
            throw new IllegalStateException("not initialized");
        }
        FileSystemPathUtil.checkFormat(filePath);
        String parentDir = FileSystemPathUtil.getParentDir(filePath);
        String name = FileSystemPathUtil.getName(filePath);
        int count = 0;
        String string = this.deleteFileSQL;
        synchronized (string) {
            try {
                count = this.conHelper.update(this.deleteFileSQL, parentDir, name);
            }
            catch (SQLException e) {
                String msg = "failed to delete file: " + filePath;
                log.error(msg, e);
                throw new FileSystemException(msg, e);
            }
        }
        if (count == 0) {
            throw new FileSystemException("no such file: " + filePath);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteFolder(String folderPath) throws FileSystemException {
        if (!this.initialized) {
            throw new IllegalStateException("not initialized");
        }
        FileSystemPathUtil.checkFormat(folderPath);
        if (folderPath.equals("/")) {
            throw new FileSystemException("cannot delete root");
        }
        String parentDir = FileSystemPathUtil.getParentDir(folderPath);
        String name = FileSystemPathUtil.getName(folderPath);
        int count = 0;
        String string = this.deleteFolderSQL;
        synchronized (string) {
            try {
                count = this.conHelper.update(this.deleteFolderSQL, parentDir, name, folderPath, folderPath + "/" + "%");
            }
            catch (SQLException e) {
                String msg = "failed to delete folder: " + folderPath;
                log.error(msg, e);
                throw new FileSystemException(msg, e);
            }
        }
        if (count == 0) {
            throw new FileSystemException("no such folder: " + folderPath);
        }
    }

    @Override
    public boolean exists(String path) throws FileSystemException {
        if (!this.initialized) {
            throw new IllegalStateException("not initialized");
        }
        FileSystemPathUtil.checkFormat(path);
        String parentDir = FileSystemPathUtil.getParentDir(path);
        String name = FileSystemPathUtil.getName(path);
        String string = this.selectExistSQL;
        synchronized (string) {
            boolean bl;
            ResultSet rs = null;
            try {
                rs = this.conHelper.exec(this.selectExistSQL, new Object[]{parentDir, name}, false, 0);
                bl = rs.next();
            }
            catch (SQLException e) {
                try {
                    String msg = "failed to check existence of file system entry: " + path;
                    log.error(msg, e);
                    throw new FileSystemException(msg, e);
                }
                catch (Throwable throwable) {
                    DbUtility.close(rs);
                    throw throwable;
                }
            }
            DbUtility.close(rs);
            return bl;
        }
    }

    @Override
    public boolean isFile(String path) throws FileSystemException {
        if (!this.initialized) {
            throw new IllegalStateException("not initialized");
        }
        FileSystemPathUtil.checkFormat(path);
        String parentDir = FileSystemPathUtil.getParentDir(path);
        String name = FileSystemPathUtil.getName(path);
        String string = this.selectFileExistSQL;
        synchronized (string) {
            boolean bl;
            ResultSet rs = null;
            try {
                rs = this.conHelper.exec(this.selectFileExistSQL, new Object[]{parentDir, name}, false, 0);
                bl = rs.next();
            }
            catch (SQLException e) {
                try {
                    String msg = "failed to check existence of file: " + path;
                    log.error(msg, e);
                    throw new FileSystemException(msg, e);
                }
                catch (Throwable throwable) {
                    DbUtility.close(rs);
                    throw throwable;
                }
            }
            DbUtility.close(rs);
            return bl;
        }
    }

    @Override
    public boolean isFolder(String path) throws FileSystemException {
        if (!this.initialized) {
            throw new IllegalStateException("not initialized");
        }
        FileSystemPathUtil.checkFormat(path);
        String parentDir = FileSystemPathUtil.getParentDir(path);
        String name = FileSystemPathUtil.getName(path);
        String string = this.selectFolderExistSQL;
        synchronized (string) {
            boolean bl;
            ResultSet rs = null;
            try {
                rs = this.conHelper.exec(this.selectFolderExistSQL, new Object[]{parentDir, name}, false, 0);
                bl = rs.next();
            }
            catch (SQLException e) {
                try {
                    String msg = "failed to check existence of folder: " + path;
                    log.error(msg, e);
                    throw new FileSystemException(msg, e);
                }
                catch (Throwable throwable) {
                    DbUtility.close(rs);
                    throw throwable;
                }
            }
            DbUtility.close(rs);
            return bl;
        }
    }

    @Override
    public long lastModified(String path) throws FileSystemException {
        if (!this.initialized) {
            throw new IllegalStateException("not initialized");
        }
        FileSystemPathUtil.checkFormat(path);
        String parentDir = FileSystemPathUtil.getParentDir(path);
        String name = FileSystemPathUtil.getName(path);
        String string = this.selectLastModifiedSQL;
        synchronized (string) {
            long l;
            ResultSet rs = null;
            try {
                rs = this.conHelper.exec(this.selectLastModifiedSQL, new Object[]{parentDir, name}, false, 0);
                if (!rs.next()) {
                    throw new FileSystemException("no such file system entry: " + path);
                }
                l = rs.getLong(1);
            }
            catch (SQLException e) {
                try {
                    String msg = "failed to determine lastModified of file system entry: " + path;
                    log.error(msg, e);
                    throw new FileSystemException(msg, e);
                }
                catch (Throwable throwable) {
                    DbUtility.close(rs);
                    throw throwable;
                }
            }
            DbUtility.close(rs);
            return l;
        }
    }

    @Override
    public long length(String filePath) throws FileSystemException {
        if (!this.initialized) {
            throw new IllegalStateException("not initialized");
        }
        FileSystemPathUtil.checkFormat(filePath);
        String parentDir = FileSystemPathUtil.getParentDir(filePath);
        String name = FileSystemPathUtil.getName(filePath);
        String string = this.selectLengthSQL;
        synchronized (string) {
            long l;
            ResultSet rs = null;
            try {
                rs = this.conHelper.exec(this.selectLengthSQL, new Object[]{parentDir, name}, false, 0);
                if (!rs.next()) {
                    throw new FileSystemException("no such file: " + filePath);
                }
                l = rs.getLong(1);
            }
            catch (SQLException e) {
                try {
                    String msg = "failed to determine length of file: " + filePath;
                    log.error(msg, e);
                    throw new FileSystemException(msg, e);
                }
                catch (Throwable throwable) {
                    DbUtility.close(rs);
                    throw throwable;
                }
            }
            DbUtility.close(rs);
            return l;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean hasChildren(String path) throws FileSystemException {
        if (!this.initialized) {
            throw new IllegalStateException("not initialized");
        }
        FileSystemPathUtil.checkFormat(path);
        if (!this.exists(path)) {
            throw new FileSystemException("no such file system entry: " + path);
        }
        String string = this.selectChildCountSQL;
        synchronized (string) {
            boolean bl;
            ResultSet rs;
            block10: {
                rs = null;
                rs = this.conHelper.exec(this.selectChildCountSQL, new Object[]{path}, false, 0);
                if (rs.next()) break block10;
                boolean bl2 = false;
                DbUtility.close(rs);
                return bl2;
            }
            try {
                int count = rs.getInt(1);
                if (FileSystemPathUtil.denotesRoot(path)) {
                    --count;
                }
                bl = count > 0;
            }
            catch (SQLException e) {
                try {
                    String msg = "failed to determine child count of file system entry: " + path;
                    log.error(msg, e);
                    throw new FileSystemException(msg, e);
                }
                catch (Throwable throwable) {
                    DbUtility.close(rs);
                    throw throwable;
                }
            }
            DbUtility.close(rs);
            return bl;
        }
    }

    @Override
    public String[] list(String folderPath) throws FileSystemException {
        if (!this.initialized) {
            throw new IllegalStateException("not initialized");
        }
        FileSystemPathUtil.checkFormat(folderPath);
        if (!this.isFolder(folderPath)) {
            throw new FileSystemException("no such folder: " + folderPath);
        }
        String string = this.selectFileAndFolderNamesSQL;
        synchronized (string) {
            String[] name;
            ResultSet rs = null;
            try {
                rs = this.conHelper.exec(this.selectFileAndFolderNamesSQL, new Object[]{folderPath}, false, 0);
                ArrayList<String[]> names = new ArrayList<String[]>();
                while (rs.next()) {
                    name = rs.getString(1);
                    if (name.length() == 0 && FileSystemPathUtil.denotesRoot(folderPath)) continue;
                    names.add(name);
                }
                name = names.toArray(new String[names.size()]);
            }
            catch (SQLException e) {
                try {
                    String msg = "failed to list child entries of folder: " + folderPath;
                    log.error(msg, e);
                    throw new FileSystemException(msg, e);
                }
                catch (Throwable throwable) {
                    DbUtility.close(rs);
                    throw throwable;
                }
            }
            DbUtility.close(rs);
            return name;
        }
    }

    @Override
    public String[] listFiles(String folderPath) throws FileSystemException {
        if (!this.initialized) {
            throw new IllegalStateException("not initialized");
        }
        FileSystemPathUtil.checkFormat(folderPath);
        if (!this.isFolder(folderPath)) {
            throw new FileSystemException("no such folder: " + folderPath);
        }
        String string = this.selectFileNamesSQL;
        synchronized (string) {
            String[] stringArray;
            ResultSet rs = null;
            try {
                rs = this.conHelper.exec(this.selectFileNamesSQL, new Object[]{folderPath}, false, 0);
                ArrayList<String> names = new ArrayList<String>();
                while (rs.next()) {
                    names.add(rs.getString(1));
                }
                stringArray = names.toArray(new String[names.size()]);
            }
            catch (SQLException e) {
                try {
                    String msg = "failed to list file entries of folder: " + folderPath;
                    log.error(msg, e);
                    throw new FileSystemException(msg, e);
                }
                catch (Throwable throwable) {
                    DbUtility.close(rs);
                    throw throwable;
                }
            }
            DbUtility.close(rs);
            return stringArray;
        }
    }

    @Override
    public String[] listFolders(String folderPath) throws FileSystemException {
        if (!this.initialized) {
            throw new IllegalStateException("not initialized");
        }
        FileSystemPathUtil.checkFormat(folderPath);
        if (!this.isFolder(folderPath)) {
            throw new FileSystemException("no such folder: " + folderPath);
        }
        String string = this.selectFolderNamesSQL;
        synchronized (string) {
            String[] name;
            ResultSet rs = null;
            try {
                rs = this.conHelper.exec(this.selectFolderNamesSQL, new Object[]{folderPath}, false, 0);
                ArrayList<String[]> names = new ArrayList<String[]>();
                while (rs.next()) {
                    name = rs.getString(1);
                    if (name.length() == 0 && FileSystemPathUtil.denotesRoot(folderPath)) continue;
                    names.add(name);
                }
                name = names.toArray(new String[names.size()]);
            }
            catch (SQLException e) {
                try {
                    String msg = "failed to list folder entries of folder: " + folderPath;
                    log.error(msg, e);
                    throw new FileSystemException(msg, e);
                }
                catch (Throwable throwable) {
                    DbUtility.close(rs);
                    throw throwable;
                }
            }
            DbUtility.close(rs);
            return name;
        }
    }

    @Override
    public InputStream getInputStream(String filePath) throws FileSystemException {
        if (!this.initialized) {
            throw new IllegalStateException("not initialized");
        }
        FileSystemPathUtil.checkFormat(filePath);
        String parentDir = FileSystemPathUtil.getParentDir(filePath);
        String name = FileSystemPathUtil.getName(filePath);
        String string = this.selectDataSQL;
        synchronized (string) {
            try {
                final ResultSet rs = this.conHelper.exec(this.selectDataSQL, new Object[]{parentDir, name}, false, 0);
                if (!rs.next()) {
                    throw new FileSystemException("no such file: " + filePath);
                }
                InputStream in = rs.getBinaryStream(1);
                return new FilterInputStream(in){

                    @Override
                    public void close() throws IOException {
                        super.close();
                        DbUtility.close(rs);
                    }
                };
            }
            catch (SQLException e) {
                String msg = "failed to retrieve data of file: " + filePath;
                log.error(msg, e);
                throw new FileSystemException(msg, e);
            }
        }
    }

    @Override
    public OutputStream getOutputStream(final String filePath) throws FileSystemException {
        if (!this.initialized) {
            throw new IllegalStateException("not initialized");
        }
        FileSystemPathUtil.checkFormat(filePath);
        final String parentDir = FileSystemPathUtil.getParentDir(filePath);
        final String name = FileSystemPathUtil.getName(filePath);
        if (!this.isFolder(parentDir)) {
            throw new FileSystemException("path not found: " + parentDir);
        }
        if (this.isFolder(filePath)) {
            throw new FileSystemException("path denotes folder: " + filePath);
        }
        try {
            TransientFileFactory fileFactory = TransientFileFactory.getInstance();
            final File tmpFile = fileFactory.createTransientFile("bin", null, null);
            return new FilterOutputStream(new FileOutputStream(tmpFile)){

                @Override
                public void write(byte[] bytes, int off, int len) throws IOException {
                    this.out.write(bytes, off, len);
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void close() throws IOException {
                    block13: {
                        this.out.flush();
                        ((FileOutputStream)this.out).getFD().sync();
                        this.out.close();
                        InputStream in = null;
                        try {
                            if (DatabaseFileSystem.this.isFile(filePath)) {
                                String string = DatabaseFileSystem.this.updateDataSQL;
                                synchronized (string) {
                                    long length = tmpFile.length();
                                    in = new FileInputStream(tmpFile);
                                    DatabaseFileSystem.this.conHelper.exec(DatabaseFileSystem.this.updateDataSQL, new StreamWrapper(in, length), new Long(System.currentTimeMillis()), new Long(length), parentDir, name);
                                    break block13;
                                }
                            }
                            String string = DatabaseFileSystem.this.insertFileSQL;
                            synchronized (string) {
                                long length = tmpFile.length();
                                in = new FileInputStream(tmpFile);
                                DatabaseFileSystem.this.conHelper.exec(DatabaseFileSystem.this.insertFileSQL, parentDir, name, new StreamWrapper(in, length), new Long(System.currentTimeMillis()), new Long(length));
                            }
                        }
                        catch (Exception e) {
                            IOException ioe = new IOException(e.getMessage());
                            ioe.initCause(e);
                            throw ioe;
                        }
                        finally {
                            if (in != null) {
                                in.close();
                            }
                            tmpFile.delete();
                        }
                    }
                }
            };
        }
        catch (Exception e) {
            String msg = "failed to open output stream to file: " + filePath;
            log.error(msg, e);
            throw new FileSystemException(msg, e);
        }
    }

    protected void buildSQLStatements() {
        this.insertFileSQL = "insert into " + this.schemaObjectPrefix + "FSENTRY (FSENTRY_PATH, FSENTRY_NAME, FSENTRY_DATA, FSENTRY_LASTMOD, FSENTRY_LENGTH) values (?, ?, ?, ?, ?)";
        this.insertFolderSQL = "insert into " + this.schemaObjectPrefix + "FSENTRY (FSENTRY_PATH, FSENTRY_NAME, FSENTRY_LASTMOD, FSENTRY_LENGTH) values (?, ?, ?, 0)";
        this.updateDataSQL = "update " + this.schemaObjectPrefix + "FSENTRY set FSENTRY_DATA = ?, FSENTRY_LASTMOD = ?, FSENTRY_LENGTH = ? where FSENTRY_PATH = ? and FSENTRY_NAME = ? and FSENTRY_DATA is not null";
        this.updateLastModifiedSQL = "update " + this.schemaObjectPrefix + "FSENTRY set FSENTRY_LASTMOD = ? where FSENTRY_PATH = ? and FSENTRY_NAME = ? and FSENTRY_DATA is not null";
        this.selectExistSQL = "select 1 from " + this.schemaObjectPrefix + "FSENTRY where FSENTRY_PATH = ? and FSENTRY_NAME = ?";
        this.selectFileExistSQL = "select 1 from " + this.schemaObjectPrefix + "FSENTRY where FSENTRY_PATH = ? and FSENTRY_NAME = ? and FSENTRY_DATA is not null";
        this.selectFolderExistSQL = "select 1 from " + this.schemaObjectPrefix + "FSENTRY where FSENTRY_PATH = ? and FSENTRY_NAME = ? and FSENTRY_DATA is null";
        this.selectFileNamesSQL = "select FSENTRY_NAME from " + this.schemaObjectPrefix + "FSENTRY where FSENTRY_PATH = ? and FSENTRY_DATA is not null";
        this.selectFolderNamesSQL = "select FSENTRY_NAME from " + this.schemaObjectPrefix + "FSENTRY where FSENTRY_PATH = ? and FSENTRY_DATA is null";
        this.selectFileAndFolderNamesSQL = "select FSENTRY_NAME from " + this.schemaObjectPrefix + "FSENTRY where FSENTRY_PATH = ?";
        this.selectChildCountSQL = "select count(FSENTRY_NAME) from " + this.schemaObjectPrefix + "FSENTRY where FSENTRY_PATH = ?  ";
        this.selectDataSQL = "select FSENTRY_DATA from " + this.schemaObjectPrefix + "FSENTRY where FSENTRY_PATH = ? and FSENTRY_NAME = ? and FSENTRY_DATA is not null";
        this.selectLastModifiedSQL = "select FSENTRY_LASTMOD from " + this.schemaObjectPrefix + "FSENTRY where FSENTRY_PATH = ? and FSENTRY_NAME = ?";
        this.selectLengthSQL = "select FSENTRY_LENGTH from " + this.schemaObjectPrefix + "FSENTRY where FSENTRY_PATH = ? and FSENTRY_NAME = ? and FSENTRY_DATA is not null";
        this.deleteFileSQL = "delete from " + this.schemaObjectPrefix + "FSENTRY where FSENTRY_PATH = ? and FSENTRY_NAME = ? and FSENTRY_DATA is not null";
        this.deleteFolderSQL = "delete from " + this.schemaObjectPrefix + "FSENTRY where (FSENTRY_PATH = ? and FSENTRY_NAME = ? and FSENTRY_DATA is null) or (FSENTRY_PATH = ?) or (FSENTRY_PATH like ?) ";
        this.copyFileSQL = "insert into " + this.schemaObjectPrefix + "FSENTRY (FSENTRY_PATH, FSENTRY_NAME, FSENTRY_DATA, FSENTRY_LASTMOD, FSENTRY_LENGTH) select ?, ?, FSENTRY_DATA, FSENTRY_LASTMOD, FSENTRY_LENGTH from " + this.schemaObjectPrefix + "FSENTRY where FSENTRY_PATH = ? and FSENTRY_NAME = ? and FSENTRY_DATA is not null";
        this.copyFilesSQL = "insert into " + this.schemaObjectPrefix + "FSENTRY (FSENTRY_PATH, FSENTRY_NAME, FSENTRY_DATA, FSENTRY_LASTMOD, FSENTRY_LENGTH) select ?, FSENTRY_NAME, FSENTRY_DATA, FSENTRY_LASTMOD, FSENTRY_LENGTH from " + this.schemaObjectPrefix + "FSENTRY where FSENTRY_PATH = ? and FSENTRY_DATA is not null";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void verifyRootExists() throws Exception {
        String string = this.selectFolderExistSQL;
        synchronized (string) {
            ResultSet rs;
            block6: {
                rs = null;
                try {
                    rs = this.conHelper.exec(this.selectFolderExistSQL, new Object[]{"/", ""}, false, 0);
                    if (!rs.next()) break block6;
                }
                catch (SQLException e) {
                    try {
                        String msg = "failed to check existence of file system root entry";
                        log.error(msg, e);
                        throw new FileSystemException(msg, e);
                    }
                    catch (Throwable throwable) {
                        DbUtility.close(rs);
                        throw throwable;
                    }
                }
                DbUtility.close(rs);
                return;
            }
            DbUtility.close(rs);
        }
        this.createDeepFolder("/");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void createDeepFolder(String folderPath) throws FileSystemException {
        String parentDir = FileSystemPathUtil.getParentDir(folderPath);
        String name = FileSystemPathUtil.getName(folderPath);
        if (!FileSystemPathUtil.denotesRoot(folderPath) && !this.exists(parentDir)) {
            this.createDeepFolder(parentDir);
        }
        String string = this.insertFolderSQL;
        synchronized (string) {
            try {
                this.conHelper.exec(this.insertFolderSQL, parentDir, name, new Long(System.currentTimeMillis()));
            }
            catch (SQLException e) {
                String msg = "failed to create folder entry: " + folderPath;
                log.error(msg, e);
                throw new FileSystemException(msg, e);
            }
        }
    }
}

