/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.rmi.value;

import java.math.BigDecimal;
import java.util.Calendar;
import java.util.TimeZone;
import javax.jcr.ValueFormatException;
import org.apache.jackrabbit.rmi.value.AbstractValue;

class StringValue
extends AbstractValue {
    private static final long serialVersionUID = 220963478492833703L;
    private final String value;

    public StringValue(String value) {
        this.value = value;
    }

    @Override
    public int getType() {
        return 1;
    }

    @Override
    public boolean getBoolean() {
        return Boolean.valueOf(this.value);
    }

    @Override
    public Calendar getDate() throws ValueFormatException {
        String tzID;
        int ms;
        int sec;
        int min;
        int hour;
        int day;
        int month;
        int year;
        int sign;
        block19: {
            sign = 43;
            int start = 0;
            if (this.value.startsWith("-")) {
                sign = 45;
                start = 1;
            } else if (this.value.startsWith("+")) {
                sign = 43;
                start = 1;
            }
            try {
                year = Integer.parseInt(this.value.substring(start, start + 4));
                if (this.value.charAt(start += 4) != '-') {
                    throw new ValueFormatException("Not a date: " + this.value);
                }
                month = Integer.parseInt(this.value.substring(++start, start + 2));
                if (this.value.charAt(start += 2) != '-') {
                    throw new ValueFormatException("Not a date: " + this.value);
                }
                day = Integer.parseInt(this.value.substring(++start, start + 2));
                if (this.value.charAt(start += 2) != 'T') {
                    throw new ValueFormatException("Not a date: " + this.value);
                }
                hour = Integer.parseInt(this.value.substring(++start, start + 2));
                if (this.value.charAt(start += 2) != ':') {
                    throw new ValueFormatException("Not a date: " + this.value);
                }
                min = Integer.parseInt(this.value.substring(++start, start + 2));
                if (this.value.charAt(start += 2) != ':') {
                    throw new ValueFormatException("Not a date: " + this.value);
                }
                sec = Integer.parseInt(this.value.substring(++start, start + 2));
                if (this.value.charAt(start += 2) != '.') {
                    throw new ValueFormatException("Not a date: " + this.value);
                }
                ms = Integer.parseInt(this.value.substring(++start, start + 3));
                if (this.value.charAt(start += 3) == '+' || this.value.charAt(start) == '-') {
                    tzID = "GMT" + this.value.substring(start);
                    break block19;
                }
                if (this.value.substring(start).equals("Z")) {
                    tzID = "GMT";
                    break block19;
                }
                throw new ValueFormatException("Invalid time zone in a date: " + this.value);
            }
            catch (IndexOutOfBoundsException e) {
                throw new ValueFormatException("Not a date: " + this.value, e);
            }
            catch (NumberFormatException e) {
                throw new ValueFormatException("Not a date: " + this.value, e);
            }
        }
        TimeZone tz = TimeZone.getTimeZone(tzID);
        if (!tz.getID().equals(tzID)) {
            throw new ValueFormatException("Invalid time zone in a date: " + this.value);
        }
        Calendar cal = Calendar.getInstance(tz);
        cal.setLenient(false);
        if (sign == 45 || year == 0) {
            cal.set(1, year + 1);
            cal.set(0, 0);
        } else {
            cal.set(1, year);
            cal.set(0, 1);
        }
        cal.set(2, month - 1);
        cal.set(5, day);
        cal.set(11, hour);
        cal.set(12, min);
        cal.set(13, sec);
        cal.set(14, ms);
        try {
            cal.getTime();
        }
        catch (IllegalArgumentException e) {
            throw new ValueFormatException("Not a date: " + this.value, e);
        }
        return cal;
    }

    @Override
    public BigDecimal getDecimal() throws ValueFormatException {
        try {
            return new BigDecimal(this.value);
        }
        catch (NumberFormatException e) {
            throw new ValueFormatException("Not a decimal value: " + this.value, e);
        }
    }

    @Override
    public double getDouble() throws ValueFormatException {
        try {
            return Double.valueOf(this.value);
        }
        catch (NumberFormatException e) {
            throw new ValueFormatException("Not a double value: " + this.value, e);
        }
    }

    @Override
    public long getLong() throws ValueFormatException {
        try {
            return Long.valueOf(this.value);
        }
        catch (NumberFormatException e) {
            throw new ValueFormatException("Not a long value: " + this.value, e);
        }
    }

    @Override
    public String getString() {
        return this.value;
    }
}

