/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.rmi.server;

import java.rmi.RemoteException;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import javax.jcr.query.Query;
import org.apache.jackrabbit.rmi.remote.RemoteNode;
import org.apache.jackrabbit.rmi.remote.RemoteQuery;
import org.apache.jackrabbit.rmi.remote.RemoteQueryResult;
import org.apache.jackrabbit.rmi.server.RemoteAdapterFactory;
import org.apache.jackrabbit.rmi.server.ServerObject;

public class ServerQuery
extends ServerObject
implements RemoteQuery {
    private Query query;

    public ServerQuery(Query query, RemoteAdapterFactory factory) throws RemoteException {
        super(factory);
        this.query = query;
    }

    @Override
    public RemoteQueryResult execute() throws RepositoryException, RemoteException {
        return this.getFactory().getRemoteQueryResult(this.query.execute());
    }

    @Override
    public String getStatement() throws RemoteException {
        return this.query.getStatement();
    }

    @Override
    public String getLanguage() throws RemoteException {
        return this.query.getLanguage();
    }

    @Override
    public String getStoredQueryPath() throws RepositoryException, RemoteException {
        return this.query.getStoredQueryPath();
    }

    @Override
    public RemoteNode storeAsNode(String absPath) throws RepositoryException, RemoteException {
        return this.getRemoteNode(this.query.storeAsNode(absPath));
    }

    @Override
    public void bindValue(String varName, Value value) throws RepositoryException, RemoteException {
        this.query.bindValue(varName, value);
    }

    @Override
    public String[] getBindVariableNames() throws RepositoryException, RemoteException {
        try {
            return this.query.getBindVariableNames();
        }
        catch (RepositoryException ex) {
            throw this.getRepositoryException(ex);
        }
    }

    @Override
    public void setLimit(long limit) throws RemoteException {
        this.query.setLimit(limit);
    }

    @Override
    public void setOffset(long offset) throws RemoteException {
        this.query.setOffset(offset);
    }
}

