/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.rmi.client;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.rmi.RemoteException;
import java.security.AccessControlException;
import javax.jcr.Credentials;
import javax.jcr.Item;
import javax.jcr.Node;
import javax.jcr.Property;
import javax.jcr.Repository;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.UnsupportedRepositoryOperationException;
import javax.jcr.ValueFactory;
import javax.jcr.Workspace;
import javax.jcr.retention.RetentionManager;
import javax.jcr.security.AccessControlManager;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.sax.SAXResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.jackrabbit.rmi.client.ClientObject;
import org.apache.jackrabbit.rmi.client.DefaultContentHandler;
import org.apache.jackrabbit.rmi.client.LocalAdapterFactory;
import org.apache.jackrabbit.rmi.client.RemoteRepositoryException;
import org.apache.jackrabbit.rmi.client.RemoteRuntimeException;
import org.apache.jackrabbit.rmi.client.SerializingContentHandler;
import org.apache.jackrabbit.rmi.remote.RemoteSession;
import org.apache.jackrabbit.rmi.value.SerialValueFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class ClientSession
extends ClientObject
implements Session {
    private static final Logger log = LoggerFactory.getLogger(ClientSession.class);
    private final Repository repository;
    private boolean live = true;
    protected final RemoteSession remote;
    private Workspace workspace;

    public ClientSession(Repository repository, RemoteSession remote, LocalAdapterFactory factory) {
        super(factory);
        this.repository = repository;
        this.remote = remote;
    }

    @Override
    public Repository getRepository() {
        return this.repository;
    }

    @Override
    public String getUserID() {
        try {
            return this.remote.getUserID();
        }
        catch (RemoteException ex) {
            throw new RemoteRuntimeException(ex);
        }
    }

    @Override
    public Object getAttribute(String name) {
        try {
            return this.remote.getAttribute(name);
        }
        catch (RemoteException ex) {
            throw new RemoteRuntimeException(ex);
        }
    }

    @Override
    public String[] getAttributeNames() {
        try {
            return this.remote.getAttributeNames();
        }
        catch (RemoteException ex) {
            throw new RemoteRuntimeException(ex);
        }
    }

    @Override
    public Workspace getWorkspace() {
        if (this.workspace == null) {
            try {
                this.workspace = this.getFactory().getWorkspace(this, this.remote.getWorkspace());
            }
            catch (RemoteException ex) {
                throw new RemoteRuntimeException(ex);
            }
        }
        return this.workspace;
    }

    @Override
    public Session impersonate(Credentials credentials) throws RepositoryException {
        try {
            RemoteSession session = this.remote.impersonate(credentials);
            return this.getFactory().getSession(this.repository, session);
        }
        catch (RemoteException ex) {
            throw new RemoteRepositoryException(ex);
        }
    }

    @Override
    public Node getRootNode() throws RepositoryException {
        try {
            return this.getNode(this, this.remote.getRootNode());
        }
        catch (RemoteException ex) {
            throw new RemoteRepositoryException(ex);
        }
    }

    @Override
    public Node getNodeByIdentifier(String id) throws RepositoryException {
        try {
            return this.getNode(this, this.remote.getNodeByIdentifier(id));
        }
        catch (RemoteException ex) {
            throw new RemoteRepositoryException(ex);
        }
    }

    @Override
    public Node getNodeByUUID(String uuid) throws RepositoryException {
        try {
            return this.getNode(this, this.remote.getNodeByUUID(uuid));
        }
        catch (RemoteException ex) {
            throw new RemoteRepositoryException(ex);
        }
    }

    @Override
    public Item getItem(String path) throws RepositoryException {
        try {
            return this.getItem(this, this.remote.getItem(path));
        }
        catch (RemoteException ex) {
            throw new RemoteRepositoryException(ex);
        }
    }

    @Override
    public Node getNode(String path) throws RepositoryException {
        try {
            return this.getNode(this, this.remote.getNode(path));
        }
        catch (RemoteException ex) {
            throw new RemoteRepositoryException(ex);
        }
    }

    @Override
    public Property getProperty(String path) throws RepositoryException {
        try {
            return (Property)this.getItem(this, this.remote.getProperty(path));
        }
        catch (RemoteException ex) {
            throw new RemoteRepositoryException(ex);
        }
    }

    @Override
    public boolean itemExists(String path) throws RepositoryException {
        try {
            return this.remote.itemExists(path);
        }
        catch (RemoteException ex) {
            throw new RemoteRuntimeException(ex);
        }
    }

    @Override
    public boolean nodeExists(String path) throws RepositoryException {
        try {
            return this.remote.nodeExists(path);
        }
        catch (RemoteException ex) {
            throw new RemoteRuntimeException(ex);
        }
    }

    @Override
    public boolean propertyExists(String path) throws RepositoryException {
        try {
            return this.remote.propertyExists(path);
        }
        catch (RemoteException ex) {
            throw new RemoteRuntimeException(ex);
        }
    }

    @Override
    public void removeItem(String path) throws RepositoryException {
        try {
            this.remote.removeItem(path);
        }
        catch (RemoteException ex) {
            throw new RemoteRepositoryException(ex);
        }
    }

    @Override
    public void move(String from, String to) throws RepositoryException {
        try {
            this.remote.move(from, to);
        }
        catch (RemoteException ex) {
            throw new RemoteRepositoryException(ex);
        }
    }

    @Override
    public void save() throws RepositoryException {
        try {
            this.remote.save();
        }
        catch (RemoteException ex) {
            throw new RemoteRepositoryException(ex);
        }
    }

    @Override
    public void refresh(boolean keepChanges) throws RepositoryException {
        try {
            this.remote.refresh(keepChanges);
        }
        catch (RemoteException ex) {
            throw new RemoteRepositoryException(ex);
        }
    }

    @Override
    public boolean hasPendingChanges() throws RepositoryException {
        try {
            return this.remote.hasPendingChanges();
        }
        catch (RemoteException ex) {
            throw new RemoteRepositoryException(ex);
        }
    }

    @Override
    public ValueFactory getValueFactory() {
        return SerialValueFactory.getInstance();
    }

    @Override
    public void checkPermission(String path, String actions) throws AccessControlException, RepositoryException {
        if (!this.hasPermission(path, actions)) {
            throw new AccessControlException("No permission for " + actions + " on " + path);
        }
    }

    @Override
    public boolean hasPermission(String path, String actions) throws RepositoryException {
        try {
            return this.remote.hasPermission(path, actions);
        }
        catch (RemoteException ex) {
            throw new RemoteRuntimeException(ex);
        }
    }

    @Override
    public void importXML(String path, InputStream xml, int mode) throws IOException, RepositoryException {
        try {
            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            byte[] bytes = new byte[4096];
            int n = xml.read(bytes);
            while (n != -1) {
                buffer.write(bytes, 0, n);
                n = xml.read(bytes);
            }
            this.remote.importXML(path, buffer.toByteArray(), mode);
        }
        catch (RemoteException ex) {
            throw new RemoteRepositoryException(ex);
        }
        finally {
            try {
                xml.close();
            }
            catch (IOException iOException) {}
        }
    }

    @Override
    public ContentHandler getImportContentHandler(final String path, final int mode) throws RepositoryException {
        this.getItem(path);
        try {
            final ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            DefaultHandler handler = SerializingContentHandler.getSerializer(buffer);
            return new DefaultContentHandler(handler){

                @Override
                public void endDocument() throws SAXException {
                    super.endDocument();
                    try {
                        ClientSession.this.remote.importXML(path, buffer.toByteArray(), mode);
                    }
                    catch (Exception e) {
                        throw new SAXException("XML import failed", e);
                    }
                }
            };
        }
        catch (SAXException e) {
            throw new RepositoryException("XML serialization failed", e);
        }
    }

    @Override
    public void setNamespacePrefix(String prefix, String uri) throws RepositoryException {
        try {
            this.remote.setNamespacePrefix(prefix, uri);
        }
        catch (RemoteException ex) {
            throw new RemoteRuntimeException(ex);
        }
    }

    @Override
    public String[] getNamespacePrefixes() throws RepositoryException {
        try {
            return this.remote.getNamespacePrefixes();
        }
        catch (RemoteException ex) {
            throw new RemoteRepositoryException(ex);
        }
    }

    @Override
    public String getNamespaceURI(String prefix) throws RepositoryException {
        try {
            return this.remote.getNamespaceURI(prefix);
        }
        catch (RemoteException ex) {
            throw new RemoteRepositoryException(ex);
        }
    }

    @Override
    public String getNamespacePrefix(String uri) throws RepositoryException {
        try {
            return this.remote.getNamespacePrefix(uri);
        }
        catch (RemoteException ex) {
            throw new RemoteRepositoryException(ex);
        }
    }

    @Override
    public void logout() {
        if (!this.isLive()) {
            return;
        }
        try {
            this.remote.logout();
        }
        catch (RemoteException ex) {
            log.warn("Remote logout failed", ex);
        }
        finally {
            this.live = false;
        }
    }

    @Override
    public void addLockToken(String name) {
        try {
            this.remote.addLockToken(name);
        }
        catch (RemoteException ex) {
            throw new RemoteRuntimeException(ex);
        }
    }

    @Override
    public String[] getLockTokens() {
        try {
            return this.remote.getLockTokens();
        }
        catch (RemoteException ex) {
            throw new RemoteRuntimeException(ex);
        }
    }

    @Override
    public void removeLockToken(String name) {
        try {
            this.remote.removeLockToken(name);
        }
        catch (RemoteException ex) {
            throw new RemoteRuntimeException(ex);
        }
    }

    @Override
    public void exportSystemView(String path, ContentHandler handler, boolean binaryAsLink, boolean noRecurse) throws SAXException, RepositoryException {
        try {
            byte[] xml = this.remote.exportSystemView(path, binaryAsLink, noRecurse);
            StreamSource source = new StreamSource(new ByteArrayInputStream(xml));
            SAXResult result = new SAXResult(handler);
            TransformerFactory factory = TransformerFactory.newInstance();
            Transformer transformer = factory.newTransformer();
            transformer.transform(source, result);
        }
        catch (RemoteException ex) {
            throw new RemoteRepositoryException(ex);
        }
        catch (IOException ex) {
            throw new SAXException(ex);
        }
        catch (TransformerConfigurationException ex) {
            throw new SAXException(ex);
        }
        catch (TransformerException ex) {
            throw new SAXException(ex);
        }
    }

    @Override
    public void exportSystemView(String path, OutputStream output, boolean binaryAsLink, boolean noRecurse) throws IOException, RepositoryException {
        try {
            byte[] xml = this.remote.exportSystemView(path, binaryAsLink, noRecurse);
            output.write(xml);
        }
        catch (RemoteException ex) {
            throw new RemoteRepositoryException(ex);
        }
    }

    @Override
    public void exportDocumentView(String path, ContentHandler handler, boolean binaryAsLink, boolean noRecurse) throws SAXException, RepositoryException {
        try {
            byte[] xml = this.remote.exportDocumentView(path, binaryAsLink, noRecurse);
            StreamSource source = new StreamSource(new ByteArrayInputStream(xml));
            SAXResult result = new SAXResult(handler);
            TransformerFactory factory = TransformerFactory.newInstance();
            Transformer transformer = factory.newTransformer();
            transformer.transform(source, result);
        }
        catch (RemoteException ex) {
            throw new RemoteRepositoryException(ex);
        }
        catch (IOException ex) {
            throw new SAXException(ex);
        }
        catch (TransformerConfigurationException ex) {
            throw new SAXException(ex);
        }
        catch (TransformerException ex) {
            throw new SAXException(ex);
        }
    }

    @Override
    public void exportDocumentView(String path, OutputStream output, boolean binaryAsLink, boolean noRecurse) throws IOException, RepositoryException {
        try {
            byte[] xml = this.remote.exportDocumentView(path, binaryAsLink, noRecurse);
            output.write(xml);
        }
        catch (RemoteException ex) {
            throw new RemoteRepositoryException(ex);
        }
    }

    @Override
    public boolean isLive() {
        try {
            return this.live && this.remote.isLive();
        }
        catch (RemoteException e) {
            log.warn("Failed to test remote session state", e);
            return false;
        }
    }

    @Override
    public AccessControlManager getAccessControlManager() throws UnsupportedRepositoryOperationException, RepositoryException {
        try {
            return this.getFactory().getAccessControlManager(this.remote.getAccessControlManager());
        }
        catch (RemoteException ex) {
            throw new RemoteRepositoryException(ex);
        }
    }

    @Override
    public RetentionManager getRetentionManager() throws RepositoryException {
        throw new UnsupportedRepositoryOperationException("TODO: JCR-3206");
    }

    @Override
    public boolean hasCapability(String methodName, Object target, Object[] arguments) throws RepositoryException {
        throw new UnsupportedRepositoryOperationException("TODO: JCR-3206");
    }
}

