/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.xml;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Stack;
import javax.jcr.AccessDeniedException;
import javax.jcr.ItemExistsException;
import javax.jcr.ItemNotFoundException;
import javax.jcr.Property;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import javax.jcr.ValueFormatException;
import javax.jcr.nodetype.ConstraintViolationException;
import javax.jcr.nodetype.NodeDefinition;
import org.apache.jackrabbit.core.NodeImpl;
import org.apache.jackrabbit.core.SessionImpl;
import org.apache.jackrabbit.core.config.ImportConfig;
import org.apache.jackrabbit.core.id.NodeId;
import org.apache.jackrabbit.core.util.ReferenceChangeTracker;
import org.apache.jackrabbit.core.xml.DefaultProtectedItemImporter;
import org.apache.jackrabbit.core.xml.Importer;
import org.apache.jackrabbit.core.xml.NodeInfo;
import org.apache.jackrabbit.core.xml.PropInfo;
import org.apache.jackrabbit.core.xml.ProtectedItemImporter;
import org.apache.jackrabbit.core.xml.ProtectedNodeImporter;
import org.apache.jackrabbit.core.xml.ProtectedPropertyImporter;
import org.apache.jackrabbit.spi.Name;
import org.apache.jackrabbit.spi.QPropertyDefinition;
import org.apache.jackrabbit.spi.commons.name.NameConstants;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SessionImporter
implements Importer {
    private static Logger log = LoggerFactory.getLogger(SessionImporter.class);
    private final SessionImpl session;
    private final NodeImpl importTargetNode;
    private final int uuidBehavior;
    private Stack<NodeImpl> parents;
    private final ReferenceChangeTracker refTracker;
    private final List<ProtectedItemImporter> pItemImporters = new ArrayList<ProtectedItemImporter>();
    private ProtectedNodeImporter pnImporter = null;

    public SessionImporter(NodeImpl importTargetNode, SessionImpl session, int uuidBehavior) {
        this(importTargetNode, session, uuidBehavior, null);
    }

    public SessionImporter(NodeImpl importTargetNode, SessionImpl session, int uuidBehavior, ImportConfig config) {
        DefaultProtectedItemImporter def;
        this.importTargetNode = importTargetNode;
        this.session = session;
        this.uuidBehavior = uuidBehavior;
        this.refTracker = new ReferenceChangeTracker();
        this.parents = new Stack();
        this.parents.push(importTargetNode);
        if (config != null) {
            List<? extends ProtectedItemImporter> iList = config.getProtectedItemImporters();
            for (ProtectedItemImporter protectedItemImporter : iList) {
                if (!protectedItemImporter.init(session, session, false, uuidBehavior, this.refTracker)) continue;
                this.pItemImporters.add(protectedItemImporter);
            }
        }
        if (this.pItemImporters.isEmpty() && (def = new DefaultProtectedItemImporter()).init(session, session, false, uuidBehavior, this.refTracker)) {
            this.pItemImporters.add(def);
        }
    }

    protected void checkPermission(NodeImpl parent, Name nodeName) throws RepositoryException {
        if (!this.session.getAccessManager().isGranted(this.session.getQPath(parent.getPath()), nodeName, 128)) {
            throw new AccessDeniedException("Insufficient permission.");
        }
    }

    protected NodeImpl createNode(NodeImpl parent, Name nodeName, Name nodeTypeName, Name[] mixinNames, NodeId id) throws RepositoryException {
        NodeImpl node = parent.addNode(nodeName, nodeTypeName, id);
        if (mixinNames != null) {
            for (Name mixinName : mixinNames) {
                node.addMixin(mixinName);
            }
        }
        return node;
    }

    protected void createProperty(NodeImpl node, PropInfo pInfo, QPropertyDefinition def) throws RepositoryException {
        Value[] va = pInfo.getValues(pInfo.getTargetType(def), this.session);
        Name name = pInfo.getName();
        int type = pInfo.getType();
        if (va.length == 1 && !def.isMultiple()) {
            RepositoryException e = null;
            try {
                node.setProperty(name, va[0]);
            }
            catch (ValueFormatException vfe) {
                e = vfe;
            }
            catch (ConstraintViolationException cve) {
                e = cve;
            }
            if (e != null) {
                node.setProperty(name, va, type);
            }
        } else {
            node.setProperty(name, va, type);
        }
        if (type == 9 || type == 10) {
            this.refTracker.processedReference(node.getProperty(name));
        }
    }

    protected NodeImpl resolveUUIDConflict(NodeImpl parent, NodeId conflictingId, NodeInfo nodeInfo) throws RepositoryException {
        NodeImpl node;
        NodeImpl conflicting;
        try {
            conflicting = this.session.getNodeById(conflictingId);
        }
        catch (ItemNotFoundException infe) {
            conflicting = null;
        }
        if (this.uuidBehavior == 0) {
            this.checkPermission(parent, nodeInfo.getName());
            node = this.createNode(parent, nodeInfo.getName(), nodeInfo.getNodeTypeName(), nodeInfo.getMixinNames(), null);
            if (node.isNodeType(NameConstants.MIX_REFERENCEABLE)) {
                this.refTracker.mappedId(nodeInfo.getId(), node.getNodeId());
            }
        } else {
            if (this.uuidBehavior == 3) {
                if (conflicting != null && conflicting.isNodeType(NameConstants.MIX_SHAREABLE)) {
                    parent.clone(conflicting, nodeInfo.getName());
                    return null;
                }
                String msg = "a node with uuid " + nodeInfo.getId() + " already exists!";
                log.debug(msg);
                throw new ItemExistsException(msg);
            }
            if (this.uuidBehavior == 1) {
                if (conflicting == null) {
                    String msg = "node with uuid " + conflictingId + " cannot be removed";
                    log.debug(msg);
                    throw new RepositoryException(msg);
                }
                if (this.importTargetNode.getPath().startsWith(conflicting.getPath())) {
                    String msg = "cannot remove ancestor node";
                    log.debug(msg);
                    throw new ConstraintViolationException(msg);
                }
                conflicting.remove();
                this.checkPermission(parent, nodeInfo.getName());
                node = this.createNode(parent, nodeInfo.getName(), nodeInfo.getNodeTypeName(), nodeInfo.getMixinNames(), nodeInfo.getId());
            } else if (this.uuidBehavior == 2) {
                if (conflicting == null) {
                    String msg = "node with uuid " + conflictingId + " cannot be replaced";
                    log.debug(msg);
                    throw new RepositoryException(msg);
                }
                if (conflicting.getDepth() == 0) {
                    String msg = "root node cannot be replaced";
                    log.debug(msg);
                    throw new RepositoryException(msg);
                }
                parent = (NodeImpl)conflicting.getParent();
                this.checkPermission(parent, nodeInfo.getName());
                node = parent.replaceChildNode(nodeInfo.getId(), nodeInfo.getName(), nodeInfo.getNodeTypeName(), nodeInfo.getMixinNames());
            } else {
                String msg = "unknown uuidBehavior: " + this.uuidBehavior;
                log.debug(msg);
                throw new RepositoryException(msg);
            }
        }
        return node;
    }

    @Override
    public void start() throws RepositoryException {
    }

    @Override
    public void startNode(NodeInfo nodeInfo, List<PropInfo> propInfos) throws RepositoryException {
        NodeImpl existing;
        NodeDefinition def;
        NodeImpl parent = this.parents.peek();
        NodeImpl node = null;
        NodeId id = nodeInfo.getId();
        Name nodeName = nodeInfo.getName();
        Name ntName = nodeInfo.getNodeTypeName();
        Name[] mixins = nodeInfo.getMixinNames();
        if (parent == null) {
            log.debug("Skipping node: " + nodeName);
            this.parents.push(null);
            if (this.pnImporter != null) {
                this.pnImporter.startChildInfo(nodeInfo, propInfos);
            }
            return;
        }
        if (parent.getDefinition().isProtected()) {
            this.parents.push(null);
            log.debug("Skipping protected node: " + nodeName);
            if (this.pnImporter != null) {
                this.pnImporter.startChildInfo(nodeInfo, propInfos);
            } else {
                for (ProtectedItemImporter pni : this.pItemImporters) {
                    if (!(pni instanceof ProtectedNodeImporter) || !((ProtectedNodeImporter)pni).start(parent)) continue;
                    log.debug("Protected node -> delegated to ProtectedNodeImporter");
                    this.pnImporter = (ProtectedNodeImporter)pni;
                    this.pnImporter.startChildInfo(nodeInfo, propInfos);
                    break;
                }
            }
            return;
        }
        if (parent.hasNode(nodeName) && !(def = (existing = parent.getNode(nodeName)).getDefinition()).allowsSameNameSiblings()) {
            if (def.isProtected() && existing.isNodeType(ntName)) {
                log.debug("Skipping protected node: " + existing);
                this.parents.push(existing);
                return;
            }
            if (def.isAutoCreated() && existing.isNodeType(ntName)) {
                node = existing;
            } else {
                boolean sameId = existing.getId().equals(id);
                if (!sameId || sameId && this.uuidBehavior == 0) {
                    throw new ItemExistsException("Same name sibling not allowed for " + existing + " by definition " + def.getName() + " (declaring type " + def.getDeclaringNodeType().getName() + ")");
                }
            }
        }
        if (node == null) {
            if (id == null) {
                this.checkPermission(parent, nodeName);
                node = this.createNode(parent, nodeName, ntName, mixins, null);
            } else {
                boolean isConflicting;
                try {
                    this.session.getHierarchyManager().getName(id);
                    isConflicting = true;
                }
                catch (ItemNotFoundException infe) {
                    isConflicting = false;
                }
                if (isConflicting) {
                    node = this.resolveUUIDConflict(parent, id, nodeInfo);
                    if (node == null) {
                        this.parents.push(null);
                        log.debug("Skipping existing node " + nodeInfo.getName());
                        return;
                    }
                } else {
                    this.checkPermission(parent, nodeName);
                    node = this.createNode(parent, nodeName, ntName, mixins, id);
                }
            }
        }
        block3: for (PropInfo pi : propInfos) {
            QPropertyDefinition def2 = pi.getApplicablePropertyDef(node.getEffectiveNodeType());
            if (def2.isProtected()) {
                log.debug("Skipping protected property " + pi.getName());
                for (ProtectedItemImporter ppi : this.pItemImporters) {
                    if (!(ppi instanceof ProtectedPropertyImporter) || !((ProtectedPropertyImporter)ppi).handlePropInfo(node, pi, def2)) continue;
                    log.debug("Protected property -> delegated to ProtectedPropertyImporter");
                    continue block3;
                }
                continue;
            }
            this.createProperty(node, pi, def2);
        }
        this.parents.push(node);
    }

    @Override
    public void endNode(NodeInfo nodeInfo) throws RepositoryException {
        NodeImpl parent = this.parents.pop();
        if (parent == null) {
            if (this.pnImporter != null) {
                this.pnImporter.endChildInfo();
            }
        } else if (parent.getDefinition().isProtected() && this.pnImporter != null) {
            this.pnImporter.end(parent);
            this.pnImporter = null;
        }
    }

    @Override
    public void end() throws RepositoryException {
        for (ProtectedItemImporter ppi : this.pItemImporters) {
            ppi.processReferences();
        }
        Iterator<Object> iter = this.refTracker.getProcessedReferences();
        while (iter.hasNext()) {
            Property prop;
            Object ref = iter.next();
            if (!(ref instanceof Property) || (prop = (Property)ref).getType() != 9 && prop.getType() != 10) continue;
            if (prop.isMultiple()) {
                Value[] values = prop.getValues();
                Value[] newVals = new Value[values.length];
                for (int i = 0; i < values.length; ++i) {
                    Value val = values[i];
                    NodeId original = new NodeId(val.getString());
                    NodeId adjusted = this.refTracker.getMappedId(original);
                    newVals[i] = adjusted != null ? this.session.getValueFactory().createValue(this.session.getNodeById(adjusted), prop.getType() != 9) : val;
                }
                prop.setValue(newVals);
                continue;
            }
            Value val = prop.getValue();
            NodeId original = new NodeId(val.getString());
            NodeId adjusted = this.refTracker.getMappedId(original);
            if (adjusted == null) continue;
            prop.setValue(this.session.getNodeById(adjusted).getUUID());
        }
        this.refTracker.clear();
    }
}

