/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.relational.sql.ast;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.AstVisitor;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Expression;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Identifier;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Node;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.NodeLocation;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.TableFunctionTableArgument;

public class TableFunctionArgument
extends Node {
    private final Optional<Identifier> name;
    private final Node value;

    public TableFunctionArgument(NodeLocation location, Optional<Identifier> name, Node value) {
        super(location);
        this.name = Objects.requireNonNull(name, "name is null");
        Objects.requireNonNull(value, "value is null");
        Preconditions.checkArgument((value instanceof TableFunctionTableArgument || value instanceof Expression ? 1 : 0) != 0);
        this.value = value;
    }

    public Optional<Identifier> getName() {
        return this.name;
    }

    public Node getValue() {
        return this.value;
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitTableFunctionArgument(this, context);
    }

    @Override
    public List<? extends Node> getChildren() {
        return ImmutableList.of((Object)this.value);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TableFunctionArgument other = (TableFunctionArgument)o;
        return Objects.equals(this.name, other.name) && Objects.equals(this.value, other.value);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.name, this.value);
    }

    @Override
    public String toString() {
        return this.name.map(identifier -> identifier + " => ").orElse("") + this.value;
    }

    @Override
    public boolean shallowEquals(Node o) {
        if (!TableFunctionArgument.sameClass(this, o)) {
            return false;
        }
        return Objects.equals(this.name, ((TableFunctionArgument)o).name);
    }
}

