/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.tools.upgrade;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.iotdb.db.engine.StorageEngine;
import org.apache.iotdb.db.engine.storagegroup.TsFileResource;
import org.apache.iotdb.db.exception.metadata.IllegalPathException;
import org.apache.iotdb.db.tools.TsFileRewriteTool;
import org.apache.iotdb.tsfile.exception.write.WriteProcessException;
import org.apache.iotdb.tsfile.file.header.PageHeader;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSEncoding;
import org.apache.iotdb.tsfile.read.common.BatchData;
import org.apache.iotdb.tsfile.v2.read.TsFileSequenceReaderForV2;
import org.apache.iotdb.tsfile.v2.read.reader.page.PageReaderV2;
import org.apache.iotdb.tsfile.write.chunk.ChunkWriterImpl;
import org.apache.iotdb.tsfile.write.schema.MeasurementSchema;
import org.apache.iotdb.tsfile.write.writer.TsFileIOWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TsFileOnlineUpgradeTool
extends TsFileRewriteTool {
    private static final Logger logger = LoggerFactory.getLogger(TsFileOnlineUpgradeTool.class);

    public TsFileOnlineUpgradeTool(TsFileResource resourceToBeUpgraded) throws IOException {
        super(resourceToBeUpgraded, true);
    }

    public static void upgradeOneTsFile(TsFileResource resourceToBeUpgraded, List<TsFileResource> upgradedResources) throws IOException, WriteProcessException {
        try (TsFileOnlineUpgradeTool updater = new TsFileOnlineUpgradeTool(resourceToBeUpgraded);){
            updater.upgradeFile(upgradedResources);
        }
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void upgradeFile(List<TsFileResource> upgradedResources) throws IOException, WriteProcessException {
        block21: {
            if (!this.fileCheck()) {
                return;
            }
            headerLength = "TsFile".getBytes().length + "000002".getBytes().length;
            this.reader.position((long)headerLength);
            firstChunkPositionInChunkGroup = headerLength;
            firstChunkInChunkGroup = true;
            deviceId = null;
            skipReadingChunk = true;
            try lbl-1000:
            // 2 sources

            {
                block10: while (true) {
                    if ((marker = this.reader.readMarker()) != 2) {
                        switch (marker) {
                            case 1: {
                                chunkHeaderOffset = this.reader.position() - 1L;
                                if (skipReadingChunk || deviceId == null) {
                                    header = ((TsFileSequenceReaderForV2)this.reader).readChunkHeader();
                                    dataSize = header.getDataSize();
                                    break block21;
                                } else {
                                    header = ((TsFileSequenceReaderForV2)this.reader).readChunkHeader();
                                    measurementSchema = new MeasurementSchema(header.getMeasurementID(), header.getDataType(), header.getEncodingType(), header.getCompressionType());
                                    dataType = header.getDataType();
                                    encoding = header.getEncodingType();
                                    pageHeadersInChunk = new ArrayList<PageHeader>();
                                    dataInChunk = new ArrayList<ByteBuffer>();
                                    needToDecodeInfo = new ArrayList<Boolean>();
                                    for (dataSize = header.getDataSize(); dataSize > 0; dataSize -= 32 + (pageHeader.getStatistics().getStatsSize() - (dataType == TSDataType.BOOLEAN ? 8 : 0)) + pageHeader.getCompressedSize()) {
                                        pageHeader = ((TsFileSequenceReaderForV2)this.reader).readPageHeader(dataType);
                                        needToDecode = this.checkIfNeedToDecode(dataType, encoding, pageHeader, measurementSchema, deviceId, chunkHeaderOffset);
                                        needToDecodeInfo.add(needToDecode);
                                        pageData = needToDecode == false ? this.reader.readCompressedPage(pageHeader) : this.reader.readPage(pageHeader, header.getCompressionType());
                                        pageHeadersInChunk.add(pageHeader);
                                        dataInChunk.add(pageData);
                                    }
                                    this.reWriteChunk(deviceId, firstChunkInChunkGroup, measurementSchema, pageHeadersInChunk, dataInChunk, needToDecodeInfo, chunkHeaderOffset);
                                    if (!firstChunkInChunkGroup) continue block10;
                                    firstChunkInChunkGroup = false;
                                    continue block10;
                                }
                            }
                            case 0: {
                                if (skipReadingChunk) {
                                    skipReadingChunk = false;
                                    chunkGroupFooter = ((TsFileSequenceReaderForV2)this.reader).readChunkGroupFooter();
                                    deviceId = chunkGroupFooter.getDeviceID();
                                    this.reader.position(firstChunkPositionInChunkGroup);
                                    continue block10;
                                }
                                this.endChunkGroup();
                                skipReadingChunk = true;
                                ((TsFileSequenceReaderForV2)this.reader).readChunkGroupFooter();
                                deviceId = null;
                                firstChunkPositionInChunkGroup = this.reader.position();
                                firstChunkInChunkGroup = true;
                                continue block10;
                            }
                            case 3: {
                                version = ((TsFileSequenceReaderForV2)this.reader).readVersion();
                                for (TsFileIOWriter tsFileIOWriter : this.partitionWriterMap.values()) {
                                    tsFileIOWriter.writePlanIndices();
                                }
                                firstChunkPositionInChunkGroup = this.reader.position();
                                continue block10;
                            }
                            default: {
                                throw new IOException("Unrecognized marker detected, this file may be corrupted");
                            }
                        }
                    }
                    for (TsFileIOWriter tsFileIOWriter : this.partitionWriterMap.values()) {
                        upgradedResources.add(this.endFileAndGenerateResource(tsFileIOWriter));
                    }
                    this.oldTsFileResource.removeModFile();
                    return;
                }
            }
            catch (Exception e2) {
                throw new IOException("TsFile upgrade process cannot proceed at position " + this.reader.position() + "because: " + e2.getMessage());
            }
            finally {
                if (this.reader != null) {
                    this.reader.close();
                }
            }
        }
        while (true) {
            if (dataSize > 0) ** break;
            ** continue;
            pageHeader = ((TsFileSequenceReaderForV2)this.reader).readPageHeader(header.getDataType());
            ((TsFileSequenceReaderForV2)this.reader).readCompressedPage(pageHeader);
            dataSize -= 32 + (pageHeader.getStatistics().getStatsSize() - (header.getDataType() == TSDataType.BOOLEAN ? 8 : 0)) + pageHeader.getCompressedSize();
        }
    }

    @Override
    public String upgradeTsFileName(String oldTsFileName) {
        String[] name = oldTsFileName.split(".tsfile");
        return name[0] + "-0" + ".tsfile";
    }

    protected boolean checkIfNeedToDecode(TSDataType dataType, TSEncoding encoding, PageHeader pageHeader, MeasurementSchema schema, String deviceId, long chunkHeaderOffset) throws IllegalPathException {
        return dataType == TSDataType.BOOLEAN || dataType == TSDataType.TEXT || dataType == TSDataType.INT32 && encoding == TSEncoding.PLAIN || StorageEngine.getTimePartition(pageHeader.getStartTime()) != StorageEngine.getTimePartition(pageHeader.getEndTime()) || super.checkIfNeedToDecode(schema, deviceId, pageHeader, chunkHeaderOffset);
    }

    protected void decodeAndWritePage(MeasurementSchema schema, ByteBuffer pageData, Map<Long, ChunkWriterImpl> partitionChunkWriterMap) throws IOException {
        this.valueDecoder.reset();
        PageReaderV2 pageReader = new PageReaderV2(pageData, schema.getType(), this.valueDecoder, this.defaultTimeDecoder, null);
        BatchData batchData = pageReader.getAllSatisfiedPageData();
        this.rewritePageIntoFiles(batchData, schema, partitionChunkWriterMap);
    }

    @Override
    protected boolean fileCheck() throws IOException {
        String magic = this.reader.readHeadMagic();
        if (!magic.equals("TsFile")) {
            logger.error("the file's MAGIC STRING is incorrect, file path: {}", (Object)this.reader.getFileName());
            return false;
        }
        String versionNumber = ((TsFileSequenceReaderForV2)this.reader).readVersionNumberV2();
        if (!versionNumber.equals("000002")) {
            logger.error("the file's Version Number is incorrect, file path: {}", (Object)this.reader.getFileName());
            return false;
        }
        if (!this.reader.readTailMagic().equals("TsFile")) {
            logger.error("the file is not closed correctly, file path: {}", (Object)this.reader.getFileName());
            return false;
        }
        return true;
    }
}

