/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.engine.compaction.cross.rewrite.selector;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.engine.compaction.cross.rewrite.TsFileDeviceInfoStore;
import org.apache.iotdb.db.engine.compaction.cross.rewrite.manage.CrossSpaceCompactionResource;
import org.apache.iotdb.db.engine.compaction.cross.rewrite.selector.AbstractCompactionEstimator;
import org.apache.iotdb.db.engine.compaction.cross.rewrite.selector.ICrossSpaceMergeFileSelector;
import org.apache.iotdb.db.engine.compaction.cross.rewrite.selector.RewriteCrossCompactionEstimator;
import org.apache.iotdb.db.engine.storagegroup.TsFileNameGenerator;
import org.apache.iotdb.db.engine.storagegroup.TsFileResource;
import org.apache.iotdb.db.engine.storagegroup.TsFileResourceStatus;
import org.apache.iotdb.db.exception.MergeException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RewriteCompactionFileSelector
implements ICrossSpaceMergeFileSelector {
    private static final Logger logger = LoggerFactory.getLogger(RewriteCompactionFileSelector.class);
    private static final String LOG_FILE_COST = "Memory cost of file {} is {}";
    CrossSpaceCompactionResource resource;
    long totalCost;
    private long memoryBudget;
    private long maxSeqFileCost;
    private int maxCrossCompactionFileNum;
    int concurrentMergeNum = 1;
    private Map<TsFileResource, Long> fileMetaSizeMap = new HashMap<TsFileResource, Long>();
    private Map<TsFileResource, Long> maxSeriesQueryCostMap = new HashMap<TsFileResource, Long>();
    List<TsFileResource> selectedUnseqFiles;
    List<TsFileResource> selectedSeqFiles;
    private Collection<Integer> tmpSelectedSeqFiles;
    private long tempMaxSeqFileCost;
    private long totalSize;
    private final long maxCrossCompactionFileSize;
    private boolean[] seqSelected;
    private int seqSelectedNum;
    private AbstractCompactionEstimator compactionEstimator;
    private final TsFileDeviceInfoStore deviceInfoStore;

    public RewriteCompactionFileSelector(CrossSpaceCompactionResource resource, long memoryBudget) {
        this.resource = resource;
        this.memoryBudget = memoryBudget;
        this.maxCrossCompactionFileNum = IoTDBDescriptor.getInstance().getConfig().getMaxCrossCompactionCandidateFileNum();
        this.maxCrossCompactionFileSize = IoTDBDescriptor.getInstance().getConfig().getMaxCrossCompactionCandidateFileSize();
        this.compactionEstimator = new RewriteCrossCompactionEstimator();
        this.deviceInfoStore = new TsFileDeviceInfoStore();
    }

    @Override
    public List[] select() throws MergeException {
        long startTime = System.currentTimeMillis();
        this.totalSize = 0L;
        try {
            logger.debug("Selecting merge candidates from {} seqFile, {} unseqFiles", (Object)this.resource.getSeqFiles().size(), (Object)this.resource.getUnseqFiles().size());
            this.selectFiles();
            this.resource.setSeqFiles(this.selectedSeqFiles);
            this.resource.setUnseqFiles(this.selectedUnseqFiles);
            this.resource.removeOutdatedSeqReaders();
            if (this.selectedUnseqFiles.isEmpty()) {
                logger.debug("No merge candidates are found");
                List[] listArray = new List[]{};
                return listArray;
            }
        }
        catch (IOException e) {
            throw new MergeException(e);
        }
        finally {
            try {
                this.compactionEstimator.close();
            }
            catch (Exception e) {
                throw new MergeException(e);
            }
        }
        if (logger.isInfoEnabled()) {
            logger.info("Selected merge candidates, {} seqFiles, {} unseqFiles, total memory cost {}, time consumption {}ms", new Object[]{this.selectedSeqFiles.size(), this.selectedUnseqFiles.size(), this.totalCost, System.currentTimeMillis() - startTime});
        }
        return new List[]{this.selectedSeqFiles, this.selectedUnseqFiles};
    }

    void selectFiles() throws IOException {
        this.tmpSelectedSeqFiles = new HashSet<Integer>();
        this.seqSelected = new boolean[this.resource.getSeqFiles().size()];
        this.seqSelectedNum = 0;
        this.selectedSeqFiles = new ArrayList<TsFileResource>();
        this.selectedUnseqFiles = new ArrayList<TsFileResource>();
        this.maxSeqFileCost = 0L;
        this.tempMaxSeqFileCost = 0L;
        this.totalCost = 0L;
        int unseqIndex = 0;
        long startTime = System.currentTimeMillis();
        long timeConsumption = 0L;
        long timeLimit = IoTDBDescriptor.getInstance().getConfig().getCrossCompactionFileSelectionTimeBudget();
        if (timeLimit < 0L) {
            timeLimit = Long.MAX_VALUE;
        }
        while (unseqIndex < this.resource.getUnseqFiles().size() && timeConsumption < timeLimit) {
            boolean isSeqFilesValid;
            TsFileResource unseqFile = this.resource.getUnseqFiles().get(unseqIndex);
            if (this.seqSelectedNum != this.resource.getSeqFiles().size()) {
                this.selectOverlappedSeqFiles(unseqFile);
            }
            if (!(isSeqFilesValid = this.checkIsSeqFilesValid())) {
                this.tmpSelectedSeqFiles.clear();
                break;
            }
            for (int i = 0; i < this.seqSelected.length; ++i) {
                if (!this.seqSelected[i]) continue;
                this.tmpSelectedSeqFiles.remove(i);
            }
            ArrayList<TsFileResource> tmpSelectedSeqFileResources = new ArrayList<TsFileResource>();
            for (int seqIndex : this.tmpSelectedSeqFiles) {
                TsFileResource tsFileResource = this.resource.getSeqFiles().get(seqIndex);
                tmpSelectedSeqFileResources.add(tsFileResource);
                this.totalSize += this.resource.getSeqFiles().get(seqIndex).getTsFileSize();
            }
            this.totalSize += unseqFile.getTsFileSize();
            this.tempMaxSeqFileCost = this.maxSeqFileCost;
            long newCost = this.compactionEstimator.estimateCrossCompactionMemory(tmpSelectedSeqFileResources, unseqFile);
            if (!this.updateSelectedFiles(newCost, unseqFile)) break;
            this.tmpSelectedSeqFiles.clear();
            ++unseqIndex;
            timeConsumption = System.currentTimeMillis() - startTime;
        }
        for (int i = 0; i < this.seqSelected.length; ++i) {
            if (!this.seqSelected[i]) continue;
            this.selectedSeqFiles.add(this.resource.getSeqFiles().get(i));
        }
    }

    private boolean updateSelectedFiles(long newCost, TsFileResource unseqFile) {
        if (this.selectedUnseqFiles.size() == 0 || this.seqSelectedNum + this.selectedUnseqFiles.size() + 1 + this.tmpSelectedSeqFiles.size() <= this.maxCrossCompactionFileNum && this.totalSize <= this.maxCrossCompactionFileSize && this.totalCost + newCost < this.memoryBudget) {
            this.selectedUnseqFiles.add(unseqFile);
            this.maxSeqFileCost = this.tempMaxSeqFileCost;
            for (Integer seqIdx : this.tmpSelectedSeqFiles) {
                if (this.seqSelected[seqIdx]) continue;
                ++this.seqSelectedNum;
                this.seqSelected[seqIdx.intValue()] = true;
            }
            this.totalCost += newCost;
            logger.debug("Adding a new unseqFile {} and seqFiles {} as candidates, new cost {}, total cost {}", new Object[]{unseqFile, this.tmpSelectedSeqFiles, newCost, this.totalCost});
            return true;
        }
        return false;
    }

    private boolean checkIsSeqFilesValid() {
        for (Integer seqIdx : this.tmpSelectedSeqFiles) {
            if (this.resource.getSeqFiles().get(seqIdx).getStatus() == TsFileResourceStatus.CLOSED && this.resource.getSeqFiles().get(seqIdx).getTsFile().exists()) continue;
            return false;
        }
        return true;
    }

    private void selectOverlappedSeqFiles(TsFileResource unseqFile) throws IOException {
        int SELECT_WARN_THRESHOLD = 10;
        TsFileDeviceInfoStore.TsFileDeviceInfo unseqFileDeviceInfo = new TsFileDeviceInfoStore.TsFileDeviceInfo(unseqFile);
        for (TsFileDeviceInfoStore.DeviceInfo deviceInfo : unseqFileDeviceInfo.getDevices()) {
            String deviceId = deviceInfo.deviceId;
            long unseqStartTime = deviceInfo.startTime;
            long unseqEndTime = deviceInfo.endTime;
            boolean noMoreOverlap = false;
            for (int i = 0; i < this.resource.getSeqFiles().size() && !noMoreOverlap; ++i) {
                TsFileResource seqFile = this.resource.getSeqFiles().get(i);
                TsFileDeviceInfoStore.TsFileDeviceInfo seqFileDeviceInfo = this.deviceInfoStore.get(seqFile);
                if (!seqFileDeviceInfo.containsDevice(deviceId)) continue;
                int crossSpaceCompactionTimes = 0;
                try {
                    TsFileNameGenerator.TsFileName tsFileName = TsFileNameGenerator.getTsFileName(seqFile.getTsFile().getName());
                    crossSpaceCompactionTimes = tsFileName.getCrossCompactionCnt();
                }
                catch (IOException e) {
                    logger.warn("Meets IOException when selecting files for cross space compaction", (Throwable)e);
                }
                long seqEndTime = seqFileDeviceInfo.getDeviceInfoById((String)deviceId).endTime;
                long seqStartTime = seqFileDeviceInfo.getDeviceInfoById((String)deviceId).startTime;
                if (!seqFile.isClosed()) {
                    if (unseqEndTime < seqStartTime) continue;
                    this.tmpSelectedSeqFiles.add(i);
                    if (crossSpaceCompactionTimes < 10) continue;
                    logger.warn("{} is selected for cross space compaction, it is overlapped with {}. It's selected because its start time {} is less than or equals to unseq file's endTime {} in device {}", new Object[]{seqFile.getTsFile().getAbsolutePath(), unseqFile.getTsFile().getAbsolutePath(), seqStartTime, unseqEndTime, deviceId});
                    continue;
                }
                if (unseqEndTime <= seqEndTime) {
                    this.tmpSelectedSeqFiles.add(i);
                    noMoreOverlap = true;
                    if (crossSpaceCompactionTimes < 10) continue;
                    logger.warn("{} is selected for cross space compaction, it is overlapped with {}. It's selected because its end time {} is greater than or equals to unseq file's endTime {} in device {}", new Object[]{seqFile.getTsFile().getAbsolutePath(), unseqFile.getTsFile().getAbsolutePath(), seqEndTime, unseqEndTime, deviceId});
                    continue;
                }
                if (unseqStartTime > seqEndTime) continue;
                this.tmpSelectedSeqFiles.add(i);
                if (crossSpaceCompactionTimes < 10) continue;
                logger.warn("{} is selected for cross space compaction, it is overlapped with {}. It's selected because its end time {} is greater than or equals to unseq file's startTime {} in device {}", new Object[]{seqFile.getTsFile().getAbsolutePath(), unseqFile.getTsFile().getAbsolutePath(), seqEndTime, unseqStartTime, deviceId});
            }
        }
    }

    @Override
    public int getConcurrentMergeNum() {
        return this.concurrentMergeNum;
    }

    @Override
    public List<Long> getMemoryCost() {
        return Collections.singletonList(this.totalCost);
    }
}

