/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.persistence.snapshot;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.FileChannel;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteException;
import org.apache.ignite.IgniteSnapshot;
import org.apache.ignite.binary.BinaryType;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.events.DiscoveryEvent;
import org.apache.ignite.events.SnapshotEvent;
import org.apache.ignite.internal.GridClosureCallMode;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.IgniteClientDisconnectedCheckedException;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.IgniteFeatures;
import org.apache.ignite.internal.IgniteFutureCancelledCheckedException;
import org.apache.ignite.internal.IgniteInternalFuture;
import org.apache.ignite.internal.MarshallerContextImpl;
import org.apache.ignite.internal.NodeStoppingException;
import org.apache.ignite.internal.cluster.ClusterTopologyCheckedException;
import org.apache.ignite.internal.events.DiscoveryCustomEvent;
import org.apache.ignite.internal.managers.eventstorage.DiscoveryEventListener;
import org.apache.ignite.internal.processors.affinity.AffinityTopologyVersion;
import org.apache.ignite.internal.processors.cache.CacheGroupDescriptor;
import org.apache.ignite.internal.processors.cache.CacheType;
import org.apache.ignite.internal.processors.cache.GridCacheSharedManagerAdapter;
import org.apache.ignite.internal.processors.cache.binary.CacheObjectBinaryProcessorImpl;
import org.apache.ignite.internal.processors.cache.distributed.dht.preloader.GridDhtPartitionsExchangeFuture;
import org.apache.ignite.internal.processors.cache.distributed.dht.preloader.PartitionsExchangeAware;
import org.apache.ignite.internal.processors.cache.persistence.file.FileIO;
import org.apache.ignite.internal.processors.cache.persistence.file.FileIOFactory;
import org.apache.ignite.internal.processors.cache.persistence.file.FilePageStore;
import org.apache.ignite.internal.processors.cache.persistence.file.FilePageStoreFactory;
import org.apache.ignite.internal.processors.cache.persistence.file.FilePageStoreManager;
import org.apache.ignite.internal.processors.cache.persistence.file.RandomAccessFileIOFactory;
import org.apache.ignite.internal.processors.cache.persistence.filename.PdsFolderSettings;
import org.apache.ignite.internal.processors.cache.persistence.metastorage.MetastorageLifecycleListener;
import org.apache.ignite.internal.processors.cache.persistence.metastorage.ReadOnlyMetastorage;
import org.apache.ignite.internal.processors.cache.persistence.metastorage.ReadWriteMetastorage;
import org.apache.ignite.internal.processors.cache.persistence.partstate.GroupPartitionId;
import org.apache.ignite.internal.processors.cache.persistence.snapshot.SnapshotDiscoveryMessage;
import org.apache.ignite.internal.processors.cache.persistence.snapshot.SnapshotFutureTask;
import org.apache.ignite.internal.processors.cache.persistence.snapshot.SnapshotSender;
import org.apache.ignite.internal.processors.cache.persistence.tree.io.PageIO;
import org.apache.ignite.internal.processors.cache.persistence.wal.crc.FastCrc;
import org.apache.ignite.internal.processors.cluster.DiscoveryDataClusterState;
import org.apache.ignite.internal.processors.marshaller.MappedName;
import org.apache.ignite.internal.processors.metric.MetricRegistry;
import org.apache.ignite.internal.processors.task.GridInternal;
import org.apache.ignite.internal.util.GridBusyLock;
import org.apache.ignite.internal.util.IgniteUtils;
import org.apache.ignite.internal.util.distributed.DistributedProcess;
import org.apache.ignite.internal.util.distributed.InitMessage;
import org.apache.ignite.internal.util.future.GridFinishedFuture;
import org.apache.ignite.internal.util.future.GridFutureAdapter;
import org.apache.ignite.internal.util.future.IgniteFinishedFutureImpl;
import org.apache.ignite.internal.util.future.IgniteFutureImpl;
import org.apache.ignite.internal.util.lang.GridClosureException;
import org.apache.ignite.internal.util.lang.GridPlainRunnable;
import org.apache.ignite.internal.util.tostring.GridToStringInclude;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.A;
import org.apache.ignite.internal.util.typedef.internal.CU;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgniteCallable;
import org.apache.ignite.lang.IgniteFuture;
import org.apache.ignite.lang.IgnitePredicate;
import org.apache.ignite.plugin.security.SecurityPermission;
import org.apache.ignite.resources.IgniteInstanceResource;
import org.apache.ignite.thread.IgniteThreadPoolExecutor;
import org.apache.ignite.thread.OomExceptionHandler;
import org.jetbrains.annotations.Nullable;

public class IgniteSnapshotManager
extends GridCacheSharedManagerAdapter
implements IgniteSnapshot,
PartitionsExchangeAware,
MetastorageLifecycleListener {
    public static final String DELTA_SUFFIX = ".delta";
    public static final String PART_DELTA_TEMPLATE = "part-%d.bin.delta";
    public static final String INDEX_DELTA_NAME = "index.bin.delta";
    public static final String CP_SNAPSHOT_REASON = "Checkpoint started to enforce snapshot operation: %s";
    public static final String DFLT_SNAPSHOT_TMP_DIR = "snp";
    public static final String SNP_IN_PROGRESS_ERR_MSG = "Operation rejected due to the snapshot operation in progress.";
    public static final String SNP_NODE_STOPPING_ERR_MSG = "Snapshot has been cancelled due to the local node is stopping";
    public static final String SNP_RUNNING_KEY = "snapshot-running";
    public static final String SNAPSHOT_METRICS = "snapshot";
    private static final String SNAPSHOT_RUNNER_THREAD_PREFIX = "snapshot-runner";
    private static final String SNAPSHOT_FINISHED_MSG = "Cluster-wide snapshot operation finished successfully: ";
    private static final String SNAPSHOT_FAILED_MSG = "Cluster-wide snapshot operation failed: ";
    private static final int SNAPSHOT_THREAD_POOL_SIZE = 4;
    private final ThreadLocal<ByteBuffer> locBuff;
    private final ConcurrentMap<String, SnapshotFutureTask> locSnpTasks = new ConcurrentHashMap<String, SnapshotFutureTask>();
    private final GridBusyLock busyLock = new GridBusyLock();
    private final Object snpOpMux = new Object();
    private final DistributedProcess<SnapshotOperationRequest, SnapshotOperationResponse> startSnpProc;
    private final DistributedProcess<SnapshotOperationRequest, SnapshotOperationResponse> endSnpProc;
    private volatile PdsFolderSettings pdsSettings;
    private volatile ReadWriteMetastorage metaStorage;
    private Function<String, SnapshotSender> locSndrFactory = x$0 -> new LocalSnapshotSender((String)x$0);
    private volatile File locSnpDir;
    private File tmpWorkDir;
    private volatile FileIOFactory ioFactory = new RandomAccessFileIOFactory();
    private volatile BiFunction<Integer, Boolean, FilePageStoreFactory> storeFactory;
    private ExecutorService snpRunner;
    private DiscoveryEventListener discoLsnr;
    private ClusterSnapshotFuture clusterSnpFut;
    private volatile SnapshotOperationRequest clusterSnpReq;
    private volatile boolean recovered;
    private volatile ClusterSnapshotFuture lastSeenSnpFut = new ClusterSnapshotFuture();

    public IgniteSnapshotManager(GridKernalContext ctx) {
        this.locBuff = ThreadLocal.withInitial(() -> ByteBuffer.allocateDirect(ctx.config().getDataStorageConfiguration().getPageSize()).order(ByteOrder.nativeOrder()));
        this.startSnpProc = new DistributedProcess(ctx, DistributedProcess.DistributedProcessType.START_SNAPSHOT, this::initLocalSnapshotStartStage, this::processLocalSnapshotStartStageResult, SnapshotStartDiscoveryMessage::new);
        this.endSnpProc = new DistributedProcess(ctx, DistributedProcess.DistributedProcessType.END_SNAPSHOT, this::initLocalSnapshotEndStage, this::processLocalSnapshotEndStageResult);
    }

    public static File partDeltaFile(File snapshotCacheDir, int partId) {
        return new File(snapshotCacheDir, IgniteSnapshotManager.partDeltaFileName(partId));
    }

    public static String partDeltaFileName(int partId) {
        assert (partId <= 65500 || partId == 65535);
        return partId == 65535 ? INDEX_DELTA_NAME : String.format(PART_DELTA_TEMPLATE, partId);
    }

    @Override
    protected void start0() throws IgniteCheckedException {
        super.start0();
        GridKernalContext ctx = this.cctx.kernalContext();
        if (ctx.clientNode()) {
            return;
        }
        if (!CU.isPersistenceEnabled(ctx.config())) {
            return;
        }
        this.snpRunner = new IgniteThreadPoolExecutor(SNAPSHOT_RUNNER_THREAD_PREFIX, this.cctx.igniteInstanceName(), 4, 4, 60000L, new LinkedBlockingQueue<Runnable>(), 2, new OomExceptionHandler(ctx));
        assert (this.cctx.pageStore() instanceof FilePageStoreManager);
        FilePageStoreManager storeMgr = (FilePageStoreManager)this.cctx.pageStore();
        this.pdsSettings = this.cctx.kernalContext().pdsFolderResolver().resolveFolders();
        this.locSnpDir = IgniteSnapshotManager.resolveSnapshotWorkDirectory(ctx.config());
        this.tmpWorkDir = U.resolveWorkDirectory(storeMgr.workDir().getAbsolutePath(), DFLT_SNAPSHOT_TMP_DIR, true);
        U.ensureDirectory(this.locSnpDir, "snapshot work directory", this.log);
        U.ensureDirectory(this.tmpWorkDir, "temp directory for snapshot creation", this.log);
        MetricRegistry mreg = this.cctx.kernalContext().metric().registry(SNAPSHOT_METRICS);
        mreg.register("LastSnapshotStartTime", () -> this.lastSeenSnpFut.startTime, "The system time of the last cluster snapshot request start time on this node.");
        mreg.register("LastSnapshotEndTime", () -> this.lastSeenSnpFut.endTime, "The system time of the last cluster snapshot request end time on this node.");
        mreg.register("LastSnapshotName", () -> this.lastSeenSnpFut.name, String.class, "The name of last started cluster snapshot request on this node.");
        mreg.register("LastSnapshotErrorMessage", () -> this.lastSeenSnpFut.error() == null ? "" : this.lastSeenSnpFut.error().getMessage(), String.class, "The error message of last started cluster snapshot request which fail with an error. This value will be empty if last snapshot request has been completed successfully.");
        mreg.register("LocalSnapshotNames", this::localSnapshotNames, List.class, "The list of names of all snapshots currently saved on the local node with respect to the configured via IgniteConfiguration snapshot working path.");
        this.storeFactory = storeMgr::getPageStoreFactory;
        this.cctx.exchange().registerExchangeAwareComponent(this);
        ctx.internalSubscriptionProcessor().registerMetastorageListener(this);
        this.discoLsnr = (evt, discoCache) -> {
            if (!this.busyLock.enterBusy()) {
                return;
            }
            try {
                UUID leftNodeId = evt.eventNode().id();
                if (evt.type() == 11 || evt.type() == 12) {
                    SnapshotOperationRequest snpReq = this.clusterSnpReq;
                    for (SnapshotFutureTask sctx : this.locSnpTasks.values()) {
                        if (!sctx.sourceNodeId().equals(leftNodeId) && (snpReq == null || !snpReq.snpName.equals(sctx.snapshotName()) || !snpReq.bltNodes.contains(leftNodeId))) continue;
                        sctx.acceptException(new ClusterTopologyCheckedException("Snapshot operation interrupted. One of baseline nodes left the cluster: " + leftNodeId));
                    }
                }
            }
            finally {
                this.busyLock.leaveBusy();
            }
        };
        this.cctx.gridEvents().addDiscoveryEventListener(this.discoLsnr, 11, 12);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void stop0(boolean cancel) {
        this.busyLock.block();
        try {
            for (SnapshotFutureTask sctx : this.locSnpTasks.values()) {
                sctx.acceptException(new NodeStoppingException(SNP_NODE_STOPPING_ERR_MSG));
            }
            this.locSnpTasks.clear();
            Object object = this.snpOpMux;
            synchronized (object) {
                if (this.clusterSnpFut != null) {
                    this.clusterSnpFut.onDone(new NodeStoppingException(SNP_NODE_STOPPING_ERR_MSG));
                    this.clusterSnpFut = null;
                }
            }
            if (this.snpRunner != null) {
                this.snpRunner.shutdownNow();
            }
            if (this.discoLsnr != null) {
                this.cctx.kernalContext().event().removeDiscoveryEventListener(this.discoLsnr, new int[0]);
            }
            this.cctx.exchange().unregisterExchangeAwareComponent(this);
        }
        finally {
            this.busyLock.unblock();
        }
    }

    public void deleteSnapshot(File snpDir, String folderName) {
        if (!snpDir.exists()) {
            return;
        }
        assert (snpDir.isDirectory()) : snpDir;
        try {
            File binDir = CacheObjectBinaryProcessorImpl.binaryWorkDir(snpDir.getAbsolutePath(), folderName);
            File nodeDbDir = new File(snpDir.getAbsolutePath(), IgniteSnapshotManager.databaseRelativePath(folderName));
            U.delete(binDir);
            U.delete(nodeDbDir);
            File marshDir = MarshallerContextImpl.mappingFileStoreWorkDir(snpDir.getAbsolutePath());
            Files.walkFileTree(marshDir.toPath(), (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) {
                    U.delete(file);
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult visitFileFailed(Path file, IOException exc) {
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult postVisitDirectory(Path dir, IOException exc) {
                    dir.toFile().delete();
                    if (IgniteSnapshotManager.this.log.isInfoEnabled() && exc != null) {
                        IgniteSnapshotManager.this.log.info("Marshaller directory cleaned with an exception: " + exc.getMessage());
                    }
                    return FileVisitResult.CONTINUE;
                }
            });
            File binMetadataDfltDir = new File(snpDir, "db/binary_meta");
            File marshallerDfltDir = new File(snpDir, "db/marshaller");
            U.delete(binMetadataDfltDir);
            U.delete(marshallerDfltDir);
            File db = new File(snpDir, "db");
            if (!db.exists() || F.isEmpty(db.list())) {
                marshDir.delete();
                db.delete();
                U.delete(snpDir);
            }
        }
        catch (IOException e) {
            throw new IgniteException(e);
        }
    }

    public File snapshotLocalDir(String snpName) {
        assert (this.locSnpDir != null);
        assert (U.alphanumericUnderscore(snpName)) : snpName;
        return new File(this.locSnpDir, snpName);
    }

    public File snapshotTmpDir() {
        assert (this.tmpWorkDir != null);
        return this.tmpWorkDir;
    }

    private IgniteInternalFuture<SnapshotOperationResponse> initLocalSnapshotStartStage(SnapshotOperationRequest req) {
        if (this.cctx.kernalContext().clientNode() || !CU.baselineNode(this.cctx.localNode(), this.cctx.kernalContext().state().clusterState())) {
            return new GridFinishedFuture<SnapshotOperationResponse>();
        }
        if (this.clusterSnpReq != null) {
            return new GridFinishedFuture<SnapshotOperationResponse>(new IgniteCheckedException("Snapshot operation has been rejected. Another snapshot operation in progress [req=" + req + ", curr=" + this.clusterSnpReq + ']'));
        }
        HashSet leftNodes = new HashSet(req.bltNodes);
        leftNodes.removeAll(F.viewReadOnly(this.cctx.discovery().serverNodes(AffinityTopologyVersion.NONE), F.node2id(), new IgnitePredicate[0]));
        if (!leftNodes.isEmpty()) {
            return new GridFinishedFuture<SnapshotOperationResponse>(new IgniteCheckedException("Some of baseline nodes left the cluster prior to snapshot operation start: " + leftNodes));
        }
        HashSet leftGrps = new HashSet(req.grpIds);
        leftGrps.removeAll(this.cctx.cache().cacheGroupDescriptors().keySet());
        if (!leftGrps.isEmpty()) {
            return new GridFinishedFuture<SnapshotOperationResponse>(new IgniteCheckedException("Some of requested cache groups doesn't exist on the local node [missed=" + leftGrps + ", nodeId=" + this.cctx.localNodeId() + ']'));
        }
        HashMap<Integer, Set<Integer>> parts = new HashMap<Integer, Set<Integer>>();
        for (Integer grpId : req.grpIds) {
            if (this.cctx.cache().cacheGroup(grpId) == null) continue;
            parts.put(grpId, null);
        }
        if (parts.isEmpty()) {
            return new GridFinishedFuture<SnapshotOperationResponse>();
        }
        SnapshotFutureTask task0 = this.registerSnapshotTask(req.snpName, req.srcNodeId, parts, this.locSndrFactory.apply(req.snpName));
        this.clusterSnpReq = req;
        return task0.chain(fut -> {
            if (fut.error() == null) {
                return new SnapshotOperationResponse();
            }
            throw new GridClosureException(fut.error());
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processLocalSnapshotStartStageResult(UUID id, Map<UUID, SnapshotOperationResponse> res, Map<UUID, Exception> err) {
        if (this.cctx.kernalContext().clientNode()) {
            return;
        }
        SnapshotOperationRequest snpReq = this.clusterSnpReq;
        boolean cancelled = err.values().stream().anyMatch(e -> e instanceof IgniteFutureCancelledCheckedException);
        if (snpReq == null || !snpReq.rqId.equals(id)) {
            Object object = this.snpOpMux;
            synchronized (object) {
                if (this.clusterSnpFut != null && this.clusterSnpFut.rqId.equals(id)) {
                    if (cancelled) {
                        this.clusterSnpFut.onDone(new IgniteFutureCancelledCheckedException("Execution of snapshot tasks has been cancelled by external process [err=" + err + ", snpReq=" + snpReq + ']'));
                    } else {
                        this.clusterSnpFut.onDone(new IgniteCheckedException("Snapshot operation has not been fully completed [err=" + err + ", snpReq=" + snpReq + ']'));
                    }
                    this.clusterSnpFut = null;
                }
                return;
            }
        }
        if (IgniteUtils.isLocalNodeCoordinator(this.cctx.discovery())) {
            HashSet missed = new HashSet(snpReq.bltNodes);
            missed.removeAll(res.keySet());
            missed.removeAll(err.keySet());
            if (cancelled) {
                snpReq.err = new IgniteFutureCancelledCheckedException("Execution of snapshot tasks has been cancelled by external process [err=" + err + ", missed=" + missed + ']');
            } else if (!F.isEmpty(err) || !missed.isEmpty()) {
                snpReq.err = new IgniteCheckedException("Execution of local snapshot tasks fails or them haven't been executed due to some of nodes left the cluster. Uncompleted snapshot will be deleted [err=" + err + ", missed=" + missed + ']');
            }
            this.endSnpProc.start(UUID.randomUUID(), snpReq);
        }
    }

    private IgniteInternalFuture<SnapshotOperationResponse> initLocalSnapshotEndStage(SnapshotOperationRequest req) {
        if (this.clusterSnpReq == null) {
            return new GridFinishedFuture<SnapshotOperationResponse>(new SnapshotOperationResponse());
        }
        try {
            if (req.err != null) {
                this.deleteSnapshot(this.snapshotLocalDir(req.snpName), this.pdsSettings.folderName());
            }
            this.removeLastMetaStorageKey();
        }
        catch (Exception e) {
            return new GridFinishedFuture<SnapshotOperationResponse>(e);
        }
        return new GridFinishedFuture<SnapshotOperationResponse>(new SnapshotOperationResponse());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processLocalSnapshotEndStageResult(UUID id, Map<UUID, SnapshotOperationResponse> res, Map<UUID, Exception> err) {
        SnapshotOperationRequest snpReq = this.clusterSnpReq;
        if (snpReq == null) {
            return;
        }
        HashSet endFail = new HashSet(snpReq.bltNodes);
        endFail.removeAll(res.keySet());
        this.clusterSnpReq = null;
        Object object = this.snpOpMux;
        synchronized (object) {
            if (this.clusterSnpFut != null) {
                if (endFail.isEmpty() && snpReq.err == null) {
                    this.clusterSnpFut.onDone();
                    if (this.log.isInfoEnabled()) {
                        this.log.info(SNAPSHOT_FINISHED_MSG + snpReq);
                    }
                } else if (snpReq.err == null) {
                    this.clusterSnpFut.onDone(new IgniteCheckedException("Snapshot creation has been finished with an error. Local snapshot tasks may not finished completely or finalizing results fails [fail=" + endFail + ", err=" + err + ']'));
                } else {
                    this.clusterSnpFut.onDone(snpReq.err);
                }
                this.clusterSnpFut = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isSnapshotCreating() {
        if (this.clusterSnpReq != null) {
            return true;
        }
        Object object = this.snpOpMux;
        synchronized (object) {
            return this.clusterSnpReq != null || this.clusterSnpFut != null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> localSnapshotNames() {
        if (this.cctx.kernalContext().clientNode()) {
            throw new UnsupportedOperationException("Client and daemon nodes can not perform this operation.");
        }
        if (this.locSnpDir == null) {
            return Collections.emptyList();
        }
        Object object = this.snpOpMux;
        synchronized (object) {
            return Arrays.stream(this.locSnpDir.listFiles(File::isDirectory)).map(File::getName).collect(Collectors.toList());
        }
    }

    @Override
    public IgniteFuture<Void> cancelSnapshot(String name) {
        A.notNullOrEmpty(name, "Snapshot name must be not empty or null");
        this.cctx.kernalContext().security().authorize(SecurityPermission.ADMIN_SNAPSHOT);
        IgniteInternalFuture<Void> fut0 = this.cctx.kernalContext().closure().callAsyncNoFailover(GridClosureCallMode.BROADCAST, new CancelSnapshotCallable(name), this.cctx.discovery().aliveServerNodes(), false, 0L, true);
        return new IgniteFutureImpl<Void>(fut0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancelLocalSnapshotTask(String name) {
        A.notNullOrEmpty(name, "Snapshot name must be not null or empty");
        ClusterSnapshotFuture fut0 = null;
        this.busyLock.enterBusy();
        try {
            for (SnapshotFutureTask sctx : this.locSnpTasks.values()) {
                if (!sctx.snapshotName().equals(name)) continue;
                sctx.cancel();
            }
            Object object = this.snpOpMux;
            synchronized (object) {
                if (this.clusterSnpFut != null) {
                    fut0 = this.clusterSnpFut;
                }
            }
        }
        finally {
            this.busyLock.leaveBusy();
        }
        try {
            if (fut0 != null) {
                fut0.get();
            }
        }
        catch (IgniteCheckedException e) {
            if (e instanceof IgniteFutureCancelledCheckedException) {
                if (this.log.isInfoEnabled()) {
                    this.log.info("Expected cancelled exception: " + e.getMessage());
                }
            }
            throw new IgniteException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IgniteFuture<Void> createSnapshot(String name) {
        A.notNullOrEmpty(name, "Snapshot name cannot be null or empty.");
        A.ensure(U.alphanumericUnderscore(name), "Snapshot name must satisfy the following name pattern: a-zA-Z0-9_");
        try {
            ClusterSnapshotFuture snpFut0;
            this.cctx.kernalContext().security().authorize(SecurityPermission.ADMIN_SNAPSHOT);
            if (!IgniteFeatures.allNodesSupports(this.cctx.discovery().aliveServerNodes(), IgniteFeatures.PERSISTENCE_CACHE_SNAPSHOT)) {
                throw new IgniteException("Not all nodes in the cluster support a snapshot operation.");
            }
            if (!CU.isPersistenceEnabled(this.cctx.gridConfig())) {
                throw new IgniteException("Create snapshot request has been rejected. Snapshots on an in-memory clusters are not allowed.");
            }
            if (!this.cctx.kernalContext().state().clusterState().state().active()) {
                throw new IgniteException("Snapshot operation has been rejected. The cluster is inactive.");
            }
            DiscoveryDataClusterState clusterState = this.cctx.kernalContext().state().clusterState();
            if (!clusterState.hasBaselineTopology()) {
                throw new IgniteException("Snapshot operation has been rejected. The baseline topology is not configured for cluster.");
            }
            if (this.cctx.kernalContext().clientNode()) {
                ClusterNode crd = U.oldest(this.cctx.kernalContext().discovery().aliveServerNodes(), null);
                if (crd == null) {
                    throw new IgniteException("There is no alive server nodes in the cluster");
                }
                return new IgniteSnapshotFutureImpl(this.cctx.kernalContext().closure().callAsyncNoFailover(GridClosureCallMode.BALANCE, new CreateSnapshotCallable(name), Collections.singletonList(crd), false, 0L, true));
            }
            Object object = this.snpOpMux;
            synchronized (object) {
                if (this.clusterSnpFut != null && !this.clusterSnpFut.isDone()) {
                    throw new IgniteException("Create snapshot request has been rejected. The previous snapshot operation was not completed.");
                }
                if (this.clusterSnpReq != null) {
                    throw new IgniteException("Create snapshot request has been rejected. Parallel snapshot processes are not allowed.");
                }
                if (this.localSnapshotNames().contains(name)) {
                    throw new IgniteException("Create snapshot request has been rejected. Snapshot with given name already exists on local node.");
                }
                this.clusterSnpFut = snpFut0 = new ClusterSnapshotFuture(UUID.randomUUID(), name);
                this.lastSeenSnpFut = snpFut0;
            }
            List<Integer> grps = this.cctx.cache().persistentGroups().stream().filter(g -> this.cctx.cache().cacheType(g.cacheOrGroupName()) == CacheType.USER).filter(g -> !g.config().isEncryptionEnabled()).map(CacheGroupDescriptor::groupId).collect(Collectors.toList());
            List<ClusterNode> srvNodes = this.cctx.discovery().serverNodes(AffinityTopologyVersion.NONE);
            snpFut0.listen(f -> {
                if (f.error() == null) {
                    this.recordSnapshotEvent(name, SNAPSHOT_FINISHED_MSG + grps, 150);
                } else {
                    this.recordSnapshotEvent(name, SNAPSHOT_FAILED_MSG + f.error().getMessage(), 151);
                }
            });
            this.startSnpProc.start(snpFut0.rqId, new SnapshotOperationRequest(snpFut0.rqId, this.cctx.localNodeId(), name, grps, new HashSet<UUID>(F.viewReadOnly(srvNodes, F.node2id(), node -> CU.baselineNode(node, clusterState)))));
            String msg = "Cluster-wide snapshot operation started [snpName=" + name + ", grps=" + grps + ']';
            this.recordSnapshotEvent(name, msg, 149);
            if (this.log.isInfoEnabled()) {
                this.log.info(msg);
            }
            return new IgniteFutureImpl<Void>(snpFut0);
        }
        catch (Exception e) {
            this.recordSnapshotEvent(name, SNAPSHOT_FAILED_MSG + e.getMessage(), 151);
            U.error(this.log, SNAPSHOT_FAILED_MSG, e);
            this.lastSeenSnpFut = new ClusterSnapshotFuture(name, e);
            return new IgniteFinishedFutureImpl<Void>(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onReadyForReadWrite(ReadWriteMetastorage metaStorage) throws IgniteCheckedException {
        Object object = this.snpOpMux;
        synchronized (object) {
            this.metaStorage = metaStorage;
            if (this.recovered) {
                this.removeLastMetaStorageKey();
            }
            this.recovered = false;
        }
    }

    @Override
    public void onReadyForRead(ReadOnlyMetastorage metaStorage) throws IgniteCheckedException {
        String snpName = (String)((Object)metaStorage.read(SNP_RUNNING_KEY));
        if (snpName == null) {
            return;
        }
        this.recovered = true;
        for (File tmp : this.snapshotTmpDir().listFiles()) {
            U.delete(tmp);
        }
        this.deleteSnapshot(this.snapshotLocalDir(snpName), this.pdsSettings.folderName());
        if (this.log.isInfoEnabled()) {
            this.log.info("Previous attempt to create snapshot fail due to the local node crash. All resources related to snapshot operation have been deleted: " + snpName);
        }
    }

    public static boolean isSnapshotOperation(DiscoveryEvent evt) {
        return !evt.eventNode().isClient() && evt.type() == 18 && ((DiscoveryCustomEvent)evt).customMessage() instanceof SnapshotStartDiscoveryMessage;
    }

    @Override
    public void onDoneBeforeTopologyUnlock(GridDhtPartitionsExchangeFuture fut) {
        if (this.clusterSnpReq == null || this.cctx.kernalContext().clientNode()) {
            return;
        }
        SnapshotOperationRequest snpReq = this.clusterSnpReq;
        SnapshotFutureTask task = (SnapshotFutureTask)this.locSnpTasks.get(snpReq.snpName);
        if (task == null) {
            return;
        }
        if (task.start()) {
            this.cctx.database().forceCheckpoint(String.format("Start snapshot operation: %s", snpReq.snpName));
            try {
                task.awaitStarted();
            }
            catch (IgniteCheckedException e) {
                U.error(this.log, "Fail to wait while cluster-wide snapshot operation started", e);
            }
        }
    }

    public void onCacheGroupsStopped(List<Integer> grps) {
        for (SnapshotFutureTask sctx : this.locSnpTasks.values()) {
            HashSet<Integer> retain = new HashSet<Integer>(grps);
            retain.retainAll(sctx.affectedCacheGroups());
            if (retain.isEmpty()) continue;
            sctx.acceptException(new IgniteCheckedException("Snapshot has been interrupted due to some of the required cache groups stopped: " + retain));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    SnapshotFutureTask registerSnapshotTask(String snpName, UUID srcNodeId, Map<Integer, Set<Integer>> parts, SnapshotSender snpSndr) {
        if (!this.busyLock.enterBusy()) {
            return new SnapshotFutureTask(new IgniteCheckedException("Snapshot manager is stopping [locNodeId=" + this.cctx.localNodeId() + ']'));
        }
        try {
            if (this.locSnpTasks.containsKey(snpName)) {
                SnapshotFutureTask snapshotFutureTask = new SnapshotFutureTask(new IgniteCheckedException("Snapshot with requested name is already scheduled: " + snpName));
                return snapshotFutureTask;
            }
            SnapshotFutureTask snpFutTask = new SnapshotFutureTask(this.cctx, srcNodeId, snpName, this.tmpWorkDir, this.ioFactory, snpSndr, parts, this.locBuff);
            SnapshotFutureTask prev = this.locSnpTasks.putIfAbsent(snpName, snpFutTask);
            if (prev != null) {
                SnapshotFutureTask snapshotFutureTask = new SnapshotFutureTask(new IgniteCheckedException("Snapshot with requested name is already scheduled: " + snpName));
                return snapshotFutureTask;
            }
            if (this.log.isInfoEnabled()) {
                this.log.info("Snapshot task has been registered on local node [sctx=" + this + ", topVer=" + this.cctx.discovery().topologyVersionEx() + ']');
            }
            snpFutTask.listen(f -> {
                SnapshotFutureTask cfr_ignored_0 = (SnapshotFutureTask)this.locSnpTasks.remove(snpName);
            });
            SnapshotFutureTask snapshotFutureTask = snpFutTask;
            return snapshotFutureTask;
        }
        finally {
            this.busyLock.leaveBusy();
        }
    }

    void localSnapshotSenderFactory(Function<String, SnapshotSender> factory) {
        this.locSndrFactory = factory;
    }

    Function<String, SnapshotSender> localSnapshotSenderFactory() {
        return this.locSndrFactory;
    }

    private void removeLastMetaStorageKey() throws IgniteCheckedException {
        this.cctx.database().checkpointReadLock();
        try {
            this.metaStorage.remove(SNP_RUNNING_KEY);
        }
        finally {
            this.cctx.database().checkpointReadUnlock();
        }
    }

    private void recordSnapshotEvent(final String snpName, final String msg, final int type) {
        if (!this.cctx.gridEvents().isRecordable(type) || !this.cctx.gridEvents().hasListener(type)) {
            return;
        }
        this.cctx.kernalContext().closure().runLocalSafe(new GridPlainRunnable(){

            @Override
            public void run() {
                IgniteSnapshotManager.this.cctx.gridEvents().record(new SnapshotEvent(IgniteSnapshotManager.this.cctx.localNode(), msg, snpName, type));
            }
        });
    }

    Executor snapshotExecutorService() {
        assert (this.snpRunner != null);
        return this.snpRunner;
    }

    void ioFactory(FileIOFactory ioFactory) {
        this.ioFactory = ioFactory;
    }

    static String databaseRelativePath(String folderName) {
        return Paths.get("db", folderName).toString();
    }

    public static File resolveSnapshotWorkDirectory(IgniteConfiguration cfg) {
        try {
            return U.resolveWorkDirectory(cfg.getWorkDirectory() == null ? U.defaultWorkDirectory() : cfg.getWorkDirectory(), cfg.getSnapshotPath(), false);
        }
        catch (IgniteCheckedException e) {
            throw new IgniteException(e);
        }
    }

    static void copy(FileIOFactory factory, File from, File to, long length) {
        try (FileIO src = factory.create(from, StandardOpenOption.READ);
             FileChannel dest = new FileOutputStream(to).getChannel();){
            if (src.size() < length) {
                throw new IgniteException("The source file to copy has to enough length [expected=" + length + ", actual=" + src.size() + ']');
            }
            src.position(0L);
            for (long written = 0L; written < length; written += src.transferTo(written, length - written, dest)) {
            }
        }
        catch (IOException e) {
            throw new IgniteException(e);
        }
    }

    private static class IgniteSnapshotFutureImpl
    extends IgniteFutureImpl<Void> {
        public IgniteSnapshotFutureImpl(IgniteInternalFuture<Void> fut) {
            super(fut);
        }

        @Override
        protected IgniteException convertException(IgniteCheckedException e) {
            if (e instanceof IgniteClientDisconnectedCheckedException) {
                return new IgniteException("Client disconnected. Snapshot result is unknown", U.convertException(e));
            }
            return new IgniteException("Snapshot has not been created", U.convertException(e));
        }
    }

    @GridInternal
    private static class CancelSnapshotCallable
    implements IgniteCallable<Void> {
        private static final long serialVersionUID = 0L;
        private final String snpName;
        @IgniteInstanceResource
        private transient IgniteEx ignite;

        public CancelSnapshotCallable(String snpName) {
            this.snpName = snpName;
        }

        @Override
        public Void call() throws Exception {
            this.ignite.context().cache().context().snapshotMgr().cancelLocalSnapshotTask(this.snpName);
            return null;
        }
    }

    @GridInternal
    private static class CreateSnapshotCallable
    implements IgniteCallable<Void> {
        private static final long serialVersionUID = 0L;
        private final String snpName;
        @IgniteInstanceResource
        private transient IgniteEx ignite;

        public CreateSnapshotCallable(String snpName) {
            this.snpName = snpName;
        }

        @Override
        public Void call() throws Exception {
            this.ignite.snapshot().createSnapshot(this.snpName).get();
            return null;
        }
    }

    private static class ClusterSnapshotFuture
    extends GridFutureAdapter<Void> {
        private final UUID rqId;
        private final String name;
        private final long startTime;
        private volatile long endTime;

        public ClusterSnapshotFuture() {
            this.onDone();
            this.rqId = null;
            this.name = "";
            this.startTime = 0L;
            this.endTime = 0L;
        }

        public ClusterSnapshotFuture(String name, Exception err) {
            this.onDone(err);
            this.name = name;
            this.startTime = U.currentTimeMillis();
            this.endTime = 0L;
            this.rqId = null;
        }

        public ClusterSnapshotFuture(UUID rqId, String name) {
            this.rqId = rqId;
            this.name = name;
            this.startTime = U.currentTimeMillis();
        }

        @Override
        protected boolean onDone(@Nullable Void res, @Nullable Throwable err, boolean cancel) {
            this.endTime = U.currentTimeMillis();
            return super.onDone(res, err, cancel);
        }
    }

    private static class SnapshotStartDiscoveryMessage
    extends InitMessage<SnapshotOperationRequest>
    implements SnapshotDiscoveryMessage {
        private static final long serialVersionUID = 0L;

        public SnapshotStartDiscoveryMessage(UUID processId, SnapshotOperationRequest req) {
            super(processId, DistributedProcess.DistributedProcessType.START_SNAPSHOT, req);
        }

        @Override
        public boolean needExchange() {
            return true;
        }

        @Override
        public boolean needAssignPartitions() {
            return false;
        }

        @Override
        public String toString() {
            return S.toString(SnapshotStartDiscoveryMessage.class, this, super.toString());
        }
    }

    private static class SnapshotOperationResponse
    implements Serializable {
        private static final long serialVersionUID = 0L;

        private SnapshotOperationResponse() {
        }
    }

    private static class SnapshotOperationRequest
    implements Serializable {
        private static final long serialVersionUID = 0L;
        private final UUID rqId;
        private final UUID srcNodeId;
        private final String snpName;
        @GridToStringInclude
        private final List<Integer> grpIds;
        @GridToStringInclude
        private final Set<UUID> bltNodes;
        private volatile IgniteCheckedException err;

        public SnapshotOperationRequest(UUID rqId, UUID srcNodeId, String snpName, List<Integer> grpIds, Set<UUID> bltNodes) {
            this.rqId = rqId;
            this.srcNodeId = srcNodeId;
            this.snpName = snpName;
            this.grpIds = grpIds;
            this.bltNodes = bltNodes;
        }

        public String toString() {
            return S.toString(SnapshotOperationRequest.class, this);
        }
    }

    private class LocalSnapshotSender
    extends SnapshotSender {
        private final String snpName;
        private final File snpLocDir;
        private File dbDir;
        private final int pageSize;

        public LocalSnapshotSender(String snpName) {
            super(IgniteSnapshotManager.this.log, IgniteSnapshotManager.this.snpRunner);
            this.snpName = snpName;
            this.snpLocDir = IgniteSnapshotManager.this.snapshotLocalDir(snpName);
            this.pageSize = IgniteSnapshotManager.this.cctx.kernalContext().config().getDataStorageConfiguration().getPageSize();
        }

        @Override
        protected void init(int partsCnt) {
            this.dbDir = new File(this.snpLocDir, IgniteSnapshotManager.databaseRelativePath(IgniteSnapshotManager.this.pdsSettings.folderName()));
            if (this.dbDir.exists()) {
                throw new IgniteException("Snapshot with given name already exists [snpName=" + this.snpName + ", absPath=" + this.dbDir.getAbsolutePath() + ']');
            }
            IgniteSnapshotManager.this.cctx.database().checkpointReadLock();
            try {
                assert (IgniteSnapshotManager.this.metaStorage != null && IgniteSnapshotManager.this.metaStorage.read(IgniteSnapshotManager.SNP_RUNNING_KEY) == null) : "The previous snapshot hasn't been completed correctly";
                IgniteSnapshotManager.this.metaStorage.write(IgniteSnapshotManager.SNP_RUNNING_KEY, (Serializable)((Object)this.snpName));
                U.ensureDirectory(this.dbDir, "snapshot work directory", this.log);
            }
            catch (IgniteCheckedException e) {
                throw new IgniteException(e);
            }
            finally {
                IgniteSnapshotManager.this.cctx.database().checkpointReadUnlock();
            }
        }

        @Override
        public void sendCacheConfig0(File ccfg, String cacheDirName) {
            assert (this.dbDir != null);
            try {
                File cacheDir = U.resolveWorkDirectory(this.dbDir.getAbsolutePath(), cacheDirName, false);
                IgniteSnapshotManager.copy(IgniteSnapshotManager.this.ioFactory, ccfg, new File(cacheDir, ccfg.getName()), ccfg.length());
            }
            catch (IgniteCheckedException e) {
                throw new IgniteException(e);
            }
        }

        @Override
        public void sendMarshallerMeta0(List<Map<Integer, MappedName>> mappings) {
            if (mappings == null) {
                return;
            }
            try {
                MarshallerContextImpl.saveMappings(IgniteSnapshotManager.this.cctx.kernalContext(), mappings, this.snpLocDir);
            }
            catch (IgniteCheckedException e) {
                throw new IgniteException(e);
            }
        }

        @Override
        public void sendBinaryMeta0(Collection<BinaryType> types) {
            if (types == null) {
                return;
            }
            IgniteSnapshotManager.this.cctx.kernalContext().cacheObjects().saveMetadata(types, this.snpLocDir);
        }

        @Override
        public void sendPart0(File part, String cacheDirName, GroupPartitionId pair, Long len) {
            try {
                if (len == 0L) {
                    return;
                }
                File cacheDir = U.resolveWorkDirectory(this.dbDir.getAbsolutePath(), cacheDirName, false);
                File snpPart = new File(cacheDir, part.getName());
                if (!snpPart.exists() || snpPart.delete()) {
                    snpPart.createNewFile();
                }
                IgniteSnapshotManager.copy(IgniteSnapshotManager.this.ioFactory, part, snpPart, len);
                if (this.log.isInfoEnabled()) {
                    this.log.info("Partition has been snapshot [snapshotDir=" + this.dbDir.getAbsolutePath() + ", cacheDirName=" + cacheDirName + ", part=" + part.getName() + ", length=" + part.length() + ", snapshot=" + snpPart.getName() + ']');
                }
            }
            catch (IOException | IgniteCheckedException ex) {
                throw new IgniteException(ex);
            }
        }

        @Override
        public void sendDelta0(File delta, String cacheDirName, GroupPartitionId pair) {
            File snpPart = FilePageStoreManager.getPartitionFile(this.dbDir, cacheDirName, pair.getPartitionId());
            if (this.log.isInfoEnabled()) {
                this.log.info("Start partition snapshot recovery with the given delta page file [part=" + snpPart + ", delta=" + delta + ']');
            }
            try (FileIO fileIo = IgniteSnapshotManager.this.ioFactory.create(delta, StandardOpenOption.READ);
                 FilePageStore pageStore = (FilePageStore)((FilePageStoreFactory)IgniteSnapshotManager.this.storeFactory.apply(pair.getGroupId(), false)).createPageStore(GroupPartitionId.getTypeByPartId(pair.getPartitionId()), snpPart::toPath, val -> {});){
                ByteBuffer pageBuf = ByteBuffer.allocate(this.pageSize).order(ByteOrder.nativeOrder());
                long totalBytes = fileIo.size();
                assert (totalBytes % (long)this.pageSize == 0L) : "Given file with delta pages has incorrect size: " + fileIo.size();
                pageStore.beginRecover();
                for (long pos = 0L; pos < totalBytes; pos += (long)this.pageSize) {
                    long read = fileIo.readFully(pageBuf, pos);
                    assert (read == (long)pageBuf.capacity());
                    pageBuf.flip();
                    if (this.log.isDebugEnabled()) {
                        this.log.debug("Read page given delta file [path=" + delta.getName() + ", pageId=" + PageIO.getPageId(pageBuf) + ", pos=" + pos + ", pages=" + totalBytes / (long)this.pageSize + ", crcBuff=" + FastCrc.calcCrc(pageBuf, pageBuf.limit()) + ", crcPage=" + PageIO.getCrc(pageBuf) + ']');
                        pageBuf.rewind();
                    }
                    pageStore.write(PageIO.getPageId(pageBuf), pageBuf, 0, false);
                    pageBuf.flip();
                }
                pageStore.finishRecover();
            }
            catch (IOException | IgniteCheckedException e) {
                throw new IgniteException(e);
            }
        }

        @Override
        protected void close0(@Nullable Throwable th) {
            if (th == null) {
                if (this.log.isInfoEnabled()) {
                    this.log.info("Local snapshot sender closed, resources released [dbNodeSnpDir=" + this.dbDir + ']');
                }
            } else {
                IgniteSnapshotManager.this.deleteSnapshot(this.snpLocDir, IgniteSnapshotManager.this.pdsSettings.folderName());
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Local snapshot sender closed due to an error occurred: " + th.getMessage());
                }
            }
        }
    }
}

