/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.Request;
import com.amazonaws.services.ec2.model.DryRunSupportedRequest;
import com.amazonaws.services.ec2.model.transform.CreateSubnetRequestMarshaller;
import java.io.Serializable;

public class CreateSubnetRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable,
DryRunSupportedRequest<CreateSubnetRequest> {
    private String vpcId;
    private String cidrBlock;
    private String ipv6CidrBlock;
    private String availabilityZone;

    public CreateSubnetRequest() {
    }

    public CreateSubnetRequest(String vpcId, String cidrBlock) {
        this.setVpcId(vpcId);
        this.setCidrBlock(cidrBlock);
    }

    public void setVpcId(String vpcId) {
        this.vpcId = vpcId;
    }

    public String getVpcId() {
        return this.vpcId;
    }

    public CreateSubnetRequest withVpcId(String vpcId) {
        this.setVpcId(vpcId);
        return this;
    }

    public void setCidrBlock(String cidrBlock) {
        this.cidrBlock = cidrBlock;
    }

    public String getCidrBlock() {
        return this.cidrBlock;
    }

    public CreateSubnetRequest withCidrBlock(String cidrBlock) {
        this.setCidrBlock(cidrBlock);
        return this;
    }

    public void setIpv6CidrBlock(String ipv6CidrBlock) {
        this.ipv6CidrBlock = ipv6CidrBlock;
    }

    public String getIpv6CidrBlock() {
        return this.ipv6CidrBlock;
    }

    public CreateSubnetRequest withIpv6CidrBlock(String ipv6CidrBlock) {
        this.setIpv6CidrBlock(ipv6CidrBlock);
        return this;
    }

    public void setAvailabilityZone(String availabilityZone) {
        this.availabilityZone = availabilityZone;
    }

    public String getAvailabilityZone() {
        return this.availabilityZone;
    }

    public CreateSubnetRequest withAvailabilityZone(String availabilityZone) {
        this.setAvailabilityZone(availabilityZone);
        return this;
    }

    @Override
    public Request<CreateSubnetRequest> getDryRunRequest() {
        Request<CreateSubnetRequest> request = new CreateSubnetRequestMarshaller().marshall(this);
        request.addParameter("DryRun", Boolean.toString(true));
        return request;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getVpcId() != null) {
            sb.append("VpcId: ").append(this.getVpcId()).append(",");
        }
        if (this.getCidrBlock() != null) {
            sb.append("CidrBlock: ").append(this.getCidrBlock()).append(",");
        }
        if (this.getIpv6CidrBlock() != null) {
            sb.append("Ipv6CidrBlock: ").append(this.getIpv6CidrBlock()).append(",");
        }
        if (this.getAvailabilityZone() != null) {
            sb.append("AvailabilityZone: ").append(this.getAvailabilityZone());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateSubnetRequest)) {
            return false;
        }
        CreateSubnetRequest other = (CreateSubnetRequest)obj;
        if (other.getVpcId() == null ^ this.getVpcId() == null) {
            return false;
        }
        if (other.getVpcId() != null && !other.getVpcId().equals(this.getVpcId())) {
            return false;
        }
        if (other.getCidrBlock() == null ^ this.getCidrBlock() == null) {
            return false;
        }
        if (other.getCidrBlock() != null && !other.getCidrBlock().equals(this.getCidrBlock())) {
            return false;
        }
        if (other.getIpv6CidrBlock() == null ^ this.getIpv6CidrBlock() == null) {
            return false;
        }
        if (other.getIpv6CidrBlock() != null && !other.getIpv6CidrBlock().equals(this.getIpv6CidrBlock())) {
            return false;
        }
        if (other.getAvailabilityZone() == null ^ this.getAvailabilityZone() == null) {
            return false;
        }
        return other.getAvailabilityZone() == null || other.getAvailabilityZone().equals(this.getAvailabilityZone());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getVpcId() == null ? 0 : this.getVpcId().hashCode());
        hashCode = 31 * hashCode + (this.getCidrBlock() == null ? 0 : this.getCidrBlock().hashCode());
        hashCode = 31 * hashCode + (this.getIpv6CidrBlock() == null ? 0 : this.getIpv6CidrBlock().hashCode());
        hashCode = 31 * hashCode + (this.getAvailabilityZone() == null ? 0 : this.getAvailabilityZone().hashCode());
        return hashCode;
    }

    public CreateSubnetRequest clone() {
        return (CreateSubnetRequest)super.clone();
    }
}

