/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.spi.discovery.tcp.ipfinder.s3.encrypt;

import com.amazonaws.ClientConfiguration;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.AWSStaticCredentialsProvider;
import com.amazonaws.encryptionsdk.AwsCrypto;
import com.amazonaws.encryptionsdk.CryptoResult;
import com.amazonaws.encryptionsdk.MasterKeyProvider;
import com.amazonaws.encryptionsdk.kms.KmsMasterKeyProvider;
import com.amazonaws.regions.Region;
import java.util.List;
import org.apache.ignite.IgniteException;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.spi.discovery.tcp.ipfinder.s3.encrypt.EncryptionService;

public class AwsKmsEncryptionService
implements EncryptionService {
    private String keyId;
    private Region region;
    private AWSCredentials creds;
    private ClientConfiguration clientConf = new ClientConfiguration();
    private KmsMasterKeyProvider prov;
    private AwsCrypto crypto;

    public AwsKmsEncryptionService setKeyId(String keyId) {
        this.keyId = keyId;
        return this;
    }

    public AwsKmsEncryptionService setRegion(Region region) {
        this.region = region;
        return this;
    }

    public AwsKmsEncryptionService setCredentials(AWSCredentials creds) {
        this.creds = creds;
        return this;
    }

    public AwsKmsEncryptionService setClientConf(ClientConfiguration clientConf) {
        this.clientConf = clientConf;
        return this;
    }

    @Override
    public void init() {
        if (this.creds == null || this.region == null || this.keyId == null || this.keyId.trim().isEmpty()) {
            throw new IgniteException(String.format("At-least one of the required parameters [creds = %s, region = %s, keyId = %s] is invalid.", this.creds, this.region, this.keyId));
        }
        this.crypto = this.createClient();
        this.prov = this.createKmsMasterKeyProvider();
    }

    @Override
    public byte[] encrypt(byte[] data) {
        if (this.crypto == null || this.prov == null) {
            throw new IgniteException("The init() method was not called.");
        }
        return (byte[])this.crypto.encryptData((MasterKeyProvider)this.prov, data).getResult();
    }

    @Override
    public byte[] decrypt(byte[] data) {
        if (this.crypto == null || this.prov == null) {
            throw new IgniteException("The init() method was not called.");
        }
        CryptoResult decryptRes = this.crypto.decryptData((MasterKeyProvider)this.prov, data);
        List keyIds = decryptRes.getMasterKeyIds();
        if (keyIds != null && !keyIds.contains(this.keyId)) {
            throw new IgniteException("Wrong KMS key ID!");
        }
        return (byte[])decryptRes.getResult();
    }

    AwsCrypto createClient() {
        this.crypto = new AwsCrypto();
        return this.crypto;
    }

    KmsMasterKeyProvider createKmsMasterKeyProvider() {
        return new KmsMasterKeyProvider((AWSCredentialsProvider)new AWSStaticCredentialsProvider(this.creds), this.region, this.clientConf, this.keyId);
    }

    public String toString() {
        return S.toString(AwsKmsEncryptionService.class, (Object)this, (String)"super", (Object)super.toString());
    }
}

