/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elasticloadbalancingv2.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.elasticloadbalancingv2.model.CreateTargetGroupRequest;
import com.amazonaws.services.elasticloadbalancingv2.model.Matcher;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class CreateTargetGroupRequestMarshaller
implements Marshaller<Request<CreateTargetGroupRequest>, CreateTargetGroupRequest> {
    public Request<CreateTargetGroupRequest> marshall(CreateTargetGroupRequest createTargetGroupRequest) {
        Matcher matcher;
        if (createTargetGroupRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)createTargetGroupRequest, "AmazonElasticLoadBalancing");
        request.addParameter("Action", "CreateTargetGroup");
        request.addParameter("Version", "2015-12-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (createTargetGroupRequest.getName() != null) {
            request.addParameter("Name", StringUtils.fromString((String)createTargetGroupRequest.getName()));
        }
        if (createTargetGroupRequest.getProtocol() != null) {
            request.addParameter("Protocol", StringUtils.fromString((String)createTargetGroupRequest.getProtocol()));
        }
        if (createTargetGroupRequest.getPort() != null) {
            request.addParameter("Port", StringUtils.fromInteger((Integer)createTargetGroupRequest.getPort()));
        }
        if (createTargetGroupRequest.getVpcId() != null) {
            request.addParameter("VpcId", StringUtils.fromString((String)createTargetGroupRequest.getVpcId()));
        }
        if (createTargetGroupRequest.getHealthCheckProtocol() != null) {
            request.addParameter("HealthCheckProtocol", StringUtils.fromString((String)createTargetGroupRequest.getHealthCheckProtocol()));
        }
        if (createTargetGroupRequest.getHealthCheckPort() != null) {
            request.addParameter("HealthCheckPort", StringUtils.fromString((String)createTargetGroupRequest.getHealthCheckPort()));
        }
        if (createTargetGroupRequest.getHealthCheckPath() != null) {
            request.addParameter("HealthCheckPath", StringUtils.fromString((String)createTargetGroupRequest.getHealthCheckPath()));
        }
        if (createTargetGroupRequest.getHealthCheckIntervalSeconds() != null) {
            request.addParameter("HealthCheckIntervalSeconds", StringUtils.fromInteger((Integer)createTargetGroupRequest.getHealthCheckIntervalSeconds()));
        }
        if (createTargetGroupRequest.getHealthCheckTimeoutSeconds() != null) {
            request.addParameter("HealthCheckTimeoutSeconds", StringUtils.fromInteger((Integer)createTargetGroupRequest.getHealthCheckTimeoutSeconds()));
        }
        if (createTargetGroupRequest.getHealthyThresholdCount() != null) {
            request.addParameter("HealthyThresholdCount", StringUtils.fromInteger((Integer)createTargetGroupRequest.getHealthyThresholdCount()));
        }
        if (createTargetGroupRequest.getUnhealthyThresholdCount() != null) {
            request.addParameter("UnhealthyThresholdCount", StringUtils.fromInteger((Integer)createTargetGroupRequest.getUnhealthyThresholdCount()));
        }
        if ((matcher = createTargetGroupRequest.getMatcher()) != null && matcher.getHttpCode() != null) {
            request.addParameter("Matcher.HttpCode", StringUtils.fromString((String)matcher.getHttpCode()));
        }
        return request;
    }
}

