/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.raft.jraft.rpc;

import java.util.Objects;
import org.apache.ignite3.internal.network.serialization.MessageSerializer;
import org.apache.ignite3.internal.tostring.IgniteToStringInclude;
import org.apache.ignite3.internal.tostring.S;
import org.apache.ignite3.raft.jraft.rpc.AddPeerRequestBuilder;
import org.apache.ignite3.raft.jraft.rpc.AddPeerRequestSerializer;
import org.apache.ignite3.raft.jraft.rpc.CliRequests;

public class AddPeerRequestImpl
implements CliRequests.AddPeerRequest,
Cloneable {
    public static final short GROUP_TYPE = 3;
    public static final short TYPE = 1000;
    @IgniteToStringInclude
    private final String groupId;
    @IgniteToStringInclude
    private final String leaderId;
    @IgniteToStringInclude
    private final String peerId;

    private AddPeerRequestImpl(String groupId, String leaderId, String peerId) {
        this.groupId = groupId;
        this.leaderId = leaderId;
        this.peerId = peerId;
    }

    @Override
    public String groupId() {
        return this.groupId;
    }

    @Override
    public String leaderId() {
        return this.leaderId;
    }

    @Override
    public String peerId() {
        return this.peerId;
    }

    public MessageSerializer serializer() {
        return AddPeerRequestSerializer.INSTANCE;
    }

    @Override
    public short groupType() {
        return 3;
    }

    public String toString() {
        return S.toString(AddPeerRequestImpl.class, this);
    }

    @Override
    public short messageType() {
        return 1000;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        AddPeerRequestImpl otherMessage = (AddPeerRequestImpl)other;
        return Objects.equals(this.groupId, otherMessage.groupId) && Objects.equals(this.leaderId, otherMessage.leaderId) && Objects.equals(this.peerId, otherMessage.peerId);
    }

    public int hashCode() {
        int result = 0;
        result = Objects.hash(this.groupId, this.leaderId, this.peerId);
        return result;
    }

    @Override
    public AddPeerRequestImpl clone() {
        try {
            return (AddPeerRequestImpl)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError((Object)e);
        }
    }

    public static AddPeerRequestBuilder builder() {
        return new Builder();
    }

    private static class Builder
    implements AddPeerRequestBuilder {
        private String groupId;
        private String leaderId;
        private String peerId;

        private Builder() {
        }

        @Override
        public AddPeerRequestBuilder groupId(String groupId) {
            Objects.requireNonNull(groupId, "groupId is not marked @Nullable");
            this.groupId = groupId;
            return this;
        }

        @Override
        public AddPeerRequestBuilder leaderId(String leaderId) {
            Objects.requireNonNull(leaderId, "leaderId is not marked @Nullable");
            this.leaderId = leaderId;
            return this;
        }

        @Override
        public AddPeerRequestBuilder peerId(String peerId) {
            Objects.requireNonNull(peerId, "peerId is not marked @Nullable");
            this.peerId = peerId;
            return this;
        }

        @Override
        public String groupId() {
            return this.groupId;
        }

        @Override
        public String leaderId() {
            return this.leaderId;
        }

        @Override
        public String peerId() {
            return this.peerId;
        }

        @Override
        public CliRequests.AddPeerRequest build() {
            return new AddPeerRequestImpl(Objects.requireNonNull(this.groupId, "groupId is not marked @Nullable"), Objects.requireNonNull(this.leaderId, "leaderId is not marked @Nullable"), Objects.requireNonNull(this.peerId, "peerId is not marked @Nullable"));
        }
    }
}

