/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.raft.storage.impl;

import java.util.List;
import java.util.NavigableMap;
import java.util.concurrent.ConcurrentSkipListMap;
import org.apache.ignite.internal.raft.storage.impl.Logs;
import org.apache.ignite.raft.jraft.entity.LogEntry;
import org.apache.ignite.raft.jraft.option.LogStorageOptions;

public class OnHeapLogs
implements Logs {
    private final NavigableMap<Long, LogEntry> map = new ConcurrentSkipListMap<Long, LogEntry>();

    @Override
    public boolean init(LogStorageOptions opts) {
        return true;
    }

    @Override
    public void shutdown() {
    }

    @Override
    public LogEntry getEntry(long index) {
        return (LogEntry)this.map.get(index);
    }

    @Override
    public void appendEntry(LogEntry entry) {
        this.map.put(entry.getId().getIndex(), entry);
    }

    @Override
    public void appendEntries(List<LogEntry> entries) {
        for (LogEntry entry : entries) {
            this.appendEntry(entry);
        }
    }

    @Override
    public void truncatePrefix(long firstIndexKept) {
        this.map.headMap(firstIndexKept).clear();
    }

    @Override
    public void truncateSuffix(long lastIndexKept) {
        this.map.tailMap(lastIndexKept, false).clear();
    }

    @Override
    public void reset() {
        this.map.clear();
    }
}

