/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.event;

import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import java.util.function.Function;
import org.apache.ignite.internal.event.EventParameters;
import org.apache.ignite.internal.util.CompletableFutures;

@FunctionalInterface
public interface EventListener<P extends EventParameters> {
    public CompletableFuture<Boolean> notify(P var1);

    public static <P extends EventParameters> EventListener<P> fromConsumer(Consumer<P> callback) {
        return parameters -> {
            try {
                callback.accept(parameters);
            }
            catch (Throwable e) {
                return CompletableFuture.failedFuture(e);
            }
            return CompletableFutures.falseCompletedFuture();
        };
    }

    public static <P extends EventParameters> EventListener<P> fromFunction(Function<P, CompletableFuture<Boolean>> callback) {
        return parameters -> {
            try {
                return (CompletableFuture)callback.apply(parameters);
            }
            catch (Throwable e) {
                return CompletableFuture.failedFuture(e);
            }
        };
    }
}

