/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.sql.fun;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.SetMultimap;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Objects;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rel.type.RelDataTypeFamily;
import org.apache.calcite.sql.SqlCall;
import org.apache.calcite.sql.SqlCallBinding;
import org.apache.calcite.sql.SqlDynamicParam;
import org.apache.calcite.sql.SqlFunction;
import org.apache.calcite.sql.SqlFunctionCategory;
import org.apache.calcite.sql.SqlIntervalQualifier;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlLiteral;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlOperandCountRange;
import org.apache.calcite.sql.SqlOperatorBinding;
import org.apache.calcite.sql.SqlSyntax;
import org.apache.calcite.sql.SqlUtil;
import org.apache.calcite.sql.SqlWriter;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.calcite.sql.type.InferTypes;
import org.apache.calcite.sql.type.SqlOperandCountRanges;
import org.apache.calcite.sql.type.SqlReturnTypeInference;
import org.apache.calcite.sql.type.SqlTypeFamily;
import org.apache.calcite.sql.type.SqlTypeMappingRule;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.calcite.sql.type.SqlTypeUtil;
import org.apache.calcite.sql.validate.SqlMonotonicity;
import org.apache.calcite.sql.validate.SqlValidator;
import org.apache.calcite.util.Static;

public class SqlCastFunction
extends SqlFunction {
    private final SetMultimap<SqlTypeFamily, SqlTypeFamily> nonMonotonicCasts = ImmutableSetMultimap.builder().put((Object)SqlTypeFamily.EXACT_NUMERIC, (Object)SqlTypeFamily.CHARACTER).put((Object)SqlTypeFamily.NUMERIC, (Object)SqlTypeFamily.CHARACTER).put((Object)SqlTypeFamily.APPROXIMATE_NUMERIC, (Object)SqlTypeFamily.CHARACTER).put((Object)SqlTypeFamily.DATETIME_INTERVAL, (Object)SqlTypeFamily.CHARACTER).put((Object)SqlTypeFamily.CHARACTER, (Object)SqlTypeFamily.EXACT_NUMERIC).put((Object)SqlTypeFamily.CHARACTER, (Object)SqlTypeFamily.NUMERIC).put((Object)SqlTypeFamily.CHARACTER, (Object)SqlTypeFamily.APPROXIMATE_NUMERIC).put((Object)SqlTypeFamily.CHARACTER, (Object)SqlTypeFamily.DATETIME_INTERVAL).put((Object)SqlTypeFamily.DATETIME, (Object)SqlTypeFamily.TIME).put((Object)SqlTypeFamily.TIMESTAMP, (Object)SqlTypeFamily.TIME).put((Object)SqlTypeFamily.TIME, (Object)SqlTypeFamily.DATETIME).put((Object)SqlTypeFamily.TIME, (Object)SqlTypeFamily.TIMESTAMP).build();

    public SqlCastFunction() {
        this(SqlKind.CAST.toString(), SqlKind.CAST);
    }

    public SqlCastFunction(String name, SqlKind kind) {
        super(name, kind, SqlCastFunction.returnTypeInference(kind == SqlKind.SAFE_CAST), InferTypes.FIRST_KNOWN, null, SqlFunctionCategory.SYSTEM);
        Preconditions.checkArgument((kind == SqlKind.CAST || kind == SqlKind.SAFE_CAST ? 1 : 0) != 0, (Object)((Object)kind));
    }

    static SqlReturnTypeInference returnTypeInference(boolean safe) {
        return opBinding -> {
            SqlCallBinding callBinding;
            SqlNode operand0;
            assert (opBinding.getOperandCount() <= 3);
            RelDataType ret = SqlCastFunction.deriveType(opBinding.getTypeFactory(), opBinding.getOperandType(0), opBinding.getOperandType(1), safe);
            if (opBinding instanceof SqlCallBinding && (SqlUtil.isNullLiteral(operand0 = (callBinding = (SqlCallBinding)opBinding).operand(0), false) || operand0 instanceof SqlDynamicParam)) {
                callBinding.getValidator().setValidatedNodeType(operand0, ret);
            }
            return ret;
        };
    }

    public static RelDataType deriveType(RelDataTypeFactory typeFactory, RelDataType expressionType, RelDataType targetType, boolean safe) {
        return SqlCastFunction.createTypeWithNullabilityFromExpr(typeFactory, expressionType, targetType, safe);
    }

    private static RelDataType createTypeWithNullabilityFromExpr(RelDataTypeFactory typeFactory, RelDataType expressionType, RelDataType targetType, boolean safe) {
        boolean isNullable;
        boolean bl = isNullable = expressionType.isNullable() || safe;
        if (targetType.getSqlTypeName() == SqlTypeName.VARIANT) {
            return typeFactory.createTypeWithNullability(targetType, expressionType.isNullable());
        }
        if (expressionType.getSqlTypeName() == SqlTypeName.VARIANT) {
            return typeFactory.createTypeWithNullability(targetType, true);
        }
        if (SqlTypeUtil.isCollection(expressionType)) {
            RelDataType expressionElementType = expressionType.getComponentType();
            RelDataType targetElementType = targetType.getComponentType();
            Objects.requireNonNull(expressionElementType, () -> "componentType of " + expressionType);
            Objects.requireNonNull(targetElementType, () -> "componentType of " + targetType);
            RelDataType newElementType = SqlCastFunction.createTypeWithNullabilityFromExpr(typeFactory, expressionElementType, targetElementType, safe);
            return SqlTypeUtil.isArray(targetType) ? SqlTypeUtil.createArrayType(typeFactory, newElementType, isNullable) : SqlTypeUtil.createMultisetType(typeFactory, newElementType, isNullable);
        }
        if (SqlTypeUtil.isRow(expressionType)) {
            int fieldCount = expressionType.getFieldCount();
            ArrayList<RelDataType> typeList = new ArrayList<RelDataType>(fieldCount);
            for (int i = 0; i < fieldCount; ++i) {
                RelDataType expressionElementType = expressionType.getFieldList().get(i).getType();
                RelDataType targetElementType = targetType.getFieldList().get(i).getType();
                typeList.add(SqlCastFunction.createTypeWithNullabilityFromExpr(typeFactory, expressionElementType, targetElementType, safe));
            }
            return typeFactory.createTypeWithNullability(typeFactory.createStructType(typeList, targetType.getFieldNames()), isNullable);
        }
        if (SqlTypeUtil.isMap(expressionType)) {
            RelDataType expressionKeyType = Objects.requireNonNull(expressionType.getKeyType(), () -> "keyType of " + expressionType);
            RelDataType expressionValueType = Objects.requireNonNull(expressionType.getValueType(), () -> "valueType of " + expressionType);
            RelDataType targetKeyType = Objects.requireNonNull(targetType.getKeyType(), () -> "keyType of " + targetType);
            RelDataType targetValueType = Objects.requireNonNull(targetType.getValueType(), () -> "valueType of " + targetType);
            RelDataType keyType = SqlCastFunction.createTypeWithNullabilityFromExpr(typeFactory, expressionKeyType, targetKeyType, safe);
            RelDataType valueType = SqlCastFunction.createTypeWithNullabilityFromExpr(typeFactory, expressionValueType, targetValueType, safe);
            SqlTypeUtil.createMapType(typeFactory, keyType, valueType, isNullable);
        }
        return typeFactory.createTypeWithNullability(targetType, isNullable);
    }

    @Override
    public String getSignatureTemplate(int operandsCount) {
        assert (operandsCount <= 3);
        return "{0}({1} AS {2} [FORMAT {3}])";
    }

    @Override
    public SqlOperandCountRange getOperandCountRange() {
        return SqlOperandCountRanges.between(2, 3);
    }

    @Override
    public boolean checkOperandTypes(SqlCallBinding callBinding, boolean throwOnFailure) {
        SqlTypeMappingRule mappingRule;
        SqlLiteral format;
        SqlNode left = callBinding.operand(0);
        SqlNode right = callBinding.operand(1);
        SqlLiteral sqlLiteral = format = callBinding.getOperandCount() > 2 ? (SqlLiteral)callBinding.operand(2) : SqlLiteral.createNull(SqlParserPos.ZERO);
        if (SqlUtil.isNullLiteral(left, false) || left instanceof SqlDynamicParam) {
            return true;
        }
        SqlValidator validator = callBinding.getValidator();
        RelDataType validatedNodeType = validator.getValidatedNodeType(left);
        RelDataType returnType = SqlTypeUtil.deriveType(callBinding, right);
        if (!SqlTypeUtil.canCastFrom(returnType, validatedNodeType, mappingRule = validator.getTypeMappingRule())) {
            if (throwOnFailure) {
                throw callBinding.newError(Static.RESOURCE.cannotCastValue(validatedNodeType.toString(), returnType.toString()));
            }
            return false;
        }
        if (SqlTypeUtil.areCharacterSetsMismatched(validatedNodeType, returnType)) {
            if (throwOnFailure) {
                throw callBinding.newError(Static.RESOURCE.cannotCastValue(validatedNodeType.getFullTypeString(), returnType.getFullTypeString()));
            }
            return false;
        }
        return SqlUtil.isNullLiteral(format, false) || SqlLiteral.valueMatchesType(format.getValue(), SqlTypeName.CHAR);
    }

    @Override
    public SqlSyntax getSyntax() {
        return SqlSyntax.SPECIAL;
    }

    @Override
    public void unparse(SqlWriter writer, SqlCall call, int leftPrec, int rightPrec) {
        assert (call.operandCount() <= 3);
        SqlWriter.Frame frame = writer.startFunCall(this.getName());
        ((SqlNode)call.operand(0)).unparse(writer, 0, 0);
        writer.sep("AS");
        if (call.operand(1) instanceof SqlIntervalQualifier) {
            writer.sep("INTERVAL");
        }
        ((SqlNode)call.operand(1)).unparse(writer, 0, 0);
        if (call.getOperandList().size() > 2) {
            writer.sep("FORMAT");
            ((SqlNode)call.operand(2)).unparse(writer, 0, 0);
        }
        writer.endFunCall(frame);
    }

    @Override
    public SqlMonotonicity getMonotonicity(SqlOperatorBinding call) {
        Collator castToCollator;
        RelDataType castFromType = call.getOperandType(0);
        RelDataTypeFamily castFromFamily = castFromType.getFamily();
        Collator castFromCollator = castFromType.getCollation() == null ? null : castFromType.getCollation().getCollator();
        RelDataType castToType = call.getOperandType(1);
        RelDataTypeFamily castToFamily = castToType.getFamily();
        Collator collator = castToCollator = castToType.getCollation() == null ? null : castToType.getCollation().getCollator();
        if (!Objects.equals(castFromCollator, castToCollator)) {
            return SqlMonotonicity.NOT_MONOTONIC;
        }
        if (castFromFamily instanceof SqlTypeFamily && castToFamily instanceof SqlTypeFamily && this.nonMonotonicCasts.containsEntry((Object)castFromFamily, (Object)castToFamily)) {
            return SqlMonotonicity.NOT_MONOTONIC;
        }
        return call.getOperandMonotonicity(0);
    }
}

