/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.sql.engine.rex;

import java.math.BigDecimal;
import java.util.UUID;
import org.apache.calcite.avatica.util.ByteString;
import org.apache.calcite.avatica.util.TimeUnit;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.calcite.sql.type.SqlTypeUtil;
import org.apache.calcite.util.NlsString;
import org.apache.ignite.internal.sql.engine.type.IgniteTypeFactory;
import org.jetbrains.annotations.Nullable;

public class IgniteRexBuilder
extends RexBuilder {
    public static final IgniteRexBuilder INSTANCE = new IgniteRexBuilder((RelDataTypeFactory)IgniteTypeFactory.INSTANCE);

    private IgniteRexBuilder(RelDataTypeFactory typeFactory) {
        super(typeFactory);
    }

    public RexNode makeLiteral(@Nullable Object value, RelDataType type, boolean allowCast, boolean trim) {
        if (value != null) {
            if (type.getSqlTypeName() == SqlTypeName.CHAR) {
                NlsString string;
                if (type.isNullable()) {
                    RelDataType typeNotNull = this.typeFactory.createTypeWithNullability(type, false);
                    if (allowCast) {
                        RexNode literalNotNull = this.makeLiteral(value, typeNotNull, allowCast);
                        return this.makeAbstractCast(type, literalNotNull, false);
                    }
                }
                if (value instanceof NlsString) {
                    string = (NlsString)value;
                } else {
                    assert (type.getCharset() != null) : String.valueOf(type) + ".getCharset() must not be null";
                    string = new NlsString((String)value, type.getCharset().name(), type.getCollation());
                }
                return this.makeCharLiteral(string);
            }
            if (type.getSqlTypeName() == SqlTypeName.BINARY) {
                return this.makeBinaryLiteral((ByteString)value);
            }
            if (value instanceof String) {
                if (type.getSqlTypeName() == SqlTypeName.DOUBLE) {
                    value = Double.parseDouble((String)value);
                } else if (type.getSqlTypeName() == SqlTypeName.REAL || type.getSqlTypeName() == SqlTypeName.FLOAT) {
                    value = Float.valueOf(Float.parseFloat((String)value));
                }
            }
        }
        if (value instanceof UUID && type.getSqlTypeName() == SqlTypeName.UUID) {
            return this.makeUuidLiteral((UUID)value);
        }
        return super.makeLiteral(value, type, allowCast, trim);
    }

    public RexNode makeCast(SqlParserPos pos, RelDataType type, RexNode exp, boolean matchNullability, boolean safe, RexLiteral format) {
        if (exp instanceof RexLiteral && SqlTypeUtil.isExactNumeric((RelDataType)type) && SqlTypeUtil.isInterval((RelDataType)exp.getType())) {
            return this.makeCastIntervalToExact(pos, type, exp);
        }
        return super.makeCast(pos, type, exp, matchNullability, safe, format);
    }

    private RexNode makeCastIntervalToExact(SqlParserPos pos, RelDataType toType, RexNode exp) {
        TimeUnit endUnit = exp.getType().getSqlTypeName().getEndUnit();
        TimeUnit baseUnit = IgniteRexBuilder.baseUnit((SqlTypeName)exp.getType().getSqlTypeName());
        BigDecimal multiplier = baseUnit.multiplier;
        BigDecimal divider = endUnit.multiplier;
        RexNode value = this.multiplyDivide(pos, this.decodeIntervalOrDecimal(pos, exp), multiplier, divider);
        return this.ensureType(pos, toType, value, false);
    }
}

