/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.storage.pagememory.mv;

import java.util.Arrays;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;
import java.util.function.Consumer;
import java.util.function.Predicate;
import org.apache.ignite.internal.failure.FailureContext;
import org.apache.ignite.internal.failure.FailureProcessor;
import org.apache.ignite.internal.hlc.HybridTimestamp;
import org.apache.ignite.internal.lang.IgniteInternalCheckedException;
import org.apache.ignite.internal.lang.IgniteInternalException;
import org.apache.ignite.internal.pagememory.tree.BplusTree;
import org.apache.ignite.internal.pagememory.util.GradualTask;
import org.apache.ignite.internal.pagememory.util.GradualTaskExecutor;
import org.apache.ignite.internal.storage.MvPartitionStorage;
import org.apache.ignite.internal.storage.StorageException;
import org.apache.ignite.internal.storage.lease.LeaseInfo;
import org.apache.ignite.internal.storage.pagememory.VolatilePageMemoryTableStorage;
import org.apache.ignite.internal.storage.pagememory.index.meta.IndexMetaTree;
import org.apache.ignite.internal.storage.pagememory.mv.AbstractPageMemoryMvPartitionStorage;
import org.apache.ignite.internal.storage.pagememory.mv.RenewablePartitionStorageState;
import org.apache.ignite.internal.storage.pagememory.mv.RowVersion;
import org.apache.ignite.internal.storage.pagememory.mv.VersionChain;
import org.apache.ignite.internal.storage.pagememory.mv.VersionChainTree;
import org.apache.ignite.internal.storage.pagememory.mv.gc.GcQueue;
import org.apache.ignite.internal.storage.util.LocalLocker;
import org.apache.ignite.internal.storage.util.StorageState;
import org.apache.ignite.internal.storage.util.StorageUtils;
import org.apache.ignite.internal.util.CompletableFutures;
import org.jetbrains.annotations.Nullable;

public class VolatilePageMemoryMvPartitionStorage
extends AbstractPageMemoryMvPartitionStorage {
    private static final Predicate<HybridTimestamp> NEVER_LOAD_VALUE = ts -> false;
    private static final AtomicLongFieldUpdater<VolatilePageMemoryMvPartitionStorage> ESTIMATED_SIZE_UPDATER = AtomicLongFieldUpdater.newUpdater(VolatilePageMemoryMvPartitionStorage.class, "estimatedSize");
    private volatile long lastAppliedIndex;
    private volatile long lastAppliedTerm;
    @Nullable
    private volatile LeaseInfo leaseInfo;
    private volatile byte @Nullable [] groupConfig;
    private volatile long estimatedSize;

    public VolatilePageMemoryMvPartitionStorage(VolatilePageMemoryTableStorage tableStorage, int partitionId, VersionChainTree versionChainTree, IndexMetaTree indexMetaTree, GcQueue gcQueue, ExecutorService destructionExecutor, FailureProcessor failureProcessor) {
        super(partitionId, tableStorage, new RenewablePartitionStorageState(tableStorage, partitionId, versionChainTree, tableStorage.dataRegion().freeList(), indexMetaTree, gcQueue), destructionExecutor, failureProcessor);
    }

    @Override
    protected GradualTaskExecutor createGradualTaskExecutor(ExecutorService threadPool) {
        return new GradualTaskExecutor(threadPool);
    }

    public <V> V runConsistently(MvPartitionStorage.WriteClosure<V> closure) throws StorageException {
        LocalLocker locker = (LocalLocker)THREAD_LOCAL_LOCKER.get();
        if (locker != null) {
            return (V)closure.execute((MvPartitionStorage.Locker)locker);
        }
        return (V)this.busy(() -> {
            StorageUtils.throwExceptionIfStorageNotInRunnableOrRebalanceState((StorageState)((StorageState)this.state.get()), this::createStorageInfo);
            LocalLocker locker0 = new LocalLocker(this.lockByRowId);
            THREAD_LOCAL_LOCKER.set(locker0);
            try {
                Object object = closure.execute((MvPartitionStorage.Locker)locker0);
                return object;
            }
            finally {
                THREAD_LOCAL_LOCKER.remove();
                locker0.unlockAll();
            }
        });
    }

    public CompletableFuture<Void> flush(boolean trigger) {
        return this.busy(() -> {
            StorageUtils.throwExceptionIfStorageNotInRunnableOrRebalanceState((StorageState)((StorageState)this.state.get()), this::createStorageInfo);
            return CompletableFutures.nullCompletedFuture();
        });
    }

    public long lastAppliedIndex() {
        return this.busy(() -> {
            StorageUtils.throwExceptionIfStorageNotInRunnableOrRebalanceState((StorageState)((StorageState)this.state.get()), this::createStorageInfo);
            return this.lastAppliedIndex;
        });
    }

    public long lastAppliedTerm() {
        return this.busy(() -> {
            StorageUtils.throwExceptionIfStorageNotInRunnableOrRebalanceState((StorageState)((StorageState)this.state.get()), this::createStorageInfo);
            return this.lastAppliedTerm;
        });
    }

    public void lastApplied(long lastAppliedIndex, long lastAppliedTerm) throws StorageException {
        this.busy(() -> {
            this.throwExceptionIfStorageNotInRunnableState();
            this.lastAppliedIndex = lastAppliedIndex;
            this.lastAppliedTerm = lastAppliedTerm;
            return null;
        });
    }

    public byte @Nullable [] committedGroupConfiguration() {
        return this.busy(() -> {
            StorageUtils.throwExceptionIfStorageNotInRunnableOrRebalanceState((StorageState)((StorageState)this.state.get()), this::createStorageInfo);
            byte[] currentConfig = this.groupConfig;
            return currentConfig == null ? null : Arrays.copyOf(currentConfig, currentConfig.length);
        });
    }

    public void committedGroupConfiguration(byte[] config) {
        this.busy(() -> {
            this.throwExceptionIfStorageNotInRunnableState();
            this.groupConfig = Arrays.copyOf(config, config.length);
            return null;
        });
    }

    public void updateLease(LeaseInfo leaseInfo) {
        this.busy(() -> {
            this.throwExceptionIfStorageNotInRunnableState();
            LeaseInfo thisLeaseInfo = this.leaseInfo;
            if (thisLeaseInfo != null && leaseInfo.leaseStartTime() <= thisLeaseInfo.leaseStartTime()) {
                return null;
            }
            this.leaseInfo = leaseInfo;
            return null;
        });
    }

    @Nullable
    public LeaseInfo leaseInfo() {
        return this.busy(() -> {
            this.throwExceptionIfStorageNotInRunnableState();
            return this.leaseInfo;
        });
    }

    @Override
    public void lastAppliedOnRebalance(long lastAppliedIndex, long lastAppliedTerm) {
        StorageUtils.throwExceptionIfStorageNotInProgressOfRebalance((StorageState)((StorageState)this.state.get()), this::createStorageInfo);
        this.lastAppliedIndex = lastAppliedIndex;
        this.lastAppliedTerm = lastAppliedTerm;
    }

    public CompletableFuture<Void> destroyStructures() {
        RenewablePartitionStorageState localState = this.renewableState;
        CompletableFuture<Void> destroyFuture = CompletableFuture.allOf(this.startMvDataDestruction(localState), this.startIndexMetaTreeDestruction(localState), this.startGarbageCollectionTreeDestruction(localState), this.indexes.destroyStructures());
        this.lastAppliedIndex = 0L;
        this.lastAppliedTerm = 0L;
        this.groupConfig = null;
        this.leaseInfo = null;
        return destroyFuture;
    }

    private CompletableFuture<Void> startMvDataDestruction(RenewablePartitionStorageState renewableState) {
        return this.destroyTree(renewableState.versionChainTree(), chainKey -> this.destroyVersionChain((VersionChain)chainKey, renewableState)).whenComplete((res, e) -> {
            if (e != null) {
                String errorMessage = String.format("Version chains destruction failed: [tableId=%s, partitionId=%s]", this.tableStorage.getTableId(), this.partitionId);
                this.failureProcessor.process(new FailureContext(e, errorMessage));
            }
        });
    }

    private void destroyVersionChain(VersionChain chainKey, RenewablePartitionStorageState renewableState) {
        try {
            this.deleteRowVersionsFromFreeList(chainKey, renewableState);
        }
        catch (IgniteInternalCheckedException e) {
            throw new IgniteInternalException((Throwable)e);
        }
    }

    private void deleteRowVersionsFromFreeList(VersionChain chain, RenewablePartitionStorageState renewableState) throws IgniteInternalCheckedException {
        long rowVersionLink = chain.headLink();
        while (rowVersionLink != 0L) {
            RowVersion rowVersion = this.readRowVersion(rowVersionLink, NEVER_LOAD_VALUE);
            renewableState.freeList().removeDataRowByLink(rowVersion.link());
            rowVersionLink = rowVersion.nextLink();
        }
    }

    private CompletableFuture<Void> startIndexMetaTreeDestruction(RenewablePartitionStorageState renewableState) {
        return this.destroyTree(renewableState.indexMetaTree(), null).whenComplete((res, e) -> {
            if (e != null) {
                String errorMessage = String.format("Index meta tree destruction failed: [tableId=%s, partitionId=%s]", this.tableStorage.getTableId(), this.partitionId);
                this.failureProcessor.process(new FailureContext(e, errorMessage));
            }
        });
    }

    private CompletableFuture<Void> startGarbageCollectionTreeDestruction(RenewablePartitionStorageState renewableState) {
        return this.destroyTree(renewableState.gcQueue(), null).whenComplete((res, e) -> {
            if (e != null) {
                String errorMessage = String.format("Garbage collection tree destruction failed: [tableId=%s, partitionId=%s]", this.tableStorage.getTableId(), this.partitionId);
                this.failureProcessor.process(new FailureContext(e, errorMessage));
            }
        });
    }

    private <T> CompletableFuture<Void> destroyTree(BplusTree<T, ?> target, @Nullable Consumer<T> consumer) {
        try {
            GradualTask task = target.startGradualDestruction(consumer, false, 1000);
            return this.destructionExecutor.execute(task);
        }
        catch (IgniteInternalCheckedException e) {
            return CompletableFuture.failedFuture(e);
        }
    }

    @Override
    List<AutoCloseable> getResourcesToCloseOnCleanup() {
        RenewablePartitionStorageState localState = this.renewableState;
        return List.of(() -> ((VersionChainTree)localState.versionChainTree()).close(), () -> ((IndexMetaTree)localState.indexMetaTree()).close(), () -> ((GcQueue)localState.gcQueue()).close());
    }

    public void updateDataStructures(VersionChainTree versionChainTree, IndexMetaTree indexMetaTree, GcQueue gcQueue) {
        StorageUtils.throwExceptionIfStorageNotInCleanupOrRebalancedState((StorageState)((StorageState)this.state.get()), this::createStorageInfo);
        RenewablePartitionStorageState prevState = this.renewableState;
        this.updateRenewableState(versionChainTree, prevState.freeList(), indexMetaTree, gcQueue);
        this.estimatedSize = 0L;
    }

    @Override
    public void committedGroupConfigurationOnRebalance(byte[] config) throws StorageException {
        StorageUtils.throwExceptionIfStorageNotInProgressOfRebalance((StorageState)((StorageState)this.state.get()), this::createStorageInfo);
        this.groupConfig = config;
    }

    @Override
    public void updateLeaseOnRebalance(LeaseInfo leaseInfo) {
        StorageUtils.throwExceptionIfStorageNotInProgressOfRebalance((StorageState)((StorageState)this.state.get()), this::createStorageInfo);
        this.leaseInfo = leaseInfo;
    }

    public long estimatedSize() {
        return this.estimatedSize;
    }

    @Override
    public void incrementEstimatedSize() {
        ESTIMATED_SIZE_UPDATER.incrementAndGet(this);
    }

    @Override
    public void decrementEstimatedSize() {
        ESTIMATED_SIZE_UPDATER.decrementAndGet(this);
    }
}

