/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.cli.core.repl.completer.unit;

import jakarta.inject.Singleton;
import org.apache.ignite.internal.cli.core.repl.completer.DummyCompleter;
import org.apache.ignite.internal.cli.core.repl.completer.DynamicCompleter;
import org.apache.ignite.internal.cli.core.repl.completer.DynamicCompleterFactory;
import org.apache.ignite.internal.cli.core.repl.completer.StringDynamicCompleter;
import org.apache.ignite.internal.cli.core.repl.completer.unit.ArgumentParser;
import org.apache.ignite.internal.cli.core.repl.registry.UnitsRegistry;

@Singleton
public class UnitVersionsDynamicCompleterFactory
implements DynamicCompleterFactory {
    private final UnitsRegistry unitsRegistry;
    private final ArgumentParser parser;

    public UnitVersionsDynamicCompleterFactory(UnitsRegistry unitsRegistry, ArgumentParser parser) {
        this.unitsRegistry = unitsRegistry;
        this.parser = parser;
    }

    @Override
    public DynamicCompleter getDynamicCompleter(String[] words) {
        String unitId = this.parser.parseFirstPositionalParameter(words);
        if (unitId != null) {
            return new StringDynamicCompleter(this.unitsRegistry.versions(unitId));
        }
        return new DummyCompleter();
    }
}

