/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.partition.replicator.schema;

import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.apache.ignite.internal.catalog.CatalogService;
import org.apache.ignite.internal.catalog.descriptors.CatalogTableDescriptor;
import org.apache.ignite.internal.hlc.HybridTimestamp;
import org.apache.ignite.internal.partition.replicator.schema.FullTableSchema;
import org.apache.ignite.internal.partition.replicator.schema.ValidationSchemasSource;
import org.apache.ignite.internal.schema.SchemaManager;

public class CatalogValidationSchemasSource
implements ValidationSchemasSource {
    private final CatalogService catalogService;
    private final SchemaManager schemaManager;
    private final ConcurrentMap<CatalogVersionsSpan, List<FullTableSchema>> catalogVersionSpansCache = new ConcurrentHashMap<CatalogVersionsSpan, List<FullTableSchema>>();
    private final ConcurrentMap<CatalogVersionToTableVersionSpan, List<FullTableSchema>> catalogVersionToTableVersionSpansCache = new ConcurrentHashMap<CatalogVersionToTableVersionSpan, List<FullTableSchema>>();

    public CatalogValidationSchemasSource(CatalogService catalogService, SchemaManager schemaManager) {
        this.catalogService = catalogService;
        this.schemaManager = schemaManager;
    }

    @Override
    public CompletableFuture<Void> waitForSchemaAvailability(int tableId, int schemaVersion) {
        return this.schemaManager.schemaRegistry(tableId).schemaAsync(schemaVersion).thenApply(unused -> null);
    }

    @Override
    public List<FullTableSchema> tableSchemaVersionsBetween(int tableId, HybridTimestamp fromIncluding, HybridTimestamp toIncluding) {
        int fromCatalogVersion = this.catalogService.activeCatalogVersion(fromIncluding.longValue());
        int toCatalogVersion = this.catalogService.activeCatalogVersion(toIncluding.longValue());
        return this.catalogVersionSpansCache.computeIfAbsent(new CatalogVersionsSpan(tableId, fromCatalogVersion, toCatalogVersion), key -> this.tableSchemaVersionsBetweenCatalogVersions(tableId, fromCatalogVersion, toCatalogVersion));
    }

    @Override
    public List<FullTableSchema> tableSchemaVersionsBetween(int tableId, HybridTimestamp fromIncluding, int toTableVersionIncluding) {
        int fromCatalogVersion = this.catalogService.activeCatalogVersion(fromIncluding.longValue());
        return this.catalogVersionToTableVersionSpansCache.computeIfAbsent(new CatalogVersionToTableVersionSpan(tableId, fromCatalogVersion, toTableVersionIncluding), key -> this.tableSchemaVersionsBetweenCatalogAndTableVersions(tableId, fromCatalogVersion, toTableVersionIncluding));
    }

    private List<FullTableSchema> tableSchemaVersionsBetweenCatalogVersions(int tableId, int fromCatalogVersion, int toCatalogVersion) {
        return this.tableVersionsBetween(tableId, fromCatalogVersion, toCatalogVersion).map(CatalogValidationSchemasSource::fullSchemaFromTableDescriptor).collect(Collectors.toList());
    }

    private Stream<CatalogTableDescriptor> tableVersionsBetween(int tableId, int fromCatalogVersionIncluding, int toCatalogVersionIncluding) {
        return IntStream.rangeClosed(fromCatalogVersionIncluding, toCatalogVersionIncluding).mapToObj(catalogVersion -> this.catalogService.catalog(catalogVersion).table(tableId)).takeWhile(Objects::nonNull).filter(new Predicate<CatalogTableDescriptor>(){
            int prevVersion = Integer.MIN_VALUE;

            @Override
            public boolean test(CatalogTableDescriptor tableDescriptor) {
                if (tableDescriptor.latestSchemaVersion() == this.prevVersion) {
                    return false;
                }
                assert (this.prevVersion == Integer.MIN_VALUE || tableDescriptor.latestSchemaVersion() == this.prevVersion + 1) : String.format("Table version is expected to be prevVersion+1, but version is %d and prevVersion is %d", tableDescriptor.latestSchemaVersion(), this.prevVersion);
                this.prevVersion = tableDescriptor.latestSchemaVersion();
                return true;
            }
        });
    }

    private List<FullTableSchema> tableSchemaVersionsBetweenCatalogAndTableVersions(int tableId, int fromCatalogVersion, int toTableVersion) {
        return this.tableVersionsBetween(tableId, fromCatalogVersion, this.catalogService.latestCatalogVersion()).takeWhile(tableDescriptor -> tableDescriptor.latestSchemaVersion() <= toTableVersion).map(CatalogValidationSchemasSource::fullSchemaFromTableDescriptor).collect(Collectors.toList());
    }

    private static FullTableSchema fullSchemaFromTableDescriptor(CatalogTableDescriptor tableDescriptor) {
        return new FullTableSchema(tableDescriptor.latestSchemaVersion(), tableDescriptor.id(), tableDescriptor.name(), tableDescriptor.columns());
    }

    private static class CatalogVersionsSpan {
        private final int tableId;
        private final int fromCatalogVersion;
        private final int toCatalogVersion;

        private CatalogVersionsSpan(int tableId, int fromCatalogVersion, int toCatalogVersion) {
            this.tableId = tableId;
            this.fromCatalogVersion = fromCatalogVersion;
            this.toCatalogVersion = toCatalogVersion;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CatalogVersionsSpan that = (CatalogVersionsSpan)o;
            if (this.tableId != that.tableId) {
                return false;
            }
            if (this.fromCatalogVersion != that.fromCatalogVersion) {
                return false;
            }
            return this.toCatalogVersion == that.toCatalogVersion;
        }

        public int hashCode() {
            int result = this.tableId;
            result = 31 * result + this.fromCatalogVersion;
            result = 31 * result + this.toCatalogVersion;
            return result;
        }
    }

    private static class CatalogVersionToTableVersionSpan {
        private final int tableId;
        private final int fromCatalogVersion;
        private final int toTableVersion;

        private CatalogVersionToTableVersionSpan(int tableId, int fromCatalogVersion, int toTableVersion) {
            this.tableId = tableId;
            this.fromCatalogVersion = fromCatalogVersion;
            this.toTableVersion = toTableVersion;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CatalogVersionToTableVersionSpan that = (CatalogVersionToTableVersionSpan)o;
            if (this.tableId != that.tableId) {
                return false;
            }
            if (this.fromCatalogVersion != that.fromCatalogVersion) {
                return false;
            }
            return this.toTableVersion == that.toTableVersion;
        }

        public int hashCode() {
            int result = this.tableId;
            result = 31 * result + this.fromCatalogVersion;
            result = 31 * result + this.toTableVersion;
            return result;
        }
    }
}

