/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.util.io;

import java.io.IOException;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.Period;
import java.util.Arrays;
import java.util.BitSet;
import java.util.UUID;
import org.apache.ignite.internal.tostring.IgniteToStringBuilder;
import org.apache.ignite.internal.util.FastTimestamps;
import org.apache.ignite.internal.util.GridUnsafe;
import org.apache.ignite.internal.util.StringIntrospection;
import org.apache.ignite.internal.util.VarIntUtils;
import org.apache.ignite.internal.util.io.IgniteDataOutput;

public class IgniteUnsafeDataOutput
extends OutputStream
implements IgniteDataOutput {
    private static final int MAX_BYTE_ARRAY_SIZE = 0x7FFFFFF7;
    private static final int CHAR_BUF_SIZE = 256;
    private final char[] cbuf = new char[256];
    private static final long NO_AUTO_SHRINK = -1L;
    private final long shrinkCheckFrequencyMs;
    private byte[] bytes;
    private int off;
    private OutputStream out;
    private int maxOff;
    private long lastAutoShrinkCheckTimestamp;

    public IgniteUnsafeDataOutput() {
        this(-1L);
    }

    public IgniteUnsafeDataOutput(long shrinkCheckFrequencyMs) {
        if (shrinkCheckFrequencyMs != -1L && shrinkCheckFrequencyMs <= 0L) {
            throw new IllegalArgumentException("Auto-shrink frequency must be either -1 (when auto-shrinking is disabled) or positive, but it's " + shrinkCheckFrequencyMs);
        }
        this.shrinkCheckFrequencyMs = shrinkCheckFrequencyMs;
    }

    public IgniteUnsafeDataOutput(int size) {
        this(size, -1L);
    }

    public IgniteUnsafeDataOutput(int size, long shrinkCheckFrequencyMs) {
        this(shrinkCheckFrequencyMs);
        this.bytes = new byte[size];
    }

    public void bytes(byte[] bytes, int off) {
        this.bytes = bytes;
        this.off = off;
    }

    @Override
    public void outputStream(OutputStream out) {
        this.out = out;
        this.off = 0;
    }

    @Override
    public byte[] array() {
        byte[] bytes0 = new byte[this.off];
        System.arraycopy(this.bytes, 0, bytes0, 0, this.off);
        return bytes0;
    }

    @Override
    public byte[] internalArray() {
        return this.bytes;
    }

    @Override
    public int offset() {
        return this.off;
    }

    @Override
    public void offset(int off) {
        this.off = off;
    }

    private void requestFreeSize(int size) throws IOException {
        long now;
        if (!this.canBeAllocated(this.off + size)) {
            throw new IOException("Failed to allocate required memory (byte array size overflow detected) [length=" + size + ", offset=" + this.off + "]");
        }
        size = this.off + size;
        this.maxOff = Math.max(this.maxOff, size);
        if (size > this.bytes.length) {
            int newSize = size << 1;
            if (!this.canBeAllocated(newSize)) {
                newSize = 0x7FFFFFF7;
            }
            this.bytes = Arrays.copyOf(this.bytes, newSize);
        } else if (this.isAutoShrinkEnabled() && (now = FastTimestamps.coarseCurrentTimeMillis()) - this.lastAutoShrinkCheckTimestamp > this.shrinkCheckFrequencyMs) {
            int halfSize = this.bytes.length >> 1;
            if (this.maxOff < halfSize) {
                this.bytes = Arrays.copyOf(this.bytes, halfSize);
            }
            this.maxOff = 0;
            this.lastAutoShrinkCheckTimestamp = now;
        }
    }

    private boolean isAutoShrinkEnabled() {
        return this.shrinkCheckFrequencyMs != -1L;
    }

    private boolean canBeAllocated(long size) {
        return 0L <= size && size <= 0x7FFFFFF7L;
    }

    private void onWrite(int size) throws IOException {
        if (this.out != null) {
            this.out.write(this.bytes, 0, size);
        } else {
            this.off += size;
        }
    }

    @Override
    public void write(int b) throws IOException {
        this.writeByte(b);
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.requestFreeSize(b.length);
        System.arraycopy(b, 0, this.bytes, this.off, b.length);
        this.onWrite(b.length);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        this.requestFreeSize(len);
        System.arraycopy(b, off, this.bytes, this.off, len);
        this.onWrite(len);
    }

    @Override
    public void writeDoubleArray(double[] arr) throws IOException {
        this.checkArrayAllocationOverflow(8, arr.length, "double");
        int bytesToCp = arr.length << 3;
        this.requestFreeSize(bytesToCp);
        if (GridUnsafe.IS_BIG_ENDIAN) {
            long off = GridUnsafe.BYTE_ARR_OFF + (long)this.off;
            for (double val : arr) {
                GridUnsafe.putDoubleLittleEndian(this.bytes, off, val);
                off += 8L;
            }
        } else {
            GridUnsafe.copyMemory(arr, GridUnsafe.DOUBLE_ARR_OFF, this.bytes, GridUnsafe.BYTE_ARR_OFF + (long)this.off, bytesToCp);
        }
        this.onWrite(bytesToCp);
    }

    private void putInt(int val, long off) {
        if (GridUnsafe.IS_BIG_ENDIAN) {
            GridUnsafe.putIntLittleEndian(this.bytes, off, val);
        } else {
            GridUnsafe.putInt(this.bytes, off, val);
        }
    }

    @Override
    public void writeBooleanArray(boolean[] arr) throws IOException {
        for (int i = 0; i < arr.length; ++i) {
            this.writeBoolean(arr[i]);
        }
    }

    @Override
    public void writeCharArray(char[] arr) throws IOException {
        this.checkArrayAllocationOverflow(2, arr.length, "char");
        int bytesToCp = arr.length << 1;
        this.requestFreeSize(bytesToCp);
        if (GridUnsafe.IS_BIG_ENDIAN) {
            long off = GridUnsafe.BYTE_ARR_OFF + (long)this.off;
            for (char val : arr) {
                GridUnsafe.putCharLittleEndian(this.bytes, off, val);
                off += 2L;
            }
        } else {
            GridUnsafe.copyMemory(arr, GridUnsafe.CHAR_ARR_OFF, this.bytes, GridUnsafe.BYTE_ARR_OFF + (long)this.off, bytesToCp);
        }
        this.onWrite(bytesToCp);
    }

    @Override
    public void writeBigInteger(BigInteger val) throws IOException {
        byte[] bytes = val.toByteArray();
        this.writeInt(bytes.length);
        this.writeByteArray(bytes);
    }

    @Override
    public void writeBigDecimal(BigDecimal val) throws IOException {
        short scale = (short)val.scale();
        byte[] bytes = val.unscaledValue().toByteArray();
        this.writeShort(scale);
        this.writeInt(bytes.length);
        this.writeByteArray(bytes);
    }

    @Override
    public void writeLocalTime(LocalTime val) throws IOException {
        byte hour = (byte)val.getHour();
        byte minute = (byte)val.getMinute();
        byte second = (byte)val.getSecond();
        int nano = val.getNano();
        this.writeByte(hour);
        this.writeByte(minute);
        this.writeByte(second);
        this.writeInt(nano);
    }

    @Override
    public void writeLocalDate(LocalDate date) throws IOException {
        int year = date.getYear();
        short month = (short)date.getMonth().getValue();
        short day = (short)date.getDayOfMonth();
        this.writeInt(year);
        this.writeShort(month);
        this.writeShort(day);
    }

    @Override
    public void writeLocalDateTime(LocalDateTime val) throws IOException {
        int year = val.getYear();
        short month = (short)val.getMonth().getValue();
        short day = (short)val.getDayOfMonth();
        byte hour = (byte)val.getHour();
        byte minute = (byte)val.getMinute();
        byte second = (byte)val.getSecond();
        int nano = val.getNano();
        this.writeInt(year);
        this.writeShort(month);
        this.writeShort(day);
        this.writeByte(hour);
        this.writeByte(minute);
        this.writeByte(second);
        this.writeInt(nano);
    }

    @Override
    public void writeInstant(Instant val) throws IOException {
        long epochSecond = val.getEpochSecond();
        int nano = val.getNano();
        this.writeLong(epochSecond);
        this.writeInt(nano);
    }

    @Override
    public void writePeriod(Period val) throws IOException {
        this.writeInt(val.getYears());
        this.writeInt(val.getMonths());
        this.writeInt(val.getDays());
    }

    @Override
    public void writeDuration(Duration val) throws IOException {
        this.writeLong(val.getSeconds());
        this.writeInt(val.getNano());
    }

    @Override
    public void writeUuid(UUID val) throws IOException {
        this.writeLong(val.getMostSignificantBits());
        this.writeLong(val.getLeastSignificantBits());
    }

    @Override
    public void writeBitSet(BitSet val) throws IOException {
        byte[] bytes = val.toByteArray();
        this.writeInt(bytes.length);
        this.writeByteArray(bytes);
    }

    @Override
    public void writeLongArray(long[] arr) throws IOException {
        this.checkArrayAllocationOverflow(8, arr.length, "long");
        int bytesToCp = arr.length << 3;
        this.requestFreeSize(bytesToCp);
        if (GridUnsafe.IS_BIG_ENDIAN) {
            long off = GridUnsafe.BYTE_ARR_OFF + (long)this.off;
            for (long val : arr) {
                GridUnsafe.putLongLittleEndian(this.bytes, off, val);
                off += 8L;
            }
        } else {
            GridUnsafe.copyMemory(arr, GridUnsafe.LONG_ARR_OFF, this.bytes, GridUnsafe.BYTE_ARR_OFF + (long)this.off, bytesToCp);
        }
        this.onWrite(bytesToCp);
    }

    @Override
    public void writeFloatArray(float[] arr) throws IOException {
        this.checkArrayAllocationOverflow(4, arr.length, "float");
        int bytesToCp = arr.length << 2;
        this.requestFreeSize(bytesToCp);
        if (GridUnsafe.IS_BIG_ENDIAN) {
            long off = GridUnsafe.BYTE_ARR_OFF + (long)this.off;
            for (float val : arr) {
                GridUnsafe.putFloatLittleEndian(this.bytes, off, val);
                off += 4L;
            }
        } else {
            GridUnsafe.copyMemory(arr, GridUnsafe.FLOAT_ARR_OFF, this.bytes, GridUnsafe.BYTE_ARR_OFF + (long)this.off, bytesToCp);
        }
        this.onWrite(bytesToCp);
    }

    @Override
    public void cleanup() {
        this.off = 0;
        this.out = null;
    }

    @Override
    public void writeVarInt(long val) throws IOException {
        VarIntUtils.writeVarInt(val, this);
    }

    @Override
    public void writeByteArray(byte[] arr) throws IOException {
        this.requestFreeSize(arr.length);
        System.arraycopy(arr, 0, this.bytes, this.off, arr.length);
        this.onWrite(arr.length);
    }

    @Override
    public void writeShortArray(short[] arr) throws IOException {
        this.checkArrayAllocationOverflow(2, arr.length, "short");
        int bytesToCp = arr.length << 1;
        this.requestFreeSize(bytesToCp);
        if (GridUnsafe.IS_BIG_ENDIAN) {
            long off = GridUnsafe.BYTE_ARR_OFF + (long)this.off;
            for (short val : arr) {
                GridUnsafe.putShortLittleEndian(this.bytes, off, val);
                off += 2L;
            }
        } else {
            GridUnsafe.copyMemory(arr, GridUnsafe.SHORT_ARR_OFF, this.bytes, GridUnsafe.BYTE_ARR_OFF + (long)this.off, bytesToCp);
        }
        this.onWrite(bytesToCp);
    }

    @Override
    public void writeIntArray(int[] arr) throws IOException {
        this.checkArrayAllocationOverflow(4, arr.length, "int");
        int bytesToCp = arr.length << 2;
        this.requestFreeSize(bytesToCp);
        if (GridUnsafe.IS_BIG_ENDIAN) {
            long off = GridUnsafe.BYTE_ARR_OFF + (long)this.off;
            for (int val : arr) {
                GridUnsafe.putIntLittleEndian(this.bytes, off, val);
                off += 4L;
            }
        } else {
            GridUnsafe.copyMemory(arr, GridUnsafe.INT_ARR_OFF, this.bytes, GridUnsafe.BYTE_ARR_OFF + (long)this.off, bytesToCp);
        }
        this.onWrite(bytesToCp);
    }

    @Override
    public void close() throws IOException {
        this.cleanup();
    }

    @Override
    public void writeBoolean(boolean v) throws IOException {
        this.requestFreeSize(1);
        GridUnsafe.putBoolean(this.bytes, GridUnsafe.BYTE_ARR_OFF + (long)this.off, v);
        this.onWrite(1);
    }

    @Override
    public void writeByte(int v) throws IOException {
        this.requestFreeSize(1);
        this.putByte((byte)v, GridUnsafe.BYTE_ARR_OFF + (long)this.off);
        this.onWrite(1);
    }

    private void putByte(byte val, long off) {
        GridUnsafe.putByte(this.bytes, off, val);
    }

    @Override
    public void writeShort(int v) throws IOException {
        this.requestFreeSize(2);
        short val = (short)v;
        long off = GridUnsafe.BYTE_ARR_OFF + (long)this.off;
        this.putShort(val, off);
        this.onWrite(2);
    }

    private void putShort(short val, long off) {
        if (GridUnsafe.IS_BIG_ENDIAN) {
            GridUnsafe.putShortLittleEndian(this.bytes, off, val);
        } else {
            GridUnsafe.putShort(this.bytes, off, val);
        }
    }

    @Override
    public void writeChar(int v) throws IOException {
        this.requestFreeSize(2);
        char val = (char)v;
        long off = GridUnsafe.BYTE_ARR_OFF + (long)this.off;
        if (GridUnsafe.IS_BIG_ENDIAN) {
            GridUnsafe.putCharLittleEndian(this.bytes, off, val);
        } else {
            GridUnsafe.putChar(this.bytes, off, val);
        }
        this.onWrite(2);
    }

    @Override
    public void writeInt(int v) throws IOException {
        this.requestFreeSize(4);
        long off = GridUnsafe.BYTE_ARR_OFF + (long)this.off;
        this.putInt(v, off);
        this.onWrite(4);
    }

    @Override
    public void writeLong(long v) throws IOException {
        this.requestFreeSize(8);
        long off = GridUnsafe.BYTE_ARR_OFF + (long)this.off;
        if (GridUnsafe.IS_BIG_ENDIAN) {
            GridUnsafe.putLongLittleEndian(this.bytes, off, v);
        } else {
            GridUnsafe.putLong(this.bytes, off, v);
        }
        this.onWrite(8);
    }

    @Override
    public void writeFloat(float v) throws IOException {
        int val = Float.floatToIntBits(v);
        this.writeInt(val);
    }

    @Override
    public void writeDouble(double v) throws IOException {
        long val = Double.doubleToLongBits(v);
        this.writeLong(val);
    }

    @Override
    public void writeBytes(String s2) throws IOException {
        int len = s2.length();
        if (this.utfLength(s2) == len) {
            this.writeAsciiStringBytes(s2);
        } else {
            for (int i = 0; i < len; ++i) {
                this.writeByte(s2.charAt(i));
            }
        }
    }

    private void writeAsciiStringBytes(String s2) throws IOException {
        this.writeByteArray(StringIntrospection.fastAsciiBytes(s2));
    }

    @Override
    public void writeChars(String s2) throws IOException {
        int len = s2.length();
        for (int i = 0; i < len; ++i) {
            this.writeChar(s2.charAt(i));
        }
    }

    @Override
    public void writeUTF(String s2) throws IOException {
        this.writeUtf(s2, this.utfLength(s2));
    }

    private void writeUtf(String s2, int utfLen) throws IOException {
        this.writeVarInt(utfLen);
        if (utfLen == s2.length()) {
            this.writeAsciiStringBytes(s2);
        } else {
            this.writeUtfBody(s2);
        }
    }

    private void checkArrayAllocationOverflow(int bytes, int arrLen, String type) throws IOException {
        long bytesToAlloc = (long)arrLen * (long)bytes;
        if (!this.canBeAllocated(bytesToAlloc)) {
            throw new IOException("Failed to allocate required memory for " + type + " array (byte array size overflow detected) [length=" + arrLen + "]");
        }
    }

    private int utfLength(String s2) {
        int size;
        int len = s2.length();
        int utfLen = 0;
        for (int off = 0; off < len; off += size) {
            size = Math.min(len - off, 256);
            s2.getChars(off, off + size, this.cbuf, 0);
            for (int pos = 0; pos < size; ++pos) {
                char c = this.cbuf[pos];
                if (c >= '\u0001' && c <= '\u007f') {
                    ++utfLen;
                    continue;
                }
                utfLen += c > '\u07ff' ? 3 : 2;
            }
        }
        return utfLen;
    }

    private void writeUtfBody(String s2) throws IOException {
        int csize;
        int len = s2.length();
        for (int off = 0; off < len; off += csize) {
            csize = Math.min(len - off, 256);
            s2.getChars(off, off + csize, this.cbuf, 0);
            for (int cpos = 0; cpos < csize; ++cpos) {
                char c = this.cbuf[cpos];
                if (c <= '\u007f' && c != '\u0000') {
                    this.write(c);
                    continue;
                }
                if (c > '\u07ff') {
                    this.write(0xE0 | c >> 12 & 0xF);
                    this.write(0x80 | c >> 6 & 0x3F);
                    this.write(0x80 | c & 0x3F);
                    continue;
                }
                this.write(0xC0 | c >> 6 & 0x1F);
                this.write(0x80 | c & 0x3F);
            }
        }
    }

    @Override
    public void flush() throws IOException {
        if (this.out != null) {
            this.out.flush();
        }
    }

    public String toString() {
        return IgniteToStringBuilder.toString(IgniteUnsafeDataOutput.class, this);
    }
}

