/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.client.table;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Flow;
import java.util.function.Function;
import org.apache.ignite.client.RetryLimitPolicy;
import org.apache.ignite.internal.client.PayloadOutputChannel;
import org.apache.ignite.internal.client.proto.TuplePart;
import org.apache.ignite.internal.client.sql.ClientSql;
import org.apache.ignite.internal.client.table.AbstractClientView;
import org.apache.ignite.internal.client.table.ClientDataStreamer;
import org.apache.ignite.internal.client.table.ClientRecordSerializer;
import org.apache.ignite.internal.client.table.ClientSchema;
import org.apache.ignite.internal.client.table.ClientTable;
import org.apache.ignite.internal.client.table.ClientTupleSerializer;
import org.apache.ignite.internal.client.table.PartitionAwarenessProvider;
import org.apache.ignite.internal.client.table.PojoStreamerPartitionAwarenessProvider;
import org.apache.ignite.internal.marshaller.Marshaller;
import org.apache.ignite.internal.marshaller.TupleReader;
import org.apache.ignite.internal.streamer.StreamerBatchSender;
import org.apache.ignite.internal.table.criteria.SqlRowProjection;
import org.apache.ignite.internal.util.CompletableFutures;
import org.apache.ignite.internal.util.ViewUtils;
import org.apache.ignite.shaded.org.jetbrains.annotations.Nullable;
import org.apache.ignite.sql.ResultSetMetadata;
import org.apache.ignite.sql.SqlRow;
import org.apache.ignite.table.DataStreamerItem;
import org.apache.ignite.table.DataStreamerOptions;
import org.apache.ignite.table.ReceiverDescriptor;
import org.apache.ignite.table.RecordView;
import org.apache.ignite.table.mapper.Mapper;
import org.apache.ignite.tx.Transaction;

public class ClientRecordView<R>
extends AbstractClientView<R>
implements RecordView<R> {
    private final ClientRecordSerializer<R> ser;

    ClientRecordView(ClientTable tbl, ClientSql sql, Mapper<R> recMapper) {
        super(tbl, sql);
        this.ser = new ClientRecordSerializer<R>(tbl.tableId(), recMapper);
    }

    @Override
    public R get(@Nullable Transaction tx, R keyRec) {
        return ViewUtils.sync(this.getAsync(tx, keyRec));
    }

    @Override
    public CompletableFuture<R> getAsync(@Nullable Transaction tx, R keyRec) {
        Objects.requireNonNull(keyRec);
        return this.tbl.doSchemaOutInOpAsync(12, (s2, w) -> this.ser.writeRec(tx, keyRec, (ClientSchema)s2, (PayloadOutputChannel)w, TuplePart.KEY), (s2, r) -> this.ser.readValRec(keyRec, (ClientSchema)s2, r.in()), null, ClientTupleSerializer.getPartitionAwarenessProvider(tx, this.ser.mapper(), keyRec), tx);
    }

    @Override
    public List<R> getAll(@Nullable Transaction tx, Collection<R> keyRecs) {
        return ViewUtils.sync(this.getAllAsync(tx, keyRecs));
    }

    @Override
    public CompletableFuture<List<R>> getAllAsync(@Nullable Transaction tx, Collection<R> keyRecs) {
        ViewUtils.checkCollectionForNulls(keyRecs, "keyRecs", "key");
        if (keyRecs.isEmpty()) {
            return CompletableFutures.emptyListCompletedFuture();
        }
        return this.tbl.doSchemaOutInOpAsync(15, (s2, w) -> this.ser.writeRecs(tx, keyRecs, (ClientSchema)s2, (PayloadOutputChannel)w, TuplePart.KEY), (s2, r) -> this.ser.readRecs((ClientSchema)s2, r.in(), true, TuplePart.KEY_AND_VAL), Collections.emptyList(), ClientTupleSerializer.getPartitionAwarenessProvider(tx, this.ser.mapper(), keyRecs.iterator().next()), tx);
    }

    @Override
    public boolean contains(@Nullable Transaction tx, R key) {
        return ViewUtils.sync(this.containsAsync(tx, key));
    }

    @Override
    public CompletableFuture<Boolean> containsAsync(@Nullable Transaction tx, R key) {
        Objects.requireNonNull(key);
        return this.tbl.doSchemaOutOpAsync(33, (s2, w) -> this.ser.writeRec(tx, key, (ClientSchema)s2, (PayloadOutputChannel)w, TuplePart.KEY), r -> r.in().unpackBoolean(), ClientTupleSerializer.getPartitionAwarenessProvider(tx, this.ser.mapper(), key), tx);
    }

    @Override
    public boolean containsAll(@Nullable Transaction tx, Collection<R> keys) {
        return ViewUtils.sync(this.containsAllAsync(tx, keys));
    }

    @Override
    public CompletableFuture<Boolean> containsAllAsync(@Nullable Transaction tx, Collection<R> keys) {
        ViewUtils.checkKeysForNulls(keys);
        if (keys.isEmpty()) {
            return CompletableFutures.trueCompletedFuture();
        }
        return this.tbl.doSchemaOutOpAsync(67, (s2, w) -> this.ser.writeRecs(tx, keys, (ClientSchema)s2, (PayloadOutputChannel)w, TuplePart.KEY), r -> r.in().unpackBoolean(), ClientTupleSerializer.getPartitionAwarenessProvider(tx, this.ser.mapper(), keys.iterator().next()), tx);
    }

    @Override
    public void upsert(@Nullable Transaction tx, R rec) {
        ViewUtils.sync(this.upsertAsync(tx, rec));
    }

    @Override
    public CompletableFuture<Void> upsertAsync(@Nullable Transaction tx, R rec) {
        Objects.requireNonNull(rec);
        return this.tbl.doSchemaOutOpAsync(10, (s2, w) -> this.ser.writeRec(tx, rec, (ClientSchema)s2, (PayloadOutputChannel)w, TuplePart.KEY_AND_VAL), r -> null, ClientTupleSerializer.getPartitionAwarenessProvider(tx, this.ser.mapper(), rec), tx);
    }

    @Override
    public void upsertAll(@Nullable Transaction tx, Collection<R> recs) {
        ViewUtils.sync(this.upsertAllAsync(tx, recs));
    }

    @Override
    public CompletableFuture<Void> upsertAllAsync(@Nullable Transaction tx, Collection<R> recs) {
        ViewUtils.checkCollectionForNulls(recs, "recs", "rec");
        if (recs.isEmpty()) {
            return CompletableFutures.nullCompletedFuture();
        }
        return this.tbl.doSchemaOutOpAsync(13, (s2, w) -> this.ser.writeRecs(tx, recs, (ClientSchema)s2, (PayloadOutputChannel)w, TuplePart.KEY_AND_VAL), r -> null, ClientTupleSerializer.getPartitionAwarenessProvider(tx, this.ser.mapper(), recs.iterator().next()), tx);
    }

    @Override
    public R getAndUpsert(@Nullable Transaction tx, R rec) {
        return ViewUtils.sync(this.getAndUpsertAsync(tx, rec));
    }

    @Override
    public CompletableFuture<R> getAndUpsertAsync(@Nullable Transaction tx, R rec) {
        Objects.requireNonNull(rec);
        return this.tbl.doSchemaOutInOpAsync(16, (s2, w) -> this.ser.writeRec(tx, rec, (ClientSchema)s2, (PayloadOutputChannel)w, TuplePart.KEY_AND_VAL), (s2, r) -> this.ser.readValRec(rec, (ClientSchema)s2, r.in()), null, ClientTupleSerializer.getPartitionAwarenessProvider(tx, this.ser.mapper(), rec), tx);
    }

    @Override
    public boolean insert(@Nullable Transaction tx, R rec) {
        return ViewUtils.sync(this.insertAsync(tx, rec));
    }

    @Override
    public CompletableFuture<Boolean> insertAsync(@Nullable Transaction tx, R rec) {
        Objects.requireNonNull(rec);
        return this.tbl.doSchemaOutOpAsync(18, (s2, w) -> this.ser.writeRec(tx, rec, (ClientSchema)s2, (PayloadOutputChannel)w, TuplePart.KEY_AND_VAL), r -> r.in().unpackBoolean(), ClientTupleSerializer.getPartitionAwarenessProvider(tx, this.ser.mapper(), rec), tx);
    }

    @Override
    public List<R> insertAll(@Nullable Transaction tx, Collection<R> recs) {
        return ViewUtils.sync(this.insertAllAsync(tx, recs));
    }

    @Override
    public CompletableFuture<List<R>> insertAllAsync(@Nullable Transaction tx, Collection<R> recs) {
        ViewUtils.checkCollectionForNulls(recs, "recs", "rec");
        if (recs.isEmpty()) {
            return CompletableFutures.emptyListCompletedFuture();
        }
        return this.tbl.doSchemaOutInOpAsync(20, (s2, w) -> this.ser.writeRecs(tx, recs, (ClientSchema)s2, (PayloadOutputChannel)w, TuplePart.KEY_AND_VAL), (s2, r) -> this.ser.readRecs((ClientSchema)s2, r.in(), false, TuplePart.KEY_AND_VAL), Collections.emptyList(), ClientTupleSerializer.getPartitionAwarenessProvider(tx, this.ser.mapper(), recs.iterator().next()), tx);
    }

    @Override
    public boolean replace(@Nullable Transaction tx, R rec) {
        return ViewUtils.sync(this.replaceAsync(tx, rec));
    }

    @Override
    public boolean replace(@Nullable Transaction tx, R oldRec, R newRec) {
        return ViewUtils.sync(this.replaceAsync(tx, oldRec, newRec));
    }

    @Override
    public CompletableFuture<Boolean> replaceAsync(@Nullable Transaction tx, R rec) {
        Objects.requireNonNull(rec);
        return this.tbl.doSchemaOutOpAsync(22, (s2, w) -> this.ser.writeRec(tx, rec, (ClientSchema)s2, (PayloadOutputChannel)w, TuplePart.KEY_AND_VAL), r -> r.in().unpackBoolean(), ClientTupleSerializer.getPartitionAwarenessProvider(tx, this.ser.mapper(), rec), tx);
    }

    @Override
    public CompletableFuture<Boolean> replaceAsync(@Nullable Transaction tx, R oldRec, R newRec) {
        Objects.requireNonNull(oldRec);
        Objects.requireNonNull(newRec);
        return this.tbl.doSchemaOutOpAsync(24, (s2, w) -> this.ser.writeRecs(tx, oldRec, newRec, (ClientSchema)s2, (PayloadOutputChannel)w, TuplePart.KEY_AND_VAL), r -> r.in().unpackBoolean(), ClientTupleSerializer.getPartitionAwarenessProvider(tx, this.ser.mapper(), oldRec), tx);
    }

    @Override
    public R getAndReplace(@Nullable Transaction tx, R rec) {
        return ViewUtils.sync(this.getAndReplaceAsync(tx, rec));
    }

    @Override
    public CompletableFuture<R> getAndReplaceAsync(@Nullable Transaction tx, R rec) {
        Objects.requireNonNull(rec);
        return this.tbl.doSchemaOutInOpAsync(26, (s2, w) -> this.ser.writeRec(tx, rec, (ClientSchema)s2, (PayloadOutputChannel)w, TuplePart.KEY_AND_VAL), (s2, r) -> this.ser.readValRec(rec, (ClientSchema)s2, r.in()), null, ClientTupleSerializer.getPartitionAwarenessProvider(tx, this.ser.mapper(), rec), tx);
    }

    @Override
    public boolean delete(@Nullable Transaction tx, R keyRec) {
        return ViewUtils.sync(this.deleteAsync(tx, keyRec));
    }

    @Override
    public CompletableFuture<Boolean> deleteAsync(@Nullable Transaction tx, R keyRec) {
        Objects.requireNonNull(keyRec);
        return this.tbl.doSchemaOutOpAsync(28, (s2, w) -> this.ser.writeRec(tx, keyRec, (ClientSchema)s2, (PayloadOutputChannel)w, TuplePart.KEY), r -> r.in().unpackBoolean(), ClientTupleSerializer.getPartitionAwarenessProvider(tx, this.ser.mapper(), keyRec), tx);
    }

    @Override
    public boolean deleteExact(@Nullable Transaction tx, R rec) {
        return ViewUtils.sync(this.deleteExactAsync(tx, rec));
    }

    @Override
    public CompletableFuture<Boolean> deleteExactAsync(@Nullable Transaction tx, R rec) {
        Objects.requireNonNull(rec);
        return this.tbl.doSchemaOutOpAsync(30, (s2, w) -> this.ser.writeRec(tx, rec, (ClientSchema)s2, (PayloadOutputChannel)w, TuplePart.KEY_AND_VAL), r -> r.in().unpackBoolean(), ClientTupleSerializer.getPartitionAwarenessProvider(tx, this.ser.mapper(), rec), tx);
    }

    @Override
    public R getAndDelete(@Nullable Transaction tx, R keyRec) {
        return ViewUtils.sync(this.getAndDeleteAsync(tx, keyRec));
    }

    @Override
    public CompletableFuture<R> getAndDeleteAsync(@Nullable Transaction tx, R keyRec) {
        Objects.requireNonNull(keyRec);
        return this.tbl.doSchemaOutInOpAsync(32, (s2, w) -> this.ser.writeRec(tx, keyRec, (ClientSchema)s2, (PayloadOutputChannel)w, TuplePart.KEY), (s2, r) -> this.ser.readValRec(keyRec, (ClientSchema)s2, r.in()), null, ClientTupleSerializer.getPartitionAwarenessProvider(tx, this.ser.mapper(), keyRec), tx);
    }

    @Override
    public List<R> deleteAll(@Nullable Transaction tx, Collection<R> keyRecs) {
        return ViewUtils.sync(this.deleteAllAsync(tx, keyRecs));
    }

    @Override
    public CompletableFuture<List<R>> deleteAllAsync(@Nullable Transaction tx, Collection<R> keyRecs) {
        Objects.requireNonNull(keyRecs);
        if (keyRecs.isEmpty()) {
            return CompletableFutures.emptyListCompletedFuture();
        }
        return this.tbl.doSchemaOutInOpAsync(29, (s2, w) -> this.ser.writeRecs(tx, keyRecs, (ClientSchema)s2, (PayloadOutputChannel)w, TuplePart.KEY), (s2, r) -> this.ser.readRecs((ClientSchema)s2, r.in(), false, TuplePart.KEY), Collections.emptyList(), ClientTupleSerializer.getPartitionAwarenessProvider(tx, this.ser.mapper(), keyRecs.iterator().next()), tx);
    }

    @Override
    public List<R> deleteAllExact(@Nullable Transaction tx, Collection<R> recs) {
        return ViewUtils.sync(this.deleteAllExactAsync(tx, recs));
    }

    @Override
    public CompletableFuture<List<R>> deleteAllExactAsync(@Nullable Transaction tx, Collection<R> recs) {
        Objects.requireNonNull(recs);
        if (recs.isEmpty()) {
            return CompletableFutures.emptyListCompletedFuture();
        }
        return this.tbl.doSchemaOutInOpAsync(31, (s2, w) -> this.ser.writeRecs(tx, recs, (ClientSchema)s2, (PayloadOutputChannel)w, TuplePart.KEY_AND_VAL), (s2, r) -> this.ser.readRecs((ClientSchema)s2, r.in(), false, TuplePart.KEY_AND_VAL), Collections.emptyList(), ClientTupleSerializer.getPartitionAwarenessProvider(tx, this.ser.mapper(), recs.iterator().next()), tx);
    }

    @Override
    public CompletableFuture<Void> streamData(Flow.Publisher<DataStreamerItem<R>> publisher, @Nullable DataStreamerOptions options) {
        Objects.requireNonNull(publisher);
        PojoStreamerPartitionAwarenessProvider<R> provider = new PojoStreamerPartitionAwarenessProvider<R>(this.tbl, this.ser.mapper());
        DataStreamerOptions opts = options == null ? DataStreamerOptions.DEFAULT : options;
        StreamerBatchSender batchSender = (partition, items, deleted) -> this.tbl.doSchemaOutOpAsync(62, (s2, w) -> this.ser.writeStreamerRecs((int)partition, items, deleted, (ClientSchema)s2, (PayloadOutputChannel)w), r -> null, PartitionAwarenessProvider.of(partition), new RetryLimitPolicy().retryLimit(opts.retryLimit()), null);
        return ClientDataStreamer.streamData(publisher, opts, batchSender, provider, this.tbl);
    }

    @Override
    public <E, V, R1, A> CompletableFuture<Void> streamData(Flow.Publisher<E> publisher, Function<E, R> keyFunc, Function<E, V> payloadFunc, ReceiverDescriptor<A> receiver, @Nullable Flow.Subscriber<R1> resultSubscriber, @Nullable DataStreamerOptions options, A receiverArg) {
        Objects.requireNonNull(publisher);
        Objects.requireNonNull(keyFunc);
        Objects.requireNonNull(payloadFunc);
        Objects.requireNonNull(receiver);
        return ClientDataStreamer.streamData(publisher, keyFunc, payloadFunc, x -> false, options == null ? DataStreamerOptions.DEFAULT : options, new PojoStreamerPartitionAwarenessProvider<R>(this.tbl, this.ser.mapper()), this.tbl, resultSubscriber, receiver.units(), receiver.receiverClassName(), receiverArg, receiver.argumentMarshaller());
    }

    @Override
    protected Function<SqlRow, R> queryMapper(ResultSetMetadata meta, ClientSchema schema) {
        String[] cols = ClientRecordView.columnNames(schema.columns());
        Marshaller marsh = schema.getMarshaller(this.ser.mapper(), TuplePart.KEY_AND_VAL, true);
        return row -> marsh.readObject(new TupleReader(new SqlRowProjection((SqlRow)row, meta, cols)), null);
    }
}

