/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.raft.jraft.util;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.WritableByteChannel;

public class ByteString
implements Externalizable {
    public static final ByteString EMPTY = new ByteString(ByteBuffer.wrap(new byte[0]));
    private ByteBuffer buf;

    public ByteString() {
    }

    public ByteString(ByteBuffer buf) {
        this.buf = buf;
    }

    public ByteString(byte[] bytes) {
        this.buf = ByteBuffer.wrap(bytes);
    }

    public int size() {
        return this.buf.capacity();
    }

    public ByteBuffer asReadOnlyByteBuffer() {
        return this.buf.asReadOnlyBuffer();
    }

    public byte byteAt(int pos) {
        return this.buf.get(pos);
    }

    public void writeTo(OutputStream outputStream) throws IOException {
        WritableByteChannel channel = Channels.newChannel(outputStream);
        channel.write(this.buf);
    }

    public byte[] toByteArray() {
        byte[] arr = new byte[this.buf.remaining()];
        this.buf.get(arr);
        this.buf.flip();
        return arr;
    }

    public ByteString copy() {
        return this == EMPTY ? EMPTY : new ByteString(this.toByteArray());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ByteString that = (ByteString)o;
        return this.buf.equals(that.buf);
    }

    public int hashCode() {
        return this.buf.hashCode();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        byte[] bytes = this.toByteArray();
        out.writeInt(bytes.length);
        out.write(bytes);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        int len = in.readInt();
        byte[] data = new byte[len];
        in.readFully(data);
        this.buf = ByteBuffer.wrap(data);
    }
}

