/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.table;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import org.apache.ignite.internal.schema.BinaryRow;
import org.apache.ignite.internal.schema.BinaryRowEx;
import org.apache.ignite.internal.schema.SchemaRegistry;
import org.apache.ignite.internal.schema.marshaller.TupleMarshallerException;
import org.apache.ignite.internal.schema.marshaller.TupleMarshallerImpl;
import org.apache.ignite.internal.schema.row.Row;
import org.apache.ignite.internal.table.AbstractTableView;
import org.apache.ignite.internal.table.InternalTable;
import org.apache.ignite.internal.table.TableRow;
import org.apache.ignite.internal.tx.InternalTransaction;
import org.apache.ignite.lang.IgniteException;
import org.apache.ignite.table.InvokeProcessor;
import org.apache.ignite.table.RecordView;
import org.apache.ignite.table.Tuple;
import org.apache.ignite.tx.Transaction;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RecordBinaryViewImpl
extends AbstractTableView
implements RecordView<Tuple> {
    private final TupleMarshallerImpl marsh;

    public RecordBinaryViewImpl(InternalTable tbl, SchemaRegistry schemaReg) {
        super(tbl, schemaReg);
        this.marsh = new TupleMarshallerImpl(schemaReg);
    }

    public Tuple get(@Nullable Transaction tx, @NotNull Tuple keyRec) {
        return this.sync(this.getAsync(tx, keyRec));
    }

    @NotNull
    public CompletableFuture<Tuple> getAsync(@Nullable Transaction tx, @NotNull Tuple keyRec) {
        Objects.requireNonNull(keyRec);
        Row keyRow = this.marshal(keyRec, true);
        return this.tbl.get((BinaryRowEx)keyRow, (InternalTransaction)tx).thenApply(this::wrap);
    }

    public Collection<Tuple> getAll(@Nullable Transaction tx, @NotNull Collection<Tuple> keyRecs) {
        return this.sync(this.getAllAsync(tx, keyRecs));
    }

    @NotNull
    public CompletableFuture<Collection<Tuple>> getAllAsync(@Nullable Transaction tx, @NotNull Collection<Tuple> keyRecs) {
        Objects.requireNonNull(keyRecs);
        return this.tbl.getAll(this.mapToBinary(keyRecs, true), (InternalTransaction)tx).thenApply(this::wrap);
    }

    public void upsert(@Nullable Transaction tx, @NotNull Tuple rec) {
        this.sync(this.upsertAsync(tx, rec));
    }

    @NotNull
    public CompletableFuture<Void> upsertAsync(@Nullable Transaction tx, @NotNull Tuple rec) {
        Objects.requireNonNull(rec);
        Row row = this.marshal(rec, false);
        return this.tbl.upsert((BinaryRowEx)row, (InternalTransaction)tx);
    }

    public void upsertAll(@Nullable Transaction tx, @NotNull Collection<Tuple> recs) {
        this.sync(this.upsertAllAsync(tx, recs));
    }

    @NotNull
    public CompletableFuture<Void> upsertAllAsync(@Nullable Transaction tx, @NotNull Collection<Tuple> recs) {
        Objects.requireNonNull(recs);
        return this.tbl.upsertAll(this.mapToBinary(recs, false), (InternalTransaction)tx);
    }

    public Tuple getAndUpsert(@Nullable Transaction tx, @NotNull Tuple rec) {
        return this.sync(this.getAndUpsertAsync(tx, rec));
    }

    @NotNull
    public CompletableFuture<Tuple> getAndUpsertAsync(@Nullable Transaction tx, @NotNull Tuple rec) {
        Objects.requireNonNull(rec);
        Row row = this.marshal(rec, false);
        return this.tbl.getAndUpsert((BinaryRowEx)row, (InternalTransaction)tx).thenApply(this::wrap);
    }

    public boolean insert(@Nullable Transaction tx, @NotNull Tuple rec) {
        return this.sync(this.insertAsync(tx, rec));
    }

    @NotNull
    public CompletableFuture<Boolean> insertAsync(@Nullable Transaction tx, @NotNull Tuple rec) {
        Objects.requireNonNull(rec);
        Row row = this.marshal(rec, false);
        return this.tbl.insert((BinaryRowEx)row, (InternalTransaction)tx);
    }

    public Collection<Tuple> insertAll(@Nullable Transaction tx, @NotNull Collection<Tuple> recs) {
        return this.sync(this.insertAllAsync(tx, recs));
    }

    @NotNull
    public CompletableFuture<Collection<Tuple>> insertAllAsync(@Nullable Transaction tx, @NotNull Collection<Tuple> recs) {
        Objects.requireNonNull(recs);
        return this.tbl.insertAll(this.mapToBinary(recs, false), (InternalTransaction)tx).thenApply(this::wrap);
    }

    public boolean replace(@Nullable Transaction tx, @NotNull Tuple rec) {
        return this.sync(this.replaceAsync(tx, rec));
    }

    public boolean replace(@Nullable Transaction tx, @NotNull Tuple oldRec, @NotNull Tuple newRec) {
        return this.sync(this.replaceAsync(tx, oldRec, newRec));
    }

    @NotNull
    public CompletableFuture<Boolean> replaceAsync(@Nullable Transaction tx, @NotNull Tuple rec) {
        Objects.requireNonNull(rec);
        Row row = this.marshal(rec, false);
        return this.tbl.replace((BinaryRowEx)row, (InternalTransaction)tx);
    }

    @NotNull
    public CompletableFuture<Boolean> replaceAsync(@Nullable Transaction tx, @NotNull Tuple oldRec, @NotNull Tuple newRec) {
        Objects.requireNonNull(oldRec);
        Objects.requireNonNull(newRec);
        Row oldRow = this.marshal(oldRec, false);
        Row newRow = this.marshal(newRec, false);
        return this.tbl.replace((BinaryRowEx)oldRow, (BinaryRowEx)newRow, (InternalTransaction)tx);
    }

    public Tuple getAndReplace(@Nullable Transaction tx, @NotNull Tuple rec) {
        return this.sync(this.getAndReplaceAsync(tx, rec));
    }

    @NotNull
    public CompletableFuture<Tuple> getAndReplaceAsync(@Nullable Transaction tx, @NotNull Tuple rec) {
        Objects.requireNonNull(rec);
        Row row = this.marshal(rec, false);
        return this.tbl.getAndReplace((BinaryRowEx)row, (InternalTransaction)tx).thenApply(this::wrap);
    }

    public boolean delete(@Nullable Transaction tx, @NotNull Tuple keyRec) {
        return this.sync(this.deleteAsync(tx, keyRec));
    }

    @NotNull
    public CompletableFuture<Boolean> deleteAsync(@Nullable Transaction tx, @NotNull Tuple keyRec) {
        Objects.requireNonNull(keyRec);
        Row keyRow = this.marshal(keyRec, true);
        return this.tbl.delete((BinaryRowEx)keyRow, (InternalTransaction)tx);
    }

    public boolean deleteExact(@Nullable Transaction tx, @NotNull Tuple rec) {
        return this.sync(this.deleteExactAsync(tx, rec));
    }

    @NotNull
    public CompletableFuture<Boolean> deleteExactAsync(@Nullable Transaction tx, @NotNull Tuple rec) {
        Objects.requireNonNull(rec);
        Row row = this.marshal(rec, false);
        return this.tbl.deleteExact((BinaryRowEx)row, (InternalTransaction)tx);
    }

    public Tuple getAndDelete(@Nullable Transaction tx, @NotNull Tuple keyRec) {
        return this.sync(this.getAndDeleteAsync(tx, keyRec));
    }

    @NotNull
    public CompletableFuture<Tuple> getAndDeleteAsync(@Nullable Transaction tx, @NotNull Tuple keyRec) {
        Objects.requireNonNull(keyRec);
        Row keyRow = this.marshal(keyRec, true);
        return this.tbl.getAndDelete((BinaryRowEx)keyRow, (InternalTransaction)tx).thenApply(this::wrap);
    }

    public Collection<Tuple> deleteAll(@Nullable Transaction tx, @NotNull Collection<Tuple> keyRecs) {
        return this.sync(this.deleteAllAsync(tx, keyRecs));
    }

    @NotNull
    public CompletableFuture<Collection<Tuple>> deleteAllAsync(@Nullable Transaction tx, @NotNull Collection<Tuple> keyRecs) {
        Objects.requireNonNull(keyRecs);
        return this.tbl.deleteAll(this.mapToBinary(keyRecs, true), (InternalTransaction)tx).thenApply(this::wrap);
    }

    public Collection<Tuple> deleteAllExact(@Nullable Transaction tx, @NotNull Collection<Tuple> recs) {
        return this.sync(this.deleteAllExactAsync(tx, recs));
    }

    @NotNull
    public CompletableFuture<Collection<Tuple>> deleteAllExactAsync(@Nullable Transaction tx, @NotNull Collection<Tuple> recs) {
        Objects.requireNonNull(recs);
        return this.tbl.deleteAllExact(this.mapToBinary(recs, false), (InternalTransaction)tx).thenApply(this::wrap);
    }

    public <T extends Serializable> T invoke(@Nullable Transaction tx, @NotNull Tuple keyRec, InvokeProcessor<Tuple, Tuple, T> proc) {
        throw new UnsupportedOperationException("Not implemented yet.");
    }

    @NotNull
    public <T extends Serializable> CompletableFuture<T> invokeAsync(@Nullable Transaction tx, @NotNull Tuple keyRec, InvokeProcessor<Tuple, Tuple, T> proc) {
        throw new UnsupportedOperationException("Not implemented yet.");
    }

    public <T extends Serializable> Map<Tuple, T> invokeAll(@Nullable Transaction tx, @NotNull Collection<Tuple> keyRecs, InvokeProcessor<Tuple, Tuple, T> proc) {
        throw new UnsupportedOperationException("Not implemented yet.");
    }

    @NotNull
    public <T extends Serializable> CompletableFuture<Map<Tuple, T>> invokeAllAsync(@Nullable Transaction tx, @NotNull Collection<Tuple> keyRecs, InvokeProcessor<Tuple, Tuple, T> proc) {
        throw new UnsupportedOperationException("Not implemented yet.");
    }

    private Row marshal(@NotNull Tuple tuple, boolean keyOnly) throws IgniteException {
        try {
            if (keyOnly) {
                return this.marsh.marshalKey(tuple);
            }
            return this.marsh.marshal(tuple);
        }
        catch (TupleMarshallerException ex) {
            throw this.convertException((Throwable)((Object)ex));
        }
    }

    @Nullable
    private Tuple wrap(@Nullable BinaryRow row) {
        return row == null ? null : TableRow.tuple(this.schemaReg.resolve(row));
    }

    private Collection<Tuple> wrap(Collection<BinaryRow> rows) {
        if (rows.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<Tuple> wrapped = new ArrayList<Tuple>(rows.size());
        for (Row row : this.schemaReg.resolve(rows)) {
            if (row == null) continue;
            wrapped.add(TableRow.tuple(row));
        }
        return wrapped;
    }

    private Collection<BinaryRowEx> mapToBinary(Collection<Tuple> rows, boolean key) {
        ArrayList<BinaryRowEx> mapped = new ArrayList<BinaryRowEx>(rows.size());
        for (Tuple row : rows) {
            mapped.add((BinaryRowEx)this.marshal(row, key));
        }
        return mapped;
    }
}

