/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.sql.engine.trait;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.apache.calcite.rel.RelDistribution;
import org.apache.calcite.util.ImmutableIntList;
import org.apache.ignite.internal.sql.engine.Stubs;
import org.apache.ignite.internal.sql.engine.exec.ExecutionContext;
import org.apache.ignite.internal.sql.engine.metadata.AffinityService;
import org.apache.ignite.internal.sql.engine.metadata.ColocationGroup;
import org.apache.ignite.internal.sql.engine.trait.AffinityAdapter;
import org.apache.ignite.internal.sql.engine.trait.AllNodes;
import org.apache.ignite.internal.sql.engine.trait.Destination;
import org.apache.ignite.internal.sql.engine.trait.Partitioned;
import org.apache.ignite.internal.sql.engine.trait.RandomNode;
import org.apache.ignite.internal.util.CollectionUtils;
import org.apache.ignite.internal.util.IgniteUtils;

public abstract class DistributionFunction {
    private String name;

    private DistributionFunction() {
    }

    public abstract RelDistribution.Type type();

    public final String name() {
        if (this.name != null) {
            return this.name;
        }
        this.name = this.name0().intern();
        return this.name;
    }

    public boolean affinity() {
        return false;
    }

    public static DistributionFunction affinity(int cacheId, Object identity) {
        return new AffinityDistribution(cacheId, identity);
    }

    abstract <RowT> Destination<RowT> destination(ExecutionContext<RowT> var1, AffinityService var2, ColocationGroup var3, ImmutableIntList var4);

    protected String name0() {
        return this.type().shortName;
    }

    public final int hashCode() {
        return Objects.hashCode(this.name());
    }

    public final boolean equals(Object obj) {
        if (obj instanceof DistributionFunction) {
            return this.name() == ((DistributionFunction)obj).name();
        }
        return false;
    }

    public final String toString() {
        return this.name();
    }

    public static DistributionFunction any() {
        return AnyDistribution.INSTANCE;
    }

    public static DistributionFunction broadcast() {
        return BroadcastDistribution.INSTANCE;
    }

    public static DistributionFunction singleton() {
        return SingletonDistribution.INSTANCE;
    }

    public static DistributionFunction random() {
        return RandomDistribution.INSTANCE;
    }

    public static DistributionFunction hash() {
        return HashDistribution.INSTANCE;
    }

    public static boolean satisfy(DistributionFunction f0, DistributionFunction f1) {
        if (f0 == f1 || f0.name() == f1.name()) {
            return true;
        }
        return f0 instanceof AffinityDistribution && f1 instanceof AffinityDistribution && Objects.equals(((AffinityDistribution)f0).identity(), ((AffinityDistribution)f1).identity());
    }

    private static final class AffinityDistribution
    extends DistributionFunction {
        private final int cacheId;
        private final Object identity;

        private AffinityDistribution(int cacheId, Object identity) {
            this.cacheId = cacheId;
            this.identity = identity;
        }

        @Override
        public boolean affinity() {
            return true;
        }

        @Override
        public RelDistribution.Type type() {
            return RelDistribution.Type.HASH_DISTRIBUTED;
        }

        @Override
        public <RowT> Destination<RowT> destination(ExecutionContext<RowT> ctx, AffinityService affSrvc, ColocationGroup m, ImmutableIntList k) {
            assert (m != null && !CollectionUtils.nullOrEmpty(m.assignments()) && k.size() == 1);
            List<List<String>> assignments = m.assignments();
            if (IgniteUtils.assertionsEnabled()) {
                for (List<String> assignment : assignments) {
                    assert (CollectionUtils.nullOrEmpty(assignment) || assignment.size() == 1);
                }
            }
            AffinityAdapter<RowT> affinity = new AffinityAdapter<RowT>(affSrvc.affinity(this.cacheId), k.toIntArray(), ctx.rowHandler());
            return new Partitioned<RowT>(assignments, affinity);
        }

        public Object identity() {
            return this.identity;
        }

        @Override
        protected String name0() {
            return "affinity[identity=" + this.identity + ", cacheId=" + this.cacheId + "]";
        }
    }

    private static final class HashDistribution
    extends DistributionFunction {
        public static final DistributionFunction INSTANCE = new HashDistribution();

        private HashDistribution() {
        }

        @Override
        public RelDistribution.Type type() {
            return RelDistribution.Type.HASH_DISTRIBUTED;
        }

        @Override
        public <RowT> Destination<RowT> destination(ExecutionContext<RowT> ctx, AffinityService affSrvc, ColocationGroup m, ImmutableIntList k) {
            assert (m != null && !CollectionUtils.nullOrEmpty(m.assignments()) && !k.isEmpty());
            List<List<String>> assignments = m.assignments();
            if (IgniteUtils.assertionsEnabled()) {
                for (List<String> assignment : assignments) {
                    assert (CollectionUtils.nullOrEmpty(assignment) || assignment.size() == 1);
                }
            }
            AffinityAdapter<RowT> affinity = new AffinityAdapter<RowT>(affSrvc.affinity(Stubs.intFoo(new Object[0])), k.toIntArray(), ctx.rowHandler());
            return new Partitioned<RowT>(assignments, affinity);
        }
    }

    private static final class SingletonDistribution
    extends DistributionFunction {
        public static final DistributionFunction INSTANCE = new SingletonDistribution();

        private SingletonDistribution() {
        }

        @Override
        public RelDistribution.Type type() {
            return RelDistribution.Type.SINGLETON;
        }

        @Override
        public <RowT> Destination<RowT> destination(ExecutionContext<RowT> ctx, AffinityService affinityService, ColocationGroup m, ImmutableIntList k) {
            if (m == null || m.nodeIds() == null || m.nodeIds().size() != 1) {
                throw new IllegalStateException();
            }
            return new AllNodes(Collections.singletonList(Objects.requireNonNull((String)CollectionUtils.first(m.nodeIds()))));
        }
    }

    private static final class RandomDistribution
    extends DistributionFunction {
        public static final DistributionFunction INSTANCE = new RandomDistribution();

        private RandomDistribution() {
        }

        @Override
        public RelDistribution.Type type() {
            return RelDistribution.Type.RANDOM_DISTRIBUTED;
        }

        @Override
        public <RowT> Destination<RowT> destination(ExecutionContext<RowT> ctx, AffinityService affinityService, ColocationGroup m, ImmutableIntList k) {
            assert (m != null && !CollectionUtils.nullOrEmpty(m.nodeIds()));
            return new RandomNode(m.nodeIds());
        }
    }

    private static final class BroadcastDistribution
    extends DistributionFunction {
        public static final DistributionFunction INSTANCE = new BroadcastDistribution();

        private BroadcastDistribution() {
        }

        @Override
        public RelDistribution.Type type() {
            return RelDistribution.Type.BROADCAST_DISTRIBUTED;
        }

        @Override
        public <RowT> Destination<RowT> destination(ExecutionContext<RowT> ctx, AffinityService affinityService, ColocationGroup m, ImmutableIntList k) {
            assert (m != null && !CollectionUtils.nullOrEmpty(m.nodeIds()));
            return new AllNodes(m.nodeIds());
        }
    }

    private static final class AnyDistribution
    extends DistributionFunction {
        public static final DistributionFunction INSTANCE = new AnyDistribution();

        private AnyDistribution() {
        }

        public static DistributionFunction affinity(int cacheId, Object identity) {
            return new AffinityDistribution(cacheId, identity);
        }

        @Override
        public RelDistribution.Type type() {
            return RelDistribution.Type.ANY;
        }

        @Override
        public <RowT> Destination<RowT> destination(ExecutionContext<RowT> ctx, AffinityService affinityService, ColocationGroup m, ImmutableIntList k) {
            throw new IllegalStateException();
        }
    }
}

