/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.sql.engine.trait;

import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import org.apache.calcite.plan.RelOptPlanner;
import org.apache.calcite.plan.RelTrait;
import org.apache.calcite.plan.RelTraitDef;
import org.apache.calcite.rel.core.CorrelationId;
import org.apache.ignite.internal.sql.engine.trait.CorrelationTraitDef;
import org.apache.ignite.internal.util.CollectionUtils;

public class CorrelationTrait
implements RelTrait {
    public static final CorrelationTrait UNCORRELATED = CorrelationTrait.canonize(new CorrelationTrait(Collections.emptyList()));
    private final Set<CorrelationId> correlations;

    public CorrelationTrait(Collection<CorrelationId> correlationIds) {
        this.correlations = Set.copyOf(correlationIds);
    }

    public boolean correlated() {
        return !CollectionUtils.nullOrEmpty(this.correlations);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CorrelationTrait)) {
            return false;
        }
        return this.correlations.equals(((CorrelationTrait)o).correlations);
    }

    public int hashCode() {
        return this.correlations.hashCode();
    }

    public String toString() {
        return this.correlated() ? "correlated" + this.correlations : "uncorrelated";
    }

    public RelTraitDef<CorrelationTrait> getTraitDef() {
        return CorrelationTraitDef.INSTANCE;
    }

    public boolean satisfies(RelTrait trait) {
        if (trait == this || this == UNCORRELATED) {
            return true;
        }
        if (!(trait instanceof CorrelationTrait)) {
            return false;
        }
        CorrelationTrait other = (CorrelationTrait)trait;
        return other.correlated() && other.correlationIds().containsAll(this.correlationIds());
    }

    public void register(RelOptPlanner planner) {
    }

    private static CorrelationTrait canonize(CorrelationTrait trait) {
        return (CorrelationTrait)CorrelationTraitDef.INSTANCE.canonize(trait);
    }

    public Set<CorrelationId> correlationIds() {
        return this.correlations;
    }

    public static CorrelationTrait correlations(Collection<CorrelationId> correlationIds) {
        return CorrelationTrait.canonize(new CorrelationTrait(correlationIds));
    }
}

