/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.sql.engine.prepare;

import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import org.apache.calcite.plan.Context;
import org.apache.calcite.plan.Contexts;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.prepare.CalciteCatalogReader;
import org.apache.calcite.schema.SchemaPlus;
import org.apache.calcite.sql.SqlOperatorTable;
import org.apache.calcite.sql.validate.SqlConformance;
import org.apache.calcite.tools.FrameworkConfig;
import org.apache.calcite.tools.RuleSet;
import org.apache.calcite.util.CancelFlag;
import org.apache.ignite.internal.sql.engine.prepare.IgnitePlanner;
import org.apache.ignite.internal.sql.engine.type.IgniteTypeFactory;
import org.apache.ignite.internal.sql.engine.util.BaseQueryContext;
import org.apache.ignite.internal.util.FastTimestamps;
import org.jetbrains.annotations.NotNull;

public final class PlanningContext
implements Context {
    private final Context parentCtx;
    private final String qry;
    private final CancelFlag cancelFlag = new CancelFlag(new AtomicBoolean());
    private Function<RuleSet, RuleSet> rulesFilter;
    private IgnitePlanner planner;
    private final long startTs;
    private final long plannerTimeout;

    private PlanningContext(Context parentCtx, String qry, long plannerTimeout) {
        this.qry = qry;
        this.parentCtx = parentCtx;
        this.startTs = FastTimestamps.coarseCurrentTimeMillis();
        this.plannerTimeout = plannerTimeout;
    }

    public FrameworkConfig config() {
        return this.unwrap(BaseQueryContext.class).config();
    }

    public String query() {
        return this.qry;
    }

    public Object[] parameters() {
        return this.unwrap(BaseQueryContext.class).parameters();
    }

    public SqlOperatorTable opTable() {
        return this.config().getOperatorTable();
    }

    public SqlConformance conformance() {
        return this.config().getParserConfig().conformance();
    }

    public long startTs() {
        return this.startTs;
    }

    public long plannerTimeout() {
        return this.plannerTimeout;
    }

    public IgnitePlanner planner() {
        if (this.planner == null) {
            this.planner = new IgnitePlanner(this);
        }
        return this.planner;
    }

    public String schemaName() {
        return this.schema().getName();
    }

    public SchemaPlus schema() {
        return this.config().getDefaultSchema();
    }

    public IgniteTypeFactory typeFactory() {
        return this.unwrap(BaseQueryContext.class).typeFactory();
    }

    public CalciteCatalogReader catalogReader() {
        return this.unwrap(BaseQueryContext.class).catalogReader();
    }

    public RelOptCluster cluster() {
        return this.planner().cluster();
    }

    public <C> C unwrap(Class<C> clazz) {
        if (clazz == this.getClass()) {
            return clazz.cast(this);
        }
        if (clazz == CancelFlag.class) {
            return clazz.cast(this.cancelFlag);
        }
        return (C)this.parentCtx.unwrap(clazz);
    }

    public static Builder builder() {
        return new Builder();
    }

    public RuleSet rules(RuleSet set) {
        return this.rulesFilter != null ? this.rulesFilter.apply(set) : set;
    }

    public void rulesFilter(Function<RuleSet, RuleSet> rulesFilter) {
        this.rulesFilter = rulesFilter;
    }

    public static class Builder {
        private Context parentCtx = Contexts.empty();
        private String qry;
        private long plannerTimeout;

        public Builder parentContext(@NotNull Context parentCtx) {
            this.parentCtx = parentCtx;
            return this;
        }

        public Builder query(@NotNull String qry) {
            this.qry = qry;
            return this;
        }

        public Builder plannerTimeout(long plannerTimeout) {
            this.plannerTimeout = plannerTimeout;
            return this;
        }

        public PlanningContext build() {
            return new PlanningContext(this.parentCtx, this.qry, this.plannerTimeout);
        }
    }
}

