/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.storage.pagememory.index.freelist.io;

import java.nio.ByteBuffer;
import org.apache.ignite.internal.pagememory.io.AbstractDataPageIo;
import org.apache.ignite.internal.pagememory.io.IoVersions;
import org.apache.ignite.internal.pagememory.io.PageIo;
import org.apache.ignite.internal.pagememory.util.PageUtils;
import org.apache.ignite.internal.storage.pagememory.index.freelist.IndexColumns;
import org.apache.ignite.lang.IgniteStringBuilder;

public class IndexColumnsDataIo
extends AbstractDataPageIo<IndexColumns> {
    public static final IoVersions<IndexColumnsDataIo> VERSIONS = new IoVersions((PageIo[])new IndexColumnsDataIo[]{new IndexColumnsDataIo(1)});

    protected IndexColumnsDataIo(int ver) {
        super(100, ver);
    }

    protected void writeRowData(long pageAddr, int dataOff, int payloadSize, IndexColumns row, boolean newRow) {
        this.assertPageType(pageAddr);
        PageUtils.putShort((long)pageAddr, (int)dataOff, (short)((short)payloadSize));
        PageUtils.putInt((long)pageAddr, (int)((dataOff += 2) + 0), (int)row.valueSize());
        PageUtils.putByteBuffer((long)pageAddr, (int)(dataOff + 4), (ByteBuffer)row.valueBuffer());
    }

    protected void writeFragmentData(IndexColumns row, ByteBuffer pageBuf, int rowOff, int payloadSize) {
        this.assertPageType(pageBuf);
        if (rowOff == 0) {
            assert (row.headerSize() <= payloadSize);
            pageBuf.putInt(row.valueSize());
            this.putValueBufferIntoPage(pageBuf, row.valueBuffer(), 0, payloadSize - 4);
        } else {
            assert (rowOff >= row.headerSize());
            this.putValueBufferIntoPage(pageBuf, row.valueBuffer(), rowOff - 4, payloadSize);
        }
    }

    protected void printPage(long addr, int pageSize, IgniteStringBuilder sb) {
        sb.app("IndexColumnsDataIo [\n");
        this.printPageLayout(addr, pageSize, sb);
        sb.app("\n]");
    }
}

