/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.platform.services;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Map;
import org.apache.ignite.Ignite;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.internal.binary.BinaryRawReaderEx;
import org.apache.ignite.internal.binary.BinaryRawWriterEx;
import org.apache.ignite.internal.processors.platform.PlatformContext;
import org.apache.ignite.internal.processors.platform.memory.PlatformInputStream;
import org.apache.ignite.internal.processors.platform.memory.PlatformMemory;
import org.apache.ignite.internal.processors.platform.memory.PlatformOutputStream;
import org.apache.ignite.internal.processors.platform.services.PlatformService;
import org.apache.ignite.internal.processors.platform.utils.PlatformUtils;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.resources.IgniteInstanceResource;
import org.apache.ignite.resources.ServiceContextResource;
import org.apache.ignite.services.ServiceContext;
import org.jetbrains.annotations.Nullable;

public abstract class PlatformAbstractService
implements PlatformService,
Externalizable {
    private static final long serialVersionUID = 0L;
    protected Object svc;
    protected Object interceptors;
    protected boolean srvKeepBinary;
    protected transient long ptr;
    protected transient PlatformContext platformCtx;
    @ServiceContextResource
    private transient ServiceContext ctx;

    public PlatformAbstractService() {
    }

    public PlatformAbstractService(Object svc, PlatformContext ctx, boolean srvKeepBinary, @Nullable Object interceptors) {
        assert (svc != null);
        assert (ctx != null);
        this.svc = svc;
        this.platformCtx = ctx;
        this.srvKeepBinary = srvKeepBinary;
        this.interceptors = interceptors;
    }

    @Override
    public void init() throws Exception {
        assert (this.ptr == 0L);
        assert (this.platformCtx != null);
        try (PlatformMemory mem = this.platformCtx.memory().allocate();){
            PlatformOutputStream out = mem.output();
            BinaryRawWriterEx writer = this.platformCtx.writer(out);
            writer.writeBoolean(this.srvKeepBinary);
            writer.writeObject(this.svc);
            writer.writeObject(this.interceptors);
            this.writeServiceContext(this.ctx, writer);
            out.synchronize();
            this.ptr = this.platformCtx.gateway().serviceInit(mem.pointer());
            PlatformInputStream in = mem.input();
            in.synchronize();
            BinaryRawReaderEx reader = this.platformCtx.reader(in);
            PlatformUtils.readInvocationResult(this.platformCtx, reader);
        }
        catch (IgniteCheckedException e) {
            throw U.convertException(e);
        }
    }

    @Override
    public void execute() throws Exception {
        assert (this.ptr != 0L);
        assert (this.platformCtx != null);
        try (PlatformMemory mem = this.platformCtx.memory().allocate();){
            PlatformOutputStream out = mem.output();
            BinaryRawWriterEx writer = this.platformCtx.writer(out);
            writer.writeLong(this.ptr);
            out.synchronize();
            this.platformCtx.gateway().serviceExecute(mem.pointer());
        }
        catch (IgniteCheckedException e) {
            throw U.convertException(e);
        }
    }

    @Override
    public void cancel() {
        assert (this.ptr != 0L);
        assert (this.platformCtx != null);
        try (PlatformMemory mem = this.platformCtx.memory().allocate();){
            PlatformOutputStream out = mem.output();
            BinaryRawWriterEx writer = this.platformCtx.writer(out);
            writer.writeLong(this.ptr);
            out.synchronize();
            this.platformCtx.gateway().serviceCancel(mem.pointer());
        }
        catch (IgniteCheckedException e) {
            throw U.convertException(e);
        }
    }

    private void writeServiceContext(ServiceContext ctx, BinaryRawWriterEx writer) {
        writer.writeString(ctx.name());
        writer.writeUuid(ctx.executionId());
        writer.writeBoolean(ctx.isCancelled());
        writer.writeString(ctx.cacheName());
        writer.writeObject(ctx.affinityKey());
    }

    @Override
    public long pointer() {
        assert (this.ptr != 0L);
        return this.ptr;
    }

    @Override
    public Object invokeMethod(String mthdName, boolean srvKeepBinary, boolean deserializeResult, @Nullable Object[] args, @Nullable Map<String, Object> callAttrs) throws IgniteCheckedException {
        assert (this.ptr != 0L);
        assert (this.platformCtx != null);
        try (PlatformMemory mem = this.platformCtx.memory().allocate();){
            PlatformOutputStream out = mem.output();
            BinaryRawWriterEx writer = this.platformCtx.writer(out);
            writer.writeLong(this.ptr);
            writer.writeBoolean(srvKeepBinary);
            writer.writeString(mthdName);
            if (args == null) {
                writer.writeBoolean(false);
            } else {
                writer.writeBoolean(true);
                writer.writeInt(args.length);
                for (Object arg : args) {
                    writer.writeObjectDetached(arg);
                }
            }
            writer.writeMap(callAttrs);
            out.synchronize();
            this.platformCtx.gateway().serviceInvokeMethod(mem.pointer());
            PlatformInputStream in = mem.input();
            in.synchronize();
            BinaryRawReaderEx reader = this.platformCtx.reader(in);
            Object object = PlatformUtils.readInvocationResult(this.platformCtx, reader, deserializeResult);
            return object;
        }
    }

    @IgniteInstanceResource
    public void setIgniteInstance(Ignite ignite) {
        if (ignite != null && this.platformCtx == null) {
            this.platformCtx = PlatformUtils.platformContext(ignite);
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.svc = in.readObject();
        this.srvKeepBinary = in.readBoolean();
        this.interceptors = in.readObject();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.svc);
        out.writeBoolean(this.srvKeepBinary);
        out.writeObject(this.interceptors);
    }
}

