/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.yardstick.cache.jdbc;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.Map;
import java.util.concurrent.ThreadLocalRandom;
import org.apache.ignite.yardstick.cache.jdbc.JdbcAbstractBenchmark;
import org.yardstickframework.BenchmarkConfiguration;
import org.yardstickframework.BenchmarkUtils;

public class JdbcSqlQueryBenchmark
extends JdbcAbstractBenchmark {
    private static final String SELECT_QUERY = "select p.id, p.org_id, p.first_name, p.last_name, p.salary from PERSON p where salary >= ? and salary <= ?";

    @Override
    public void setUp(BenchmarkConfiguration cfg) throws Exception {
        super.setUp(cfg);
        BenchmarkUtils.println((BenchmarkConfiguration)cfg, (String)"Populating query data...");
        long start = System.nanoTime();
        try (PreparedStatement stmt = ((Connection)this.conn.get()).prepareStatement("insert into PERSON(id, first_name, last_name, salary) values(?, ?, ?, ?)");){
            for (int i = 0; i < this.args.range() && !Thread.currentThread().isInterrupted(); ++i) {
                stmt.setInt(1, i);
                stmt.setString(2, "firstName" + i);
                stmt.setString(3, "lastName" + i);
                stmt.setDouble(4, i * 1000);
                stmt.addBatch();
                if (i % 100000 != 0) continue;
                BenchmarkUtils.println((BenchmarkConfiguration)cfg, (String)("Populated persons: " + i));
            }
            stmt.executeBatch();
        }
        BenchmarkUtils.println((BenchmarkConfiguration)cfg, (String)("Finished populating join query data in " + (System.nanoTime() - start) / 1000000L + " ms."));
    }

    public boolean test(Map<Object, Object> ctx) throws Exception {
        double salary = ThreadLocalRandom.current().nextDouble() * (double)this.args.range() * 1000.0;
        double maxSalary = salary + 1000.0;
        try (PreparedStatement stmt = ((Connection)this.conn.get()).prepareStatement(SELECT_QUERY);){
            stmt.setDouble(1, salary);
            stmt.setDouble(2, maxSalary);
            try (ResultSet rs = stmt.executeQuery();){
                while (rs.next()) {
                    double actualSalary = rs.getDouble(5);
                    if (!(actualSalary < salary) && !(actualSalary > maxSalary)) continue;
                    throw new Exception("Invalid person retrieved [min=" + salary + ", max=" + maxSalary + ", salary=" + actualSalary + ", id=" + rs.getInt(1) + "]");
                }
            }
        }
        return true;
    }

    @Override
    public void tearDown() throws Exception {
        if (!this.args.createTempDatabase()) {
            this.clearTable("PERSON");
        }
        super.tearDown();
    }
}

