/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.common.typeutils.base;

import java.io.IOException;
import java.sql.Timestamp;
import java.util.Date;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.typeutils.base.BasicTypeComparator;
import org.apache.flink.api.common.typeutils.base.DateComparator;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.MemorySegment;

@Internal
public final class SqlTimestampComparator
extends BasicTypeComparator<Date> {
    private static final long serialVersionUID = 1L;

    public SqlTimestampComparator(boolean ascending) {
        super(ascending);
    }

    @Override
    public int compareSerialized(DataInputView firstSource, DataInputView secondSource) throws IOException {
        int comp = DateComparator.compareSerializedDate(firstSource, secondSource, this.ascendingComparison);
        if (comp == 0) {
            int i2;
            int i1 = firstSource.readInt();
            int comp2 = i1 < (i2 = secondSource.readInt()) ? -1 : (i1 == i2 ? 0 : 1);
            return this.ascendingComparison ? comp2 : -comp2;
        }
        return comp;
    }

    @Override
    public boolean supportsNormalizedKey() {
        return true;
    }

    @Override
    public int getNormalizeKeyLen() {
        return 12;
    }

    @Override
    public boolean isNormalizedKeyPrefixOnly(int keyBytes) {
        return keyBytes < 12;
    }

    @Override
    public void putNormalizedKey(Date record, MemorySegment target, int offset, int numBytes) {
        block4: {
            DateComparator.putNormalizedKeyDate(record, target, offset, numBytes > 8 ? 8 : numBytes);
            offset += 8;
            if ((numBytes -= 8) <= 0) break block4;
            if (numBytes < 4) {
                int nanos = ((Timestamp)record).getNanos();
                int i = 0;
                while (numBytes > 0) {
                    target.put(offset + i, (byte)(nanos >>> (3 - i << 3)));
                    --numBytes;
                    ++i;
                }
            } else {
                int nanos = ((Timestamp)record).getNanos();
                target.putIntBigEndian(offset, nanos);
                for (int i = 4; i < numBytes; ++i) {
                    target.put(offset + i, (byte)0);
                }
            }
        }
    }

    public SqlTimestampComparator duplicate() {
        return new SqlTimestampComparator(this.ascendingComparison);
    }
}

