/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.transforms.join;

import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import org.apache.beam.sdk.values.TupleTag;
import org.apache.beam.sdk.values.TupleTagList;
import org.checkerframework.checker.nullness.qual.Nullable;

public class CoGbkResultSchema
implements Serializable {
    private final TupleTagList tupleTagList;
    private final HashMap<TupleTag<?>, Integer> tagMap = new HashMap();

    public static CoGbkResultSchema of(List<TupleTag<?>> tags) {
        TupleTagList tupleTags = TupleTagList.empty();
        for (TupleTag<?> tag : tags) {
            tupleTags = tupleTags.and(tag);
        }
        return new CoGbkResultSchema(tupleTags);
    }

    public CoGbkResultSchema(TupleTagList tupleTagList) {
        this.tupleTagList = tupleTagList;
        int index = -1;
        for (TupleTag<?> tag : tupleTagList.getAll()) {
            this.tagMap.put(tag, ++index);
        }
    }

    public int getIndex(TupleTag<?> tag) {
        Integer index = this.tagMap.get(tag);
        return index == null ? -1 : index;
    }

    public TupleTag<?> getTag(int index) {
        return this.tupleTagList.get(index);
    }

    public int size() {
        return this.tupleTagList.getAll().size();
    }

    public TupleTagList getTupleTagList() {
        return this.tupleTagList;
    }

    public boolean equals(@Nullable Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof CoGbkResultSchema)) {
            return false;
        }
        CoGbkResultSchema other = (CoGbkResultSchema)obj;
        return this.tupleTagList.getAll().equals(other.tupleTagList.getAll());
    }

    public int hashCode() {
        return this.tupleTagList.getAll().hashCode();
    }

    public String toString() {
        return "CoGbkResultSchema: " + this.tupleTagList.getAll();
    }
}

