/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.service.reads.repair;

import java.util.Map;
import java.util.function.Consumer;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.Mutation;
import org.apache.cassandra.db.ReadCommand;
import org.apache.cassandra.db.partitions.PartitionIterator;
import org.apache.cassandra.db.partitions.UnfilteredPartitionIterators;
import org.apache.cassandra.exceptions.ReadTimeoutException;
import org.apache.cassandra.locator.Endpoints;
import org.apache.cassandra.locator.Replica;
import org.apache.cassandra.locator.ReplicaPlan;
import org.apache.cassandra.service.reads.DigestResolver;

public interface ReadRepair<E extends Endpoints<E>, P extends ReplicaPlan.ForRead<E>> {
    public static <E extends Endpoints<E>, P extends ReplicaPlan.ForRead<E>> ReadRepair<E, P> create(ReadCommand command, ReplicaPlan.Shared<E, P> replicaPlan, long queryStartNanoTime) {
        return command.metadata().params.readRepair.create(command, replicaPlan, queryStartNanoTime);
    }

    public UnfilteredPartitionIterators.MergeListener getMergeListener(P var1);

    public void startRepair(DigestResolver<E, P> var1, Consumer<PartitionIterator> var2);

    public void awaitReads() throws ReadTimeoutException;

    public void maybeSendAdditionalReads();

    public void maybeSendAdditionalWrites();

    public void awaitWrites();

    public void repairPartition(DecoratedKey var1, Map<Replica, Mutation> var2, ReplicaPlan.ForTokenWrite var3);

    public static interface Factory {
        public <E extends Endpoints<E>, P extends ReplicaPlan.ForRead<E>> ReadRepair<E, P> create(ReadCommand var1, ReplicaPlan.Shared<E, P> var2, long var3);
    }
}

