/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cql3.selection;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.cassandra.cql3.AssignmentTestable;
import org.apache.cassandra.cql3.CQL3Type;
import org.apache.cassandra.cql3.ColumnIdentifier;
import org.apache.cassandra.cql3.ColumnSpecification;
import org.apache.cassandra.cql3.Constants;
import org.apache.cassandra.cql3.FieldIdentifier;
import org.apache.cassandra.cql3.Lists;
import org.apache.cassandra.cql3.Maps;
import org.apache.cassandra.cql3.Sets;
import org.apache.cassandra.cql3.Term;
import org.apache.cassandra.cql3.Tuples;
import org.apache.cassandra.cql3.UserTypes;
import org.apache.cassandra.cql3.VariableSpecifications;
import org.apache.cassandra.cql3.functions.AggregateFcts;
import org.apache.cassandra.cql3.functions.CastFcts;
import org.apache.cassandra.cql3.functions.Function;
import org.apache.cassandra.cql3.functions.FunctionName;
import org.apache.cassandra.cql3.functions.FunctionResolver;
import org.apache.cassandra.cql3.functions.OperationFcts;
import org.apache.cassandra.cql3.functions.ToJsonFct;
import org.apache.cassandra.cql3.selection.AbstractFunctionSelector;
import org.apache.cassandra.cql3.selection.ElementsSelector;
import org.apache.cassandra.cql3.selection.FieldSelector;
import org.apache.cassandra.cql3.selection.ForwardingFactory;
import org.apache.cassandra.cql3.selection.ListSelector;
import org.apache.cassandra.cql3.selection.MapSelector;
import org.apache.cassandra.cql3.selection.Selector;
import org.apache.cassandra.cql3.selection.SelectorFactories;
import org.apache.cassandra.cql3.selection.SetSelector;
import org.apache.cassandra.cql3.selection.TermSelector;
import org.apache.cassandra.cql3.selection.TupleSelector;
import org.apache.cassandra.cql3.selection.UserTypeSelector;
import org.apache.cassandra.cql3.selection.WritetimeOrTTLSelector;
import org.apache.cassandra.cql3.statements.RequestValidations;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.db.marshal.CollectionType;
import org.apache.cassandra.db.marshal.DurationType;
import org.apache.cassandra.db.marshal.Int32Type;
import org.apache.cassandra.db.marshal.ListType;
import org.apache.cassandra.db.marshal.LongType;
import org.apache.cassandra.db.marshal.MapType;
import org.apache.cassandra.db.marshal.SetType;
import org.apache.cassandra.db.marshal.TupleType;
import org.apache.cassandra.db.marshal.UTF8Type;
import org.apache.cassandra.db.marshal.UserType;
import org.apache.cassandra.exceptions.InvalidRequestException;
import org.apache.cassandra.schema.ColumnMetadata;
import org.apache.cassandra.schema.TableMetadata;
import org.apache.cassandra.utils.Pair;
import org.apache.commons.lang3.text.StrBuilder;

public interface Selectable
extends AssignmentTestable {
    public Selector.Factory newSelectorFactory(TableMetadata var1, AbstractType<?> var2, List<ColumnMetadata> var3, VariableSpecifications var4);

    public AbstractType<?> getExactTypeIfKnown(String var1);

    public boolean selectColumns(Predicate<ColumnMetadata> var1);

    public static boolean selectColumns(List<Selectable> selectables, Predicate<ColumnMetadata> predicate) {
        for (Selectable selectable : selectables) {
            if (!selectable.selectColumns(predicate)) continue;
            return true;
        }
        return false;
    }

    default public boolean processesSelection() {
        return true;
    }

    @Override
    default public AssignmentTestable.TestResult testAssignment(String keyspace, ColumnSpecification receiver) {
        AbstractType<?> type = this.getExactTypeIfKnown(keyspace);
        return type == null ? AssignmentTestable.TestResult.NOT_ASSIGNABLE : type.testAssignment(keyspace, receiver);
    }

    default public int addAndGetIndex(ColumnMetadata def, List<ColumnMetadata> l) {
        int idx = l.indexOf(def);
        if (idx < 0) {
            idx = l.size();
            l.add(def);
        }
        return idx;
    }

    default public ColumnSpecification specForElementOrSlice(Selectable selected, ColumnSpecification receiver, String selectionType) {
        switch (((CollectionType)receiver.type).kind) {
            case LIST: {
                throw new InvalidRequestException(String.format("%s selection is only allowed on sets and maps, but %s is a list", selectionType, selected));
            }
            case SET: {
                return Sets.valueSpecOf(receiver);
            }
            case MAP: {
                return Maps.keySpecOf(receiver);
            }
        }
        throw new AssertionError();
    }

    public static class WithSliceSelection
    implements Selectable {
        public final Selectable selected;
        public final Term.Raw from;
        public final Term.Raw to;

        private WithSliceSelection(Selectable selected, Term.Raw from, Term.Raw to) {
            this.selected = selected;
            this.from = from;
            this.to = to;
        }

        public String toString() {
            return String.format("%s[%s..%s]", this.selected, this.from == null ? "" : this.from, this.to == null ? "" : this.to);
        }

        @Override
        public Selector.Factory newSelectorFactory(TableMetadata cfm, AbstractType<?> expectedType, List<ColumnMetadata> defs, VariableSpecifications boundNames) {
            Selector.Factory factory = this.selected.newSelectorFactory(cfm, expectedType, defs, boundNames);
            ColumnSpecification receiver = factory.getColumnSpecification(cfm);
            if (!(receiver.type instanceof CollectionType)) {
                throw new InvalidRequestException(String.format("Invalid slice selection: %s of type %s is not a collection", this.selected, receiver.type.asCQL3Type()));
            }
            ColumnSpecification boundSpec = this.specForElementOrSlice(this.selected, receiver, "Slice");
            Constants.Value f = this.from == null ? Constants.UNSET_VALUE : this.from.prepare(cfm.keyspace, boundSpec);
            Constants.Value t = this.to == null ? Constants.UNSET_VALUE : this.to.prepare(cfm.keyspace, boundSpec);
            f.collectMarkerSpecification(boundNames);
            t.collectMarkerSpecification(boundNames);
            return ElementsSelector.newSliceFactory(this.toString(), factory, (CollectionType)receiver.type, f, t);
        }

        @Override
        public AbstractType<?> getExactTypeIfKnown(String keyspace) {
            AbstractType<?> selectedType = this.selected.getExactTypeIfKnown(keyspace);
            if (selectedType == null || !(selectedType instanceof CollectionType)) {
                return null;
            }
            return selectedType;
        }

        @Override
        public boolean selectColumns(Predicate<ColumnMetadata> predicate) {
            return this.selected.selectColumns(predicate);
        }

        public static class Raw
        implements org.apache.cassandra.cql3.selection.Selectable$Raw {
            private final org.apache.cassandra.cql3.selection.Selectable$Raw selected;
            private final Term.Raw from;
            private final Term.Raw to;

            public Raw(org.apache.cassandra.cql3.selection.Selectable$Raw selected, Term.Raw from, Term.Raw to) {
                this.selected = selected;
                this.from = from;
                this.to = to;
            }

            @Override
            public WithSliceSelection prepare(TableMetadata cfm) {
                return new WithSliceSelection(this.selected.prepare(cfm), this.from, this.to);
            }

            public String toString() {
                return String.format("%s[%s..%s]", this.selected, this.from == null ? "" : this.from, this.to == null ? "" : this.to);
            }
        }
    }

    public static class WithElementSelection
    implements Selectable {
        public final Selectable selected;
        public final Term.Raw element;

        private WithElementSelection(Selectable selected, Term.Raw element) {
            assert (element != null);
            this.selected = selected;
            this.element = element;
        }

        public String toString() {
            return String.format("%s[%s]", this.selected, this.element);
        }

        @Override
        public Selector.Factory newSelectorFactory(TableMetadata cfm, AbstractType<?> expectedType, List<ColumnMetadata> defs, VariableSpecifications boundNames) {
            Selector.Factory factory = this.selected.newSelectorFactory(cfm, null, defs, boundNames);
            ColumnSpecification receiver = factory.getColumnSpecification(cfm);
            if (!(receiver.type instanceof CollectionType)) {
                throw new InvalidRequestException(String.format("Invalid element selection: %s is of type %s is not a collection", this.selected, receiver.type.asCQL3Type()));
            }
            ColumnSpecification boundSpec = this.specForElementOrSlice(this.selected, receiver, "Element");
            Term elt = this.element.prepare(cfm.keyspace, boundSpec);
            elt.collectMarkerSpecification(boundNames);
            return ElementsSelector.newElementFactory(this.toString(), factory, (CollectionType)receiver.type, elt);
        }

        @Override
        public AbstractType<?> getExactTypeIfKnown(String keyspace) {
            AbstractType<?> selectedType = this.selected.getExactTypeIfKnown(keyspace);
            if (selectedType == null || !(selectedType instanceof CollectionType)) {
                return null;
            }
            return ElementsSelector.valueType((CollectionType)selectedType);
        }

        @Override
        public boolean selectColumns(Predicate<ColumnMetadata> predicate) {
            return this.selected.selectColumns(predicate);
        }

        public static class Raw
        implements org.apache.cassandra.cql3.selection.Selectable$Raw {
            private final org.apache.cassandra.cql3.selection.Selectable$Raw selected;
            private final Term.Raw element;

            public Raw(org.apache.cassandra.cql3.selection.Selectable$Raw selected, Term.Raw element) {
                this.selected = selected;
                this.element = element;
            }

            @Override
            public WithElementSelection prepare(TableMetadata cfm) {
                return new WithElementSelection(this.selected.prepare(cfm), this.element);
            }

            public String toString() {
                return String.format("%s[%s]", this.selected, this.element);
            }
        }
    }

    public static final class RawIdentifier
    implements Raw {
        private final String text;
        private final boolean quoted;

        public static RawIdentifier forUnquoted(String text) {
            return new RawIdentifier(text, false);
        }

        public static RawIdentifier forQuoted(String text) {
            return new RawIdentifier(text, true);
        }

        private RawIdentifier(String text, boolean quoted) {
            this.text = text;
            this.quoted = quoted;
        }

        @Override
        public ColumnMetadata prepare(TableMetadata cfm) {
            return cfm.getExistingColumn(ColumnIdentifier.getInterned(this.text, this.quoted));
        }

        public FieldIdentifier toFieldIdentifier() {
            return this.quoted ? FieldIdentifier.forQuoted(this.text) : FieldIdentifier.forUnquoted(this.text);
        }

        public String toString() {
            return this.text;
        }
    }

    public static class WithTypeHint
    implements Selectable {
        private final String typeName;
        private final AbstractType<?> type;
        private final Selectable selectable;

        public WithTypeHint(String typeName, AbstractType<?> type, Selectable selectable) {
            this.typeName = typeName;
            this.type = type;
            this.selectable = selectable;
        }

        @Override
        public AssignmentTestable.TestResult testAssignment(String keyspace, ColumnSpecification receiver) {
            if (receiver.type.equals(this.type)) {
                return AssignmentTestable.TestResult.EXACT_MATCH;
            }
            if (receiver.type.isValueCompatibleWith(this.type)) {
                return AssignmentTestable.TestResult.WEAKLY_ASSIGNABLE;
            }
            return AssignmentTestable.TestResult.NOT_ASSIGNABLE;
        }

        @Override
        public Selector.Factory newSelectorFactory(TableMetadata cfm, AbstractType<?> expectedType, List<ColumnMetadata> defs, VariableSpecifications boundNames) {
            ColumnSpecification receiver = new ColumnSpecification(cfm.keyspace, cfm.name, new ColumnIdentifier(this.toString(), true), this.type);
            if (!this.selectable.testAssignment(cfm.keyspace, receiver).isAssignable()) {
                throw new InvalidRequestException(String.format("Cannot assign value %s to %s of type %s", this, receiver.name, receiver.type.asCQL3Type()));
            }
            final Selector.Factory factory = this.selectable.newSelectorFactory(cfm, this.type, defs, boundNames);
            return new ForwardingFactory(){

                @Override
                protected Selector.Factory delegate() {
                    return factory;
                }

                @Override
                protected AbstractType<?> getReturnType() {
                    return type;
                }

                @Override
                protected String getColumnName() {
                    return String.format("(%s)%s", typeName, factory.getColumnName());
                }
            };
        }

        @Override
        public AbstractType<?> getExactTypeIfKnown(String keyspace) {
            return this.type;
        }

        @Override
        public boolean selectColumns(Predicate<ColumnMetadata> predicate) {
            return this.selectable.selectColumns(predicate);
        }

        public String toString() {
            return String.format("(%s)%s", this.typeName, this.selectable);
        }

        public static class Raw
        implements org.apache.cassandra.cql3.selection.Selectable$Raw {
            private final CQL3Type.Raw typeRaw;
            private final org.apache.cassandra.cql3.selection.Selectable$Raw raw;

            public Raw(CQL3Type.Raw typeRaw, org.apache.cassandra.cql3.selection.Selectable$Raw raw) {
                this.typeRaw = typeRaw;
                this.raw = raw;
            }

            @Override
            public Selectable prepare(TableMetadata cfm) {
                Selectable selectable = this.raw.prepare(cfm);
                AbstractType<?> type = this.typeRaw.prepare(cfm.keyspace).getType();
                if (type.isFreezable()) {
                    type = type.freeze();
                }
                return new WithTypeHint(this.typeRaw.toString(), type, selectable);
            }
        }
    }

    public static class WithMapOrUdt
    implements Selectable {
        private final TableMetadata cfm;
        private final List<Pair<org.apache.cassandra.cql3.selection.Selectable$Raw, org.apache.cassandra.cql3.selection.Selectable$Raw>> raws;

        public WithMapOrUdt(TableMetadata cfm, List<Pair<org.apache.cassandra.cql3.selection.Selectable$Raw, org.apache.cassandra.cql3.selection.Selectable$Raw>> raws) {
            this.cfm = cfm;
            this.raws = raws;
        }

        @Override
        public AssignmentTestable.TestResult testAssignment(String keyspace, ColumnSpecification receiver) {
            return receiver.type.isUDT() ? UserTypes.testUserTypeAssignment(receiver, this.getUdtFields((UserType)receiver.type)) : Maps.testMapAssignment(receiver, this.getMapEntries(this.cfm));
        }

        @Override
        public Selector.Factory newSelectorFactory(TableMetadata cfm, AbstractType<?> expectedType, List<ColumnMetadata> defs, VariableSpecifications boundNames) {
            AbstractType<?> type = this.getExactTypeIfKnown(cfm.keyspace);
            if (type == null && (type = expectedType) == null) {
                throw RequestValidations.invalidRequest("Cannot infer type for term %s in selection clause (try using a cast to force a type)", this);
            }
            if (type.isUDT()) {
                return this.newUdtSelectorFactory(cfm, expectedType, defs, boundNames);
            }
            return this.newMapSelectorFactory(cfm, defs, boundNames, type);
        }

        private Selector.Factory newMapSelectorFactory(TableMetadata cfm, List<ColumnMetadata> defs, VariableSpecifications boundNames, AbstractType<?> type) {
            MapType mapType = (MapType)type;
            if (mapType.getKeysType() == DurationType.instance) {
                throw RequestValidations.invalidRequest("Durations are not allowed as map keys: %s", mapType.asCQL3Type());
            }
            return MapSelector.newFactory(type, this.getMapEntries(cfm).stream().map(p -> Pair.create(((Selectable)p.left).newSelectorFactory(cfm, mapType.getKeysType(), defs, boundNames), ((Selectable)p.right).newSelectorFactory(cfm, mapType.getValuesType(), defs, boundNames))).collect(Collectors.toList()));
        }

        private Selector.Factory newUdtSelectorFactory(TableMetadata cfm, AbstractType<?> expectedType, List<ColumnMetadata> defs, VariableSpecifications boundNames) {
            UserType ut = (UserType)expectedType;
            LinkedHashMap<FieldIdentifier, Selector.Factory> factories = new LinkedHashMap<FieldIdentifier, Selector.Factory>(ut.size());
            for (Pair<org.apache.cassandra.cql3.selection.Selectable$Raw, org.apache.cassandra.cql3.selection.Selectable$Raw> raw : this.raws) {
                if (!(raw.left instanceof RawIdentifier)) {
                    throw RequestValidations.invalidRequest("%s is not a valid field identifier of type %s ", raw.left, ut.getNameAsString());
                }
                FieldIdentifier fieldName = ((RawIdentifier)raw.left).toFieldIdentifier();
                int fieldPosition = ut.fieldPosition(fieldName);
                if (fieldPosition == -1) {
                    throw RequestValidations.invalidRequest("Unknown field '%s' in value of user defined type %s", fieldName, ut.getNameAsString());
                }
                AbstractType<?> fieldType = ut.fieldType(fieldPosition);
                factories.put(fieldName, ((org.apache.cassandra.cql3.selection.Selectable$Raw)raw.right).prepare(cfm).newSelectorFactory(cfm, fieldType, defs, boundNames));
            }
            return UserTypeSelector.newFactory(expectedType, factories);
        }

        @Override
        public AbstractType<?> getExactTypeIfKnown(String keyspace) {
            return null;
        }

        @Override
        public boolean selectColumns(Predicate<ColumnMetadata> predicate) {
            for (Pair<org.apache.cassandra.cql3.selection.Selectable$Raw, org.apache.cassandra.cql3.selection.Selectable$Raw> raw : this.raws) {
                if (!(raw.left instanceof RawIdentifier) && ((org.apache.cassandra.cql3.selection.Selectable$Raw)raw.left).prepare(this.cfm).selectColumns(predicate)) {
                    return true;
                }
                if (((org.apache.cassandra.cql3.selection.Selectable$Raw)raw.right).prepare(this.cfm).selectColumns(predicate)) continue;
                return true;
            }
            return false;
        }

        public String toString() {
            return this.raws.stream().map(p -> String.format("%s: %s", p.left instanceof RawIdentifier ? p.left : ((org.apache.cassandra.cql3.selection.Selectable$Raw)p.left).prepare(this.cfm), ((org.apache.cassandra.cql3.selection.Selectable$Raw)p.right).prepare(this.cfm))).collect(Collectors.joining(", ", "{", "}"));
        }

        private List<Pair<Selectable, Selectable>> getMapEntries(TableMetadata cfm) {
            return this.raws.stream().map(p -> Pair.create(((org.apache.cassandra.cql3.selection.Selectable$Raw)p.left).prepare(cfm), ((org.apache.cassandra.cql3.selection.Selectable$Raw)p.right).prepare(cfm))).collect(Collectors.toList());
        }

        private Map<FieldIdentifier, Selectable> getUdtFields(UserType ut) {
            LinkedHashMap<FieldIdentifier, Selectable> fields = new LinkedHashMap<FieldIdentifier, Selectable>(ut.size());
            for (Pair<org.apache.cassandra.cql3.selection.Selectable$Raw, org.apache.cassandra.cql3.selection.Selectable$Raw> raw : this.raws) {
                if (!(raw.left instanceof RawIdentifier)) {
                    throw RequestValidations.invalidRequest("%s is not a valid field identifier of type %s ", raw.left, ut.getNameAsString());
                }
                FieldIdentifier fieldName = ((RawIdentifier)raw.left).toFieldIdentifier();
                int fieldPosition = ut.fieldPosition(fieldName);
                if (fieldPosition == -1) {
                    throw RequestValidations.invalidRequest("Unknown field '%s' in value of user defined type %s", fieldName, ut.getNameAsString());
                }
                fields.put(fieldName, ((org.apache.cassandra.cql3.selection.Selectable$Raw)raw.right).prepare(this.cfm));
            }
            return fields;
        }

        public static class Raw
        implements org.apache.cassandra.cql3.selection.Selectable$Raw {
            private final List<Pair<org.apache.cassandra.cql3.selection.Selectable$Raw, org.apache.cassandra.cql3.selection.Selectable$Raw>> raws;

            public Raw(List<Pair<org.apache.cassandra.cql3.selection.Selectable$Raw, org.apache.cassandra.cql3.selection.Selectable$Raw>> raws) {
                this.raws = raws;
            }

            @Override
            public Selectable prepare(TableMetadata cfm) {
                return new WithMapOrUdt(cfm, this.raws);
            }
        }
    }

    public static class WithSet
    implements Selectable {
        private final List<Selectable> selectables;

        public WithSet(List<Selectable> selectables) {
            this.selectables = selectables;
        }

        @Override
        public AssignmentTestable.TestResult testAssignment(String keyspace, ColumnSpecification receiver) {
            return Sets.testSetAssignment(receiver, this.selectables);
        }

        @Override
        public Selector.Factory newSelectorFactory(TableMetadata cfm, AbstractType<?> expectedType, List<ColumnMetadata> defs, VariableSpecifications boundNames) {
            AbstractType<?> type = this.getExactTypeIfKnown(cfm.keyspace);
            if (type == null && (type = expectedType) == null) {
                throw RequestValidations.invalidRequest("Cannot infer type for term %s in selection clause (try using a cast to force a type)", this);
            }
            if (type instanceof MapType) {
                return MapSelector.newFactory(type, Collections.emptyList());
            }
            SetType setType = (SetType)type;
            if (setType.getElementsType() == DurationType.instance) {
                throw RequestValidations.invalidRequest("Durations are not allowed inside sets: %s", setType.asCQL3Type());
            }
            ArrayList expectedTypes = new ArrayList(this.selectables.size());
            int m = this.selectables.size();
            for (int i = 0; i < m; ++i) {
                expectedTypes.add(setType.getElementsType());
            }
            SelectorFactories factories = SelectorFactories.createFactoriesAndCollectColumnDefinitions(this.selectables, expectedTypes, cfm, defs, boundNames);
            return SetSelector.newFactory(type, factories);
        }

        @Override
        public AbstractType<?> getExactTypeIfKnown(String keyspace) {
            return Sets.getExactSetTypeIfKnown(this.selectables, p -> p.getExactTypeIfKnown(keyspace));
        }

        @Override
        public boolean selectColumns(Predicate<ColumnMetadata> predicate) {
            return Selectable.selectColumns(this.selectables, predicate);
        }

        public String toString() {
            return Sets.setToString(this.selectables);
        }

        public static class Raw
        implements org.apache.cassandra.cql3.selection.Selectable$Raw {
            private final List<org.apache.cassandra.cql3.selection.Selectable$Raw> raws;

            public Raw(List<org.apache.cassandra.cql3.selection.Selectable$Raw> raws) {
                this.raws = raws;
            }

            @Override
            public Selectable prepare(TableMetadata cfm) {
                return new WithSet(this.raws.stream().map(p -> p.prepare(cfm)).collect(Collectors.toList()));
            }
        }
    }

    public static class WithList
    implements Selectable {
        private final List<Selectable> selectables;

        public WithList(List<Selectable> selectables) {
            this.selectables = selectables;
        }

        @Override
        public AssignmentTestable.TestResult testAssignment(String keyspace, ColumnSpecification receiver) {
            return Lists.testListAssignment(receiver, this.selectables);
        }

        @Override
        public Selector.Factory newSelectorFactory(TableMetadata cfm, AbstractType<?> expectedType, List<ColumnMetadata> defs, VariableSpecifications boundNames) {
            AbstractType<?> type = this.getExactTypeIfKnown(cfm.keyspace);
            if (type == null && (type = expectedType) == null) {
                throw RequestValidations.invalidRequest("Cannot infer type for term %s in selection clause (try using a cast to force a type)", this);
            }
            ListType listType = (ListType)type;
            ArrayList expectedTypes = new ArrayList(this.selectables.size());
            int m = this.selectables.size();
            for (int i = 0; i < m; ++i) {
                expectedTypes.add(listType.getElementsType());
            }
            SelectorFactories factories = SelectorFactories.createFactoriesAndCollectColumnDefinitions(this.selectables, expectedTypes, cfm, defs, boundNames);
            return ListSelector.newFactory(type, factories);
        }

        @Override
        public AbstractType<?> getExactTypeIfKnown(String keyspace) {
            return Lists.getExactListTypeIfKnown(this.selectables, p -> p.getExactTypeIfKnown(keyspace));
        }

        @Override
        public boolean selectColumns(Predicate<ColumnMetadata> predicate) {
            return Selectable.selectColumns(this.selectables, predicate);
        }

        public String toString() {
            return Lists.listToString(this.selectables);
        }

        public static class Raw
        implements org.apache.cassandra.cql3.selection.Selectable$Raw {
            private final List<org.apache.cassandra.cql3.selection.Selectable$Raw> raws;

            public Raw(List<org.apache.cassandra.cql3.selection.Selectable$Raw> raws) {
                this.raws = raws;
            }

            @Override
            public Selectable prepare(TableMetadata cfm) {
                return new WithList(this.raws.stream().map(p -> p.prepare(cfm)).collect(Collectors.toList()));
            }
        }
    }

    public static class BetweenParenthesesOrWithTuple
    implements Selectable {
        private final List<Selectable> selectables;

        public BetweenParenthesesOrWithTuple(List<Selectable> selectables) {
            this.selectables = selectables;
        }

        @Override
        public AssignmentTestable.TestResult testAssignment(String keyspace, ColumnSpecification receiver) {
            if (this.selectables.size() == 1 && !receiver.type.isTuple()) {
                return this.selectables.get(0).testAssignment(keyspace, receiver);
            }
            return Tuples.testTupleAssignment(receiver, this.selectables);
        }

        @Override
        public Selector.Factory newSelectorFactory(TableMetadata cfm, AbstractType<?> expectedType, List<ColumnMetadata> defs, VariableSpecifications boundNames) {
            AbstractType<?> type = this.getExactTypeIfKnown(cfm.keyspace);
            if (type == null && (type = expectedType) == null) {
                throw RequestValidations.invalidRequest("Cannot infer type for term %s in selection clause (try using a cast to force a type)", this);
            }
            if (this.selectables.size() == 1 && !type.isTuple()) {
                return this.newBetweenParenthesesSelectorFactory(cfm, expectedType, defs, boundNames);
            }
            return this.newTupleSelectorFactory(cfm, (TupleType)type, defs, boundNames);
        }

        private Selector.Factory newBetweenParenthesesSelectorFactory(TableMetadata cfm, AbstractType<?> expectedType, List<ColumnMetadata> defs, VariableSpecifications boundNames) {
            Selectable selectable = this.selectables.get(0);
            final Selector.Factory factory = selectable.newSelectorFactory(cfm, expectedType, defs, boundNames);
            return new ForwardingFactory(){

                @Override
                protected Selector.Factory delegate() {
                    return factory;
                }

                @Override
                protected String getColumnName() {
                    return String.format("(%s)", factory.getColumnName());
                }
            };
        }

        private Selector.Factory newTupleSelectorFactory(TableMetadata cfm, TupleType tupleType, List<ColumnMetadata> defs, VariableSpecifications boundNames) {
            SelectorFactories factories = SelectorFactories.createFactoriesAndCollectColumnDefinitions(this.selectables, tupleType.allTypes(), cfm, defs, boundNames);
            return TupleSelector.newFactory(tupleType, factories);
        }

        @Override
        public AbstractType<?> getExactTypeIfKnown(String keyspace) {
            if (this.selectables.size() == 1) {
                return null;
            }
            return Tuples.getExactTupleTypeIfKnown(this.selectables, p -> p.getExactTypeIfKnown(keyspace));
        }

        @Override
        public boolean selectColumns(Predicate<ColumnMetadata> predicate) {
            return Selectable.selectColumns(this.selectables, predicate);
        }

        public String toString() {
            return Tuples.tupleToString(this.selectables);
        }

        public static class Raw
        implements org.apache.cassandra.cql3.selection.Selectable$Raw {
            private final List<org.apache.cassandra.cql3.selection.Selectable$Raw> raws;

            public Raw(List<org.apache.cassandra.cql3.selection.Selectable$Raw> raws) {
                this.raws = raws;
            }

            @Override
            public Selectable prepare(TableMetadata cfm) {
                return new BetweenParenthesesOrWithTuple(this.raws.stream().map(p -> p.prepare(cfm)).collect(Collectors.toList()));
            }
        }
    }

    public static class WithFieldSelection
    implements Selectable {
        public final Selectable selected;
        public final FieldIdentifier field;

        public WithFieldSelection(Selectable selected, FieldIdentifier field) {
            this.selected = selected;
            this.field = field;
        }

        public String toString() {
            return String.format("%s.%s", this.selected, this.field);
        }

        @Override
        public Selector.Factory newSelectorFactory(TableMetadata table, AbstractType<?> expectedType, List<ColumnMetadata> defs, VariableSpecifications boundNames) {
            Selector.Factory factory;
            AbstractType<?> type;
            AbstractType<?> expectedUdtType = null;
            if (this.selected instanceof BetweenParenthesesOrWithTuple) {
                BetweenParenthesesOrWithTuple betweenParentheses = (BetweenParenthesesOrWithTuple)this.selected;
                expectedUdtType = ((Selectable)betweenParentheses.selectables.get(0)).getExactTypeIfKnown(table.keyspace);
            }
            if (!(type = (factory = this.selected.newSelectorFactory(table, expectedUdtType, defs, boundNames)).getReturnType()).isUDT()) {
                throw new InvalidRequestException(String.format("Invalid field selection: %s of type %s is not a user type", this.selected, type.asCQL3Type()));
            }
            UserType ut = (UserType)type;
            int fieldIndex = ut.fieldPosition(this.field);
            if (fieldIndex == -1) {
                throw new InvalidRequestException(String.format("%s of type %s has no field %s", this.selected, type.asCQL3Type(), this.field));
            }
            return FieldSelector.newFactory(ut, fieldIndex, factory);
        }

        @Override
        public AbstractType<?> getExactTypeIfKnown(String keyspace) {
            AbstractType<?> selectedType = this.selected.getExactTypeIfKnown(keyspace);
            if (selectedType == null || !(selectedType instanceof UserType)) {
                return null;
            }
            UserType ut = (UserType)selectedType;
            int fieldIndex = ut.fieldPosition(this.field);
            if (fieldIndex == -1) {
                return null;
            }
            return ut.fieldType(fieldIndex);
        }

        @Override
        public boolean selectColumns(Predicate<ColumnMetadata> predicate) {
            return this.selected.selectColumns(predicate);
        }

        public static class Raw
        implements org.apache.cassandra.cql3.selection.Selectable$Raw {
            private final org.apache.cassandra.cql3.selection.Selectable$Raw selected;
            private final FieldIdentifier field;

            public Raw(org.apache.cassandra.cql3.selection.Selectable$Raw selected, FieldIdentifier field) {
                this.selected = selected;
                this.field = field;
            }

            @Override
            public WithFieldSelection prepare(TableMetadata table) {
                return new WithFieldSelection(this.selected.prepare(table), this.field);
            }
        }
    }

    public static class WithCast
    implements Selectable {
        private final CQL3Type type;
        private final Selectable arg;

        public WithCast(Selectable arg, CQL3Type type) {
            this.arg = arg;
            this.type = type;
        }

        public String toString() {
            return String.format("cast(%s as %s)", this.arg, this.type.toString().toLowerCase());
        }

        @Override
        public Selector.Factory newSelectorFactory(TableMetadata table, AbstractType<?> expectedType, List<ColumnMetadata> defs, VariableSpecifications boundNames) {
            List<Selectable> args = Collections.singletonList(this.arg);
            SelectorFactories factories = SelectorFactories.createFactoriesAndCollectColumnDefinitions(args, null, table, defs, boundNames);
            Selector.Factory factory = factories.get(0);
            if (this.type.getType().equals(factory.getReturnType())) {
                return factory;
            }
            FunctionName name = FunctionName.nativeFunction(CastFcts.getFunctionName(this.type));
            Function fun = FunctionResolver.get(table.keyspace, name, args, table.keyspace, table.name, null);
            if (fun == null) {
                throw new InvalidRequestException(String.format("%s cannot be cast to %s", defs.get((int)0).name, this.type));
            }
            return AbstractFunctionSelector.newFactory(fun, factories);
        }

        @Override
        public AbstractType<?> getExactTypeIfKnown(String keyspace) {
            return this.type.getType();
        }

        @Override
        public boolean selectColumns(Predicate<ColumnMetadata> predicate) {
            return this.arg.selectColumns(predicate);
        }

        public static class Raw
        implements org.apache.cassandra.cql3.selection.Selectable$Raw {
            private final CQL3Type type;
            private final org.apache.cassandra.cql3.selection.Selectable$Raw arg;

            public Raw(org.apache.cassandra.cql3.selection.Selectable$Raw arg, CQL3Type type) {
                this.arg = arg;
                this.type = type;
            }

            @Override
            public WithCast prepare(TableMetadata table) {
                return new WithCast(this.arg.prepare(table), this.type);
            }
        }
    }

    public static class WithToJSonFunction
    implements Selectable {
        public final List<Selectable> args;

        private WithToJSonFunction(List<Selectable> args) {
            this.args = args;
        }

        public String toString() {
            return new StrBuilder().append((Object)ToJsonFct.NAME).append("(").appendWithSeparators(this.args, ", ").append(")").toString();
        }

        @Override
        public Selector.Factory newSelectorFactory(TableMetadata table, AbstractType<?> expectedType, List<ColumnMetadata> defs, VariableSpecifications boundNames) {
            SelectorFactories factories = SelectorFactories.createFactoriesAndCollectColumnDefinitions(this.args, null, table, defs, boundNames);
            ToJsonFct fun = ToJsonFct.getInstance(factories.getReturnTypes());
            return AbstractFunctionSelector.newFactory(fun, factories);
        }

        @Override
        public AbstractType<?> getExactTypeIfKnown(String keyspace) {
            return UTF8Type.instance;
        }

        @Override
        public boolean selectColumns(Predicate<ColumnMetadata> predicate) {
            return Selectable.selectColumns(this.args, predicate);
        }
    }

    public static class WithFunction
    implements Selectable {
        public final Function function;
        public final List<Selectable> args;

        public WithFunction(Function function, List<Selectable> args) {
            this.function = function;
            this.args = args;
        }

        public String toString() {
            return this.function.columnName(this.args.stream().map(Object::toString).collect(Collectors.toList()));
        }

        @Override
        public Selector.Factory newSelectorFactory(TableMetadata table, AbstractType<?> expectedType, List<ColumnMetadata> defs, VariableSpecifications boundNames) {
            SelectorFactories factories = SelectorFactories.createFactoriesAndCollectColumnDefinitions(this.args, this.function.argTypes(), table, defs, boundNames);
            return AbstractFunctionSelector.newFactory(this.function, factories);
        }

        @Override
        public boolean selectColumns(Predicate<ColumnMetadata> predicate) {
            return Selectable.selectColumns(this.args, predicate);
        }

        @Override
        public AbstractType<?> getExactTypeIfKnown(String keyspace) {
            return this.function.returnType();
        }

        public static class Raw
        implements org.apache.cassandra.cql3.selection.Selectable$Raw {
            private final FunctionName functionName;
            private final List<org.apache.cassandra.cql3.selection.Selectable$Raw> args;

            public Raw(FunctionName functionName, List<org.apache.cassandra.cql3.selection.Selectable$Raw> args) {
                this.functionName = functionName;
                this.args = args;
            }

            public static Raw newCountRowsFunction() {
                return new Raw(AggregateFcts.countRowsFunction.name(), Collections.emptyList());
            }

            public static Raw newOperation(char operator, org.apache.cassandra.cql3.selection.Selectable$Raw left, org.apache.cassandra.cql3.selection.Selectable$Raw right) {
                return new Raw(OperationFcts.getFunctionNameFromOperator(operator), Arrays.asList(left, right));
            }

            public static Raw newNegation(org.apache.cassandra.cql3.selection.Selectable$Raw arg) {
                return new Raw(FunctionName.nativeFunction("_negate"), Collections.singletonList(arg));
            }

            @Override
            public Selectable prepare(TableMetadata table) {
                Function fun;
                List<Selectable> preparedArgs = new ArrayList<Selectable>(this.args.size());
                for (org.apache.cassandra.cql3.selection.Selectable$Raw arg : this.args) {
                    preparedArgs.add(arg.prepare(table));
                }
                FunctionName name = this.functionName;
                if (this.functionName.equalsNativeFunction(ToJsonFct.NAME)) {
                    return new WithToJSonFunction(preparedArgs);
                }
                if (this.functionName.equalsNativeFunction(FunctionName.nativeFunction("count")) && preparedArgs.size() == 1 && preparedArgs.get(0) instanceof WithTerm && ((WithTerm)preparedArgs.get(0)).rawTerm instanceof Constants.Literal) {
                    name = AggregateFcts.countRowsFunction.name();
                    preparedArgs = Collections.emptyList();
                }
                if ((fun = FunctionResolver.get(table.keyspace, name, preparedArgs, table.keyspace, table.name, null)) == null) {
                    throw new InvalidRequestException(String.format("Unknown function '%s'", this.functionName));
                }
                if (fun.returnType() == null) {
                    throw new InvalidRequestException(String.format("Unknown function %s called in selection clause", this.functionName));
                }
                return new WithFunction(fun, preparedArgs);
            }
        }
    }

    public static class WritetimeOrTTL
    implements Selectable {
        public final ColumnMetadata column;
        public final boolean isWritetime;

        public WritetimeOrTTL(ColumnMetadata column, boolean isWritetime) {
            this.column = column;
            this.isWritetime = isWritetime;
        }

        public String toString() {
            return (this.isWritetime ? "writetime" : "ttl") + "(" + this.column.name + ")";
        }

        @Override
        public Selector.Factory newSelectorFactory(TableMetadata table, AbstractType<?> expectedType, List<ColumnMetadata> defs, VariableSpecifications boundNames) {
            if (this.column.isPrimaryKeyColumn()) {
                throw new InvalidRequestException(String.format("Cannot use selection function %s on PRIMARY KEY part %s", this.isWritetime ? "writeTime" : "ttl", this.column.name));
            }
            if (this.column.type.isMultiCell()) {
                throw new InvalidRequestException(String.format("Cannot use selection function %s on non-frozen %s %s", this.isWritetime ? "writeTime" : "ttl", this.column.type.isCollection() ? "collection" : "UDT", this.column.name));
            }
            return WritetimeOrTTLSelector.newFactory(this.column, this.addAndGetIndex(this.column, defs), this.isWritetime);
        }

        @Override
        public AbstractType<?> getExactTypeIfKnown(String keyspace) {
            return this.isWritetime ? LongType.instance : Int32Type.instance;
        }

        @Override
        public boolean selectColumns(Predicate<ColumnMetadata> predicate) {
            return predicate.test(this.column);
        }

        public static class Raw
        implements org.apache.cassandra.cql3.selection.Selectable$Raw {
            private final RawIdentifier id;
            private final boolean isWritetime;

            public Raw(RawIdentifier id, boolean isWritetime) {
                this.id = id;
                this.isWritetime = isWritetime;
            }

            @Override
            public WritetimeOrTTL prepare(TableMetadata table) {
                return new WritetimeOrTTL(this.id.prepare(table), this.isWritetime);
            }
        }
    }

    public static class WithTerm
    implements Selectable {
        private static final ColumnIdentifier bindMarkerNameInSelection = new ColumnIdentifier("[selection]", true);
        private final Term.Raw rawTerm;

        public WithTerm(Term.Raw rawTerm) {
            this.rawTerm = rawTerm;
        }

        @Override
        public AssignmentTestable.TestResult testAssignment(String keyspace, ColumnSpecification receiver) {
            return this.rawTerm.testAssignment(keyspace, receiver);
        }

        @Override
        public Selector.Factory newSelectorFactory(TableMetadata table, AbstractType<?> expectedType, List<ColumnMetadata> defs, VariableSpecifications boundNames) throws InvalidRequestException {
            AbstractType<?> type = this.getExactTypeIfKnown(table.keyspace);
            if (type == null && (type = expectedType) == null) {
                throw new InvalidRequestException("Cannot infer type for term " + this + " in selection clause (try using a cast to force a type)");
            }
            Term term = this.rawTerm.prepare(table.keyspace, new ColumnSpecification(table.keyspace, table.name, bindMarkerNameInSelection, type));
            term.collectMarkerSpecification(boundNames);
            return TermSelector.newFactory(this.rawTerm.getText(), term, type);
        }

        @Override
        public AbstractType<?> getExactTypeIfKnown(String keyspace) {
            return this.rawTerm.getExactTypeIfKnown(keyspace);
        }

        @Override
        public boolean selectColumns(Predicate<ColumnMetadata> predicate) {
            return false;
        }

        public String toString() {
            return this.rawTerm.getText();
        }

        public static class Raw
        implements org.apache.cassandra.cql3.selection.Selectable$Raw {
            private final Term.Raw term;

            public Raw(Term.Raw term) {
                this.term = term;
            }

            @Override
            public Selectable prepare(TableMetadata table) {
                return new WithTerm(this.term);
            }
        }
    }

    public static interface Raw {
        public Selectable prepare(TableMetadata var1);
    }
}

