/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.projects.config;

import org.apache.commons.lang.StringUtils;
import org.apache.hop.core.config.plugin.ConfigPlugin;
import org.apache.hop.core.config.plugin.IConfigOptions;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.logging.ILogChannel;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.metadata.api.IHasHopMetadataProvider;
import org.apache.hop.projects.config.ProjectsOptionPlugin;
import org.apache.hop.projects.search.ProjectsSearchablesLocation;
import org.apache.hop.search.HopSearch;
import org.apache.hop.ui.core.gui.HopNamespace;

@ConfigPlugin(id="ProjectsSearchOptionPlugin", description="Project and Environment configuration options for hop-search", category="search")
public class ProjectsSearchOptionPlugin
extends ProjectsOptionPlugin
implements IConfigOptions {
    @Override
    public boolean handleOption(ILogChannel log, IHasHopMetadataProvider hasHopMetadataProvider, IVariables variables) throws HopException {
        String projectName;
        if (super.handleOption(log, hasHopMetadataProvider, variables) && StringUtils.isNotEmpty((String)(projectName = HopNamespace.getNamespace()))) {
            log.logBasic("Searching in project : " + projectName);
            ProjectsSearchablesLocation projectsSearchablesLocation = new ProjectsSearchablesLocation(this.projectConfig);
            ((HopSearch)hasHopMetadataProvider).getSearchablesLocations().add(projectsSearchablesLocation);
            return true;
        }
        return false;
    }
}

