/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.phreak;

import java.util.Comparator;
import org.drools.core.base.SalienceInteger;
import org.drools.core.common.AgendaItem;
import org.drools.core.common.EventFactHandle;
import org.drools.core.common.EventSupport;
import org.drools.core.common.InternalAgenda;
import org.drools.core.common.InternalFactHandle;
import org.drools.core.common.InternalWorkingMemory;
import org.drools.core.conflict.PhreakConflictResolver;
import org.drools.core.definitions.rule.impl.RuleImpl;
import org.drools.core.event.RuleEventListenerSupport;
import org.drools.core.phreak.RuleAgendaItem;
import org.drools.core.phreak.RuleNetworkEvaluator;
import org.drools.core.reteoo.PathMemory;
import org.drools.core.reteoo.RuleTerminalNode;
import org.drools.core.reteoo.RuleTerminalNodeLeftTuple;
import org.drools.core.spi.Activation;
import org.drools.core.spi.Consequence;
import org.drools.core.spi.ConsequenceException;
import org.drools.core.spi.InternalActivationGroup;
import org.drools.core.spi.KnowledgeHelper;
import org.drools.core.spi.Tuple;
import org.drools.core.util.BinaryHeapQueue;
import org.drools.core.util.index.TupleList;
import org.kie.api.event.rule.BeforeMatchFiredEvent;
import org.kie.api.event.rule.MatchCancelledCause;
import org.kie.api.runtime.rule.AgendaFilter;
import org.kie.api.runtime.rule.Match;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RuleExecutor {
    protected static final transient Logger log = LoggerFactory.getLogger(RuleExecutor.class);
    private final PathMemory pmem;
    private final RuleAgendaItem ruleAgendaItem;
    private final TupleList tupleList;
    private BinaryHeapQueue queue;
    private volatile boolean dirty;
    private final boolean declarativeAgendaEnabled;
    private boolean fireExitedEarly;

    public RuleExecutor(PathMemory pmem, RuleAgendaItem ruleAgendaItem, boolean declarativeAgendaEnabled) {
        this.pmem = pmem;
        this.ruleAgendaItem = ruleAgendaItem;
        this.tupleList = new TupleList();
        this.declarativeAgendaEnabled = declarativeAgendaEnabled;
        if (ruleAgendaItem.getRule().getSalience().isDynamic()) {
            this.queue = new BinaryHeapQueue(SalienceComparator.INSTANCE);
        }
    }

    public void evaluateNetwork(InternalAgenda agenda) {
        RuleNetworkEvaluator.INSTANCE.evaluateNetwork(this.pmem, this, agenda);
        this.setDirty(false);
    }

    public int evaluateNetworkAndFire(InternalWorkingMemory wm, AgendaFilter filter, int fireCount, int fireLimit) {
        this.reEvaluateNetwork(wm);
        return this.fire(wm, this.pmem.getActualAgenda(wm), filter, fireCount, fireLimit);
    }

    public int evaluateNetworkAndFire(InternalAgenda agenda, AgendaFilter filter, int fireCount, int fireLimit) {
        InternalWorkingMemory wm = agenda.getWorkingMemory();
        this.reEvaluateNetwork(agenda);
        if (wm.getSessionConfiguration().isDirectFiring()) {
            RuleTerminalNode rtn = (RuleTerminalNode)this.pmem.getPathEndNode();
            RuleImpl rule = rtn.getRule();
            int directFirings = this.tupleList.size();
            Tuple tuple = this.tupleList.getFirst();
            while (tuple != null) {
                if (this.cancelAndContinue(wm, rtn, rule, tuple, filter)) {
                    --directFirings;
                } else {
                    this.innerFireActivation(wm, agenda, (Activation)((Object)tuple), ((Activation)((Object)tuple)).getConsequence());
                }
                this.removeLeftTuple(tuple);
                tuple = this.tupleList.getFirst();
            }
            this.ruleAgendaItem.remove();
            return directFirings;
        }
        return this.fire(wm, agenda, filter, fireCount, fireLimit);
    }

    public void fire(InternalAgenda agenda) {
        this.fire(agenda.getWorkingMemory(), agenda, null, 0, Integer.MAX_VALUE);
    }

    private int fire(InternalWorkingMemory wm, InternalAgenda agenda, AgendaFilter filter, int fireCount, int fireLimit) {
        int localFireCount = 0;
        if (!this.tupleList.isEmpty()) {
            RuleAgendaItem nextRule;
            if (!this.fireExitedEarly && this.isDeclarativeAgendaEnabled() && !this.isHigherSalience(nextRule = agenda.peekNextRule())) {
                this.fireExitedEarly = true;
                return localFireCount;
            }
            RuleTerminalNode rtn = (RuleTerminalNode)this.pmem.getPathEndNode();
            RuleImpl rule = rtn.getRule();
            boolean ruleIsAllMatches = rule.isAllMatches();
            Tuple tuple = this.getNextTuple();
            if (ruleIsAllMatches) {
                this.fireConsequenceEvent(wm, agenda, (AgendaItem)((Object)tuple), "$onBeforeAllFire$");
            }
            Tuple lastTuple = null;
            while (tuple != null) {
                if (!this.cancelAndContinue(wm, rtn, rule, tuple, filter)) {
                    AgendaItem item = (AgendaItem)((Object)tuple);
                    if (agenda.getActivationsFilter() == null || agenda.getActivationsFilter().accept(item, wm, rtn)) {
                        this.fireActivation(wm, agenda, item);
                        ++localFireCount;
                        if (rtn.getLeftTupleSource() == null) break;
                        agenda.flushPropagations();
                        int salience = this.ruleAgendaItem.getSalience();
                        if (this.queue != null && !this.queue.isEmpty() && salience != this.queue.peek().getSalience()) {
                            this.ruleAgendaItem.dequeue();
                            this.ruleAgendaItem.setSalience(this.queue.peek().getSalience());
                            this.ruleAgendaItem.getAgendaGroup().add(this.ruleAgendaItem);
                        }
                        if (!ruleIsAllMatches) {
                            if (this.haltRuleFiring(fireCount, fireLimit, localFireCount, agenda)) break;
                            if (!wm.isSequential()) {
                                this.reEvaluateNetwork(agenda);
                            }
                        }
                    }
                }
                lastTuple = tuple;
                tuple = this.getNextTuple();
            }
            if (ruleIsAllMatches) {
                this.fireConsequenceEvent(wm, agenda, (AgendaItem)((Object)lastTuple), "$onAfterAllFire$");
            }
        }
        this.removeRuleAgendaItemWhenEmpty(wm);
        this.fireExitedEarly = false;
        return localFireCount;
    }

    private Tuple getNextTuple() {
        Tuple leftTuple;
        if (this.tupleList.isEmpty()) {
            return null;
        }
        if (this.queue != null) {
            leftTuple = (Tuple)((Object)this.queue.dequeue());
            this.tupleList.remove(leftTuple);
        } else {
            leftTuple = this.tupleList.removeFirst();
            ((Activation)((Object)leftTuple)).setQueued(false);
        }
        return leftTuple;
    }

    public PathMemory getPathMemory() {
        return this.pmem;
    }

    public void removeRuleAgendaItemWhenEmpty(InternalWorkingMemory wm) {
        if (!this.dirty && this.tupleList.isEmpty()) {
            if (log.isTraceEnabled()) {
                log.trace("Removing RuleAgendaItem " + this.ruleAgendaItem);
            }
            this.ruleAgendaItem.remove();
            if (this.ruleAgendaItem.getRule().isQuery()) {
                this.pmem.getActualAgenda(wm).removeQueryAgendaItem(this.ruleAgendaItem);
            } else if (this.ruleAgendaItem.getRule().isEager()) {
                this.pmem.getActualAgenda(wm).removeEagerRuleAgendaItem(this.ruleAgendaItem);
            }
        }
    }

    public void reEvaluateNetwork(InternalWorkingMemory wm) {
        this.reEvaluateNetwork(this.pmem.getActualAgenda(wm));
    }

    public void reEvaluateNetwork(InternalAgenda agenda) {
        if (this.isDirty()) {
            this.setDirty(false);
            RuleNetworkEvaluator.INSTANCE.evaluateNetwork(this.pmem, this, agenda);
        }
    }

    public RuleAgendaItem getRuleAgendaItem() {
        return this.ruleAgendaItem;
    }

    private boolean cancelAndContinue(InternalWorkingMemory wm, RuleTerminalNode rtn, RuleImpl rule, Tuple leftTuple, AgendaFilter filter) {
        if (!rule.isEffective(leftTuple, rtn, wm)) {
            return true;
        }
        if (rule.hasCalendars()) {
            long timestamp = wm.getSessionClock().getCurrentTime();
            for (String cal : rule.getCalendars()) {
                if (wm.getCalendars().get(cal).isTimeIncluded(timestamp)) continue;
                return true;
            }
        }
        return filter != null && !filter.accept((Match)((Activation)((Object)leftTuple)));
    }

    private boolean haltRuleFiring(int fireCount, int fireLimit, int localFireCount, InternalAgenda agenda) {
        if (!agenda.isFiring() || fireLimit >= 0 && localFireCount + fireCount >= fireLimit) {
            return true;
        }
        agenda.evaluateEagerList();
        RuleAgendaItem nextRule = agenda.peekNextRule();
        return nextRule != null && (!this.ruleAgendaItem.getAgendaGroup().equals(nextRule.getAgendaGroup()) || !this.isHigherSalience(nextRule));
    }

    private boolean isHigherSalience(RuleAgendaItem nextRule) {
        return PhreakConflictResolver.doCompare(this.ruleAgendaItem, nextRule) >= 0;
    }

    public TupleList getLeftTupleList() {
        return this.tupleList;
    }

    public void addLeftTuple(Tuple tuple) {
        ((AgendaItem)((Object)tuple)).setQueued(true);
        this.tupleList.add(tuple);
        if (this.queue != null) {
            this.addQueuedLeftTuple(tuple);
        }
    }

    public void addQueuedLeftTuple(Tuple tuple) {
        int currentSalience = this.queue.isEmpty() ? 0 : this.queue.peek().getSalience();
        this.queue.enqueue((Activation)((Object)tuple));
        this.updateSalience(currentSalience);
    }

    public void removeLeftTuple(Tuple tuple) {
        ((AgendaItem)((Object)tuple)).setQueued(false);
        this.tupleList.remove(tuple);
        if (this.queue != null) {
            this.removeQueuedLeftTuple(tuple);
        }
    }

    private void removeQueuedLeftTuple(Tuple tuple) {
        int currentSalience = this.queue.isEmpty() ? 0 : this.queue.peek().getSalience();
        this.queue.dequeue((Activation)((Object)tuple));
        this.updateSalience(currentSalience);
    }

    private void updateSalience(int currentSalience) {
        int newSalience;
        int n = newSalience = this.queue.isEmpty() ? SalienceInteger.DEFAULT_SALIENCE.getValue() : this.queue.peek().getSalience();
        if (currentSalience != newSalience) {
            this.ruleAgendaItem.remove();
        }
        if (!this.ruleAgendaItem.isQueued()) {
            this.ruleAgendaItem.setSalience(newSalience);
            this.ruleAgendaItem.getAgendaGroup().add(this.ruleAgendaItem);
        }
    }

    public void cancel(InternalWorkingMemory wm, EventSupport es) {
        while (!this.tupleList.isEmpty()) {
            RuleTerminalNodeLeftTuple rtnLt = (RuleTerminalNodeLeftTuple)this.tupleList.removeFirst();
            if (this.queue != null) {
                this.queue.dequeue(rtnLt);
            }
            es.getAgendaEventSupport().fireActivationCancelled(rtnLt, wm, MatchCancelledCause.CLEAR);
        }
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public void setDirty(boolean dirty) {
        this.dirty = dirty;
    }

    public boolean isDeclarativeAgendaEnabled() {
        return this.declarativeAgendaEnabled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireActivation(InternalWorkingMemory wm, InternalAgenda agenda, Activation activation) throws ConsequenceException {
        wm.startOperation();
        try {
            BeforeMatchFiredEvent beforeMatchFiredEvent = wm.getAgendaEventSupport().fireBeforeActivationFired(activation, wm);
            if (activation.getActivationGroupNode() != null) {
                InternalActivationGroup activationGroup = activation.getActivationGroupNode().getActivationGroup();
                activationGroup.removeActivation(activation);
                agenda.clearAndCancelActivationGroup(activationGroup);
            }
            activation.setQueued(false);
            try {
                this.innerFireActivation(wm, agenda, activation, activation.getConsequence());
            }
            finally {
                for (Tuple tuple = activation.getTuple().skipEmptyHandles(); tuple != null; tuple = tuple.getParent()) {
                    if (!tuple.getFactHandle().isEvent()) continue;
                    EventFactHandle handle = (EventFactHandle)tuple.getFactHandle();
                    handle.decreaseActivationsCount();
                    if (!handle.expirePartition() || !handle.isExpired() || handle.getFirstRightTuple() != null || handle.getActivationsCount() > 0L) continue;
                    handle.getEntryPoint(wm).delete(handle);
                }
            }
            wm.getAgendaEventSupport().fireAfterActivationFired(activation, wm, beforeMatchFiredEvent);
        }
        finally {
            wm.endOperation();
        }
    }

    public void fireConsequenceEvent(InternalWorkingMemory wm, InternalAgenda agenda, Activation activation, String consequenceName) {
        Consequence consequence = activation.getRule().getNamedConsequence(consequenceName);
        if (consequence != null) {
            this.fireActivationEvent(wm, agenda, activation, consequence);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireActivationEvent(InternalWorkingMemory wm, InternalAgenda agenda, Activation activation, Consequence consequence) throws ConsequenceException {
        wm.startOperation();
        try {
            this.innerFireActivation(wm, agenda, activation, consequence);
        }
        finally {
            wm.endOperation();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void innerFireActivation(InternalWorkingMemory wm, InternalAgenda agenda, Activation activation, Consequence consequence) {
        try {
            KnowledgeHelper knowledgeHelper = agenda.getKnowledgeHelper();
            knowledgeHelper.setActivation(activation);
            if (log.isTraceEnabled()) {
                log.trace("Fire event {} for rule \"{}\" \n{}", new Object[]{consequence.getName(), activation.getRule().getName(), activation.getTuple()});
            }
            RuleEventListenerSupport ruleEventSupport = wm.getRuleEventSupport();
            ruleEventSupport.onBeforeMatchFire(activation);
            consequence.evaluate(knowledgeHelper, wm);
            ruleEventSupport.onAfterMatchFire(activation);
            activation.setActive(false);
            knowledgeHelper.cancelRemainingPreviousLogicalDependencies();
            knowledgeHelper.reset();
        }
        catch (Exception e) {
            agenda.handleException(wm, activation, e);
        }
        finally {
            if (activation.getActivationFactHandle() != null) {
                InternalFactHandle factHandle = activation.getActivationFactHandle();
                wm.getEntryPointNode().modifyActivation(factHandle, activation.getPropagationContext(), wm);
            }
        }
    }

    public static class SalienceComparator
    implements Comparator {
        public static final SalienceComparator INSTANCE = new SalienceComparator();

        public int compare(Object existing, Object adding) {
            int l2;
            int s2;
            RuleTerminalNodeLeftTuple rtnLt1 = (RuleTerminalNodeLeftTuple)existing;
            RuleTerminalNodeLeftTuple rtnLt2 = (RuleTerminalNodeLeftTuple)adding;
            int s1 = rtnLt1.getSalience();
            if (s1 > (s2 = rtnLt2.getSalience())) {
                return 1;
            }
            if (s1 < s2) {
                return -1;
            }
            int l1 = rtnLt1.getRule().getLoadOrder();
            if (l1 < (l2 = rtnLt2.getRule().getLoadOrder())) {
                return 1;
            }
            if (l1 > l2) {
                return -1;
            }
            return 0;
        }
    }
}

