/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import org.hsqldb.ColumnBase;
import org.hsqldb.ColumnSchema;
import org.hsqldb.Database;
import org.hsqldb.Expression;
import org.hsqldb.ExpressionAccessor;
import org.hsqldb.ExpressionAggregate;
import org.hsqldb.ExpressionArithmetic;
import org.hsqldb.ExpressionArrayAggregate;
import org.hsqldb.ExpressionColumn;
import org.hsqldb.ExpressionLike;
import org.hsqldb.ExpressionLogical;
import org.hsqldb.ExpressionOp;
import org.hsqldb.ExpressionOrderBy;
import org.hsqldb.ExpressionPeriod;
import org.hsqldb.ExpressionPeriodOp;
import org.hsqldb.ExpressionTable;
import org.hsqldb.ExpressionValue;
import org.hsqldb.FunctionCustom;
import org.hsqldb.FunctionSQL;
import org.hsqldb.FunctionSQLInvoked;
import org.hsqldb.HsqlException;
import org.hsqldb.HsqlNameManager;
import org.hsqldb.NumberSequence;
import org.hsqldb.ParserBase;
import org.hsqldb.PeriodDefinition;
import org.hsqldb.QueryExpression;
import org.hsqldb.QuerySpecification;
import org.hsqldb.RangeGroup;
import org.hsqldb.RangeVariable;
import org.hsqldb.RangeVariableJoined;
import org.hsqldb.ReferenceObject;
import org.hsqldb.Routine;
import org.hsqldb.RoutineSchema;
import org.hsqldb.Scanner;
import org.hsqldb.SchemaObject;
import org.hsqldb.Session;
import org.hsqldb.SortAndSlice;
import org.hsqldb.SqlInvariants;
import org.hsqldb.StatementCursor;
import org.hsqldb.StatementDMQL;
import org.hsqldb.StatementQuery;
import org.hsqldb.Table;
import org.hsqldb.TableDerived;
import org.hsqldb.Token;
import org.hsqldb.View;
import org.hsqldb.error.Error;
import org.hsqldb.lib.ArrayUtil;
import org.hsqldb.lib.HashMappedList;
import org.hsqldb.lib.HsqlArrayList;
import org.hsqldb.lib.HsqlList;
import org.hsqldb.lib.Iterator;
import org.hsqldb.lib.LongDeque;
import org.hsqldb.lib.OrderedHashSet;
import org.hsqldb.lib.OrderedIntKeyHashMap;
import org.hsqldb.map.BitMap;
import org.hsqldb.map.ValuePool;
import org.hsqldb.result.ResultProperties;
import org.hsqldb.types.ArrayType;
import org.hsqldb.types.Charset;
import org.hsqldb.types.Collation;
import org.hsqldb.types.IntervalType;
import org.hsqldb.types.Type;
import org.hsqldb.types.Types;
import org.hsqldb.types.UserTypeModifier;

public class ParserDQL
extends ParserBase {
    protected Database database;
    protected Session session;
    protected final CompileContext compileContext;

    ParserDQL(Session session, Scanner scanner, CompileContext compileContext) {
        super(scanner);
        this.session = session;
        this.database = session.getDatabase();
        this.compileContext = new CompileContext(session, this, compileContext);
    }

    @Override
    void reset(Session session, String string) {
        super.reset(session, string);
        this.compileContext.reset();
        this.lastError = null;
    }

    void checkIsSchemaObjectName() {
        if (this.database.sqlEnforceNames) {
            this.checkIsNonReservedIdentifier();
        } else {
            this.checkIsNonCoreReservedIdentifier();
        }
        if (this.database.sqlRegularNames) {
            this.checkIsIrregularCharInIdentifier();
        }
    }

    Type readTypeDefinition(boolean bl, boolean bl2) {
        int n = Integer.MIN_VALUE;
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = false;
        boolean bl6 = false;
        boolean bl7 = false;
        boolean bl8 = this.database.sqlEnforceSize;
        this.checkIsIdentifier();
        if (this.token.namePrefix == null) {
            n = Type.getTypeNr(this.token.tokenString);
        }
        if (this.database.sqlSyntaxOra && !this.session.isProcessingScript() && n == 91) {
            this.read();
            return Type.SQL_TIMESTAMP_NO_FRACTION;
        }
        if (n == Integer.MIN_VALUE) {
            if (bl2) {
                this.checkIsSchemaObjectName();
                Type type = this.database.schemaManager.findDomainOrUDT(this.session, this.token.tokenString, this.token.namePrefix, this.token.namePrePrefix, this.token.namePrePrePrefix);
                if (type != null) {
                    this.getRecordedToken().setExpression(type);
                    this.compileContext.addSchemaObject(type);
                    this.read();
                    return type;
                }
            }
            if (this.token.namePrefix != null) {
                throw Error.error(5509, this.token.tokenString);
            }
            if (this.database.sqlSyntaxOra) {
                switch (this.token.tokenType) {
                    case 586: 
                    case 587: {
                        this.read();
                        return Type.SQL_DOUBLE;
                    }
                    case 636: {
                        this.read();
                        if (this.token.tokenType == 654) {
                            this.read();
                            return Type.getType(61, null, null, 0x40000000L, 0);
                        }
                        this.readIfThis(329);
                        return Type.getType(12, null, this.database.collation, 0x40000000L, 0);
                    }
                    case 474: {
                        this.read();
                        if (this.token.tokenType == 936) {
                            this.read();
                            int n2 = this.readInteger();
                            int n3 = 0;
                            if (this.token.tokenType == 924) {
                                this.read();
                                n3 = this.readInteger();
                            }
                            this.readThis(922);
                            return Type.getType(3, null, null, n2, n3);
                        }
                        return Type.SQL_DECIMAL_DEFAULT;
                    }
                    case 654: {
                        n = 61;
                        break;
                    }
                    case 675: {
                        bl7 = true;
                        bl8 = false;
                        n = 12;
                        break;
                    }
                    case 646: {
                        n = 12;
                        break;
                    }
                    case 187: {
                        n = 1;
                        break;
                    }
                }
            }
            if (this.database.sqlSyntaxMss) {
                if ("MONEY".equals(this.token.tokenString)) {
                    return Type.getType(3, null, null, 18L, 4);
                }
                if ("UNIQUEIDENTIFIER".equals(this.token.tokenString)) {
                    return Type.SQL_GUID;
                }
                if ("DATETIME2".equals(this.token.tokenString)) {
                    n = 93;
                } else if ("IMAGE".equals(this.token.tokenString)) {
                    n = -4;
                } else if ("NTEXT".equals(this.token.tokenString)) {
                    n = -1;
                }
                switch (this.token.tokenType) {
                    case 851: {
                        n = 95;
                        break;
                    }
                    case 669: {
                        n = -1;
                    }
                }
            }
            if (this.database.sqlSyntaxPgs) {
                switch (this.token.tokenType) {
                    case 669: {
                        n = -1;
                        bl7 = true;
                        break;
                    }
                    case 596: {
                        n = 100;
                    }
                }
            }
            if (this.database.sqlSyntaxMys) {
                switch (this.token.tokenType) {
                    case 610: {
                        return this.readMysEnum();
                    }
                    case 849: {
                        n = 12;
                        bl7 = true;
                        break;
                    }
                    case 669: {
                        n = -1;
                        bl7 = true;
                        break;
                    }
                    case 845: 
                    case 847: {
                        n = -1;
                        bl7 = true;
                        break;
                    }
                    case 848: {
                        n = -3;
                        break;
                    }
                    case 844: 
                    case 846: {
                        n = -4;
                    }
                }
            }
            if (n == Integer.MIN_VALUE) {
                throw Error.error(5509, this.token.tokenString);
            }
        }
        this.read();
        switch (n) {
            case 1: {
                if (this.token.tokenType == 330) {
                    this.read();
                    n = 12;
                    break;
                }
                if (this.token.tokenType == 157) {
                    this.read();
                    this.readThis(475);
                    n = 40;
                    break;
                }
                if (!this.database.sqlSyntaxOra) break;
                bl7 = true;
                break;
            }
            case 8: {
                if (this.token.tokenType != 226) break;
                this.read();
                break;
            }
            case 60: {
                if (this.token.tokenType == 330) {
                    this.read();
                    n = 61;
                    break;
                }
                if (this.token.tokenType != 157) break;
                this.read();
                this.readThis(475);
                n = 30;
                break;
            }
            case 14: {
                if (this.token.tokenType != 330) break;
                this.read();
                n = 15;
                break;
            }
            case 10: {
                return this.readIntervalType(this.session, false);
            }
        }
        long l = n == 93 ? 6L : 0L;
        int n4 = 0;
        if (Types.requiresPrecision(n) && this.token.tokenType != 936 && bl8 && !this.session.isProcessingScript()) {
            throw Error.error(5599, Type.getDefaultType(n).getNameString());
        }
        boolean bl9 = Types.acceptsPrecision(n);
        if (this.database.sqlSyntaxMys) {
            switch (n) {
                case -6: 
                case 4: 
                case 5: 
                case 25: {
                    bl9 = true;
                }
            }
        }
        if (this.database.sqlSyntaxMss) {
            switch (n) {
                case 95: {
                    bl9 = true;
                }
            }
        }
        if (bl9) {
            if (this.token.tokenType == 936) {
                int n5 = 1;
                this.read();
                block38 : switch (this.token.tokenType) {
                    case 1011: {
                        if (this.token.dataType.typeCode == 4 || this.token.dataType.typeCode == 25) break;
                        throw this.unexpectedToken();
                    }
                    case 1018: {
                        if (n == 30 || n == 40 || n == 61 || n == 12) {
                            switch (this.token.lobMultiplierType) {
                                case 448: {
                                    n5 = 1024;
                                    break block38;
                                }
                                case 457: {
                                    n5 = 0x100000;
                                    break block38;
                                }
                                case 427: {
                                    n5 = 0x40000000;
                                    break block38;
                                }
                            }
                            throw this.unexpectedToken();
                        }
                        throw this.unexpectedToken(this.token.getFullString());
                    }
                    case 173: {
                        if (this.database.sqlSyntaxMss) {
                            this.token.tokenValue = Integer.MAX_VALUE;
                            break;
                        }
                        throw this.unexpectedToken();
                    }
                    default: {
                        throw this.unexpectedToken();
                    }
                }
                bl3 = true;
                l = ((Number)this.token.tokenValue).longValue();
                if (l < 0L || l == 0L && !Types.acceptsZeroPrecision(n)) {
                    throw Error.error(5592);
                }
                l *= (long)n5;
                this.read();
                if (n == 1 || n == 12 || n == 40) {
                    if (this.token.tokenType == 376) {
                        this.read();
                    } else if (this.token.tokenType == 476) {
                        this.read();
                    }
                }
                if (Types.acceptsScaleCreateParam(n) && this.token.tokenType == 924) {
                    this.read();
                    n4 = this.readInteger();
                    if (!(n4 >= 0 || n == 3 && this.database.sqlSyntaxOra)) {
                        throw Error.error(5592);
                    }
                    if (n == 3 && (long)n4 > l) {
                        throw Error.error(5592);
                    }
                    bl4 = true;
                }
                if (bl7 && !this.readIfThis(36)) {
                    this.readIfThis(591);
                }
                this.readThis(922);
            } else if (n == 14) {
                l = 1L;
            } else if (n == 30 || n == 40) {
                l = 0x40000000L;
            } else if (bl8 && (n == 1 || n == 60)) {
                l = 1L;
            }
            switch (n) {
                case 92: 
                case 93: 
                case 95: {
                    if (l > 9L) {
                        throw Error.error(5592);
                    }
                    n4 = (int)l;
                    l = 0L;
                    if (n == 95) break;
                    if (this.token.tokenType == 337) {
                        this.read();
                        this.readThis(297);
                        this.readThis(571);
                        if (n == 93) {
                            n = 95;
                            break;
                        }
                        n = 94;
                        break;
                    }
                    if (this.token.tokenType != 339) break;
                    this.read();
                    this.readThis(297);
                    this.readThis(571);
                }
            }
        }
        switch (n) {
            case -1: {
                if (this.database.sqlLongvarIsLob) {
                    n = 40;
                    l = 0x40000000L;
                    break;
                }
                n = 12;
                if (bl3) break;
                l = 0x1000000L;
                break;
            }
            case -4: {
                if (this.database.sqlLongvarIsLob) {
                    n = 30;
                    l = 0x40000000L;
                    break;
                }
                n = 61;
                if (bl3) break;
                l = 0x1000000L;
                break;
            }
            case 1: {
                if (this.database.sqlSyntaxDb2 && this.readIfThis(120)) {
                    this.readThis(588);
                    this.readThis(399);
                    n = 60;
                    break;
                }
                bl5 = true;
                break;
            }
            case 40: {
                bl5 = true;
                break;
            }
            case 100: {
                n = 12;
                bl6 = true;
            }
            case 12: {
                if (this.database.sqlSyntaxDb2 && this.readIfThis(120)) {
                    this.readThis(588);
                    this.readThis(399);
                    n = 61;
                    if (bl3) break;
                    l = 32768L;
                    break;
                }
                bl5 = true;
                if (!bl3) {
                    l = 32768L;
                }
                if (this.session.isIgnorecase() && !this.session.isProcessingScript()) {
                    bl6 = true;
                }
                if (l <= Integer.MAX_VALUE) break;
                throw Error.error(5592);
            }
            case 60: {
                break;
            }
            case 61: {
                if (!bl3) {
                    l = 32768L;
                }
                if (l <= Integer.MAX_VALUE) break;
                throw Error.error(5592);
            }
            case 2: 
            case 3: {
                if (bl3 || bl4 || bl8) break;
                l = 128L;
                n4 = 32;
            }
        }
        Collation collation = this.database.collation;
        Charset charset = null;
        if (bl5 && bl) {
            if (this.token.tokenType == 38) {
                this.read();
                this.readThis(268);
                this.checkIsSchemaObjectName();
                charset = (Charset)this.database.schemaManager.getCharacterSet(this.session, this.token.tokenString, this.token.namePrefix);
                this.read();
            }
            if (this.token.tokenType == 44) {
                this.read();
                this.checkIsSchemaObjectName();
                collation = this.database.schemaManager.getCollation(this.session, this.token.tokenString, this.token.namePrefix);
                this.read();
            } else if (bl6) {
                collation = Collation.getUpperCaseCompareCollation(collation);
            }
        }
        Type type = Type.getType(n, charset, collation, l, n4);
        if (this.token.tokenType == 8) {
            if (type.isLobType()) {
                throw this.unexpectedToken();
            }
            this.read();
            int n6 = 1024;
            if (this.token.tokenType == 931) {
                this.read();
                n6 = this.readInteger();
                if (n6 < 0) {
                    throw Error.error(5592);
                }
                this.readThis(940);
            }
            type = new ArrayType(type, n6);
        }
        return type;
    }

    Type readMysEnum() {
        UserTypeModifier userTypeModifier;
        this.read();
        this.checkIsThis(936);
        HsqlNameManager.HsqlName hsqlName = this.database.nameManager.newHsqlName("ENUM", false, 13);
        Type type = Type.getType(12, null, null, 32L, 0);
        type.userTypeModifier = userTypeModifier = new UserTypeModifier(hsqlName, 13, type);
        return type;
    }

    void readSimpleColumnNames(OrderedHashSet orderedHashSet, RangeVariable rangeVariable, boolean bl) {
        do {
            ColumnSchema columnSchema = this.readSimpleColumnName(rangeVariable, bl);
            if (orderedHashSet.add(columnSchema.getName().name)) continue;
            throw Error.error(5579, columnSchema.getName().name);
        } while (this.readIfThis(924));
        if (this.token.tokenType != 922) {
            throw this.unexpectedToken();
        }
    }

    void readTargetSpecificationList(OrderedHashSet orderedHashSet, RangeVariable[] rangeVariableArray, LongDeque longDeque) {
        do {
            Expression expression;
            if (orderedHashSet.add(expression = this.XreadTargetSpecification(rangeVariableArray, longDeque))) continue;
            ColumnSchema columnSchema = expression.getColumn();
            throw Error.error(5579, columnSchema.getName().name);
        } while (this.readIfThis(924));
        if (this.token.tokenType != 922 && this.token.tokenType != 124) {
            throw this.unexpectedToken();
        }
    }

    int[] readColumnList(Table table, boolean bl) {
        OrderedHashSet orderedHashSet = this.readColumnNames(bl);
        return table.getColumnIndexes(orderedHashSet);
    }

    void readSimpleColumnNames(OrderedHashSet orderedHashSet, Table table, boolean bl) {
        do {
            ColumnSchema columnSchema = this.readSimpleColumnName(table, bl);
            if (orderedHashSet.add(columnSchema.getName().name)) continue;
            throw Error.error(5577, columnSchema.getName().name);
        } while (this.readIfThis(924));
        if (this.token.tokenType != 922) {
            throw this.unexpectedToken();
        }
    }

    HsqlNameManager.HsqlName[] readColumnNames(HsqlNameManager.HsqlName hsqlName) {
        BitMap bitMap = new BitMap(0, true);
        OrderedHashSet orderedHashSet = this.readColumnNames(bitMap, false);
        HsqlNameManager.HsqlName[] hsqlNameArray = new HsqlNameManager.HsqlName[orderedHashSet.size()];
        for (int i = 0; i < hsqlNameArray.length; ++i) {
            String string = (String)orderedHashSet.get(i);
            boolean bl = bitMap.isSet(i);
            hsqlNameArray[i] = this.database.nameManager.newHsqlName(hsqlName.schema, string, bl, 9, hsqlName);
        }
        return hsqlNameArray;
    }

    OrderedHashSet readColumnNames(boolean bl) {
        return this.readColumnNames(null, bl);
    }

    OrderedHashSet readColumnNames(BitMap bitMap, boolean bl) {
        this.readThis(936);
        OrderedHashSet orderedHashSet = new OrderedHashSet();
        this.readColumnNameList(orderedHashSet, bitMap, bl);
        this.readThis(922);
        return orderedHashSet;
    }

    void readColumnNameList(OrderedHashSet orderedHashSet, BitMap bitMap, boolean bl) {
        int n = 0;
        do {
            if (this.session.isProcessingScript()) {
                if (!this.isSimpleName()) {
                    this.token.isDelimitedIdentifier = true;
                }
            } else {
                this.checkIsSimpleName();
            }
            if (!orderedHashSet.add(this.token.tokenString)) {
                throw Error.error(5577, this.token.tokenString);
            }
            if (bitMap != null) {
                bitMap.setValue(n, this.isDelimitedIdentifier());
            }
            this.read();
            ++n;
            if (!bl || this.token.tokenType != 359 && this.token.tokenType != 410) continue;
            this.read();
        } while (this.readIfThis(924));
    }

    HsqlNameManager.SimpleName[] readColumnNameList(OrderedHashSet orderedHashSet) {
        BitMap bitMap = new BitMap(0, true);
        this.readThis(936);
        this.readColumnNameList(orderedHashSet, bitMap, false);
        this.readThis(922);
        HsqlNameManager.SimpleName[] simpleNameArray = new HsqlNameManager.SimpleName[orderedHashSet.size()];
        for (int i = 0; i < orderedHashSet.size(); ++i) {
            HsqlNameManager.SimpleName simpleName;
            simpleNameArray[i] = simpleName = HsqlNameManager.getSimpleName((String)orderedHashSet.get(i), bitMap.isSet(i));
        }
        return simpleNameArray;
    }

    int XreadUnionType() {
        int n = 0;
        switch (this.token.tokenType) {
            case 314: {
                this.read();
                n = 1;
                if (this.token.tokenType == 2) {
                    n = 2;
                    this.read();
                    break;
                }
                if (this.token.tokenType != 90) break;
                this.read();
                break;
            }
            case 148: {
                this.read();
                n = 3;
                if (this.token.tokenType == 2) {
                    n = 4;
                    this.read();
                    break;
                }
                if (this.token.tokenType != 90) break;
                this.read();
                break;
            }
            case 106: 
            case 642: {
                this.read();
                n = 6;
                if (this.token.tokenType == 2) {
                    n = 5;
                    this.read();
                    break;
                }
                if (this.token.tokenType != 90) break;
                this.read();
                break;
            }
        }
        return n;
    }

    void XreadUnionCorrespondingClause(QueryExpression queryExpression) {
        if (this.token.tokenType == 55) {
            this.read();
            queryExpression.setUnionCorresoponding();
            if (this.token.tokenType == 27) {
                this.read();
                OrderedHashSet orderedHashSet = this.readColumnNames(false);
                queryExpression.setUnionCorrespondingColumns(orderedHashSet);
            }
        }
    }

    QueryExpression XreadQueryExpression() {
        Cloneable cloneable;
        HsqlNameManager.HsqlName[] hsqlNameArray;
        if (this.token.tokenType == 337) {
            this.read();
            boolean bl = this.readIfThis(234);
            this.compileContext.unregisterSubqueries();
            while (true) {
                this.checkIsSimpleName();
                hsqlNameArray = null;
                HsqlNameManager.HsqlName hsqlName = this.database.nameManager.newHsqlName(this.token.tokenString, this.isDelimitedIdentifier(), 27);
                hsqlName.schema = SqlInvariants.SYSTEM_SCHEMA_HSQLNAME;
                this.read();
                this.compileContext.registerSubquery(hsqlName.name);
                if (this.token.tokenType == 936) {
                    hsqlNameArray = this.readColumnNames(hsqlName);
                } else if (bl) {
                    throw this.unexpectedTokenRequire("(");
                }
                this.readThis(11);
                this.readThis(936);
                cloneable = this.XreadTableNamedSubqueryBody(hsqlName, hsqlNameArray, bl ? 24 : 23);
                this.readThis(922);
                if (this.token.tokenType == 76) {
                    throw this.unsupportedFeature();
                }
                if (bl && this.token.tokenType == 76) {
                    Cloneable cloneable2 = cloneable;
                    int[] nArray = this.readColumnList((Table)cloneable2, false);
                    this.readThis(268);
                    this.checkIsSimpleName();
                    HsqlNameManager.HsqlName hsqlName2 = this.database.nameManager.newColumnHsqlName(((Table)cloneable2).getName(), this.token.tokenString, this.token.isDelimitedIdentifier);
                    ColumnSchema columnSchema = new ColumnSchema(hsqlName2, null, true, false, null);
                    if (((Table)cloneable2).getColumnIndex(hsqlName2.name) != -1) {
                        throw Error.error(5578, this.token.tokenString);
                    }
                    this.read();
                    this.readThis(301);
                    String string = this.readQuotedString();
                    if (string.length() != 1) {
                        throw this.unexpectedToken(string);
                    }
                    this.readThis(83);
                    String string2 = this.readQuotedString();
                    if (string2.length() != 1) {
                        throw this.unexpectedToken(string2);
                    }
                    if (string.equals(string2)) {
                        throw this.unexpectedToken(string);
                    }
                    this.readThis(322);
                    this.checkIsSimpleName();
                    this.checkIsSimpleName();
                    hsqlName2 = this.database.nameManager.newColumnHsqlName(((Table)cloneable2).getName(), this.token.tokenString, this.token.isDelimitedIdentifier);
                    if (((Table)cloneable2).getColumnIndex(hsqlName2.name) != -1) {
                        throw Error.error(5578, this.token.tokenString);
                    }
                    this.read();
                    ColumnSchema columnSchema2 = new ColumnSchema(hsqlName2, null, true, false, null);
                }
                this.compileContext.registerSubquery(hsqlName.name, (TableDerived)cloneable);
                if (this.token.tokenType != 924) break;
                this.read();
            }
        }
        QueryExpression queryExpression = this.XreadQueryExpressionBody();
        hsqlNameArray = this.XreadOrderByExpression();
        if (queryExpression.sortAndSlice == SortAndSlice.noSort) {
            queryExpression.addSortAndSlice((SortAndSlice)hsqlNameArray);
        } else if (queryExpression.sortAndSlice.hasLimit()) {
            if (hsqlNameArray.hasLimit()) {
                throw Error.error(5549);
            }
            for (int i = 0; i < hsqlNameArray.exprList.size(); ++i) {
                cloneable = (Expression)hsqlNameArray.exprList.get(i);
                queryExpression.sortAndSlice.addOrderExpression((Expression)cloneable);
            }
        } else if (hsqlNameArray != SortAndSlice.noSort) {
            queryExpression.addSortAndSlice((SortAndSlice)hsqlNameArray);
        }
        this.compileContext.unregisterSubqueries();
        return queryExpression;
    }

    QueryExpression XreadQueryExpressionBody() {
        QueryExpression queryExpression = this.XreadQueryTerm();
        block3: while (true) {
            switch (this.token.tokenType) {
                case 106: 
                case 314: 
                case 642: {
                    queryExpression = this.XreadSetOperation(queryExpression);
                    continue block3;
                }
            }
            break;
        }
        return queryExpression;
    }

    QueryExpression XreadQueryTerm() {
        QueryExpression queryExpression = this.XreadQueryPrimary();
        while (this.token.tokenType == 148) {
            queryExpression = this.XreadSetOperation(queryExpression);
        }
        return queryExpression;
    }

    private QueryExpression XreadSetOperation(QueryExpression queryExpression) {
        queryExpression = new QueryExpression(this.compileContext, queryExpression);
        int n = this.XreadUnionType();
        this.XreadUnionCorrespondingClause(queryExpression);
        QueryExpression queryExpression2 = this.XreadQueryTerm();
        queryExpression.addUnion(queryExpression2, n);
        return queryExpression;
    }

    QueryExpression XreadQueryPrimary() {
        switch (this.token.tokenType) {
            case 265: 
            case 294: 
            case 325: {
                QuerySpecification querySpecification = this.XreadSimpleTable();
                return querySpecification;
            }
            case 936: {
                this.read();
                QueryExpression queryExpression = this.XreadQueryExpressionBody();
                SortAndSlice sortAndSlice = this.XreadOrderByExpression();
                this.readThis(922);
                if (queryExpression.sortAndSlice == SortAndSlice.noSort) {
                    queryExpression.addSortAndSlice(sortAndSlice);
                } else if (queryExpression.sortAndSlice.hasLimit()) {
                    if (sortAndSlice.hasLimit()) {
                        throw Error.error(5549);
                    }
                    for (int i = 0; i < sortAndSlice.exprList.size(); ++i) {
                        Expression expression = (Expression)sortAndSlice.exprList.get(i);
                        queryExpression.sortAndSlice.addOrderExpression(expression);
                    }
                } else if (sortAndSlice != SortAndSlice.noSort) {
                    queryExpression.addSortAndSlice(sortAndSlice);
                }
                return queryExpression;
            }
        }
        throw this.unexpectedToken();
    }

    QuerySpecification XreadSimpleTable() {
        QuerySpecification querySpecification;
        switch (this.token.tokenType) {
            case 294: {
                this.read();
                Table table = this.readNamedSubqueryOrNull();
                if (table == null) {
                    table = this.readTableName(true);
                }
                if (table.isView()) {
                    table = ((View)table).newDerivedTable(this.session, this.compileContext);
                }
                querySpecification = new QuerySpecification(this.session, table, this.compileContext, false);
                break;
            }
            case 325: {
                this.read();
                TableDerived tableDerived = this.XreadRowValueExpressionList();
                querySpecification = new QuerySpecification(this.session, tableDerived, this.compileContext, true);
                break;
            }
            case 265: {
                querySpecification = this.XreadQuerySpecification();
                break;
            }
            default: {
                throw this.unexpectedToken();
            }
        }
        return querySpecification;
    }

    QuerySpecification XreadQuerySpecification() {
        QuerySpecification querySpecification = this.XreadSelect();
        if (!querySpecification.isValueList && querySpecification.getCurrentRangeVariableCount() == 0) {
            this.XreadTableExpression(querySpecification);
        }
        return querySpecification;
    }

    void XreadTableExpression(QuerySpecification querySpecification) {
        this.XreadFromClause(querySpecification);
        this.readWhereGroupHaving(querySpecification);
    }

    QuerySpecification XreadSelect() {
        QuerySpecification querySpecification;
        block10: {
            Object object;
            querySpecification = new QuerySpecification(this.compileContext);
            this.readThis(265);
            if ((this.token.tokenType == 670 || this.token.tokenType == 630) && (object = this.XreadTopOrLimit()) != null) {
                querySpecification.addSortAndSlice((SortAndSlice)object);
            }
            if (this.token.tokenType == 90) {
                querySpecification.setDistinctSelect();
                this.read();
            } else if (this.token.tokenType == 2) {
                this.read();
            }
            do {
                object = this.XreadValueExpression();
                if (this.token.tokenType == 11) {
                    if (((Expression)object).getType() == 96) {
                        throw this.unexpectedToken();
                    }
                    this.read();
                    this.checkIsNonCoreReservedIdentifier();
                }
                if (this.isNonCoreReservedIdentifier()) {
                    if (((Expression)object).getType() == 96) {
                        throw this.unexpectedToken();
                    }
                    ((Expression)object).setAlias(HsqlNameManager.getSimpleName(this.token.tokenString, this.isDelimitedIdentifier()));
                    this.read();
                }
                querySpecification.addSelectColumnExpression((Expression)object);
                if (this.token.tokenType == 124 || this.token.tokenType == 151) break block10;
            } while (this.readIfThis(924));
            if ((this.token.tokenType == 922 || this.token.tokenType == 1014 || this.token.tokenType == 941) && (this.database.sqlSyntaxMss || this.database.sqlSyntaxMys || this.database.sqlSyntaxPgs)) {
                RangeVariable rangeVariable = new RangeVariable(this.database.schemaManager.dualTable, null, null, null, this.compileContext);
                querySpecification.addRangeVariable(this.session, rangeVariable);
                return querySpecification;
            }
            throw this.unexpectedToken();
        }
        return querySpecification;
    }

    void XreadFromClause(QuerySpecification querySpecification) {
        this.readThis(124);
        do {
            this.XreadTableReference(querySpecification);
        } while (this.readIfThis(924));
    }

    void XreadTableReference(QuerySpecification querySpecification) {
        boolean bl = false;
        RangeVariable rangeVariable = this.readTableOrSubquery();
        querySpecification.addRangeVariable(this.session, rangeVariable);
        block15: while (true) {
            boolean bl2 = false;
            boolean bl3 = false;
            boolean bl4 = false;
            int n = this.token.tokenType;
            switch (this.token.tokenType) {
                case 186: {
                    if (bl) {
                        throw this.unexpectedToken();
                    }
                    this.read();
                    bl = true;
                    continue block15;
                }
                case 142: {
                    this.read();
                    this.readThis(154);
                    break;
                }
                case 60: {
                    if (bl) {
                        throw this.unexpectedToken();
                    }
                    this.read();
                    this.readThis(154);
                    break;
                }
                case 314: {
                    if (bl) {
                        throw this.unexpectedToken();
                    }
                    int n2 = this.getPosition();
                    this.read();
                    if (this.token.tokenType == 154) {
                        this.read();
                        bl2 = true;
                        bl3 = true;
                        break;
                    }
                    this.rewind(n2);
                    bl4 = true;
                    break;
                }
                case 163: {
                    this.read();
                    this.readIfThis(210);
                    this.readThis(154);
                    bl2 = true;
                    break;
                }
                case 254: {
                    this.read();
                    this.readIfThis(210);
                    this.readThis(154);
                    bl3 = true;
                    break;
                }
                case 125: {
                    this.read();
                    this.readIfThis(210);
                    this.readThis(154);
                    bl2 = true;
                    bl3 = true;
                    break;
                }
                case 154: {
                    this.read();
                    n = 142;
                    break;
                }
                default: {
                    if (bl) {
                        throw this.unexpectedToken();
                    }
                    bl4 = true;
                }
            }
            if (bl4) break;
            RangeVariable rangeVariable2 = this.readTableOrSubquery();
            Expression expression = null;
            rangeVariable2.setJoinType(bl2, bl3);
            switch (n) {
                case 60: {
                    querySpecification.addRangeVariable(this.session, rangeVariable2);
                    break;
                }
                case 314: {
                    expression = Expression.EXPR_FALSE;
                    rangeVariable2.addJoinCondition(expression);
                    querySpecification.addRangeVariable(this.session, rangeVariable2);
                    break;
                }
                case 125: 
                case 142: 
                case 163: 
                case 254: {
                    OrderedHashSet orderedHashSet;
                    boolean bl5;
                    boolean bl6 = bl5 = this.token.tokenType == 322;
                    if (bl || bl5) {
                        rangeVariable.resolveRangeTable(this.session, RangeGroup.emptyGroup, this.compileContext.getOuterRanges());
                        rangeVariable2.resolveRangeTable(this.session, RangeGroup.emptyGroup, this.compileContext.getOuterRanges());
                    }
                    if (bl) {
                        orderedHashSet = rangeVariable2.getUniqueColumnNameSet();
                        expression = querySpecification.getEquiJoinExpressions(orderedHashSet, rangeVariable2, false);
                        rangeVariable2.addJoinCondition(expression);
                        querySpecification.addRangeVariable(this.session, rangeVariable2);
                        break;
                    }
                    if (bl5) {
                        this.read();
                        orderedHashSet = new OrderedHashSet();
                        this.readThis(936);
                        this.readSimpleColumnNames(orderedHashSet, rangeVariable2, false);
                        this.readThis(922);
                        expression = querySpecification.getEquiJoinExpressions(orderedHashSet, rangeVariable2, true);
                        rangeVariable2.addJoinCondition(expression);
                        querySpecification.addRangeVariable(this.session, rangeVariable2);
                        break;
                    }
                    if (this.token.tokenType == 204) {
                        this.read();
                        expression = this.XreadBooleanValueExpression();
                        rangeVariable2.addJoinCondition(expression);
                        querySpecification.addRangeVariable(this.session, rangeVariable2);
                        break;
                    }
                    throw this.unexpectedToken();
                }
            }
            bl = false;
        }
    }

    Expression getRowExpression(OrderedHashSet orderedHashSet) {
        Expression[] expressionArray = new Expression[orderedHashSet.size()];
        for (int i = 0; i < expressionArray.length; ++i) {
            String string = (String)orderedHashSet.get(i);
            expressionArray[i] = new ExpressionColumn(null, null, string);
        }
        return new Expression(25, expressionArray);
    }

    void readWhereGroupHaving(QuerySpecification querySpecification) {
        Expression expression;
        if (this.token.tokenType == 334) {
            this.read();
            expression = this.XreadBooleanValueExpression();
            querySpecification.addQueryCondition(expression);
        }
        if (this.token.tokenType == 131) {
            this.read();
            this.readThis(27);
            while (true) {
                expression = this.XreadValueExpression();
                querySpecification.addGroupByColumnExpression(expression);
                if (this.token.tokenType != 924) break;
                this.read();
            }
        }
        if (this.token.tokenType == 135) {
            this.read();
            expression = this.XreadBooleanValueExpression();
            querySpecification.addHavingExpression(expression);
        }
    }

    SortAndSlice XreadOrderByExpression() {
        SortAndSlice sortAndSlice = null;
        if (this.token.tokenType == 208) {
            this.read();
            this.readThis(27);
            sortAndSlice = this.XreadOrderBy();
        }
        if (this.token.tokenType == 630 || this.token.tokenType == 115 || this.token.tokenType == 202) {
            if (sortAndSlice == null) {
                sortAndSlice = new SortAndSlice();
            }
            this.XreadLimit(sortAndSlice);
        }
        return sortAndSlice == null ? SortAndSlice.noSort : sortAndSlice;
    }

    private SortAndSlice XreadTopOrLimit() {
        int n;
        Expression expression = null;
        Expression expression2 = null;
        if (this.token.tokenType == 630) {
            n = this.getPosition();
            this.read();
            expression = this.XreadSimpleValueSpecificationOrNull();
            if (expression == null) {
                this.rewind(n);
                return null;
            }
            this.readIfThis(924);
            expression2 = this.XreadSimpleValueSpecificationOrNull();
            if (expression2 == null) {
                throw Error.error(5563, 81);
            }
        } else if (this.token.tokenType == 670) {
            n = this.getPosition();
            this.read();
            expression2 = this.XreadSimpleValueSpecificationOrNull();
            if (expression2 == null) {
                this.rewind(n);
                return null;
            }
            expression = new ExpressionValue(ValuePool.INTEGER_0, Type.SQL_INTEGER);
        } else {
            throw this.unexpectedToken();
        }
        n = 1;
        if (expression.isUnresolvedParam()) {
            expression.setDataType(this.session, Type.SQL_INTEGER);
        } else if (expression.opType == 1) {
            n = expression.getDataType().typeCode == 4 && (Integer)expression.getValue(null) >= 0 ? 1 : 0;
        } else {
            throw Error.error(5563, 81);
        }
        if (expression2.isUnresolvedParam()) {
            expression2.setDataType(this.session, Type.SQL_INTEGER);
        } else if (expression2.opType == 1) {
            n &= expression2.getDataType().typeCode == 4 && (Integer)expression2.getValue(null) >= 0 ? 1 : 0;
        } else {
            throw Error.error(5563, 81);
        }
        if (n != 0) {
            SortAndSlice sortAndSlice = new SortAndSlice();
            sortAndSlice.addLimitCondition(new ExpressionOp(94, expression, expression2));
            return sortAndSlice;
        }
        throw Error.error(5563, 81);
    }

    private void XreadLimit(SortAndSlice sortAndSlice) {
        Expression expression = null;
        Expression expression2 = null;
        if (this.token.tokenType == 202) {
            this.read();
            expression = this.XreadSimpleValueSpecificationOrNull();
            if (expression == null) {
                throw Error.error(5563, 81);
            }
            if (this.token.tokenType == 257 || this.token.tokenType == 259) {
                this.read();
            }
        }
        if (this.token.tokenType == 630) {
            this.read();
            expression2 = this.XreadSimpleValueSpecificationOrNull();
            if (expression2 == null) {
                throw Error.error(5563, 81);
            }
            if (expression == null) {
                if (this.token.tokenType == 924) {
                    this.read();
                    expression = expression2;
                    expression2 = this.XreadSimpleValueSpecificationOrNull();
                } else if (this.token.tokenType == 202) {
                    this.read();
                    expression = this.XreadSimpleValueSpecificationOrNull();
                }
            }
            if (this.database.sqlSyntaxPgs || this.database.sqlSyntaxMys) {
                sortAndSlice.setZeroLimit();
            }
        } else if (this.token.tokenType == 115) {
            this.read();
            if (this.token.tokenType == 423 || this.token.tokenType == 470) {
                this.read();
            }
            if ((expression2 = this.XreadSimpleValueSpecificationOrNull()) == null) {
                expression2 = new ExpressionValue(ValuePool.INTEGER_1, Type.SQL_INTEGER);
            }
            if (this.token.tokenType == 257 || this.token.tokenType == 259) {
                this.read();
            }
            this.readThis(205);
            sortAndSlice.setStrictLimit();
        }
        if (sortAndSlice.hasOrder() && this.token.tokenType == 322) {
            this.read();
            this.readThis(625);
            sortAndSlice.setUsingIndex();
        }
        if (expression == null) {
            expression = new ExpressionValue(ValuePool.INTEGER_0, Type.SQL_INTEGER);
        }
        boolean bl = true;
        if (expression.isUnresolvedParam()) {
            expression.setDataType(this.session, Type.SQL_INTEGER);
        }
        if (expression2 != null && expression2.isUnresolvedParam()) {
            expression2.setDataType(this.session, Type.SQL_INTEGER);
        }
        if (bl) {
            sortAndSlice.addLimitCondition(new ExpressionOp(94, expression, expression2));
            return;
        }
        throw Error.error(5563, 81);
    }

    private SortAndSlice XreadOrderBy() {
        SortAndSlice sortAndSlice = new SortAndSlice();
        while (true) {
            boolean bl = false;
            boolean bl2 = false;
            Expression expression = this.XreadValueExpression();
            ExpressionOrderBy expressionOrderBy = new ExpressionOrderBy(expression);
            if (this.token.tokenType == 410) {
                expressionOrderBy.setDescending();
                bl = true;
                this.read();
            } else if (this.token.tokenType == 359) {
                this.read();
            }
            bl2 = this.database.sqlNullsOrder ? !this.database.sqlNullsFirst : this.database.sqlNullsFirst == bl;
            expressionOrderBy.setNullsLast(bl2);
            if (this.token.tokenType == 473) {
                this.read();
                if (this.token.tokenType == 423) {
                    this.read();
                    expressionOrderBy.setNullsLast(false);
                } else if (this.token.tokenType == 452) {
                    this.read();
                    expressionOrderBy.setNullsLast(true);
                } else {
                    throw this.unexpectedToken();
                }
            }
            sortAndSlice.addOrderExpression(expressionOrderBy);
            if (this.token.tokenType != 924) break;
            this.read();
        }
        return sortAndSlice;
    }

    protected RangeVariable readRangeVariableForDataChange(int n) {
        Table table = this.readTableName(true);
        ExpressionPeriodOp expressionPeriodOp = this.XreadQueryApplicationPeriodSpecOrNull(table);
        HsqlNameManager.SimpleName simpleName = null;
        if (expressionPeriodOp != null) {
            throw Error.error(1551);
        }
        if (n != 1215) {
            switch (this.token.tokenType) {
                case 483: {
                    break;
                }
                case 11: {
                    this.read();
                    this.checkIsNonCoreReservedIdentifier();
                }
                default: {
                    if (!this.isNonCoreReservedIdentifier() || this.database.sqlSyntaxMys && n == 55) break;
                    simpleName = HsqlNameManager.getSimpleName(this.token.tokenString, this.isDelimitedIdentifier());
                    this.read();
                }
            }
            if (simpleName == null && this.lastSynonym != null) {
                simpleName = HsqlNameManager.getSimpleName(this.lastSynonym.name, this.lastSynonym.isNameQuoted);
            }
        }
        if (table.isView) {
            switch (n) {
                case 56: {
                    if (table.isTriggerUpdatable() && table.isTriggerInsertable() || !table.isTriggerUpdatable() && !table.isTriggerInsertable() && table.isUpdatable() && table.isInsertable()) break;
                    throw Error.error(5545);
                }
                case 92: {
                    if (table.isTriggerUpdatable() || table.isUpdatable()) break;
                    throw Error.error(5545);
                }
                case 19: {
                    if (table.isTriggerDeletable() || table.isUpdatable()) break;
                    throw Error.error(5545);
                }
                case 55: {
                    if (table.isTriggerInsertable() || table.isInsertable() || this.session.isProcessingScript()) break;
                    throw Error.error(5545);
                }
                case 1215: {
                    throw Error.error(5545);
                }
            }
            table = ((View)table).newDerivedTable(this.session, this.compileContext);
        }
        RangeVariable rangeVariable = new RangeVariable(table, simpleName, null, null, this.compileContext);
        if (table.isSystemVersioned()) {
            ExpressionPeriodOp expressionPeriodOp2 = new ExpressionPeriodOp();
            expressionPeriodOp2.setSystemRangeVariable(this.session, rangeVariable);
            rangeVariable.setSystemPeriodCondition(expressionPeriodOp2);
        }
        return rangeVariable;
    }

    protected Table readNamedSubqueryOrNull() {
        if (!this.isSimpleName()) {
            return null;
        }
        TableDerived tableDerived = this.compileContext.getNamedSubQuery(this.token.tokenString);
        if (tableDerived == null) {
            return null;
        }
        this.read();
        if (tableDerived.isRecompiled()) {
            tableDerived = tableDerived.newDerivedTable(this.session, this.compileContext);
        }
        return tableDerived;
    }

    protected RangeVariable readTableOrSubquery() {
        RangeVariable rangeVariable;
        Table table = null;
        HsqlNameManager.SimpleName simpleName = null;
        HsqlNameManager.SimpleName[] simpleNameArray = null;
        OrderedHashSet orderedHashSet = null;
        ExpressionPeriodOp expressionPeriodOp = null;
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        switch (this.token.tokenType) {
            case 936: {
                table = this.XreadTableSubqueryOrNull(false);
                if (table != null) break;
                table = this.XreadJoinedTableAsSubqueryOrNull();
                if (table == null) {
                    table = this.XreadTableSubqueryOrNull(true);
                    if (table != null) break;
                    throw this.unexpectedToken();
                }
                bl = true;
                break;
            }
            case 317: {
                Expression expression = this.XreadCollectionDerivedTable(23);
                table = expression.getTable();
                bl2 = true;
                break;
            }
            case 159: {
                Expression expression = this.XreadLateralDerivedTable();
                table = expression.getTable();
                bl2 = true;
                break;
            }
            case 294: {
                Expression expression = this.XreadTableFunctionDerivedTable();
                table = expression.getTable();
                bl2 = true;
                break;
            }
            default: {
                table = this.readNamedSubqueryOrNull();
                if (table == null) {
                    table = this.readTableName(true);
                    bl3 = true;
                    expressionPeriodOp = this.XreadQuerySystemPeriodSpecOrNull(table);
                }
                if (!table.isView()) break;
                table = ((View)table).newDerivedTable(this.session, this.compileContext);
            }
        }
        boolean bl4 = false;
        if (this.token.tokenType == 11) {
            this.read();
            this.checkIsNonCoreReservedIdentifier();
            bl4 = true;
        }
        if (this.isNonCoreReservedIdentifier()) {
            boolean bl5 = this.token.tokenType == 630 || this.token.tokenType == 202 || this.token.tokenType == 115;
            boolean bl6 = this.token.tokenType == 642;
            int n = this.getPosition();
            simpleName = HsqlNameManager.getSimpleName(this.token.tokenString, this.isDelimitedIdentifier());
            this.read();
            if (this.token.tokenType == 936) {
                orderedHashSet = new OrderedHashSet();
                simpleNameArray = this.readColumnNameList(orderedHashSet);
            } else if (!bl4 && bl5) {
                if (this.token.tokenType == 923 || this.token.tokenType == 938 || this.token.tokenType == 1011) {
                    simpleName = null;
                    this.rewind(n);
                }
            } else if (!bl4 && bl6) {
                this.rewind(n);
            }
        }
        if (bl3 && simpleName == null && this.lastSynonym != null) {
            simpleName = HsqlNameManager.getSimpleName(this.lastSynonym.name, this.lastSynonym.isNameQuoted);
        }
        if (this.database.sqlSyntaxMss && this.readIfThis(337)) {
            this.readNestedParenthesisedTokens();
        }
        if (bl) {
            rangeVariable = new RangeVariableJoined(table, simpleName, orderedHashSet, simpleNameArray, this.compileContext);
        } else {
            rangeVariable = new RangeVariable(table, simpleName, orderedHashSet, simpleNameArray, this.compileContext);
            if (expressionPeriodOp != null) {
                expressionPeriodOp.setSystemRangeVariable(this.session, rangeVariable);
                rangeVariable.setSystemPeriodCondition(expressionPeriodOp);
            }
        }
        if (bl2) {
            rangeVariable.isLateral = true;
        }
        return rangeVariable;
    }

    private Expression readAggregateFunctionOrNull() {
        int n = this.getPosition();
        int n2 = this.token.tokenType;
        this.read();
        if (this.token.tokenType != 936) {
            this.rewind(n);
            return null;
        }
        this.readThis(936);
        Expression expression = this.readAggregateExpression(n2);
        this.readThis(922);
        this.readFilterClause(expression);
        return expression;
    }

    private void readFilterClause(Expression expression) {
        ExpressionLogical expressionLogical = this.XreadFilterExpressionOrNull();
        if (expressionLogical != null) {
            expression.setCondition(expressionLogical);
        }
    }

    ExpressionLogical XreadFilterExpressionOrNull() {
        int n = this.getPosition();
        ExpressionLogical expressionLogical = null;
        if (this.token.tokenType == 116) {
            this.read();
            if (this.token.tokenType != 936) {
                this.rewind(n);
                return null;
            }
            this.readThis(936);
            this.readThis(334);
            expressionLogical = (ExpressionLogical)this.XreadBooleanValueExpression();
            this.readThis(922);
        }
        return expressionLogical;
    }

    private Expression readAggregateExpression(int n) {
        int n2 = ParserDQL.getExpressionType(n);
        boolean bl = false;
        boolean bl2 = false;
        SortAndSlice sortAndSlice = null;
        String string = null;
        if (this.token.tokenType == 90) {
            bl = true;
            this.read();
        } else if (this.token.tokenType == 2) {
            bl2 = true;
            this.read();
        }
        int n3 = this.getPosition();
        Expression expression = this.XreadValueExpression();
        switch (n2) {
            case 74: {
                if (expression.getType() == 96) {
                    if (((ExpressionColumn)expression).tableName != null) {
                        throw this.unexpectedToken();
                    }
                    if (bl2 || bl) {
                        throw this.unexpectedToken();
                    }
                    expression.opType = 11;
                    break;
                }
                if (this.token.tokenType != 924) break;
                this.rewind(n3);
                expression = this.XreadRowElementList(false);
                break;
            }
            case 81: 
            case 82: 
            case 83: 
            case 84: {
                if (!bl2 && !bl) break;
                throw this.unexpectedToken(bl2 ? "ALL" : "DISTINCT");
            }
            case 85: 
            case 86: {
                if (this.token.tokenType == 208) {
                    this.read();
                    this.readThis(27);
                    sortAndSlice = this.XreadOrderBy();
                }
                if (n2 == 86 && this.token.tokenType == 662) {
                    this.read();
                    this.checkIsQuotedString();
                    string = (String)this.token.tokenValue;
                    this.read();
                }
                return new ExpressionArrayAggregate(n2, bl, expression, sortAndSlice, string);
            }
            case 88: {
                return new ExpressionArrayAggregate(n2, bl, expression, sortAndSlice, string);
            }
            default: {
                if (expression.getType() != 96 && expression.getType() != 11) break;
                throw this.unexpectedToken("*");
            }
        }
        ExpressionAggregate expressionAggregate = new ExpressionAggregate(n2, bl, expression);
        return expressionAggregate;
    }

    Expression XreadValueSpecificationOrNull() {
        Expression expression = null;
        boolean bl = false;
        switch (this.token.tokenType) {
            case 937: {
                this.read();
                break;
            }
            case 934: {
                this.read();
                bl = true;
                break;
            }
        }
        expression = this.XreadUnsignedValueSpecificationOrNull();
        if (expression == null) {
            return null;
        }
        if (bl) {
            expression = new ExpressionArithmetic(31, expression);
        }
        return expression;
    }

    Expression XreadUnsignedValueSpecificationOrNull() {
        switch (this.token.tokenType) {
            case 310: {
                this.read();
                return Expression.EXPR_TRUE;
            }
            case 114: {
                this.read();
                return Expression.EXPR_FALSE;
            }
            case 83: {
                if (!this.compileContext.contextuallyTypedExpression) break;
                this.read();
                ExpressionColumn expressionColumn = new ExpressionColumn(4);
                return expressionColumn;
            }
            case 196: {
                ExpressionValue expressionValue = new ExpressionValue(null, null);
                this.read();
                return expressionValue;
            }
            case 1011: {
                ExpressionValue expressionValue = new ExpressionValue(this.token.tokenValue, this.token.dataType);
                this.read();
                return expressionValue;
            }
            case 1012: 
            case 1013: {
                if (!this.token.isHostParameter) {
                    return null;
                }
                return null;
            }
            case 923: {
                this.read();
                if (this.token.tokenType != 1013 && this.token.tokenType != 1012) {
                    throw this.unexpectedToken(":");
                }
            }
            case 938: {
                ExpressionColumn expressionColumn = new ExpressionColumn(8);
                this.compileContext.addParameter(expressionColumn, this.getPosition());
                this.read();
                return expressionColumn;
            }
            case 379: {
                return this.XreadCurrentCollationSpec();
            }
            case 64: 
            case 66: 
            case 67: 
            case 68: 
            case 70: 
            case 73: 
            case 74: 
            case 267: 
            case 293: 
            case 321: 
            case 323: {
                FunctionSQL functionSQL = FunctionSQL.newSQLFunction(this.token.tokenString, this.compileContext);
                if (functionSQL == null) {
                    return null;
                }
                return this.readSQLFunction(functionSQL);
            }
        }
        return null;
    }

    Expression XreadSimpleValueSpecificationOrNull() {
        switch (this.token.tokenType) {
            case 1011: {
                ExpressionValue expressionValue = new ExpressionValue(this.token.tokenValue, this.token.dataType);
                this.read();
                return expressionValue;
            }
            case 923: {
                this.read();
                if (this.token.tokenType != 1013 && this.token.tokenType != 1012) {
                    throw this.unexpectedToken(":");
                }
            }
            case 938: {
                ExpressionColumn expressionColumn = new ExpressionColumn(8);
                this.compileContext.addParameter(expressionColumn, this.getPosition());
                this.read();
                return expressionColumn;
            }
            case 1012: 
            case 1013: {
                this.checkValidCatalogName(this.token.namePrePrePrefix);
                ExpressionColumn expressionColumn = new ExpressionColumn(this.token.namePrePrefix, this.token.namePrefix, this.token.tokenString);
                this.read();
                return expressionColumn;
            }
        }
        return null;
    }

    Expression XreadAllTypesValueExpressionPrimary(boolean bl) {
        Expression expression = null;
        int n = this.getPosition();
        switch (this.token.tokenType) {
            case 109: 
            case 315: {
                if (!bl) break;
                return this.XreadPredicate();
            }
            case 220: {
                if (bl) break;
                this.read();
                if (this.readIfThis(936)) {
                    expression = this.XreadRowElementList(true);
                    if (expression.nodes.length != 2) {
                        throw Error.error(5564);
                    }
                    expression = new ExpressionPeriod(expression);
                    this.readThis(922);
                    break;
                }
                this.rewind(n);
                expression = this.XreadSimpleValueExpressionPrimary();
                if (expression == null) break;
                expression = this.XreadArrayElementReference(expression);
                break;
            }
            case 257: {
                if (bl) break;
                this.read();
                this.readThis(936);
                expression = this.XreadRowElementList(true);
                this.readThis(922);
                break;
            }
            default: {
                expression = this.XreadSimpleValueExpressionPrimary();
                if (expression == null) break;
                expression = this.XreadArrayElementReference(expression);
            }
        }
        if (expression == null) {
            if (this.token.tokenType == 257) {
                this.read();
                this.checkIsThis(936);
            } else if (this.token.tokenType == 220) {
                this.read();
                this.readThis(936);
                expression = this.XreadRowElementList(true);
                if (expression.nodes.length != 2) {
                    throw Error.error(5564);
                }
                expression = new ExpressionPeriod(expression);
                this.readThis(922);
            }
            if (this.token.tokenType == 936) {
                this.read();
                expression = this.XreadRowElementList(true);
                this.readThis(922);
            }
        }
        if (bl && expression != null) {
            expression = this.XreadPredicateRightPart(expression);
        }
        return expression;
    }

    Expression XreadValueExpressionPrimary() {
        Expression expression = this.XreadSimpleValueExpressionPrimary();
        if (expression != null) {
            expression = this.XreadArrayElementReference(expression);
            return expression;
        }
        if (this.token.tokenType != 936) {
            return null;
        }
        this.read();
        expression = this.XreadValueExpression();
        this.readThis(922);
        return expression;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    Expression XreadSimpleValueExpressionPrimary() {
        Expression expression = this.XreadUnsignedValueSpecificationOrNull();
        if (expression != null) {
            return expression;
        }
        int n = this.getPosition();
        switch (this.token.tokenType) {
            case 936: {
                this.read();
                int n2 = this.getPosition();
                this.readOpenBrackets();
                switch (this.token.tokenType) {
                    case 265: 
                    case 294: 
                    case 325: {
                        TableDerived tableDerived = null;
                        this.rewind(n2);
                        try {
                            tableDerived = this.XreadSubqueryTableBody(21);
                            this.readThis(922);
                        }
                        catch (HsqlException hsqlException) {
                            hsqlException.setLevel(this.compileContext.subqueryDepth);
                            if (this.lastError == null || this.lastError.getLevel() < hsqlException.getLevel()) {
                                this.lastError = hsqlException;
                            }
                            this.rewind(n);
                            return null;
                        }
                        if (tableDerived.queryExpression != null) {
                            expression = tableDerived.queryExpression.isSingleColumn() ? new Expression(21, tableDerived) : new Expression(22, tableDerived);
                        }
                        if (expression == null) break;
                        return expression;
                    }
                }
                this.rewind(n);
                return null;
            }
            case 921: {
                expression = new ExpressionColumn(this.token.namePrePrefix, this.token.namePrefix);
                this.getRecordedToken().setExpression(expression);
                this.read();
                return expression;
            }
            case 763: {
                expression = this.readLeastExpressionOrNull();
                if (expression == null) break;
                return expression;
            }
            case 751: {
                expression = this.readGreatestExpressionOrNull();
                if (expression == null) break;
                return expression;
            }
            case 743: {
                expression = this.readDecodeExpressionOrNull();
                if (expression == null) break;
                return expression;
            }
            case 717: {
                expression = this.readConcatExpressionOrNull();
                if (expression == null) break;
                return expression;
            }
            case 718: {
                expression = this.readConcatSeparatorExpressionOrNull();
                if (expression == null) break;
                return expression;
            }
            case 434: 
            case 594: {
                expression = this.readCaseWhenExpressionOrNull();
                if (expression == null) break;
                return expression;
            }
            case 32: {
                return this.readCaseExpression();
            }
            case 197: {
                return this.readNullIfExpression();
            }
            case 43: {
                return this.readCoalesceExpression();
            }
            case 753: 
            case 760: {
                expression = this.readIfNullExpressionOrNull();
                if (expression == null) break;
                return expression;
            }
            case 647: {
                expression = this.readIfNull2ExpressionOrNull();
                if (expression == null) break;
                return expression;
            }
            case 33: {
                expression = this.readCastExpression();
                if (expression == null) break;
                return expression;
            }
            case 53: {
                expression = this.readConvertExpressionOrNull();
                if (expression == null) break;
                return expression;
            }
            case 77: 
            case 150: 
            case 297: 
            case 298: {
                expression = this.readDateTimeIntervalLiteral(this.session);
                if (expression == null) break;
                return expression;
            }
            case 8: {
                return this.readCollection(19);
            }
            case 6: 
            case 9: 
            case 17: 
            case 56: 
            case 105: 
            case 173: 
            case 178: 
            case 272: 
            case 283: 
            case 284: 
            case 289: 
            case 326: 
            case 327: 
            case 639: 
            case 752: {
                expression = this.readAggregateFunctionOrNull();
                if (expression == null) break;
                return expression;
            }
            case 470: {
                expression = this.readSequenceExpressionOrNull(12);
                if (expression == null) break;
                return expression;
            }
            case 63: 
            case 652: {
                expression = this.readSequenceExpressionOrNull(13);
                if (expression == null) break;
                return expression;
            }
            case 604: {
                if (!this.database.sqlSyntaxPgs) break;
                this.read();
                this.readThis(936);
                String string = this.readQuotedString();
                Scanner scanner = this.session.getScanner();
                scanner.reset(this.session, string);
                scanner.scanNext();
                String string2 = this.session.getSchemaName(scanner.token.namePrefix);
                NumberSequence numberSequence = this.database.schemaManager.getSequence(scanner.token.tokenString, string2, true);
                expression = new ExpressionColumn(numberSequence, 13);
                this.readThis(922);
                return expression;
            }
            case 629: {
                if (!this.database.sqlSyntaxPgs) break;
                this.read();
                this.readThis(936);
                this.readThis(922);
                return FunctionCustom.newCustomFunction(this.session, "IDENTITY", 138);
            }
            case 644: {
                if (this.database.sqlSyntaxPgs) {
                    return this.readNextvalFunction();
                }
                if (!this.database.sqlSyntaxDb2 || (expression = this.readSequenceExpressionOrNull(12)) == null) break;
                return expression;
            }
            case 258: {
                this.read();
                if (this.token.tokenType == 936) {
                    this.read();
                    this.readThis(922);
                    this.readThis(211);
                    this.readThis(936);
                    this.readThis(922);
                    return new ExpressionColumn(14);
                }
                this.rewind(n);
                break;
            }
            case 660: {
                this.read();
                if (this.token.tokenType == 936) {
                    this.read();
                    if (this.token.tokenType == 922) {
                        this.read();
                        return new ExpressionColumn(14);
                    }
                    this.rewind(n);
                    break;
                }
                if (this.database.sqlSyntaxOra) return new ExpressionColumn(14);
                if (this.database.sqlSyntaxDb2) return new ExpressionColumn(14);
                this.rewind(n);
                break;
            }
            case 163: 
            case 254: {
                break;
            }
            case 294: {
                this.read();
                this.readThis(936);
                TableDerived tableDerived = this.XreadSubqueryTableBody(23);
                this.readThis(922);
                return new Expression(23, tableDerived);
            }
            default: {
                if (!this.isCoreReservedKey()) break;
                throw this.unexpectedToken();
            }
        }
        if (!(expression = this.readColumnOrFunctionExpression()).isSelfAggregate()) return expression;
        this.readFilterClause(expression);
        return expression;
    }

    Expression readNextvalFunction() {
        this.read();
        this.readThis(936);
        String string = this.readQuotedString();
        Scanner scanner = this.session.getScanner();
        scanner.reset(this.session, string);
        scanner.scanNext();
        String string2 = this.session.getSchemaName(scanner.token.namePrefix);
        NumberSequence numberSequence = this.database.schemaManager.getSequence(scanner.token.tokenString, string2, true);
        ExpressionColumn expressionColumn = new ExpressionColumn(numberSequence, 12);
        this.readThis(922);
        return expressionColumn;
    }

    Expression XreadAllTypesPrimary(boolean bl) {
        Expression expression = null;
        switch (this.token.tokenType) {
            case 1: 
            case 10: 
            case 30: 
            case 34: 
            case 35: 
            case 37: 
            case 39: 
            case 111: 
            case 113: 
            case 119: 
            case 166: 
            case 171: 
            case 174: 
            case 180: 
            case 192: 
            case 199: 
            case 200: 
            case 213: 
            case 222: 
            case 223: 
            case 224: 
            case 279: 
            case 286: 
            case 287: 
            case 304: 
            case 308: 
            case 320: 
            case 335: {
                FunctionSQL functionSQL = FunctionSQL.newSQLFunction(this.token.tokenString, this.compileContext);
                if (functionSQL == null) {
                    throw this.unsupportedFeature();
                }
                expression = this.readSQLFunction(functionSQL);
                if (expression != null) break;
            }
            default: {
                expression = this.XreadAllTypesValueExpressionPrimary(bl);
            }
        }
        expression = this.XreadModifier(expression);
        return expression;
    }

    Expression XreadModifier(Expression expression) {
        int n = this.getPosition();
        switch (this.token.tokenType) {
            case 14: {
                this.read();
                Expression expression2 = null;
                if (this.token.tokenType == 167) {
                    this.read();
                } else if (this.token.tokenType == 297) {
                    this.readThis(297);
                    this.readThis(571);
                    expression2 = this.XreadValueExpressionPrimary();
                    switch (this.token.tokenType) {
                        case 78: 
                        case 137: 
                        case 179: 
                        case 183: 
                        case 264: 
                        case 341: {
                            IntervalType intervalType = this.readIntervalType(this.session, false);
                            if (expression2.getType() == 33) {
                                expression2.dataType = intervalType;
                                break;
                            }
                            expression2 = new ExpressionOp(expression2, intervalType);
                            break;
                        }
                    }
                } else {
                    this.rewind(n);
                    return expression;
                }
                expression = new ExpressionOp(91, expression, expression2);
                break;
            }
            case 78: 
            case 137: 
            case 179: 
            case 183: 
            case 264: 
            case 341: {
                IntervalType intervalType = this.readIntervalType(this.session, true);
                if (expression.getType() == 33) {
                    expression.dataType = intervalType;
                    break;
                }
                expression = new ExpressionOp(expression, intervalType);
                break;
            }
            case 44: {
                this.read();
                Collation collation = this.database.schemaManager.getCollation(this.session, this.token.tokenString, this.token.namePrefix);
                expression.setCollation(collation);
                this.read();
            }
        }
        return expression;
    }

    Expression XreadValueExpressionWithContext() {
        this.compileContext.contextuallyTypedExpression = true;
        Expression expression = this.XreadValueExpression();
        this.compileContext.contextuallyTypedExpression = false;
        return expression;
    }

    Expression XreadValueExpression() {
        Expression expression = this.XreadAllTypesCommonValueExpression(true);
        if (this.token.tokenType == 931) {
            this.read();
            Expression expression2 = this.XreadNumericValueExpression();
            this.readThis(940);
            expression = new ExpressionAccessor(expression, expression2);
        }
        return expression;
    }

    Expression XreadRowOrCommonValueExpression() {
        return this.XreadAllTypesCommonValueExpression(false);
    }

    Expression XreadAllTypesCommonValueExpression(boolean bl) {
        Expression expression = this.XreadAllTypesTerm(bl);
        int n = 0;
        boolean bl2 = false;
        while (true) {
            switch (this.token.tokenType) {
                case 937: {
                    n = 32;
                    bl = false;
                    break;
                }
                case 934: {
                    n = 33;
                    bl = false;
                    break;
                }
                case 925: {
                    n = 36;
                    bl = false;
                    break;
                }
                case 207: {
                    if (bl) {
                        n = 50;
                        break;
                    }
                }
                default: {
                    bl2 = true;
                }
            }
            if (bl2) break;
            this.read();
            Expression expression2 = expression;
            expression = this.XreadAllTypesTerm(bl);
            expression = bl ? new ExpressionLogical(n, expression2, expression) : new ExpressionArithmetic(n, expression2, expression);
        }
        return expression;
    }

    Expression XreadAllTypesTerm(boolean bl) {
        Expression expression = this.XreadAllTypesFactor(bl);
        int n = 0;
        boolean bl2 = false;
        while (true) {
            switch (this.token.tokenType) {
                case 921: {
                    n = 34;
                    bl = false;
                    break;
                }
                case 926: {
                    n = 35;
                    bl = false;
                    break;
                }
                case 5: {
                    if (bl) {
                        n = 49;
                        break;
                    }
                }
                default: {
                    bl2 = true;
                }
            }
            if (bl2) break;
            this.read();
            Expression expression2 = expression;
            expression = this.XreadAllTypesFactor(bl);
            if (expression == null) {
                throw this.unexpectedToken();
            }
            expression = bl ? new ExpressionLogical(n, expression2, expression) : new ExpressionArithmetic(n, expression2, expression);
        }
        return expression;
    }

    Expression XreadAllTypesFactor(boolean bl) {
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        switch (this.token.tokenType) {
            case 937: {
                this.read();
                bl = false;
                break;
            }
            case 934: {
                this.read();
                bl = false;
                bl2 = true;
                break;
            }
            case 193: {
                if (!bl) break;
                this.read();
                bl3 = true;
                break;
            }
        }
        Expression expression = this.XreadAllTypesPrimary(bl);
        if (bl && this.token.tokenType == 152) {
            this.read();
            if (this.token.tokenType == 193) {
                this.read();
                boolean bl5 = bl3 = !bl3;
            }
            if (this.token.tokenType == 310) {
                this.read();
            } else if (this.token.tokenType == 114) {
                this.read();
                bl3 = !bl3;
            } else if (this.token.tokenType == 316) {
                this.read();
                bl4 = true;
            } else {
                throw this.unexpectedToken();
            }
        }
        if (bl4) {
            expression = new ExpressionLogical(47, expression);
        } else if (bl2) {
            expression = new ExpressionArithmetic(31, expression);
        } else if (bl3) {
            expression = new ExpressionLogical(48, expression);
        }
        return expression;
    }

    Expression XreadStringValueExpression() {
        return this.XreadCharacterValueExpression();
    }

    Expression XreadCharacterValueExpression() {
        Expression expression = this.XreadCharacterPrimary();
        Collation collation = this.readCollateClauseOrNull();
        while (this.token.tokenType == 925) {
            this.read();
            Expression expression2 = expression;
            expression = this.XreadCharacterPrimary();
            collation = this.readCollateClauseOrNull();
            expression = new ExpressionArithmetic(36, expression2, expression);
        }
        return expression;
    }

    Expression XreadCharacterPrimary() {
        switch (this.token.tokenType) {
            case 171: 
            case 213: 
            case 286: 
            case 308: 
            case 320: {
                FunctionSQL functionSQL = FunctionSQL.newSQLFunction(this.token.tokenString, this.compileContext);
                Expression expression = this.readSQLFunction(functionSQL);
                if (expression == null) break;
                return expression;
            }
        }
        return this.XreadValueExpressionPrimary();
    }

    Expression XreadNumericPrimary() {
        switch (this.token.tokenType) {
            case 1: 
            case 30: 
            case 34: 
            case 35: 
            case 37: 
            case 39: 
            case 111: 
            case 113: 
            case 119: 
            case 166: 
            case 180: 
            case 200: 
            case 222: 
            case 224: 
            case 279: 
            case 335: {
                FunctionSQL functionSQL = FunctionSQL.newSQLFunction(this.token.tokenString, this.compileContext);
                if (functionSQL == null) {
                    throw this.unexpectedToken();
                }
                Expression expression = this.readSQLFunction(functionSQL);
                if (expression == null) break;
                return expression;
            }
        }
        return this.XreadValueExpressionPrimary();
    }

    Expression XreadNumericValueExpression() {
        Expression expression = this.XreadTerm();
        while (true) {
            int n;
            if (this.token.tokenType == 937) {
                n = 32;
            } else {
                if (this.token.tokenType != 934) break;
                n = 33;
            }
            this.read();
            Expression expression2 = expression;
            expression = this.XreadTerm();
            expression = new ExpressionArithmetic(n, expression2, expression);
        }
        return expression;
    }

    Expression XreadTerm() {
        Expression expression = this.XreadFactor();
        while (true) {
            int n;
            if (this.token.tokenType == 921) {
                n = 34;
            } else {
                if (this.token.tokenType != 926) break;
                n = 35;
            }
            this.read();
            Expression expression2 = expression;
            expression = this.XreadFactor();
            if (expression == null) {
                throw this.unexpectedToken();
            }
            expression = new ExpressionArithmetic(n, expression2, expression);
        }
        return expression;
    }

    Expression XreadFactor() {
        boolean bl = false;
        if (this.token.tokenType == 937) {
            this.read();
        } else if (this.token.tokenType == 934) {
            this.read();
            bl = true;
        }
        Expression expression = this.XreadNumericPrimary();
        if (expression == null) {
            return null;
        }
        if (bl) {
            expression = new ExpressionArithmetic(31, expression);
        }
        return expression;
    }

    Expression XreadDatetimeValueExpression() {
        Expression expression = this.XreadDateTimeIntervalTerm();
        while (true) {
            int n;
            if (this.token.tokenType == 937) {
                n = 32;
            } else {
                if (this.token.tokenType != 934) break;
                n = 33;
            }
            this.read();
            Expression expression2 = expression;
            expression = this.XreadDateTimeIntervalTerm();
            expression = new ExpressionArithmetic(n, expression2, expression);
        }
        return expression;
    }

    Expression XreadIntervalValueExpression() {
        Expression expression = this.XreadDateTimeIntervalTerm();
        while (true) {
            int n;
            if (this.token.tokenType == 937) {
                n = 32;
            } else {
                if (this.token.tokenType != 934) break;
                n = 33;
            }
            this.read();
            Expression expression2 = expression;
            expression = this.XreadDateTimeIntervalTerm();
            expression = new ExpressionArithmetic(n, expression2, expression);
        }
        return expression;
    }

    Expression XreadDateTimeIntervalTerm() {
        switch (this.token.tokenType) {
            case 1: 
            case 65: 
            case 71: 
            case 72: 
            case 168: 
            case 169: {
                FunctionSQL functionSQL = FunctionSQL.newSQLFunction(this.token.tokenString, this.compileContext);
                if (functionSQL == null) {
                    throw this.unexpectedToken();
                }
                return this.readSQLFunction(functionSQL);
            }
        }
        return this.XreadValueExpressionPrimary();
    }

    Expression XreadDateTimeValueFunctionOrNull() {
        FunctionSQL functionSQL = null;
        switch (this.token.tokenType) {
            case 65: 
            case 71: 
            case 72: 
            case 168: 
            case 169: {
                functionSQL = FunctionSQL.newSQLFunction(this.token.tokenString, this.compileContext);
                break;
            }
            case 780: 
            case 815: 
            case 816: 
            case 831: {
                functionSQL = FunctionCustom.newCustomFunction(this.session, this.token.tokenString, this.token.tokenType);
                if (functionSQL != null) break;
                return null;
            }
            default: {
                return null;
            }
        }
        if (functionSQL == null) {
            throw this.unexpectedToken();
        }
        return this.readSQLFunction(functionSQL);
    }

    Expression XreadBooleanValueExpression() {
        try {
            Expression expression = this.XreadBooleanTermOrNull();
            if (expression == null) {
                throw Error.error(5568);
            }
            while (this.token.tokenType == 207) {
                int n = 50;
                this.read();
                Expression expression2 = expression;
                expression = this.XreadBooleanTermOrNull();
                if (expression == null) {
                    throw Error.error(5568);
                }
                expression = new ExpressionLogical(n, expression2, expression);
            }
            if (expression == null) {
                throw Error.error(5568);
            }
            return expression;
        }
        catch (HsqlException hsqlException) {
            HsqlException hsqlException2;
            hsqlException.setLevel(this.compileContext.subqueryDepth);
            if (this.lastError != null && this.lastError.getLevel() >= hsqlException.getLevel()) {
                hsqlException2 = this.lastError;
                this.lastError = null;
            }
            throw hsqlException2;
        }
    }

    Expression XreadBooleanTermOrNull() {
        Expression expression = this.XreadBooleanFactorOrNull();
        if (expression == null) {
            return null;
        }
        while (this.token.tokenType == 5) {
            int n = 49;
            this.read();
            Expression expression2 = expression;
            expression = this.XreadBooleanFactorOrNull();
            if (expression == null) {
                throw this.unexpectedToken();
            }
            expression = new ExpressionLogical(n, expression2, expression);
        }
        return expression;
    }

    Expression XreadBooleanFactorOrNull() {
        Expression expression;
        boolean bl = false;
        if (this.token.tokenType == 193) {
            this.read();
            bl = true;
        }
        if ((expression = this.XreadBooleanTestOrNull()) == null) {
            return null;
        }
        if (bl) {
            expression = new ExpressionLogical(48, expression);
        }
        return expression;
    }

    Expression XreadBooleanTestOrNull() {
        boolean bl = false;
        boolean bl2 = false;
        Expression expression = this.XreadBooleanPrimaryOrNull();
        if (expression == null) {
            return expression;
        }
        if (this.token.tokenType == 152) {
            this.read();
            if (this.token.tokenType == 193) {
                this.read();
                bl2 = true;
            }
            if (this.token.tokenType == 310) {
                this.read();
            } else if (this.token.tokenType == 114) {
                this.read();
                bl2 = !bl2;
            } else if (this.token.tokenType == 316) {
                this.read();
                bl = true;
            } else {
                throw this.unexpectedToken();
            }
        }
        if (bl) {
            expression = new ExpressionLogical(47, expression);
        }
        if (bl2) {
            expression = new ExpressionLogical(48, expression);
        }
        return expression;
    }

    Expression XreadBooleanPrimaryOrNull() {
        int n;
        Expression expression = null;
        switch (this.token.tokenType) {
            case 109: 
            case 315: {
                return this.XreadPredicate();
            }
            case 257: {
                this.read();
                this.readThis(936);
                expression = this.XreadRowElementList(true);
                this.readThis(922);
                break;
            }
            default: {
                n = this.getPosition();
                try {
                    expression = this.XreadAllTypesCommonValueExpression(false);
                    break;
                }
                catch (HsqlException hsqlException) {
                    hsqlException.setLevel(this.compileContext.subqueryDepth);
                    if (this.lastError == null || this.lastError.getLevel() < hsqlException.getLevel()) {
                        this.lastError = hsqlException;
                    }
                    this.rewind(n);
                }
            }
        }
        if (expression == null && this.token.tokenType == 936) {
            this.read();
            n = this.getPosition();
            try {
                expression = this.XreadRowElementList(true);
                this.readThis(922);
            }
            catch (HsqlException hsqlException) {
                hsqlException.setLevel(this.compileContext.subqueryDepth);
                if (this.lastError == null || this.lastError.getLevel() < hsqlException.getLevel()) {
                    this.lastError = hsqlException;
                }
                this.rewind(n);
                expression = this.XreadBooleanValueExpression();
                this.readThis(922);
            }
        }
        if (expression != null) {
            expression = this.XreadPredicateRightPart(expression);
        }
        return expression;
    }

    Expression XreadBooleanPredicand() {
        if (this.token.tokenType == 936) {
            this.read();
            Expression expression = this.XreadBooleanValueExpression();
            this.readThis(922);
            return expression;
        }
        Expression expression = this.XreadSimpleValueExpressionPrimary();
        if (expression != null) {
            expression = this.XreadArrayElementReference(expression);
        }
        return expression;
    }

    Expression XreadPredicate() {
        switch (this.token.tokenType) {
            case 109: {
                this.read();
                Expression expression = this.XreadTableSubquery(55);
                return new ExpressionLogical(55, expression);
            }
            case 315: {
                this.read();
                Expression expression = this.XreadTableSubquery(66);
                return new ExpressionLogical(66, expression);
            }
        }
        Expression expression = this.XreadRowValuePredicand();
        return this.XreadPredicateRightPart(expression);
    }

    Expression XreadPredicateRightPart(Expression expression) {
        boolean bl = false;
        boolean bl2 = false;
        ExpressionLogical expressionLogical = null;
        int n = this.getPosition();
        if (this.token.tokenType == 193) {
            this.read();
            bl = true;
        }
        if (this.token.tokenType == 622) {
            this.read();
            if (this.token.tokenType != 225 && this.token.tokenType != 288) {
                throw this.unexpectedToken();
            }
            bl2 = true;
        }
        block0 : switch (this.token.tokenType) {
            case 152: {
                if (bl) {
                    throw this.unexpectedToken();
                }
                this.read();
                if (this.token.tokenType == 193) {
                    bl = true;
                    this.read();
                }
                if (this.token.tokenType == 196) {
                    this.read();
                    if (bl) {
                        expressionLogical = new ExpressionLogical(39, expression);
                        bl = false;
                        break;
                    }
                    expressionLogical = new ExpressionLogical(47, expression);
                    break;
                }
                if (this.token.tokenType == 90) {
                    this.read();
                    this.readThis(124);
                    Expression expression2 = this.XreadRowValuePredicand();
                    expressionLogical = new ExpressionLogical(67, expression, expression2);
                    bl = !bl;
                    break;
                }
                this.rewind(n);
                return expression;
            }
            case 164: {
                expressionLogical = this.XreadLikePredicateRightPart(expression);
                expressionLogical.noOptimisation = this.isCheckOrTriggerCondition;
                break;
            }
            case 21: {
                expressionLogical = this.XreadBetweenPredicateRightPart(expression);
                break;
            }
            case 140: {
                expressionLogical = this.XreadInPredicateRightPart(expression);
                expressionLogical.noOptimisation = this.isCheckOrTriggerCondition;
                break;
            }
            case 52: {
                if (bl) {
                    throw this.unexpectedToken();
                }
                expressionLogical = this.XreadPeriodPredicateRightPart(59, expression);
                break;
            }
            case 103: {
                if (bl) {
                    throw this.unexpectedToken();
                }
                expressionLogical = this.XreadPeriodPredicateRightPart(60, expression);
                break;
            }
            case 212: {
                if (bl) {
                    throw this.unexpectedToken();
                }
                expressionLogical = this.XreadPeriodPredicateRightPart(61, expression);
                break;
            }
            case 225: {
                if (bl) {
                    throw this.unexpectedToken();
                }
                if (bl2) {
                    expressionLogical = this.XreadPeriodPredicateRightPart(64, expression);
                    break;
                }
                expressionLogical = this.XreadPeriodPredicateRightPart(62, expression);
                break;
            }
            case 288: {
                if (bl) {
                    throw this.unexpectedToken();
                }
                if (bl2) {
                    expressionLogical = this.XreadPeriodPredicateRightPart(65, expression);
                    break;
                }
                expressionLogical = this.XreadPeriodPredicateRightPart(63, expression);
                break;
            }
            case 417: 
            case 929: 
            case 930: 
            case 932: 
            case 933: 
            case 935: {
                if (bl) {
                    throw this.unexpectedToken();
                }
                int n2 = ParserDQL.getExpressionType(this.token.tokenType);
                this.read();
                switch (this.token.tokenType) {
                    case 2: 
                    case 6: 
                    case 272: {
                        expressionLogical = this.XreadQuantifiedComparisonRightPart(n2, expression);
                        break block0;
                    }
                }
                Expression expression3 = this.XreadRowValuePredicand();
                expressionLogical = new ExpressionLogical(n2, expression, expression3);
                break;
            }
            case 172: {
                expressionLogical = this.XreadMatchPredicateRightPart(expression);
                break;
            }
            default: {
                if (bl) {
                    throw this.unexpectedToken();
                }
                return expression;
            }
        }
        if (bl) {
            expressionLogical = new ExpressionLogical(48, (Expression)expressionLogical);
        }
        return expressionLogical;
    }

    private ExpressionLogical XreadBetweenPredicateRightPart(Expression expression) {
        boolean bl = false;
        this.read();
        if (this.token.tokenType == 13) {
            this.read();
        } else if (this.token.tokenType == 290) {
            bl = true;
            this.read();
        }
        Expression expression2 = this.XreadRowValuePredicand();
        this.readThis(5);
        Expression expression3 = this.XreadRowValuePredicand();
        ExpressionLogical expressionLogical = new ExpressionLogical(41, expression, expression2);
        ExpressionLogical expressionLogical2 = new ExpressionLogical(45, expression, expression3);
        ExpressionLogical expressionLogical3 = new ExpressionLogical(49, expressionLogical, expressionLogical2);
        if (bl) {
            expressionLogical = new ExpressionLogical(45, expression, expression2);
            expressionLogical2 = new ExpressionLogical(41, expression, expression3);
            ExpressionLogical expressionLogical4 = new ExpressionLogical(49, expressionLogical, expressionLogical2);
            return new ExpressionLogical(50, expressionLogical3, expressionLogical4);
        }
        return expressionLogical3;
    }

    private ExpressionLogical XreadQuantifiedComparisonRightPart(int n, Expression expression) {
        Expression expression2;
        Cloneable cloneable;
        int n2 = this.token.tokenType;
        int n3 = 0;
        switch (this.token.tokenType) {
            case 6: 
            case 272: {
                n3 = 52;
                break;
            }
            case 2: {
                n3 = 51;
                break;
            }
            default: {
                throw Error.runtimeError(201, "ParserDQL");
            }
        }
        this.read();
        this.readThis(936);
        int n4 = this.getPosition();
        this.readOpenBrackets();
        switch (this.token.tokenType) {
            case 265: 
            case 294: 
            case 325: 
            case 337: {
                this.rewind(n4);
                cloneable = this.XreadSubqueryTableBody(54);
                expression2 = new Expression(23, (TableDerived)cloneable);
                this.readThis(922);
                break;
            }
            default: {
                this.rewind(n4);
                expression2 = this.readAggregateExpression(n2);
                this.readThis(922);
                this.readFilterClause(expression2);
            }
        }
        cloneable = new ExpressionLogical(n, expression, expression2);
        ((ExpressionLogical)cloneable).setSubType(n3);
        return cloneable;
    }

    private ExpressionLogical XreadInPredicateRightPart(Expression expression) {
        Cloneable cloneable;
        int n = expression.getDegree();
        Expression expression2 = null;
        this.read();
        this.readThis(936);
        int n2 = this.getPosition();
        int n3 = this.readOpenBrackets();
        switch (this.token.tokenType) {
            case 317: {
                expression2 = this.XreadCollectionDerivedTable(54);
                this.readThis(922);
                this.readCloseBrackets(n3);
                break;
            }
            case 265: 
            case 294: 
            case 325: 
            case 337: {
                this.rewind(n2);
                cloneable = this.XreadSubqueryTableBody(54);
                expression2 = new Expression(23, (TableDerived)cloneable);
                this.readThis(922);
                break;
            }
            default: {
                this.rewind(n2);
                expression2 = this.XreadInValueListConstructor(n);
                this.readThis(922);
            }
        }
        if (this.isCheckOrTriggerCondition) {
            cloneable = new ExpressionLogical(54, expression, expression2);
        } else {
            cloneable = new ExpressionLogical(40, expression, expression2);
            ((ExpressionLogical)cloneable).setSubType(52);
        }
        return cloneable;
    }

    Expression XreadInValueList(int n) {
        Expression[] expressionArray;
        HsqlArrayList hsqlArrayList = new HsqlArrayList();
        while (true) {
            if ((expressionArray = this.XreadValueExpression()).getType() != 25) {
                expressionArray = new Expression(25, new Expression[]{expressionArray});
            }
            hsqlArrayList.add(expressionArray);
            if (this.token.tokenType != 924) break;
            this.read();
        }
        expressionArray = new Expression[hsqlArrayList.size()];
        hsqlArrayList.toArray(expressionArray);
        Expression expression = new Expression(26, expressionArray);
        for (int i = 0; i < expressionArray.length; ++i) {
            Expression[] expressionArray2;
            if (expressionArray[i].getType() != 25) {
                expressionArray[i] = new Expression(25, new Expression[]{expressionArray[i]});
            }
            if ((expressionArray2 = expressionArray[i].nodes).length != n) {
                throw this.unexpectedToken();
            }
            for (int j = 0; j < n; ++j) {
                if (expressionArray2[j].getType() != 25) continue;
                throw this.unexpectedToken();
            }
        }
        return expression;
    }

    private ExpressionLogical XreadLikePredicateRightPart(Expression expression) {
        this.read();
        Expression expression2 = this.XreadStringValueExpression();
        Expression expression3 = null;
        if (this.token.tokenString.equals("ESCAPE")) {
            this.read();
            expression3 = this.XreadStringValueExpression();
        }
        return new ExpressionLike(expression, expression2, expression3, this.isCheckOrTriggerCondition);
    }

    private ExpressionLogical XreadMatchPredicateRightPart(Expression expression) {
        boolean bl = false;
        int n = 68;
        this.read();
        if (this.token.tokenType == 315) {
            this.read();
            bl = true;
        }
        switch (this.token.tokenType) {
            default: {
                n = bl ? 71 : 68;
                break;
            }
            case 533: {
                this.read();
                n = bl ? 71 : 68;
                break;
            }
            case 492: {
                this.read();
                n = bl ? 72 : 69;
                break;
            }
            case 125: {
                this.read();
                n = bl ? 73 : 70;
            }
        }
        int n2 = bl ? 68 : 54;
        Expression expression2 = this.XreadTableSubquery(n2);
        return new ExpressionLogical(n, expression, expression2);
    }

    private ExpressionLogical XreadPeriodPredicateRightPart(int n, Expression expression) {
        boolean bl = false;
        switch (expression.getType()) {
            case 2: {
                expression = new ExpressionPeriod((ExpressionColumn)expression);
                break;
            }
            case 57: {
                break;
            }
            case 25: {
                if (expression.nodes.length != 2) {
                    throw Error.error(5564);
                }
                bl = true;
                break;
            }
            default: {
                throw Error.error(5564);
            }
        }
        this.read();
        boolean bl2 = false;
        if (this.token.tokenType == 220) {
            if (bl) {
                throw this.unexpectedToken();
            }
            this.read();
            bl2 = true;
            if (this.token.tokenType != 936) {
                throw this.unexpectedTokenRequire("(");
            }
        }
        Expression expression2 = this.XreadRowValuePredicand();
        switch (expression2.getType()) {
            case 2: {
                if (bl2) {
                    throw Error.error(5564);
                }
                expression2 = new ExpressionPeriod((ExpressionColumn)expression2);
                break;
            }
            case 25: {
                if (expression2.nodes.length == 2) {
                    if (bl2) {
                        expression2 = new ExpressionPeriod(expression2);
                        break;
                    }
                    if (n != 61) {
                        throw Error.error(5564);
                    }
                    return new ExpressionLogical(56, expression, expression2);
                }
                throw Error.error(5564);
            }
            default: {
                if (n != 59) {
                    throw Error.error(5564);
                }
                if (!bl2) break;
                throw Error.error(5564);
            }
        }
        return new ExpressionPeriodOp(n, expression, expression2);
    }

    Expression XreadRowValueExpression() {
        Expression expression = this.XreadExplicitRowValueConstructorOrNull();
        if (expression != null) {
            return expression;
        }
        return this.XreadRowValueSpecialCase();
    }

    Expression XreadTableRowValueConstructor() {
        Expression expression = this.XreadExplicitRowValueConstructorOrNull();
        if (expression != null) {
            return expression;
        }
        return this.XreadRowValueSpecialCase();
    }

    Expression XreadRowValuePredicand() {
        return this.XreadRowOrCommonValueExpression();
    }

    Expression XreadRowValueSpecialCase() {
        Expression expression = this.XreadSimpleValueExpressionPrimary();
        if (expression != null) {
            expression = this.XreadArrayElementReference(expression);
        }
        return expression;
    }

    Expression XreadRowValueConstructor() {
        Expression expression = this.XreadExplicitRowValueConstructorOrNull();
        if (expression != null) {
            return expression;
        }
        expression = this.XreadRowOrCommonValueExpression();
        if (expression != null) {
            return expression;
        }
        return this.XreadBooleanValueExpression();
    }

    Expression XreadExplicitRowValueConstructorOrNull() {
        switch (this.token.tokenType) {
            case 936: {
                this.read();
                int n = this.getPosition();
                this.readOpenBrackets();
                switch (this.token.tokenType) {
                    case 265: 
                    case 294: 
                    case 325: {
                        this.rewind(n);
                        TableDerived tableDerived = this.XreadSubqueryTableBody(22);
                        this.readThis(922);
                        return new Expression(22, tableDerived);
                    }
                }
                this.rewind(n);
                Expression expression = this.XreadRowElementList(true);
                this.readThis(922);
                return expression;
            }
            case 257: {
                this.read();
                this.readThis(936);
                Expression expression = this.XreadRowElementList(false);
                this.readThis(922);
                return expression;
            }
        }
        return null;
    }

    Expression XreadRowElementList(boolean bl) {
        Expression expression;
        HsqlArrayList hsqlArrayList = new HsqlArrayList();
        while (true) {
            expression = this.XreadValueExpression();
            hsqlArrayList.add(expression);
            if (this.token.tokenType != 924) break;
            this.read();
        }
        if (bl && hsqlArrayList.size() == 1) {
            return expression;
        }
        Expression[] expressionArray = new Expression[hsqlArrayList.size()];
        hsqlArrayList.toArray(expressionArray);
        return new Expression(25, expressionArray);
    }

    Expression XreadCurrentCollationSpec() {
        throw Error.error(1500);
    }

    Expression XreadTableSubquery(int n) {
        this.readThis(936);
        TableDerived tableDerived = this.XreadSubqueryTableBody(n);
        this.readThis(922);
        return new Expression(23, tableDerived);
    }

    Table XreadTableSubqueryOrNull(boolean bl) {
        boolean bl2 = false;
        int n = this.getPosition();
        this.readThis(936);
        switch (this.token.tokenType) {
            case 265: 
            case 294: 
            case 325: 
            case 337: {
                break;
            }
            case 936: {
                if (bl) break;
            }
            default: {
                bl2 = true;
            }
        }
        if (bl2) {
            this.rewind(n);
            return null;
        }
        TableDerived tableDerived = this.XreadSubqueryTableBody(23);
        this.readThis(922);
        return tableDerived;
    }

    TableDerived XreadJoinedTableAsSubqueryOrNull() {
        int n = this.getPosition();
        this.readThis(936);
        this.compileContext.incrementDepth();
        QuerySpecification querySpecification = this.XreadJoinedTableAsView();
        querySpecification.resolveReferences(this.session, this.compileContext.getOuterRanges());
        if (querySpecification.rangeVariables.length < 2) {
            this.compileContext.decrementDepth();
            this.rewind(n);
            return null;
        }
        querySpecification.resolveTypesPartOne(this.session);
        querySpecification.resolveTypesPartTwo(this.session);
        TableDerived tableDerived = this.newSubQueryTable(querySpecification, 23);
        this.readThis(922);
        tableDerived.setSQL(this.getLastPart(n));
        tableDerived.prepareTable(this.session);
        this.compileContext.decrementDepth();
        return tableDerived;
    }

    QuerySpecification XreadJoinedTableAsView() {
        QuerySpecification querySpecification = new QuerySpecification(this.compileContext);
        ExpressionColumn expressionColumn = new ExpressionColumn(96);
        querySpecification.addSelectColumnExpression(expressionColumn);
        this.XreadTableReference(querySpecification);
        return querySpecification;
    }

    TableDerived XreadTableNamedSubqueryBody(HsqlNameManager.HsqlName hsqlName, HsqlNameManager.HsqlName[] hsqlNameArray, int n) {
        TableDerived tableDerived;
        int n2 = this.getPosition();
        int n3 = this.compileContext.getDepth();
        switch (n) {
            case 24: {
                try {
                    tableDerived = this.XreadRecursiveSubqueryBody(hsqlName, hsqlNameArray);
                    break;
                }
                catch (HsqlException hsqlException) {
                    this.rewind(n2);
                    this.compileContext.decrementDepth(n3);
                }
            }
            case 23: {
                try {
                    tableDerived = this.XreadSubqueryTableBody(hsqlName, n);
                    if (tableDerived.queryExpression != null) {
                        tableDerived.canRecompile = true;
                        tableDerived.queryExpression.resolve(this.session, this.compileContext.getOuterRanges(), null);
                    }
                    tableDerived.prepareTable(this.session, hsqlNameArray);
                    break;
                }
                catch (HsqlException hsqlException) {
                    if (this.database.sqlSyntaxDb2 || this.database.sqlSyntaxOra) {
                        this.rewind(n2);
                        this.compileContext.decrementDepth(n3);
                        tableDerived = this.XreadRecursiveSubqueryBody(hsqlName, hsqlNameArray);
                        break;
                    }
                    throw hsqlException;
                }
            }
            default: {
                throw this.unexpectedToken();
            }
        }
        return tableDerived;
    }

    TableDerived XreadRecursiveSubqueryBody(HsqlNameManager.HsqlName hsqlName, HsqlNameManager.HsqlName[] hsqlNameArray) {
        int n = this.getPosition();
        this.compileContext.incrementDepth();
        this.compileContext.incrementDepth();
        QuerySpecification querySpecification = this.XreadSimpleTable();
        querySpecification.resolveReferences(this.session, this.compileContext.getOuterRanges());
        querySpecification.resolve(this.session);
        TableDerived tableDerived = this.newSubQueryTable(hsqlName, querySpecification, 23);
        this.compileContext.decrementDepth();
        tableDerived.prepareTable(this.session, hsqlNameArray);
        this.compileContext.registerSubquery(hsqlName.name);
        this.compileContext.registerSubquery(hsqlName.name, tableDerived);
        this.checkIsThis(314);
        int n2 = this.XreadUnionType();
        if ((this.database.sqlSyntaxDb2 || this.database.sqlSyntaxOra || this.database.sqlSyntaxMss || this.database.sqlSyntaxPgs) && n2 == 2) {
            n2 = 1;
        }
        QuerySpecification querySpecification2 = this.XreadSimpleTable();
        QueryExpression queryExpression = new QueryExpression(this.compileContext, querySpecification);
        querySpecification2.isBaseMergeable = false;
        querySpecification2.resolveReferences(this.session, this.compileContext.getOuterRanges());
        queryExpression.addUnion(querySpecification2, n2);
        queryExpression.isRecursive = true;
        queryExpression.recursiveTable = tableDerived;
        queryExpression.resolve(this.session);
        TableDerived tableDerived2 = this.newSubQueryTable(hsqlName, queryExpression, 23);
        tableDerived2.prepareTable(this.session, hsqlNameArray);
        tableDerived2.setSQL(this.getLastPart(n));
        this.compileContext.decrementDepth();
        return tableDerived2;
    }

    TableDerived newSubQueryTable(Expression expression, int n) {
        HsqlNameManager.HsqlName hsqlName = this.database.nameManager.getSubqueryTableName();
        TableDerived tableDerived = new TableDerived(this.database, hsqlName, 2, null, expression, n, this.compileContext.getDepth());
        return tableDerived;
    }

    TableDerived newSubQueryTable(QueryExpression queryExpression, int n) {
        return this.newSubQueryTable(null, queryExpression, n);
    }

    TableDerived newSubQueryTable(HsqlNameManager.HsqlName hsqlName, QueryExpression queryExpression, int n) {
        if (hsqlName == null) {
            hsqlName = this.database.nameManager.getSubqueryTableName();
        }
        TableDerived tableDerived = new TableDerived(this.database, hsqlName, 2, queryExpression, null, n, this.compileContext.getDepth());
        return tableDerived;
    }

    TableDerived XreadSubqueryTableBody(int n) {
        return this.XreadSubqueryTableBody(null, n);
    }

    TableDerived XreadSubqueryTableBody(HsqlNameManager.HsqlName hsqlName, int n) {
        int n2 = this.getPosition();
        this.compileContext.incrementDepth();
        QueryExpression queryExpression = this.XreadQueryExpression();
        TableDerived tableDerived = null;
        if (n == 55) {
            queryExpression.setAsExists();
        }
        if (queryExpression.isValueList) {
            tableDerived = ((QuerySpecification)queryExpression).getValueListTable();
        }
        if (tableDerived == null) {
            tableDerived = this.newSubQueryTable(hsqlName, queryExpression, n);
        }
        tableDerived.setSQL(this.getLastPart(n2));
        this.compileContext.decrementDepth();
        return tableDerived;
    }

    TableDerived XreadViewSubqueryTable(View view, boolean bl) {
        QueryExpression queryExpression;
        this.compileContext.incrementDepth();
        try {
            queryExpression = this.XreadQueryExpression();
        }
        catch (HsqlException hsqlException) {
            queryExpression = this.XreadJoinedTableAsView();
        }
        queryExpression.setView(view);
        queryExpression.resolveReferences(this.session, RangeGroup.emptyArray);
        queryExpression.resolveTypesPartOne(this.session);
        queryExpression.resolveTypesPartTwo(this.session);
        if (bl) {
            queryExpression.resolveTypesPartThree(this.session);
        }
        TableDerived tableDerived = new TableDerived(this.database, view.getName(), 8, queryExpression, null, 0, this.compileContext.getDepth());
        tableDerived.view = view;
        tableDerived.columnList = view.columnList;
        tableDerived.columnCount = view.columnList.size();
        tableDerived.createPrimaryKey();
        tableDerived.triggerList = view.triggerList;
        tableDerived.triggerLists = view.triggerLists;
        this.compileContext.decrementDepth();
        return tableDerived;
    }

    Expression XreadContextuallyTypedTable(int n) {
        int n2;
        Expression expression = this.readRow();
        Expression[] expressionArray = expression.nodes;
        boolean bl = false;
        if (n == 1) {
            if (expression.getType() == 25) {
                expression.opType = 26;
                for (int i = 0; i < expressionArray.length; ++i) {
                    if (expressionArray[i].getType() != 25) {
                        expressionArray[i] = new Expression(25, new Expression[]{expressionArray[i]});
                        continue;
                    }
                    if (expressionArray[i].nodes.length == n) continue;
                    throw Error.error(5564);
                }
                return expression;
            }
            expression = new Expression(25, new Expression[]{expression});
            expression = new Expression(26, new Expression[]{expression});
            return expression;
        }
        if (expression.getType() != 25) {
            throw Error.error(5564);
        }
        for (n2 = 0; n2 < expressionArray.length; ++n2) {
            if (expressionArray[n2].getType() != 25) continue;
            bl = true;
            break;
        }
        if (bl) {
            expression.opType = 26;
            for (n2 = 0; n2 < expressionArray.length; ++n2) {
                if (expressionArray[n2].getType() != 25) {
                    throw Error.error(5564);
                }
                Expression[] expressionArray2 = expressionArray[n2].nodes;
                if (expressionArray2.length != n) {
                    throw Error.error(5564);
                }
                for (int i = 0; i < n; ++i) {
                    if (expressionArray2[i].getType() != 25) continue;
                    throw Error.error(5564);
                }
            }
        } else {
            if (expressionArray.length != n) {
                throw Error.error(5564);
            }
            expression = new Expression(26, new Expression[]{expression});
        }
        return expression;
    }

    Expression XreadInValueListConstructor(int n) {
        int n2 = this.getPosition();
        this.compileContext.incrementDepth();
        Expression expression = this.XreadInValueList(n);
        TableDerived tableDerived = this.newSubQueryTable(expression, 54);
        tableDerived.setSQL(this.getLastPart(n2));
        expression.table = tableDerived;
        this.compileContext.decrementDepth();
        return expression;
    }

    private TableDerived XreadRowValueExpressionList() {
        this.compileContext.incrementDepth();
        Expression expression = this.XreadRowValueExpressionListBody();
        TableDerived tableDerived = this.prepareSubqueryTable(expression, null);
        this.compileContext.decrementDepth();
        return tableDerived;
    }

    private TableDerived prepareSubqueryTable(Expression expression, HsqlNameManager.HsqlName[] hsqlNameArray) {
        HsqlList hsqlList = expression.resolveColumnReferences(this.session, RangeGroup.emptyGroup, this.compileContext.getOuterRanges(), null);
        ExpressionColumn.checkColumnsResolved(hsqlList);
        expression.resolveTypes(this.session, null);
        expression.prepareTable(this.session, null, expression.nodes[0].nodes.length);
        TableDerived tableDerived = this.newSubQueryTable(expression, 26);
        tableDerived.prepareTable(this.session, hsqlNameArray);
        return tableDerived;
    }

    Expression XreadRowValueExpressionListBody() {
        Expression expression = null;
        while (true) {
            int n = this.readOpenBrackets();
            Expression expression2 = this.readRow();
            this.readCloseBrackets(n);
            if (expression == null) {
                expression = new Expression(25, new Expression[]{expression2});
            } else {
                expression.nodes = (Expression[])ArrayUtil.resizeArray(expression.nodes, expression.nodes.length + 1);
                expression.nodes[expression.nodes.length - 1] = expression2;
            }
            if (this.token.tokenType != 924) break;
            this.read();
        }
        Expression[] expressionArray = expression.nodes;
        int n = 1;
        if (expressionArray[0].getType() == 25) {
            n = expressionArray[0].nodes.length;
        }
        expression.opType = 26;
        for (int i = 0; i < expressionArray.length; ++i) {
            if (expressionArray[i].getType() == 25) {
                if (expressionArray[i].nodes.length == n) continue;
                throw Error.error(5564);
            }
            if (n != 1) {
                throw Error.error(5564);
            }
            expressionArray[i] = new Expression(25, new Expression[]{expressionArray[i]});
        }
        return expression;
    }

    Expression XreadTargetSpecification(RangeVariable[] rangeVariableArray, LongDeque longDeque) {
        ColumnBase columnBase = null;
        int n = -1;
        this.checkIsIdentifier();
        if (this.token.namePrePrePrefix != null) {
            this.checkValidCatalogName(this.token.namePrePrePrefix);
        }
        for (int i = 0; i < rangeVariableArray.length; ++i) {
            if (rangeVariableArray[i] == null || (n = rangeVariableArray[i].findColumn(this.token.namePrePrefix, this.token.namePrefix, this.token.tokenString)) <= -1) continue;
            columnBase = rangeVariableArray[i].getColumn(n);
            this.read();
            break;
        }
        if (columnBase == null) {
            throw Error.error(5501, this.token.tokenString);
        }
        longDeque.add(n);
        if (this.token.tokenType == 931) {
            if (!columnBase.getDataType().isArrayType()) {
                throw this.unexpectedToken();
            }
            this.read();
            Expression expression = this.XreadNumericValueExpression();
            if (expression == null) {
                throw Error.error(5501, this.token.tokenString);
            }
            expression = new ExpressionAccessor(((ColumnSchema)columnBase).getAccessor(), expression);
            this.readThis(940);
            return expression;
        }
        return ((ColumnSchema)columnBase).getAccessor();
    }

    Expression XreadCollectionDerivedTable(int n) {
        Expression[] expressionArray;
        boolean bl = false;
        int n2 = this.getPosition();
        this.readThis(317);
        this.readThis(936);
        this.compileContext.incrementDepth();
        HsqlArrayList hsqlArrayList = new HsqlArrayList();
        while (true) {
            expressionArray = this.XreadValueExpression();
            hsqlArrayList.add(expressionArray);
            if (this.token.tokenType != 924) break;
            this.read();
        }
        expressionArray = new Expression[hsqlArrayList.size()];
        hsqlArrayList.toArray(expressionArray);
        this.readThis(922);
        if (this.token.tokenType == 337) {
            this.read();
            this.readThis(480);
            bl = true;
        }
        ExpressionTable expressionTable = new ExpressionTable(expressionArray, bl);
        TableDerived tableDerived = this.newSubQueryTable(expressionTable, n);
        tableDerived.setSQL(this.getLastPart(n2));
        this.compileContext.decrementDepth();
        return expressionTable;
    }

    Expression XreadTableFunctionDerivedTable() {
        int n = this.getPosition();
        this.readThis(294);
        this.readThis(936);
        this.compileContext.incrementDepth();
        Expression expression = this.XreadValueExpression();
        if (expression.getType() != 27 && expression.getType() != 28) {
            this.compileContext.decrementDepth();
            throw this.unexpectedToken("TABLE");
        }
        this.readThis(922);
        expression = new ExpressionTable(new Expression[]{expression}, false);
        TableDerived tableDerived = this.newSubQueryTable(expression, 23);
        tableDerived.setSQL(this.getLastPart(n));
        this.compileContext.decrementDepth();
        return expression;
    }

    Expression XreadLateralDerivedTable() {
        this.readThis(159);
        this.readThis(936);
        TableDerived tableDerived = this.XreadSubqueryTableBody(23);
        this.readThis(922);
        return new Expression(23, tableDerived);
    }

    Expression XreadArrayConstructor() {
        this.readThis(936);
        TableDerived tableDerived = this.XreadSubqueryTableBody(23);
        this.readThis(922);
        return new Expression(100, tableDerived);
    }

    Collation readCollateClauseOrNull() {
        if (this.token.tokenType == 44) {
            this.read();
            Collation collation = this.database.schemaManager.getCollation(this.session, this.token.tokenString, this.token.namePrefix);
            return collation;
        }
        return null;
    }

    Expression XreadArrayElementReference(Expression expression) {
        if (this.token.tokenType == 931) {
            this.read();
            Expression expression2 = this.XreadNumericValueExpression();
            this.readThis(940);
            expression = new ExpressionAccessor(expression, expression2);
        }
        return expression;
    }

    Expression readRow() {
        Expression expression = null;
        while (true) {
            Expression expression2 = this.XreadValueExpressionWithContext();
            if (expression == null) {
                expression = expression2;
            } else if (expression.getType() == 25) {
                if (expression2.getType() == 25 && expression.nodes[0].getType() != 25) {
                    expression = new Expression(25, new Expression[]{expression, expression2});
                } else {
                    expression.nodes = (Expression[])ArrayUtil.resizeArray(expression.nodes, expression.nodes.length + 1);
                    expression.nodes[expression.nodes.length - 1] = expression2;
                }
            } else {
                expression = new Expression(25, new Expression[]{expression, expression2});
            }
            if (this.token.tokenType != 924) break;
            this.read();
        }
        return expression;
    }

    Expression readCaseExpression() {
        Expression expression = null;
        this.read();
        if (this.token.tokenType != 332) {
            expression = this.XreadRowValuePredicand();
        }
        return this.readCaseWhen(expression);
    }

    private Expression readCaseWhen(Expression expression) {
        Expression expression2;
        this.readThis(332);
        Expression expression3 = null;
        if (expression == null) {
            expression3 = this.XreadBooleanValueExpression();
        } else {
            while (true) {
                if (expression == (expression2 = this.XreadPredicateRightPart(expression))) {
                    expression2 = new ExpressionLogical(expression, this.XreadRowValuePredicand());
                }
                expression3 = expression3 == null ? expression2 : new ExpressionLogical(50, expression3, expression2);
                if (this.token.tokenType != 924) break;
                this.read();
            }
        }
        this.readThis(296);
        expression2 = this.XreadValueExpression();
        Expression expression4 = null;
        if (this.token.tokenType == 332) {
            expression4 = this.readCaseWhen(expression);
        } else if (this.token.tokenType == 97) {
            this.read();
            expression4 = this.XreadValueExpression();
            this.readThis(99);
            this.readIfThis(32);
        } else {
            expression4 = new ExpressionValue(null, (Type)null);
            this.readThis(99);
            this.readIfThis(32);
        }
        ExpressionOp expressionOp = new ExpressionOp(95, expression2, expression4);
        ExpressionOp expressionOp2 = new ExpressionOp(92, expression3, (Expression)expressionOp);
        return expressionOp2;
    }

    private Expression readCaseWhenExpressionOrNull() {
        Expression expression = null;
        int n = this.getPosition();
        if (this.token.tokenType == 434 && !this.database.sqlSyntaxMys && !this.database.sqlSyntaxMss) {
            return null;
        }
        this.read();
        if (!this.readIfThis(936)) {
            this.rewind(n);
            return null;
        }
        expression = this.XreadBooleanValueExpression();
        this.readThis(924);
        Expression expression2 = this.XreadValueExpression();
        this.readThis(924);
        ExpressionOp expressionOp = new ExpressionOp(95, expression2, this.XreadValueExpression());
        expression = new ExpressionOp(92, expression, (Expression)expressionOp);
        this.readThis(922);
        return expression;
    }

    private Expression readCastExpression() {
        this.read();
        this.readThis(936);
        Expression expression = this.XreadValueExpression();
        this.readThis(11);
        Type type = this.readTypeDefinition(false, true);
        if (expression.isUnresolvedParam()) {
            expression.setDataType(this.session, type);
        } else {
            expression = new ExpressionOp(expression, type);
        }
        this.readThis(922);
        return expression;
    }

    private Expression readConvertExpressionOrNull() {
        Expression expression;
        Type type;
        Expression expression2 = null;
        int n = this.getPosition();
        this.read();
        if (!this.readIfThis(936)) {
            this.rewind(n);
            return null;
        }
        if (this.database.sqlSyntaxMss) {
            type = this.readTypeDefinition(false, true);
            this.readThis(924);
            expression = this.XreadValueExpression();
            if (this.readIfThis(924)) {
                expression2 = this.XreadSimpleValueSpecificationOrNull();
            }
        } else {
            expression = this.XreadValueExpression();
            this.readThis(924);
            type = Type.getTypeForJDBCConvertToken(this.token.tokenType);
            if (type == null) {
                type = this.readTypeDefinition(false, true);
            } else {
                this.read();
            }
        }
        if (expression.isUnresolvedParam() && expression2 == null) {
            expression.setDataType(this.session, type);
        } else {
            expression = new ExpressionOp(expression, type, expression2);
        }
        this.readThis(922);
        return expression;
    }

    private Expression readColumnOrFunctionExpression() {
        Expression[] expressionArray;
        Object object;
        Object object2;
        Object object3;
        String string = this.token.tokenString;
        boolean bl = this.isDelimitedSimpleName();
        Token token = this.getRecordedToken();
        this.checkIsIdentifier();
        if (this.isUndelimitedSimpleName() && (object3 = this.readFunction()) != null) {
            return object3;
        }
        this.read();
        if (this.token.tokenType != 936) {
            this.checkValidCatalogName(token.namePrePrePrefix);
            object3 = new ExpressionColumn(token.namePrePrefix, token.namePrefix, string);
            return object3;
        }
        object3 = (RoutineSchema)this.database.schemaManager.findSchemaObject(this.session, string, token.namePrefix, token.namePrePrefix, 16);
        if (object3 == null && token.namePrefix == null && !this.isViewDefinition && (object2 = this.database.schemaManager.findSynonym(token.tokenString, (String)(object = this.session.getSchemaName(null)), 18)) != null) {
            expressionArray = ((ReferenceObject)object2).getTarget();
            object3 = (RoutineSchema)this.database.schemaManager.findSchemaObject(expressionArray.name, expressionArray.schema.name, 18);
        }
        if (object3 == null && bl) {
            object = this.database.schemaManager.getDefaultSchemaHsqlName();
            object3 = (RoutineSchema)this.database.schemaManager.findSchemaObject(string, ((HsqlNameManager.HsqlName)object).name, 16);
            if (object3 == null) {
                Routine.createRoutines(this.session, (HsqlNameManager.HsqlName)object, string);
                object3 = (RoutineSchema)this.database.schemaManager.findSchemaObject(string, ((HsqlNameManager.HsqlName)object).name, 16);
            }
        }
        if (object3 == null) {
            if (this.lastError != null) {
                throw this.lastError;
            }
            throw Error.error(5501, string);
        }
        object = new HsqlArrayList();
        this.readThis(936);
        if (this.token.tokenType == 922) {
            this.read();
        } else {
            while (true) {
                object2 = this.XreadValueExpression();
                ((HsqlArrayList)object).add(object2);
                if (this.token.tokenType != 924) break;
                this.read();
            }
            this.readThis(922);
        }
        object2 = new FunctionSQLInvoked((RoutineSchema)object3);
        expressionArray = new Expression[((HsqlArrayList)object).size()];
        ((HsqlArrayList)object).toArray(expressionArray);
        ((FunctionSQLInvoked)object2).setArguments(expressionArray);
        this.compileContext.addFunctionCall((FunctionSQLInvoked)object2);
        token.setExpression(object3);
        return object2;
    }

    Expression readFunction() {
        Expression expression;
        FunctionSQL functionSQL = FunctionCustom.newCustomFunction(this.session, this.token.tokenString, this.token.tokenType);
        if (functionSQL != null) {
            int n = this.getPosition();
            try {
                Expression expression2 = this.readSQLFunction(functionSQL);
                if (expression2 != null) {
                    return expression2;
                }
            }
            catch (HsqlException hsqlException) {
                hsqlException.setLevel(this.compileContext.subqueryDepth);
                if (this.lastError == null || this.lastError.getLevel() < hsqlException.getLevel()) {
                    this.lastError = hsqlException;
                }
                this.rewind(n);
            }
        } else if (this.isReservedKey() && (functionSQL = FunctionSQL.newSQLFunction(this.token.tokenString, this.compileContext)) != null && (expression = this.readSQLFunction(functionSQL)) != null) {
            return expression;
        }
        return null;
    }

    Expression readCollection(int n) {
        this.read();
        if (this.token.tokenType == 936) {
            return this.XreadArrayConstructor();
        }
        this.readThis(931);
        HsqlArrayList hsqlArrayList = new HsqlArrayList();
        int n2 = 0;
        while (true) {
            if (this.token.tokenType == 940) break;
            if (n2 > 0) {
                this.readThis(924);
            }
            Expression expression = this.XreadValueExpression();
            hsqlArrayList.add(expression);
            ++n2;
        }
        this.read();
        Expression[] expressionArray = new Expression[hsqlArrayList.size()];
        hsqlArrayList.toArray(expressionArray);
        return new Expression(19, expressionArray);
    }

    private Expression readDecodeExpressionOrNull() {
        ExpressionOp expressionOp;
        block6: {
            int n = this.getPosition();
            this.read();
            if (!this.readIfThis(936)) {
                this.rewind(n);
                return null;
            }
            expressionOp = null;
            Expression expression = null;
            Expression expression2 = this.XreadValueExpression();
            this.readThis(924);
            while (true) {
                Expression expression3 = this.XreadValueExpression();
                if (this.token.tokenType != 924) {
                    if (expression == null) {
                        throw this.unexpectedToken();
                    }
                    expression.setRightNode(expression3);
                    break block6;
                }
                this.readThis(924);
                ExpressionLogical expressionLogical = new ExpressionLogical(67, expression2, expression3);
                Expression expression4 = this.XreadValueExpression();
                ExpressionOp expressionOp2 = new ExpressionOp(95, expression4, null);
                ExpressionOp expressionOp3 = new ExpressionOp(92, expressionLogical, (Expression)expressionOp2);
                if (expressionOp == null) {
                    expressionOp = expressionOp3;
                } else {
                    expression.setRightNode(expressionOp3);
                }
                expression = expressionOp2;
                if (this.token.tokenType != 924) break;
                this.readThis(924);
            }
            expression.setRightNode(new ExpressionValue(null, null));
        }
        this.readThis(922);
        return expressionOp;
    }

    private Expression readConcatExpressionOrNull() {
        int n = this.getPosition();
        this.read();
        if (!this.readIfThis(936)) {
            this.rewind(n);
            return null;
        }
        Expression expression = this.XreadValueExpression();
        this.readThis(924);
        while (true) {
            Expression expression2 = this.XreadValueExpression();
            expression = new ExpressionArithmetic(36, expression, expression2);
            if (this.token.tokenType == 924) {
                this.readThis(924);
                continue;
            }
            if (this.token.tokenType == 922) break;
        }
        this.readThis(922);
        return expression;
    }

    private Expression readConcatSeparatorExpressionOrNull() {
        HsqlArrayList hsqlArrayList = new HsqlArrayList();
        int n = this.getPosition();
        this.read();
        if (!this.readIfThis(936)) {
            this.rewind(n);
            return null;
        }
        Expression expression = this.XreadValueExpression();
        hsqlArrayList.add(expression);
        this.readThis(924);
        expression = this.XreadValueExpression();
        hsqlArrayList.add(expression);
        this.readThis(924);
        while (true) {
            expression = this.XreadValueExpression();
            hsqlArrayList.add(expression);
            if (this.token.tokenType == 924) {
                this.readThis(924);
                continue;
            }
            if (this.token.tokenType == 922) break;
        }
        this.readThis(922);
        Expression[] expressionArray = new Expression[hsqlArrayList.size()];
        hsqlArrayList.toArray(expressionArray);
        return new ExpressionOp(89, expressionArray);
    }

    private Expression readLeastExpressionOrNull() {
        int n = this.getPosition();
        this.read();
        if (!this.readIfThis(936)) {
            this.rewind(n);
            return null;
        }
        Expression expression = null;
        while (true) {
            expression = this.readValue(expression, 44);
            if (this.token.tokenType != 924) break;
            this.readThis(924);
        }
        this.readThis(922);
        return expression;
    }

    private Expression readGreatestExpressionOrNull() {
        int n = this.getPosition();
        this.read();
        if (!this.readIfThis(936)) {
            this.rewind(n);
            return null;
        }
        Expression expression = null;
        while (true) {
            expression = this.readValue(expression, 43);
            if (this.token.tokenType != 924) break;
            this.readThis(924);
        }
        this.readThis(922);
        return expression;
    }

    private Expression readValue(Expression expression, int n) {
        Expression expression2 = this.XreadValueExpression();
        if (expression == null) {
            return expression2;
        }
        ExpressionLogical expressionLogical = new ExpressionLogical(n, expression, expression2);
        ExpressionOp expressionOp = new ExpressionOp(95, expression, expression2);
        return new ExpressionOp(92, expressionLogical, (Expression)expressionOp);
    }

    private Expression readNullIfExpression() {
        this.read();
        this.readThis(936);
        Expression expression = this.XreadValueExpression();
        this.readThis(924);
        ExpressionOp expressionOp = new ExpressionOp(95, new ExpressionValue(null, (Type)null), expression);
        expression = new ExpressionLogical(expression, this.XreadValueExpression());
        expression = new ExpressionOp(92, expression, (Expression)expressionOp);
        this.readThis(922);
        return expression;
    }

    private Expression readIfNullExpressionOrNull() {
        int n = this.getPosition();
        this.read();
        if (!this.readIfThis(936)) {
            this.rewind(n);
            return null;
        }
        Expression expression = this.XreadValueExpression();
        this.readThis(924);
        Expression expression2 = this.XreadValueExpression();
        ExpressionLogical expressionLogical = new ExpressionLogical(47, expression);
        ExpressionOp expressionOp = new ExpressionOp(95, expression2, expression);
        expression = new ExpressionOp(92, expressionLogical, (Expression)expressionOp);
        expression.setSubType(90);
        expressionOp.setSubType(90);
        this.readThis(922);
        return expression;
    }

    private Expression readIfNull2ExpressionOrNull() {
        int n = this.getPosition();
        this.read();
        if (!this.readIfThis(936)) {
            this.rewind(n);
            return null;
        }
        Expression expression = this.XreadValueExpression();
        this.readThis(924);
        Expression expression2 = this.XreadValueExpression();
        this.readThis(924);
        Expression expression3 = this.XreadValueExpression();
        ExpressionLogical expressionLogical = new ExpressionLogical(47, expression);
        ExpressionOp expressionOp = new ExpressionOp(95, expression3, expression2);
        expression = new ExpressionOp(92, expressionLogical, (Expression)expressionOp);
        expression.setSubType(90);
        expressionOp.setSubType(90);
        this.readThis(922);
        return expression;
    }

    private Expression readCoalesceExpression() {
        Expression expression;
        ExpressionOp expressionOp = null;
        this.read();
        this.readThis(936);
        Expression expression2 = null;
        while (true) {
            expression = this.XreadValueExpression();
            if (expression2 != null && this.token.tokenType == 922) break;
            ExpressionValue expressionValue = new ExpressionValue(null, (Type)null);
            ExpressionLogical expressionLogical = new ExpressionLogical(47, expression);
            ExpressionOp expressionOp2 = new ExpressionOp(95, expressionValue, expression);
            ExpressionOp expressionOp3 = new ExpressionOp(92, expressionLogical, (Expression)expressionOp2);
            if (this.session.database.sqlSyntaxMys) {
                expressionOp2.setSubType(90);
                expressionOp3.setSubType(90);
            }
            if (expressionOp == null) {
                expressionOp = expressionOp3;
            } else {
                expression2.setLeftNode(expressionOp3);
            }
            expression2 = expressionOp2;
            this.readThis(924);
        }
        this.readThis(922);
        expression2.setLeftNode(expression);
        return expressionOp;
    }

    Expression readSQLFunction(FunctionSQL functionSQL) {
        boolean bl;
        int n = this.getPosition();
        this.read();
        short[] sArray = functionSQL.parseList;
        if (sArray.length == 0) {
            return functionSQL;
        }
        HsqlArrayList hsqlArrayList = new HsqlArrayList();
        boolean bl2 = bl = this.token.tokenType == 936;
        if (!bl) {
            if (sArray[0] == 1002) {
                return functionSQL;
            }
            this.rewind(n);
            return null;
        }
        try {
            this.readExpression(hsqlArrayList, sArray, 0, sArray.length, false);
            this.lastError = null;
        }
        catch (HsqlException hsqlException) {
            if (functionSQL.parseListAlt == null) {
                throw hsqlException;
            }
            this.rewind(n);
            this.read();
            sArray = functionSQL.parseListAlt;
            hsqlArrayList = new HsqlArrayList();
            this.readExpression(hsqlArrayList, sArray, 0, sArray.length, false);
            this.lastError = null;
        }
        Expression[] expressionArray = new Expression[hsqlArrayList.size()];
        hsqlArrayList.toArray(expressionArray);
        functionSQL.setArguments(expressionArray);
        return functionSQL.getFunctionExpression();
    }

    void readExpression(HsqlArrayList hsqlArrayList, short[] sArray, int n, int n2, boolean bl) {
        block10: for (int i = n; i < n + n2; ++i) {
            short s = sArray[i];
            switch (s) {
                case 938: {
                    Expression expression = null;
                    expression = this.XreadAllTypesCommonValueExpression(false);
                    hsqlArrayList.add(expression);
                    continue block10;
                }
                case 1005: {
                    if (super.isUndelimitedSimpleName()) {
                        ExpressionValue expressionValue = new ExpressionValue(this.token.tokenString, Type.SQL_VARCHAR);
                        this.read();
                        hsqlArrayList.add(expressionValue);
                        continue block10;
                    }
                    throw this.unexpectedToken();
                }
                case 1004: {
                    ExpressionValue expressionValue = null;
                    Object object = this.readIntegerObject();
                    if ((Integer)object < 0) {
                        throw Error.error(5592);
                    }
                    expressionValue = new ExpressionValue(object, Type.SQL_INTEGER);
                    hsqlArrayList.add(expressionValue);
                    continue block10;
                }
                case 1002: {
                    int n3 = hsqlArrayList.size();
                    int n4 = this.getPosition();
                    int n5 = ++i;
                    ++i;
                    int n6 = sArray[n5];
                    int n7 = hsqlArrayList.size();
                    try {
                        this.readExpression(hsqlArrayList, sArray, i, n6, true);
                    }
                    catch (HsqlException hsqlException) {
                        hsqlException.setLevel(this.compileContext.subqueryDepth);
                        if (this.lastError == null || this.lastError.getLevel() < hsqlException.getLevel()) {
                            this.lastError = hsqlException;
                        }
                        this.rewind(n4);
                        hsqlArrayList.setSize(n3);
                        for (int j = i; j < i + n6; ++j) {
                            if (sArray[j] != 938 && sArray[j] != 1001 && sArray[j] != 1004) continue;
                            hsqlArrayList.add(null);
                        }
                        i += n6 - 1;
                        continue block10;
                    }
                    if (n7 == hsqlArrayList.size() && sArray[i] != 936) {
                        hsqlArrayList.add(null);
                    }
                    i += n6 - 1;
                    continue block10;
                }
                case 1003: {
                    int n6;
                    int n8 = ++i;
                    short s2 = sArray[n8];
                    int n9 = ++i;
                    do {
                        n6 = hsqlArrayList.size();
                        this.readExpression(hsqlArrayList, sArray, n9, s2, true);
                    } while (hsqlArrayList.size() != n6);
                    i += s2 - 1;
                    continue block10;
                }
                case 1001: {
                    short s3 = sArray[++i];
                    Object object = null;
                    if (ArrayUtil.find(sArray, this.token.tokenType, i + 1, s3) == -1) {
                        if (!bl) {
                            throw this.unexpectedToken();
                        }
                    } else {
                        object = new ExpressionValue(ValuePool.getInt(this.token.tokenType), Type.SQL_INTEGER);
                        this.read();
                    }
                    hsqlArrayList.add(object);
                    i += s3;
                    continue block10;
                }
                default: {
                    if (this.token.tokenType != s) {
                        throw this.unexpectedToken();
                    }
                    this.read();
                }
            }
        }
    }

    private Expression readSequenceExpressionOrNull(int n) {
        int n2 = this.getPosition();
        switch (n) {
            case 12: {
                if (this.token.tokenType == 470) {
                    this.read();
                    if (this.token.tokenType != 323) {
                        this.rewind(n2);
                        return null;
                    }
                    this.readThis(323);
                    break;
                }
                if (this.database.sqlSyntaxDb2 && this.token.tokenType == 644) {
                    this.read();
                    break;
                }
                if (this.database.sqlSyntaxDb2 && this.token.tokenType == 652) {
                    this.read();
                    break;
                }
                this.rewind(n2);
                return null;
            }
            case 13: {
                this.read();
                this.readThis(323);
                break;
            }
        }
        this.readThis(120);
        this.checkIsSchemaObjectName();
        NumberSequence numberSequence = this.database.schemaManager.findSequence(this.session, this.token.tokenString, this.token.namePrefix);
        if (numberSequence == null) {
            throw Error.error(5501, this.token.tokenString);
        }
        Token token = this.getRecordedToken();
        this.read();
        ExpressionColumn expressionColumn = new ExpressionColumn(numberSequence, n);
        token.setExpression(numberSequence);
        this.compileContext.addSequence(numberSequence);
        return expressionColumn;
    }

    HsqlNameManager.SimpleName readSimpleName() {
        this.checkIsSimpleName();
        HsqlNameManager.SimpleName simpleName = HsqlNameManager.getSimpleName(this.token.tokenString, this.isDelimitedIdentifier());
        this.read();
        return simpleName;
    }

    HsqlNameManager.HsqlName readNewSchemaName() {
        HsqlNameManager.HsqlName hsqlName = this.readNewSchemaObjectName(2, false);
        SqlInvariants.checkSchemaNameNotSystem(hsqlName.name);
        return hsqlName;
    }

    HsqlNameManager.HsqlName readNewSchemaObjectName(int n, boolean bl) {
        this.checkIsSchemaObjectName();
        HsqlNameManager.HsqlName hsqlName = this.database.nameManager.newHsqlName(this.token.tokenString, this.isDelimitedIdentifier(), n);
        if (this.token.namePrefix != null) {
            switch (n) {
                case 1: 
                case 11: 
                case 21: 
                case 22: {
                    throw this.unexpectedToken();
                }
                case 19: {
                    if (this.token.namePrePrefix == null && !this.token.isDelimitedPrefix && "MODULE".equals(this.token.namePrefix)) break;
                    throw this.unexpectedTokenRequire("MODULE");
                }
                case 2: {
                    this.checkValidCatalogName(this.token.namePrefix);
                    if (this.token.namePrePrefix == null) break;
                    throw this.tooManyIdentifiers();
                }
                case 25: 
                case 26: {
                    this.checkValidCatalogName(this.token.namePrefix);
                    if (this.token.namePrePrefix == null) break;
                    throw this.tooManyIdentifiers();
                }
                case 9: {
                    throw this.tooManyIdentifiers();
                }
                default: {
                    HsqlNameManager.HsqlName hsqlName2;
                    this.checkValidCatalogName(this.token.namePrePrefix);
                    if (bl) {
                        hsqlName2 = this.session.getSchemaHsqlName(this.token.namePrefix);
                    } else {
                        hsqlName2 = this.session.database.schemaManager.findSchemaHsqlName(this.token.namePrefix);
                        if (hsqlName2 == null) {
                            hsqlName2 = this.database.nameManager.newHsqlName(this.token.namePrefix, this.isDelimitedIdentifier(), 2);
                        }
                    }
                    hsqlName.setSchemaIfNull(hsqlName2);
                    break;
                }
            }
        }
        this.read();
        return hsqlName;
    }

    HsqlNameManager.HsqlName readNewDependentSchemaObjectName(HsqlNameManager.HsqlName hsqlName, int n) {
        HsqlNameManager.HsqlName hsqlName2 = this.readNewSchemaObjectName(n, true);
        hsqlName2.parent = hsqlName;
        hsqlName2.setSchemaIfNull(hsqlName.schema);
        if (hsqlName2.schema != null && hsqlName.schema != null && hsqlName2.schema != hsqlName.schema) {
            throw Error.error(5505, this.token.namePrefix);
        }
        return hsqlName2;
    }

    HsqlNameManager.HsqlName readSchemaName() {
        this.checkIsSchemaObjectName();
        this.checkValidCatalogName(this.token.namePrefix);
        HsqlNameManager.HsqlName hsqlName = this.session.getSchemaHsqlName(this.token.tokenString);
        this.read();
        return hsqlName;
    }

    SchemaObject readSchemaObjectName(int n) {
        this.checkIsSchemaObjectName();
        this.checkValidCatalogName(this.token.namePrePrefix);
        String string = this.session.getSchemaName(this.token.namePrefix);
        SchemaObject schemaObject = this.database.schemaManager.getSchemaObject(this.token.tokenString, string, n);
        this.read();
        return schemaObject;
    }

    SchemaObject readSchemaObjectName(HsqlNameManager.HsqlName hsqlName, int n) {
        this.checkIsSchemaObjectName();
        SchemaObject schemaObject = this.database.schemaManager.getSchemaObject(this.token.tokenString, hsqlName.name, n);
        if (this.token.namePrefix != null) {
            if (!this.token.namePrefix.equals(hsqlName.name)) {
                throw Error.error(5505, this.token.namePrefix);
            }
            if (this.token.namePrePrefix != null && !this.token.namePrePrefix.equals(this.database.getCatalogName().name)) {
                throw Error.error(5505, this.token.namePrefix);
            }
        }
        this.read();
        return schemaObject;
    }

    Table readTableName() {
        return this.readTableName(false);
    }

    Table readTableName(boolean bl) {
        this.checkIsIdentifier();
        this.lastSynonym = null;
        Table table = this.database.schemaManager.findTable(this.session, this.token.tokenString, this.token.namePrefix, this.token.namePrePrefix);
        if (table == null) {
            ReferenceObject referenceObject;
            boolean bl2;
            boolean bl3 = bl2 = bl && this.token.namePrefix == null && !this.isViewDefinition;
            if (bl2 && (referenceObject = this.database.schemaManager.findSynonym(this.token.tokenString, this.session.getCurrentSchemaHsqlName().name, 3)) != null) {
                table = (Table)this.database.schemaManager.getSchemaObject(referenceObject.getTarget());
                this.lastSynonym = referenceObject.getName();
            }
            if (table == null) {
                throw Error.error(5501, this.token.tokenString);
            }
        }
        this.getRecordedToken().setExpression(table);
        this.read();
        return table;
    }

    ExpressionPeriodOp XreadQuerySystemPeriodSpecOrNull(Table table) {
        int n = this.getPosition();
        if (!table.isSystemVersioned()) {
            return null;
        }
        if (this.token.tokenType != 120) {
            ExpressionPeriodOp expressionPeriodOp = new ExpressionPeriodOp();
            return expressionPeriodOp;
        }
        this.read();
        if (this.token.tokenType != 292) {
            this.rewind(n);
            return null;
        }
        this.read();
        switch (this.token.tokenType) {
            case 11: {
                this.read();
                this.readThis(201);
                Expression expression = this.XreadValueExpression();
                return new ExpressionPeriodOp(expression);
            }
            case 21: {
                this.read();
                this.readIfThis(13);
                Expression expression = this.XreadValueExpression();
                this.readThis(5);
                Expression expression2 = this.XreadValueExpression();
                return new ExpressionPeriodOp(expression, expression2);
            }
            case 124: {
                this.read();
                Expression expression = this.XreadValueExpression();
                this.readThis(301);
                Expression expression3 = this.XreadValueExpression();
                return new ExpressionPeriodOp(expression, expression3);
            }
        }
        throw this.unexpectedToken();
    }

    ExpressionPeriodOp XreadQueryApplicationPeriodSpecOrNull(Table table) {
        PeriodDefinition periodDefinition = table.getApplicationPeriod();
        if (periodDefinition == null) {
            return null;
        }
        if (this.token.tokenType != 120) {
            return null;
        }
        this.read();
        this.readThis(221);
        this.readThis(201);
        this.checkIsSimpleName();
        if (!this.token.tokenString.equals(periodDefinition.periodName.getNameString())) {
            throw Error.error(5501, this.token.tokenString);
        }
        this.read();
        this.readThis(124);
        Expression expression = this.XreadValueExpression();
        this.readThis(301);
        Expression expression2 = this.XreadValueExpression();
        ExpressionPeriod expressionPeriod = new ExpressionPeriod(periodDefinition);
        ExpressionPeriod expressionPeriod2 = new ExpressionPeriod(expression, expression2);
        return new ExpressionPeriodOp(61, expressionPeriod, expressionPeriod2);
    }

    ColumnSchema readSimpleColumnName(RangeVariable rangeVariable, boolean bl) {
        ColumnSchema columnSchema = null;
        this.checkIsIdentifier();
        if (!bl && this.token.namePrefix != null) {
            throw this.tooManyIdentifiers();
        }
        int n = rangeVariable.findColumn(this.token.namePrePrefix, this.token.namePrefix, this.token.tokenString);
        if (n == -1) {
            throw Error.error(5501, this.token.tokenString);
        }
        columnSchema = rangeVariable.getTable().getColumn(n);
        this.read();
        return columnSchema;
    }

    ColumnSchema readSimpleColumnName(Table table, boolean bl) {
        int n;
        this.checkIsIdentifier();
        if (bl) {
            if (this.token.namePrefix != null && !table.getName().name.equals(this.token.namePrefix)) {
                throw Error.error(5501, this.token.namePrefix);
            }
        } else if (this.token.namePrefix != null) {
            throw this.tooManyIdentifiers();
        }
        if ((n = table.findColumn(this.token.tokenString)) == -1) {
            throw Error.error(5501, this.token.tokenString);
        }
        ColumnSchema columnSchema = table.getColumn(n);
        this.read();
        return columnSchema;
    }

    StatementQuery compileDeclareCursorOrNull(RangeGroup[] rangeGroupArray, boolean bl) {
        int n;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = this.getPosition();
        this.readThis(82);
        HsqlNameManager.HsqlName hsqlName = this.readNewSchemaObjectName(19, false);
        switch (this.token.tokenType) {
            case 266: {
                this.read();
                n2 = 2;
                break;
            }
            case 144: {
                this.read();
                n2 = 1;
                break;
            }
            case 12: {
                this.read();
                break;
            }
        }
        if (this.token.tokenType == 190) {
            this.readThis(262);
        } else if (this.token.tokenType == 262) {
            this.read();
            n3 = 1;
        }
        if (this.token.tokenType != 75) {
            this.rewind(n6);
            return null;
        }
        this.readThis(75);
        for (n = 0; n < 2; ++n) {
            if (this.token.tokenType == 337) {
                this.read();
                if (n == 0 && this.token.tokenType == 136) {
                    this.read();
                    n4 = 1;
                    continue;
                }
                this.readThis(251);
                ++n;
                n5 = 1;
                continue;
            }
            if (this.token.tokenType != 339) continue;
            this.read();
            if (n == 0 && this.token.tokenType == 136) {
                this.read();
                continue;
            }
            this.readThis(251);
            ++n;
        }
        this.readThis(120);
        n = ResultProperties.getProperties(n2, 1, n3, n4, n5);
        StatementQuery statementQuery = this.compileCursorSpecification(rangeGroupArray, n, bl);
        statementQuery.setCursorName(hsqlName);
        return statementQuery;
    }

    StatementQuery compileCursorSpecification(RangeGroup[] rangeGroupArray, int n, boolean bl) {
        OrderedHashSet orderedHashSet = null;
        QueryExpression queryExpression = this.XreadQueryExpression();
        if (this.token.tokenType == 120) {
            this.read();
            if (this.token.tokenType == 502 || this.token.tokenType == 115) {
                this.read();
                this.readThis(205);
                n = ResultProperties.addUpdatable(n, false);
            } else {
                this.readThis(319);
                n = ResultProperties.addUpdatable(n, true);
                if (this.token.tokenType == 201) {
                    this.readThis(201);
                    orderedHashSet = new OrderedHashSet();
                    this.readColumnNameList(orderedHashSet, null, false);
                }
                if (this.database.sqlSyntaxOra) {
                    this.readIfThis(645);
                }
            }
        }
        if (this.database.sqlSyntaxDb2) {
            if (this.readIfThis(337) && !this.readIfThis("CS") && !this.readIfThis("RR") && !this.readIfThis("RS")) {
                this.readThis("UR");
            }
            if (this.readIfThis(673)) {
                this.readThis(5);
                this.readThis("KEEP");
                if (!this.readIfThis("EXCLUSIVE") && !this.readIfThis("SHARE")) {
                    this.readThis(319);
                }
                this.readThis(635);
            }
        }
        if (ResultProperties.isUpdatable(n)) {
            queryExpression.isUpdatable = true;
        }
        queryExpression.setReturningResult();
        queryExpression.resolve(this.session, rangeGroupArray, null);
        StatementQuery statementQuery = bl ? new StatementCursor(this.session, queryExpression, this.compileContext) : new StatementQuery(this.session, queryExpression, this.compileContext);
        return statementQuery;
    }

    StatementDMQL compileShortCursorSpecification(int n) {
        QuerySpecification querySpecification = this.XreadSimpleTable();
        if (ResultProperties.isUpdatable(n)) {
            querySpecification.isUpdatable = true;
        }
        ((QueryExpression)querySpecification).setReturningResult();
        querySpecification.resolve(this.session);
        StatementQuery statementQuery = new StatementQuery(this.session, querySpecification, this.compileContext);
        return statementQuery;
    }

    int readCloseBrackets(int n) {
        int n2;
        for (n2 = 0; n2 < n && this.token.tokenType == 922; ++n2) {
            this.read();
        }
        return n2;
    }

    int readOpenBrackets() {
        int n = 0;
        while (this.token.tokenType == 936) {
            ++n;
            this.read();
        }
        return n;
    }

    void readNestedParenthesisedTokens() {
        this.readThis(936);
        do {
            this.read();
            if (this.token.tokenType == 936) {
                this.readNestedParenthesisedTokens();
            }
            if (this.token.tokenType != 1014) continue;
            throw this.unexpectedToken();
        } while (this.token.tokenType != 922);
        this.read();
    }

    void checkValidCatalogName(String string) {
        if (string != null && !string.equals(this.database.getCatalogName().name)) {
            throw Error.error(5501, string);
        }
    }

    @Override
    void rewind(int n) {
        super.rewind(n);
        this.compileContext.rewind(n);
    }

    public static final class CompileContext {
        final Session session;
        final ParserBase parser;
        final CompileContext baseContext;
        final int basePosition;
        boolean isViewTable;
        private int subqueryDepth;
        private HsqlArrayList namedSubqueries;
        private OrderedIntKeyHashMap parameters = new OrderedIntKeyHashMap();
        private HsqlArrayList usedSequences = new HsqlArrayList(8, true);
        private HsqlArrayList usedRoutines = new HsqlArrayList(8, true);
        private OrderedIntKeyHashMap rangeVariables = new OrderedIntKeyHashMap();
        private HsqlArrayList usedObjects = new HsqlArrayList(8, true);
        Type currentDomain;
        boolean contextuallyTypedExpression;
        Routine callProcedure;
        private RangeGroup[] outerRangeGroups = RangeGroup.emptyArray;
        private final int initialRangeVarIndex;
        private int rangeVarIndex;
        private int test;

        public CompileContext(Session session) {
            this(session, null, null);
        }

        public CompileContext(Session session, ParserBase parserBase, CompileContext compileContext) {
            this.session = session;
            this.parser = parserBase;
            this.baseContext = compileContext;
            if (compileContext == null) {
                this.rangeVarIndex = 1;
                this.initialRangeVarIndex = 1;
                this.basePosition = 0;
            } else {
                this.initialRangeVarIndex = this.rangeVarIndex = compileContext.getRangeVarCount();
                this.basePosition = compileContext.parser.getPosition();
                this.subqueryDepth = compileContext.getDepth();
            }
        }

        public void reset() {
            this.rangeVarIndex = this.initialRangeVarIndex;
            this.subqueryDepth = 0;
            this.rangeVariables.clear();
            this.parameters.clear();
            this.usedSequences.clear();
            this.usedRoutines.clear();
            this.callProcedure = null;
            this.usedObjects.clear();
            this.outerRangeGroups = RangeGroup.emptyArray;
            this.currentDomain = null;
            this.contextuallyTypedExpression = false;
        }

        public int getDepth() {
            return this.subqueryDepth;
        }

        public void incrementDepth() {
            ++this.subqueryDepth;
            if (this.baseContext != null) {
                ++this.baseContext.subqueryDepth;
            }
        }

        public void decrementDepth() {
            this.clearSubqueries();
            --this.subqueryDepth;
            if (this.baseContext != null) {
                --this.baseContext.subqueryDepth;
            }
        }

        public void decrementDepth(int n) {
            while (this.subqueryDepth > n) {
                this.decrementDepth();
            }
        }

        public void rewind(int n) {
            if (this.baseContext != null) {
                this.baseContext.rewind(this.basePosition + n);
                return;
            }
            this.rewindRangeVariables(n);
            this.rewindParameters(n);
        }

        private void rewindRangeVariables(int n) {
            for (int i = this.rangeVariables.size() - 1; i >= 0; --i) {
                int n2 = this.rangeVariables.getKey(i, -1);
                if (n2 <= n) continue;
                this.rangeVariables.removeKeyAndValue(i);
            }
            if (this.rangeVariables.size() > 0) {
                RangeVariable rangeVariable = (RangeVariable)this.rangeVariables.getValue(this.rangeVariables.size() - 1);
                this.rangeVarIndex = rangeVariable.rangePosition + 1;
            } else {
                this.rangeVarIndex = this.initialRangeVarIndex;
            }
        }

        private void rewindParameters(int n) {
            if (this.baseContext != null) {
                this.baseContext.rewindParameters(this.basePosition + n);
                return;
            }
            Iterator iterator = this.parameters.keySet().iterator();
            while (iterator.hasNext()) {
                int n2 = iterator.nextInt();
                if (n2 < n) continue;
                iterator.remove();
            }
        }

        public void setCurrentSubquery(HsqlNameManager.HsqlName hsqlName) {
            this.isViewTable = hsqlName.type == 4;
        }

        public void registerRangeVariable(RangeVariable rangeVariable) {
            int n = this.basePosition;
            if (this.parser != null) {
                n += this.parser.getPosition();
            }
            if (this.isViewTable) {
                rangeVariable.isViewSubquery = true;
            }
            this.registerRangeVariable(rangeVariable, n);
        }

        private void registerRangeVariable(RangeVariable rangeVariable, int n) {
            if (this.baseContext != null) {
                this.baseContext.registerRangeVariable(rangeVariable, n);
                return;
            }
            rangeVariable.rangePosition = this.getNextRangeVarIndex();
            rangeVariable.level = this.subqueryDepth;
            this.rangeVariables.put(n, rangeVariable);
        }

        public void setNextRangeVarIndex(int n) {
            if (this.baseContext != null) {
                this.baseContext.setNextRangeVarIndex(n);
                return;
            }
            this.rangeVarIndex = n;
        }

        private int getNextRangeVarIndex() {
            if (this.baseContext != null) {
                return this.baseContext.getNextRangeVarIndex();
            }
            return this.rangeVarIndex++;
        }

        public int getNextResultRangeVarIndex() {
            RangeVariable rangeVariable = new RangeVariable(null, null, false, 5);
            this.registerRangeVariable(rangeVariable);
            return rangeVariable.rangePosition;
        }

        public int getRangeVarCount() {
            if (this.baseContext != null) {
                return this.baseContext.getRangeVarCount();
            }
            return this.rangeVarIndex;
        }

        public RangeVariable[] getAllRangeVariables() {
            HsqlArrayList hsqlArrayList = new HsqlArrayList();
            for (int i = 0; i < this.rangeVariables.size(); ++i) {
                RangeVariable rangeVariable = (RangeVariable)this.rangeVariables.getValue(i);
                if (rangeVariable.rangeType == 5) continue;
                hsqlArrayList.add(rangeVariable);
            }
            RangeVariable[] rangeVariableArray = new RangeVariable[hsqlArrayList.size()];
            hsqlArrayList.toArray(rangeVariableArray);
            return rangeVariableArray;
        }

        public RangeGroup[] getOuterRanges() {
            if (this.baseContext != null) {
                return this.baseContext.outerRangeGroups;
            }
            return this.outerRangeGroups;
        }

        public void setOuterRanges(RangeGroup[] rangeGroupArray) {
            this.outerRangeGroups = rangeGroupArray;
        }

        public NumberSequence[] getSequences() {
            if (this.usedSequences.size() == 0) {
                return NumberSequence.emptyArray;
            }
            NumberSequence[] numberSequenceArray = new NumberSequence[this.usedSequences.size()];
            this.usedSequences.toArray(numberSequenceArray);
            return numberSequenceArray;
        }

        public Routine[] getRoutines() {
            if (this.callProcedure == null && this.usedRoutines.size() == 0) {
                return Routine.emptyArray;
            }
            OrderedHashSet orderedHashSet = new OrderedHashSet();
            for (int i = 0; i < this.usedRoutines.size(); ++i) {
                FunctionSQLInvoked functionSQLInvoked = (FunctionSQLInvoked)this.usedRoutines.get(i);
                orderedHashSet.add(functionSQLInvoked.routine);
            }
            if (this.callProcedure != null) {
                orderedHashSet.add(this.callProcedure);
            }
            Object[] objectArray = new Routine[orderedHashSet.size()];
            orderedHashSet.toArray(objectArray);
            return objectArray;
        }

        private void initSubqueryNames() {
            HashMappedList hashMappedList;
            if (this.namedSubqueries == null) {
                this.namedSubqueries = new HsqlArrayList();
            }
            if (this.namedSubqueries.size() <= this.subqueryDepth) {
                this.namedSubqueries.setSize(this.subqueryDepth + 1);
            }
            if ((hashMappedList = (HashMappedList)this.namedSubqueries.get(this.subqueryDepth)) == null) {
                hashMappedList = new HashMappedList();
                this.namedSubqueries.set(this.subqueryDepth, hashMappedList);
            }
        }

        private void clearSubqueries() {
            HashMappedList hashMappedList;
            if (this.namedSubqueries != null && this.namedSubqueries.size() > this.subqueryDepth && (hashMappedList = (HashMappedList)this.namedSubqueries.get(this.subqueryDepth)) != null) {
                hashMappedList.clear();
            }
        }

        private void registerSubquery(String string) {
            this.initSubqueryNames();
            HashMappedList hashMappedList = (HashMappedList)this.namedSubqueries.get(this.subqueryDepth);
            boolean bl = hashMappedList.add(string, null);
            if (!bl) {
                throw Error.error(5504, string);
            }
        }

        private void registerSubquery(String string, TableDerived tableDerived) {
            HashMappedList hashMappedList = (HashMappedList)this.namedSubqueries.get(this.subqueryDepth);
            hashMappedList.put(string, tableDerived);
        }

        private void unregisterSubqueries() {
            if (this.namedSubqueries == null) {
                return;
            }
            for (int i = this.subqueryDepth; i < this.namedSubqueries.size(); ++i) {
                this.namedSubqueries.set(i, null);
            }
        }

        private TableDerived getNamedSubQuery(String string) {
            TableDerived tableDerived;
            if (this.baseContext != null && (tableDerived = this.baseContext.getNamedSubQuery(string)) != null) {
                return tableDerived;
            }
            if (this.namedSubqueries == null) {
                return null;
            }
            for (int i = this.subqueryDepth; i >= 0; --i) {
                TableDerived tableDerived2;
                HashMappedList hashMappedList;
                if (this.namedSubqueries.size() <= i || (hashMappedList = (HashMappedList)this.namedSubqueries.get(i)) == null || (tableDerived2 = (TableDerived)hashMappedList.get(string)) == null) continue;
                return tableDerived2;
            }
            return null;
        }

        private void addParameter(ExpressionColumn expressionColumn, int n) {
            expressionColumn.parameterIndex = this.parameters.size();
            this.parameters.put(n, expressionColumn);
        }

        private void addSchemaObject(SchemaObject schemaObject) {
            this.usedObjects.add(schemaObject);
        }

        private void addSequence(SchemaObject schemaObject) {
            this.usedSequences.add(schemaObject);
        }

        void addFunctionCall(FunctionSQLInvoked functionSQLInvoked) {
            this.usedRoutines.add(functionSQLInvoked);
        }

        void addProcedureCall(Routine routine) {
            this.callProcedure = routine;
        }

        ExpressionColumn[] getParameters() {
            if (this.parameters.size() == 0) {
                return ExpressionColumn.emptyArray;
            }
            Object[] objectArray = new ExpressionColumn[this.parameters.size()];
            this.parameters.valuesToArray(objectArray);
            this.parameters.clear();
            return objectArray;
        }

        public OrderedHashSet getSchemaObjectNames() {
            Object object;
            int n;
            OrderedHashSet orderedHashSet = new OrderedHashSet();
            for (n = 0; n < this.usedSequences.size(); ++n) {
                object = (SchemaObject)this.usedSequences.get(n);
                orderedHashSet.add(object.getName());
            }
            for (n = 0; n < this.usedObjects.size(); ++n) {
                object = (SchemaObject)this.usedObjects.get(n);
                orderedHashSet.add(object.getName());
            }
            for (n = 0; n < this.rangeVariables.size(); ++n) {
                object = (RangeVariable)this.rangeVariables.getValue(n);
                if (((RangeVariable)object).isViewSubquery || ((RangeVariable)object).rangeType == 5) continue;
                HsqlNameManager.HsqlName hsqlName = ((RangeVariable)object).rangeTable.getName();
                if (hsqlName.schema != SqlInvariants.SYSTEM_SCHEMA_HSQLNAME) {
                    orderedHashSet.add(hsqlName);
                    orderedHashSet.addAll(((RangeVariable)object).getColumnNames());
                    if (((RangeVariable)object).periodCondition == null || !((RangeVariable)object).periodCondition.isSystemVersionCondition()) continue;
                    orderedHashSet.add(((RangeVariable)object).rangeTable.systemPeriod.getName());
                    continue;
                }
                if (hsqlName.type != 10) continue;
                orderedHashSet.addAll(((RangeVariable)object).getColumnNames());
            }
            Routine[] routineArray = this.getRoutines();
            for (int i = 0; i < routineArray.length; ++i) {
                orderedHashSet.add(routineArray[i].getSpecificName());
            }
            return orderedHashSet;
        }
    }
}

