/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.ui.core.vfs;

import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOCase;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.vfs2.FileContent;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.hop.core.Const;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.gui.plugin.GuiPlugin;
import org.apache.hop.core.gui.plugin.key.GuiKeyboardShortcut;
import org.apache.hop.core.gui.plugin.key.GuiOsxKeyboardShortcut;
import org.apache.hop.core.gui.plugin.toolbar.GuiToolbarElement;
import org.apache.hop.core.logging.ILogChannel;
import org.apache.hop.core.logging.LogChannel;
import org.apache.hop.core.plugins.IPlugin;
import org.apache.hop.core.plugins.PluginRegistry;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.core.vfs.HopVfs;
import org.apache.hop.history.AuditList;
import org.apache.hop.history.AuditManager;
import org.apache.hop.history.AuditState;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.ui.core.PropsUi;
import org.apache.hop.ui.core.dialog.EnterStringDialog;
import org.apache.hop.ui.core.dialog.IDirectoryDialog;
import org.apache.hop.ui.core.dialog.IFileDialog;
import org.apache.hop.ui.core.dialog.MessageBox;
import org.apache.hop.ui.core.gui.GuiResource;
import org.apache.hop.ui.core.gui.GuiToolbarWidgets;
import org.apache.hop.ui.core.gui.HopNamespace;
import org.apache.hop.ui.core.gui.WindowProperty;
import org.apache.hop.ui.core.widget.TextVar;
import org.apache.hop.ui.core.widget.TreeUtil;
import org.apache.hop.ui.hopgui.HopGui;
import org.apache.hop.ui.hopgui.file.HopFileTypePluginType;
import org.apache.hop.ui.hopgui.file.HopFileTypeRegistry;
import org.apache.hop.ui.hopgui.file.IHopFileType;
import org.apache.hop.ui.pipeline.transform.BaseTransformDialog;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.custom.TreeEditor;
import org.eclipse.swt.dnd.DragSource;
import org.eclipse.swt.dnd.DragSourceAdapter;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.DropTargetAdapter;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.MenuAdapter;
import org.eclipse.swt.events.MenuEvent;
import org.eclipse.swt.events.MenuListener;
import org.eclipse.swt.events.ShellAdapter;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;

@GuiPlugin(description="Allows you to browse to local or VFS locations")
public class HopVfsFileDialog
implements IFileDialog,
IDirectoryDialog {
    private static final Class<?> PKG = HopVfsFileDialog.class;
    public static final String BOOKMARKS_AUDIT_TYPE = "vfs-bookmarks";
    public static final String DIALOG_STATE_TYPE = "vfs-dialog-state";
    public static final String DIALOG_STATE_NAME = "vfs-dialog-state";
    public static final String DIALOG_STATE_VALUE_SORT_INDEX = "sortIndex";
    public static final String DIALOG_STATE_VALUE_SORT_ASCENDING = "sortAscending";
    public static final String BOOKMARKS_TOOLBAR_PARENT_ID = "HopVfsFileDialog-BookmarksToolbar";
    private static final String BOOKMARKS_ITEM_ID_BOOKMARKS = "0000-bookmarks";
    private static final String BOOKMARKS_ITEM_ID_BOOKMARK_ADD = "0010-bookmark-add";
    private static final String BOOKMARKS_ITEM_ID_BOOKMARK_GOTO = "0020-bookmark-goto";
    private static final String BOOKMARKS_ITEM_ID_BOOKMARK_REMOVE = "0030-bookmark-remove";
    public static final String NAVIGATE_TOOLBAR_PARENT_ID = "HopVfsFileDialog-NavigateToolbar";
    private static final String NAVIGATE_ITEM_ID_NAVIGATE_HOME = "0000-navigate-home";
    private static final String NAVIGATE_ITEM_ID_NAVIGATE_UP = "0010-navigate-up";
    private static final String NAVIGATE_ITEM_ID_NAVIGATE_PREVIOUS = "0100-navigate-previous";
    private static final String NAVIGATE_ITEM_ID_NAVIGATE_NEXT = "0110-navigate-next";
    private static final String NAVIGATE_ITEM_ID_REFRESH_ALL = "9999-refresh-all";
    public static final String BROWSER_TOOLBAR_PARENT_ID = "HopVfsFileDialog-BrowserToolbar";
    private static final String BROWSER_ITEM_ID_CREATE_FOLDER = "0020-create-folder";
    private static final String BROWSER_ITEM_ID_SHOW_HIDDEN = "0200-show-hidden";
    private static final String BROWSER_ITEM_ID_DELETE = "0100-delete";
    private static final String BROWSER_ITEM_ID_RENAME = "0110-rename";
    private Shell parent;
    private IVariables variables;
    private String text;
    private String fileName;
    private String filterPath;
    private String[] filterExtensions;
    private String[] filterNames;
    private PropsUi props;
    private org.eclipse.swt.widgets.List wBookmarks;
    private TextVar wFilename;
    private Text wDetails;
    private Tree wBrowser;
    private TreeEditor wBrowserEditor;
    private boolean showingHiddenFiles;
    private Shell shell;
    Map<String, FileObject> fileObjectsMap;
    private Map<String, String> bookmarks;
    private FileObject activeFileObject;
    private FileObject activeFolder;
    private Image folderImage;
    private Image fileImage;
    private static HopVfsFileDialog instance;
    private List<String> navigationHistory;
    private int navigationIndex;
    private GuiToolbarWidgets navigateToolbarWidgets;
    private GuiToolbarWidgets browserToolbarWidgets;
    private GuiToolbarWidgets bookmarksToolbarWidgets;
    private Button wOk;
    private Combo wFilters;
    private String message;
    private boolean browsingDirectories;
    private boolean savingFile;
    private String saveFilename;
    private int sortIndex;
    private boolean ascending;
    private String usedNamespace;

    public HopVfsFileDialog() {
    }

    public HopVfsFileDialog(Shell parent, IVariables variables, FileObject fileObject, boolean browsingDirectories, boolean savingFile) {
        this.parent = parent;
        this.variables = variables;
        this.browsingDirectories = browsingDirectories;
        this.savingFile = savingFile;
        String string = this.fileName = this.fileName == null ? null : HopVfs.getFilename((FileObject)fileObject);
        if (this.variables == null) {
            this.variables = HopGui.getInstance().getVariables();
        }
        this.props = PropsUi.getInstance();
        this.usedNamespace = this.props.useGlobalFileBookmarks() ? "hop-gui" : HopNamespace.getNamespace();
        try {
            this.bookmarks = AuditManager.getActive().loadMap(this.usedNamespace, BOOKMARKS_AUDIT_TYPE);
            this.sortIndex = 0;
            this.ascending = true;
            AuditState auditState = AuditManager.retrieveState((ILogChannel)LogChannel.UI, (String)"hop-gui", (String)"vfs-dialog-state", (String)"vfs-dialog-state");
            if (auditState != null) {
                Object indexValue = auditState.getStateMap().get(DIALOG_STATE_VALUE_SORT_INDEX);
                Object ascendingValue = auditState.getStateMap().get(DIALOG_STATE_VALUE_SORT_ASCENDING);
                if (indexValue != null && ascendingValue != null) {
                    this.sortIndex = (Integer)indexValue;
                    this.ascending = (Boolean)ascendingValue;
                }
            }
        }
        catch (Exception e) {
            LogChannel.GENERAL.logError("Error loading bookmarks", (Throwable)e);
            this.bookmarks = new HashMap<String, String>();
        }
        try {
            AuditList auditList = AuditManager.getActive().retrieveList(this.usedNamespace, BOOKMARKS_AUDIT_TYPE);
            this.navigationHistory = auditList.getNames();
        }
        catch (Exception e) {
            LogChannel.GENERAL.logError("Error loading navigation history", (Throwable)e);
            this.navigationHistory = new ArrayList<String>();
        }
        this.navigationIndex = this.navigationHistory.size() - 1;
        this.fileImage = GuiResource.getInstance().getImageFile();
        this.folderImage = GuiResource.getInstance().getImageFolder();
    }

    public static HopVfsFileDialog getInstance() {
        return instance;
    }

    @Override
    public String open() {
        this.shell = new Shell(this.parent, 67696);
        PropsUi.setLook((Widget)this.shell);
        this.shell.setImage(GuiResource.getInstance().getImageHopUi());
        this.shell.addShellListener((ShellListener)new ShellAdapter(){

            public void shellClosed(ShellEvent e) {
                HopVfsFileDialog.this.cancel();
            }
        });
        instance = this;
        FormLayout formLayout = new FormLayout();
        formLayout.marginWidth = PropsUi.getFormMargin();
        formLayout.marginHeight = PropsUi.getFormMargin();
        this.shell.setLayout((Layout)formLayout);
        if (this.text != null) {
            this.shell.setText(this.text);
        }
        this.wOk = new Button((Composite)this.shell, 8);
        this.wOk.setText(BaseMessages.getString(PKG, (String)(this.savingFile ? "System.Button.Save" : "System.Button.Open"), (String[])new String[0]));
        this.wOk.addListener(13, e -> this.okButton());
        Button wCancel = new Button((Composite)this.shell, 8);
        wCancel.setText(BaseMessages.getString(PKG, (String)"System.Button.Cancel", (String[])new String[0]));
        wCancel.addListener(13, e -> this.cancel());
        HopVfsFileDialog hopVfsFileDialog = this;
        BaseTransformDialog.positionBottomButtons((Composite)this.shell, new Button[]{this.wOk, wCancel}, hopVfsFileDialog.props.getMargin(), null);
        Composite navigateComposite = new Composite((Composite)this.shell, 0);
        PropsUi.setLook((Widget)navigateComposite);
        GridLayout gridLayout = new GridLayout(this.browsingDirectories ? 2 : 3, false);
        gridLayout.marginWidth = 0;
        navigateComposite.setLayout((Layout)gridLayout);
        PropsUi.setLook((Widget)navigateComposite);
        FormData fdNavigationForm = new FormData();
        fdNavigationForm.left = new FormAttachment(0, 0);
        fdNavigationForm.top = new FormAttachment(0, 0);
        fdNavigationForm.right = new FormAttachment(100, 0);
        navigateComposite.setLayoutData((Object)fdNavigationForm);
        ToolBar navigateToolBar = new ToolBar(navigateComposite, 16640);
        navigateToolBar.setLayoutData((Object)new GridData(16384, 4, false, true));
        PropsUi.setLook((Widget)navigateToolBar);
        this.navigateToolbarWidgets = new GuiToolbarWidgets();
        this.navigateToolbarWidgets.registerGuiPluginObject(this);
        this.navigateToolbarWidgets.createToolbarWidgets((Composite)navigateToolBar, NAVIGATE_TOOLBAR_PARENT_ID);
        navigateToolBar.pack();
        this.wFilename = new TextVar(this.variables, navigateComposite, 18436);
        this.wFilename.addListener(14, e -> this.enteredFilenameOrFolder());
        this.wFilename.setLayoutData(new GridData(4, 4, true, true));
        PropsUi.setLook((Widget)this.wFilename);
        if (!this.browsingDirectories) {
            this.wFilters = new Combo(navigateComposite, 2052);
            this.wFilters.setItems(this.filterNames);
            this.wFilters.select(0);
            this.wFilters.addListener(13, this::fileFilterSelected);
            this.wFilters.setLayoutData((Object)new GridData(131072, 4, false, false));
            PropsUi.setLook((Widget)this.wFilters);
        }
        SashForm sashForm = new SashForm((Composite)this.shell, 256);
        FormData fdSashForm = new FormData();
        fdSashForm.left = new FormAttachment(0, 0);
        HopVfsFileDialog hopVfsFileDialog2 = this;
        fdSashForm.top = new FormAttachment((Control)navigateComposite, hopVfsFileDialog2.props.getMargin());
        fdSashForm.right = new FormAttachment(100, 0);
        HopVfsFileDialog hopVfsFileDialog3 = this;
        fdSashForm.bottom = new FormAttachment((Control)this.wOk, (int)((double)(-hopVfsFileDialog3.props.getMargin()) * this.props.getZoomFactor()));
        sashForm.setLayoutData((Object)fdSashForm);
        PropsUi.setLook((Widget)sashForm);
        Composite bookmarksComposite = new Composite((Composite)sashForm, 2048);
        PropsUi.setLook((Widget)bookmarksComposite);
        bookmarksComposite.setLayout((Layout)new FormLayout());
        ToolBar bookmarksToolBar = new ToolBar(bookmarksComposite, 16708);
        FormData fdBookmarksToolBar = new FormData();
        fdBookmarksToolBar.left = new FormAttachment(0, 0);
        fdBookmarksToolBar.top = new FormAttachment(0, 0);
        fdBookmarksToolBar.right = new FormAttachment(100, 0);
        bookmarksToolBar.setLayoutData((Object)fdBookmarksToolBar);
        PropsUi.setLook((Widget)bookmarksToolBar, 5);
        this.bookmarksToolbarWidgets = new GuiToolbarWidgets();
        this.bookmarksToolbarWidgets.registerGuiPluginObject(this);
        this.bookmarksToolbarWidgets.createToolbarWidgets((Composite)bookmarksToolBar, BOOKMARKS_TOOLBAR_PARENT_ID);
        bookmarksToolBar.pack();
        this.wBookmarks = new org.eclipse.swt.widgets.List(bookmarksComposite, 17156);
        PropsUi.setLook((Widget)this.wBookmarks);
        FormData fdBookmarks = new FormData();
        fdBookmarks.left = new FormAttachment(0, 0);
        fdBookmarks.right = new FormAttachment(100, 0);
        fdBookmarks.top = new FormAttachment(0, bookmarksToolBar.getSize().y);
        fdBookmarks.bottom = new FormAttachment(100, 0);
        this.wBookmarks.setLayoutData((Object)fdBookmarks);
        this.wBookmarks.addListener(13, e -> this.refreshStates());
        this.wBookmarks.addListener(14, this::bookmarkDefaultSelection);
        final Menu menu = new Menu((Control)this.wBookmarks);
        menu.addMenuListener((MenuListener)new MenuAdapter(){

            public void menuShown(MenuEvent event) {
                MenuItem[] items = menu.getItems();
                for (int i = 0; i < items.length; ++i) {
                    items[i].dispose();
                }
                int selected = HopVfsFileDialog.this.wBookmarks.getSelectionIndex();
                if (selected < 0 || selected >= HopVfsFileDialog.this.wBookmarks.getItemCount()) {
                    return;
                }
                MenuItem removeBookmarkMenuItem = new MenuItem(menu, 0);
                removeBookmarkMenuItem.setText(BaseMessages.getString(PKG, (String)"HopVfsFileDialog.Delete.MenuItem.Label", (String[])new String[0]));
                removeBookmarkMenuItem.addListener(13, e -> HopVfsFileDialog.this.removeBookmark());
            }
        });
        this.wBookmarks.setMenu(menu);
        DropTarget target = new DropTarget((Control)this.wBookmarks, 2);
        target.setTransfer(new Transfer[]{TextTransfer.getInstance()});
        target.addDropListener((DropTargetListener)new DropTargetAdapter(){

            public void dragEnter(DropTargetEvent event) {
                if (event.detail == 16) {
                    event.detail = (event.operations & 1) != 0 ? 1 : 0;
                }
                int n = event.dataTypes.length;
                for (int i = 0; i < n; ++i) {
                    if (!TextTransfer.getInstance().isSupportedType(event.dataTypes[i])) continue;
                    event.currentDataType = event.dataTypes[i];
                }
            }

            public void dragOver(DropTargetEvent event) {
                event.feedback = 9;
            }

            public void drop(DropTargetEvent event) {
                if (TextTransfer.getInstance().isSupportedType(event.currentDataType)) {
                    FileObject file = HopVfsFileDialog.this.fileObjectsMap.get((String)event.data);
                    if (file != null) {
                        String name = file.getName().getBaseName();
                        EnterStringDialog dialog = new EnterStringDialog(HopVfsFileDialog.this.shell, name, BaseMessages.getString(PKG, (String)"HopVfsFileDialog.BookmarkDialog.Header", (String[])new String[0]), BaseMessages.getString(PKG, (String)"HopVfsFileDialog.BookmarkDialog.Message", (String[])new String[0]));
                        if ((name = dialog.open()) != null) {
                            String path = HopVfs.getFilename((FileObject)file);
                            HopVfsFileDialog.this.bookmarks.put(name, path);
                            HopVfsFileDialog.this.saveBookmarks();
                            HopVfsFileDialog.this.refreshBookmarks();
                        }
                    }
                    HopVfsFileDialog.this.refreshStates();
                }
            }
        });
        Composite browserComposite = new Composite((Composite)sashForm, 2048);
        PropsUi.setLook((Widget)browserComposite);
        browserComposite.setLayout((Layout)new FormLayout());
        FormData fdTreeComposite = new FormData();
        fdTreeComposite.left = new FormAttachment(0, 0);
        fdTreeComposite.right = new FormAttachment(100, 0);
        fdTreeComposite.top = new FormAttachment(0, 0);
        fdTreeComposite.bottom = new FormAttachment(100, 0);
        browserComposite.setLayoutData((Object)fdTreeComposite);
        ToolBar browserToolBar = new ToolBar(browserComposite, 16704);
        FormData fdBrowserToolBar = new FormData();
        fdBrowserToolBar.left = new FormAttachment(0, 0);
        fdBrowserToolBar.top = new FormAttachment(0, 0);
        fdBrowserToolBar.right = new FormAttachment(100, 0);
        browserToolBar.setLayoutData((Object)fdBrowserToolBar);
        PropsUi.setLook((Widget)browserToolBar, 5);
        this.browserToolbarWidgets = new GuiToolbarWidgets();
        this.browserToolbarWidgets.registerGuiPluginObject(this);
        this.browserToolbarWidgets.createToolbarWidgets((Composite)browserToolBar, BROWSER_TOOLBAR_PARENT_ID);
        browserToolBar.pack();
        SashForm browseSash = new SashForm(browserComposite, 512);
        this.wBrowser = new Tree((Composite)browseSash, 772);
        PropsUi.setLook((Widget)this.wBrowser);
        this.wBrowser.setHeaderVisible(true);
        this.wBrowser.setLinesVisible(false);
        TreeColumn folderColumn = new TreeColumn(this.wBrowser, 16384);
        folderColumn.setText(BaseMessages.getString(PKG, (String)"HopVfsFileDialog.Folder.Name.Label", (String[])new String[0]));
        folderColumn.setWidth((int)(200.0 * this.props.getZoomFactor()));
        folderColumn.addListener(13, e -> this.browserColumnSelected(0));
        TreeColumn modifiedColumn = new TreeColumn(this.wBrowser, 16384);
        modifiedColumn.setText(BaseMessages.getString(PKG, (String)"HopVfsFileDialog.Modified.Date.Label", (String[])new String[0]));
        modifiedColumn.setWidth((int)(150.0 * this.props.getZoomFactor()));
        modifiedColumn.addListener(13, e -> this.browserColumnSelected(1));
        TreeColumn sizeColumn = new TreeColumn(this.wBrowser, 131072);
        sizeColumn.setText(BaseMessages.getString(PKG, (String)"HopVfsFileDialog.File.Size.Label", (String[])new String[0]));
        sizeColumn.setWidth((int)(100.0 * this.props.getZoomFactor()));
        sizeColumn.addListener(13, e -> this.browserColumnSelected(2));
        this.wBrowser.addListener(13, this::fileSelected);
        this.wBrowser.addListener(14, this::fileDefaultSelected);
        this.wBrowser.addListener(11, e -> this.resizeTableColumn());
        DragSource dragSource = new DragSource((Control)this.wBrowser, 3);
        dragSource.setTransfer(new Transfer[]{TextTransfer.getInstance()});
        dragSource.addDragListener((DragSourceListener)new DragSourceAdapter(){

            public void dragStart(DragSourceEvent event) {
                TreeItem[] selection = HopVfsFileDialog.this.wBrowser.getSelection();
                event.doit = selection != null && selection.length == 1;
            }

            public void dragSetData(DragSourceEvent event) {
                TreeItem[] selection = HopVfsFileDialog.this.wBrowser.getSelection();
                event.data = HopVfsFileDialog.this.getTreeItemPath(selection[0]);
            }
        });
        this.wBrowserEditor = new TreeEditor(this.wBrowser);
        this.wBrowserEditor.horizontalAlignment = 16384;
        this.wBrowserEditor.grabHorizontal = true;
        this.wDetails = new Text((Composite)browseSash, 778);
        PropsUi.setLook((Widget)this.wDetails);
        FormData fdBrowseSash = new FormData();
        fdBrowseSash.left = new FormAttachment(0, 0);
        fdBrowseSash.right = new FormAttachment(100, 0);
        fdBrowseSash.top = new FormAttachment((Control)browserToolBar, 0);
        fdBrowseSash.bottom = new FormAttachment(100, 0);
        browseSash.setLayoutData((Object)fdBrowseSash);
        browseSash.setWeights(new int[]{90, 10});
        sashForm.setWeights(new int[]{15, 85});
        this.getData();
        BaseTransformDialog.setSize(this.shell);
        Point shellSize = this.shell.getSize();
        if (shellSize.y < shellSize.x / 2) {
            this.shell.setSize(shellSize.x, shellSize.x / 2);
        }
        this.wFilename.setFocus();
        this.shell.open();
        while (!this.shell.isDisposed()) {
            if (this.shell.getDisplay().readAndDispatch()) continue;
            this.shell.getDisplay().sleep();
        }
        if (this.activeFileObject == null) {
            return null;
        }
        return this.activeFileObject.toString();
    }

    private void browserColumnSelected(int index) {
        if (index == this.sortIndex) {
            this.ascending = !this.ascending;
        } else {
            this.sortIndex = index;
            this.ascending = true;
        }
        this.wBrowser.setSortColumn(this.wBrowser.getColumn(index));
        this.wBrowser.setSortDirection(this.ascending ? 1024 : 128);
        this.refreshBrowser();
    }

    private void fileFilterSelected(Event event) {
        this.refreshBrowser();
    }

    @Override
    public void setMessage(String message) {
        this.message = message;
    }

    public void browseToSelectedBookmark() {
        String name = this.getSelectedBookmark();
        if (name == null) {
            return;
        }
        String path = this.bookmarks.get(name);
        if (path != null) {
            this.navigateTo(path, true);
        }
    }

    private String getSelectedBookmark() {
        int selectionIndex = this.wBookmarks.getSelectionIndex();
        if (selectionIndex < 0) {
            return null;
        }
        String name = this.wBookmarks.getItems()[selectionIndex];
        return name;
    }

    private void bookmarkDefaultSelection(Event event) {
        this.browseToSelectedBookmark();
    }

    private void okButton() {
        try {
            this.activeFileObject = HopVfs.getFileObject((String)this.wFilename.getText());
            if (!this.browsingDirectories && this.activeFileObject.isFolder()) {
                this.navigateTo(HopVfs.getFilename((FileObject)this.activeFileObject), true);
                return;
            }
            this.ok();
        }
        catch (Throwable e) {
            this.showError(BaseMessages.getString(PKG, (String)"HopVfsFileDialog.ParsingFilename.Error.Message", (String[])new String[]{this.wFilename.getText()}), e);
        }
    }

    private void enteredFilenameOrFolder() {
        if (StringUtils.isNotEmpty((String)this.saveFilename)) {
            try {
                FileObject fullObject = HopVfs.getFileObject((String)this.wFilename.getText());
                if (!fullObject.isFolder()) {
                    this.activeFileObject = fullObject;
                    this.ok();
                    return;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.refreshBrowser();
    }

    private FileObject getSelectedFileObject() {
        TreeItem[] selection = this.wBrowser.getSelection();
        if (selection == null || selection.length != 1) {
            return null;
        }
        String path = this.getTreeItemPath(selection[0]);
        FileObject fileObject = this.fileObjectsMap.get(path);
        return fileObject;
    }

    private void fileSelected(Event e) {
        FileObject selectedFile = this.getSelectedFileObject();
        if (selectedFile != null) {
            this.showFilename(selectedFile);
        }
        this.updateSelection();
    }

    private void showFilename(FileObject fileObject) {
        try {
            Map attributes;
            this.wFilename.setText(HopVfs.getFilename((FileObject)fileObject));
            FileContent content = fileObject.getContent();
            Object details = "";
            if (fileObject.isFolder()) {
                details = (String)details + BaseMessages.getString(PKG, (String)"HopVfsFileDialog.FileInfo.Tooltip.Folder", (String[])new String[]{HopVfs.getFilename((FileObject)fileObject)}) + Const.CR;
            } else {
                details = (String)details + BaseMessages.getString(PKG, (String)"HopVfsFileDialog.FileInfo.Tooltip.Name", (String[])new String[]{fileObject.getName().getBaseName()}) + "   ";
                details = (String)details + BaseMessages.getString(PKG, (String)"HopVfsFileDialog.FileInfo.Tooltip.Folder", (String[])new String[]{HopVfs.getFilename((FileObject)fileObject.getParent())}) + "   ";
                details = (String)details + BaseMessages.getString(PKG, (String)"HopVfsFileDialog.FileInfo.Tooltip.Size", (Object[])new Object[]{content.getSize()});
                if (content.getSize() >= 1024L) {
                    details = (String)details + " (" + this.getFileSize(fileObject) + ")";
                }
                details = (String)details + Const.CR;
            }
            details = (String)details + BaseMessages.getString(PKG, (String)"HopVfsFileDialog.FileInfo.Tooltip.LastModified", (String[])new String[]{this.getFileDate(fileObject)}) + Const.CR;
            details = (String)details + BaseMessages.getString(PKG, (String)"HopVfsFileDialog.FileInfo.Tooltip.Readable", (String[])new String[]{fileObject.isReadable() ? BaseMessages.getString(PKG, (String)"HopVfsFileDialog.Yes.Label", (String[])new String[0]) : BaseMessages.getString(PKG, (String)"HopVfsFileDialog.No.Label", (String[])new String[0])}) + "  ";
            details = (String)details + BaseMessages.getString(PKG, (String)"HopVfsFileDialog.FileInfo.Tooltip.Writeable", (String[])new String[]{fileObject.isWriteable() ? BaseMessages.getString(PKG, (String)"HopVfsFileDialog.Yes.Label", (String[])new String[0]) : BaseMessages.getString(PKG, (String)"HopVfsFileDialog.No.Label", (String[])new String[0])}) + "  ";
            details = (String)details + BaseMessages.getString(PKG, (String)"HopVfsFileDialog.FileInfo.Tooltip.Executable", (String[])new String[]{fileObject.isExecutable() ? BaseMessages.getString(PKG, (String)"HopVfsFileDialog.Yes.Label", (String[])new String[0]) : BaseMessages.getString(PKG, (String)"HopVfsFileDialog.No.Label", (String[])new String[0])}) + Const.CR;
            if (fileObject.isSymbolicLink()) {
                details = (String)details + BaseMessages.getString(PKG, (String)"HopVfsFileDialog.FileInfo.Tooltip.Symlink", (String[])new String[0]) + Const.CR;
            }
            if ((attributes = content.getAttributes()) != null && !attributes.isEmpty()) {
                details = (String)details + BaseMessages.getString(PKG, (String)"HopVfsFileDialog.FileInfo.Tooltip.Attributes", (String[])new String[0]) + Const.CR;
                Iterator iterator = attributes.keySet().iterator();
                while (iterator.hasNext()) {
                    String key;
                    Object value = attributes.get(key = (String)iterator.next());
                    details = (String)details + "   " + key + " : " + (value == null ? "" : value.toString()) + Const.CR;
                }
            }
            this.showDetails((String)details);
        }
        catch (Throwable e) {
            this.showError(BaseMessages.getString(PKG, (String)"HopVfsFileDialog.FilenameInfo.Error.Message", (String[])new String[]{fileObject.toString()}), e);
        }
    }

    private void fileDefaultSelected(Event event) {
        FileObject fileObject = this.getSelectedFileObject();
        if (fileObject == null) {
            return;
        }
        try {
            this.navigateTo(HopVfs.getFilename((FileObject)fileObject), true);
            if (fileObject.isFolder()) {
                this.refreshBrowser();
            } else {
                this.okButton();
            }
        }
        catch (Throwable e) {
            this.showError(BaseMessages.getString(PKG, (String)"HopVfsFileDialog.DefaultSelection.Handling.Error.Message", (String[])new String[]{fileObject.toString()}), e);
        }
    }

    private void getData() {
        if (!this.browsingDirectories) {
            this.wFilters.select(0);
        }
        this.refreshBookmarks();
        if (StringUtils.isEmpty((String)this.fileName)) {
            this.fileName = StringUtils.isEmpty((String)this.filterPath) ? System.getProperty("user.home") : this.filterPath;
        }
        this.showDetails(this.message);
        this.navigateTo(this.fileName, true);
        this.ascending = !this.ascending;
        this.browserColumnSelected(this.sortIndex);
    }

    private void showDetails(String details) {
        this.wDetails.setText(Const.NVL((String)details, (String)Const.NVL((String)this.message, (String)"")));
    }

    private void refreshBookmarks() {
        ArrayList<String> bookmarkNames = new ArrayList<String>(this.bookmarks.keySet());
        Collections.sort(bookmarkNames);
        this.wBookmarks.setItems(bookmarkNames.toArray(new String[0]));
    }

    private void refreshBrowser() {
        String filename = this.wFilename.getText();
        if (StringUtils.isEmpty((String)filename)) {
            return;
        }
        try {
            this.activeFileObject = HopVfs.getFileObject((String)filename);
            this.activeFolder = this.activeFileObject.isFolder() ? this.activeFileObject : this.activeFileObject.getParent();
            this.wBrowser.removeAll();
            this.fileObjectsMap = new HashMap<String, FileObject>();
            TreeItem parentFolderItem = new TreeItem(this.wBrowser, 0);
            parentFolderItem.setImage(this.folderImage);
            String itemName = this.activeFolder.getName().getBaseName();
            if (StringUtils.isEmpty((String)itemName)) {
                itemName = this.activeFolder.getName().getURI();
            }
            parentFolderItem.setText(itemName);
            this.fileObjectsMap.put(this.getTreeItemPath(parentFolderItem), this.activeFolder);
            this.populateFolder(this.activeFolder, parentFolderItem);
            parentFolderItem.setExpanded(true);
            this.updateSelection();
        }
        catch (Throwable e) {
            this.showError(BaseMessages.getString(PKG, (String)"HopVfsFileDialog.Browsing.Error.Message", (String[])new String[]{filename}), e);
        }
    }

    private void showError(String string, Throwable e) {
        this.showDetails(string + Const.CR + Const.getSimpleStackTrace((Throwable)e) + Const.CR + Const.CR + Const.getClassicStackTrace((Throwable)e));
    }

    private String getTreeItemPath(TreeItem item) {
        String path = "/" + item.getText();
        for (TreeItem parentItem = item.getParentItem(); parentItem != null; parentItem = parentItem.getParentItem()) {
            path = "/" + parentItem.getText() + path;
        }
        String filename = item.getText(0);
        if (StringUtils.isNotEmpty((String)filename)) {
            path = path + filename;
        }
        return path;
    }

    private void populateFolder(FileObject folder, TreeItem folderItem) throws FileSystemException {
        String baseFilename;
        FileObject[] children = folder.getChildren();
        Arrays.sort(children, (child1, child2) -> {
            try {
                int cmp;
                switch (this.sortIndex) {
                    case 0: {
                        String name1 = child1.getName().getBaseName();
                        String name2 = child2.getName().getBaseName();
                        cmp = name1.compareToIgnoreCase(name2);
                        break;
                    }
                    case 1: {
                        long time1 = child1.getContent().getLastModifiedTime();
                        long time2 = child2.getContent().getLastModifiedTime();
                        cmp = Long.compare(time1, time2);
                        break;
                    }
                    case 2: {
                        long size1 = child1.getContent().getSize();
                        long size2 = child2.getContent().getSize();
                        cmp = Long.compare(size1, size2);
                        break;
                    }
                    default: {
                        cmp = 0;
                    }
                }
                if (this.ascending) {
                    return -cmp;
                }
                return cmp;
            }
            catch (Exception e) {
                return 0;
            }
        });
        for (FileObject child : children) {
            if (!child.isFolder()) continue;
            baseFilename = child.getName().getBaseName();
            if (!this.showingHiddenFiles && baseFilename.startsWith(".")) continue;
            TreeItem childFolderItem = new TreeItem(folderItem, 0);
            childFolderItem.setImage(this.folderImage);
            childFolderItem.setText(child.getName().getBaseName());
            this.fileObjectsMap.put(this.getTreeItemPath(childFolderItem), child);
        }
        if (!this.browsingDirectories) {
            for (FileObject child : children) {
                String[] exts;
                if (!child.isFile()) continue;
                baseFilename = child.getName().getBaseName();
                if (!this.showingHiddenFiles && baseFilename.startsWith(".")) continue;
                boolean selectFile = false;
                String selectedExtensions = this.filterExtensions[this.wFilters.getSelectionIndex()];
                for (String ext : exts = selectedExtensions.split(";")) {
                    if (!FilenameUtils.wildcardMatch((String)baseFilename, (String)ext, (IOCase)IOCase.INSENSITIVE)) continue;
                    selectFile = true;
                }
                if (!selectFile) continue;
                TreeItem childFileItem = new TreeItem(folderItem, 0);
                childFileItem.setImage(this.getFileImage(child));
                childFileItem.setFont(GuiResource.getInstance().getFontBold());
                childFileItem.setText(0, child.getName().getBaseName());
                childFileItem.setText(1, this.getFileDate(child));
                childFileItem.setText(2, this.getFileSize(child));
                this.fileObjectsMap.put(this.getTreeItemPath(childFileItem), child);
                if (!child.isReadable()) {
                    childFileItem.setForeground(GuiResource.getInstance().getColorGray());
                }
                if (!child.equals(this.activeFileObject)) continue;
                this.wBrowser.setSelection(childFileItem);
                this.wBrowser.showSelection();
            }
        }
    }

    private Image getFileImage(FileObject file) {
        try {
            IPlugin plugin;
            IHopFileType fileType = HopFileTypeRegistry.getInstance().findHopFileType(file.getName().getBaseName());
            if (fileType != null && (plugin = PluginRegistry.getInstance().getPlugin(HopFileTypePluginType.class, (Object)fileType)) != null && plugin.getImageFile() != null) {
                ClassLoader classLoader = PluginRegistry.getInstance().getClassLoader(plugin);
                return GuiResource.getInstance().getImage(plugin.getImageFile(), classLoader, 16, 16);
            }
        }
        catch (HopException hopException) {
            // empty catch block
        }
        return this.fileImage;
    }

    private String getFileSize(FileObject child) {
        try {
            long size = child.getContent().getSize();
            String[] units = new String[]{"", " kB", " MB", " GB", " TB", " PB", " XB", " YB", " ZB"};
            for (int i = 0; i < units.length; ++i) {
                double unitSize = Math.pow(1024.0, i);
                double maxSize = Math.pow(1024.0, i + 1);
                if (!((double)size < maxSize)) continue;
                return new DecimalFormat("0.#").format((double)size / unitSize) + units[i];
            }
            return Long.toString(size);
        }
        catch (Exception e) {
            LogChannel.GENERAL.logError("Error getting size of file : " + child.toString(), (Throwable)e);
            return "?";
        }
    }

    private String getFileDate(FileObject child) {
        try {
            long lastModifiedTime = child.getContent().getLastModifiedTime();
            return new SimpleDateFormat("yyyy/MM/dd HH:mm:ss").format(new Date(lastModifiedTime));
        }
        catch (Exception e) {
            LogChannel.GENERAL.logError("Error getting last modified date of file : " + child.toString(), (Throwable)e);
            return "?";
        }
    }

    private void cancel() {
        this.activeFileObject = null;
        this.dispose();
    }

    private void ok() {
        try {
            if (this.activeFileObject.isFolder()) {
                this.filterPath = HopVfs.getFilename((FileObject)this.activeFileObject);
                this.fileName = null;
            } else {
                this.filterPath = HopVfs.getFilename((FileObject)this.activeFileObject.getParent());
                this.fileName = this.activeFileObject.getName().getBaseName();
            }
            this.dispose();
        }
        catch (FileSystemException e) {
            this.showError(BaseMessages.getString(PKG, (String)"HopVfsFileDialog.FindParentFolder.Error.Message", (String[])new String[]{this.activeFileObject.toString()}), e);
        }
    }

    private void dispose() {
        instance = null;
        try {
            AuditManager.getActive().storeList(this.usedNamespace, BOOKMARKS_AUDIT_TYPE, new AuditList(this.navigationHistory));
            AuditManager.storeState((ILogChannel)LogChannel.UI, (String)"hop-gui", (String)"vfs-dialog-state", (String)"vfs-dialog-state", Map.of(DIALOG_STATE_VALUE_SORT_INDEX, this.sortIndex, DIALOG_STATE_VALUE_SORT_ASCENDING, this.ascending));
        }
        catch (Exception e) {
            LogChannel.GENERAL.logError("Error storing navigation history", (Throwable)e);
        }
        this.props.setScreen(new WindowProperty(this.shell));
        this.bookmarksToolbarWidgets.dispose();
        this.browserToolbarWidgets.dispose();
        this.shell.dispose();
    }

    @GuiToolbarElement(root="HopVfsFileDialog-BookmarksToolbar", id="0010-bookmark-add", toolTip="i18n::HopVfsFileDialog.AddBookmark.Tooltip.Message", image="ui/images/bookmark-add.svg")
    public void addBookmark() {
        FileObject selectedFile = this.getSelectedFileObject();
        if (selectedFile != null) {
            String name = selectedFile.getName().getBaseName();
            EnterStringDialog dialog = new EnterStringDialog(this.shell, name, BaseMessages.getString(PKG, (String)"HopVfsFileDialog.NameBookmark.Header", (String[])new String[0]), BaseMessages.getString(PKG, (String)"HopVfsFileDialog.NameBookmark.Message", (String[])new String[0]));
            if ((name = dialog.open()) != null) {
                String path = HopVfs.getFilename((FileObject)selectedFile);
                this.bookmarks.put(name, path);
                this.saveBookmarks();
                this.refreshBookmarks();
            }
        }
        this.refreshStates();
    }

    @GuiToolbarElement(root="HopVfsFileDialog-BookmarksToolbar", id="0030-bookmark-remove", toolTip="i18n::HopVfsFileDialog.RemoveBookmark.Tooltip.Message", image="ui/images/delete.svg")
    public void removeBookmark() {
        String name = this.getSelectedBookmark();
        if (name != null) {
            this.bookmarks.remove(name);
            this.saveBookmarks();
            this.refreshBookmarks();
        }
        this.refreshStates();
    }

    private void saveBookmarks() {
        try {
            AuditManager.getActive().saveMap(this.usedNamespace, BOOKMARKS_AUDIT_TYPE, this.bookmarks);
        }
        catch (Throwable e) {
            this.showError(BaseMessages.getString(PKG, (String)"HopVfsFileDialog.Bookmark.Error.Message", (String[])new String[]{this.activeFileObject.toString()}), e);
        }
    }

    public void navigateTo(String filename, boolean saveHistory) {
        if (saveHistory) {
            if (this.navigationIndex >= 0 && this.navigationIndex < this.navigationHistory.size()) {
                this.navigationHistory.subList(this.navigationIndex, this.navigationHistory.size());
            }
            this.navigationHistory.add(filename);
            this.navigationIndex = this.navigationHistory.size() - 1;
        }
        if (StringUtils.isEmpty((String)this.saveFilename)) {
            this.wFilename.setText(filename);
        } else {
            try {
                String oldFull = this.wFilename.getText();
                if (StringUtils.isNotEmpty((String)oldFull)) {
                    try {
                        FileObject oldFullObject = HopVfs.getFileObject((String)oldFull);
                        if (!oldFullObject.isFolder()) {
                            this.saveFilename = oldFullObject.getName().getBaseName();
                        }
                    }
                    catch (Exception oldFullObject) {}
                } else if (StringUtils.isNotEmpty((String)this.filterPath)) {
                    this.wFilename.setText(this.filterPath + "/" + this.saveFilename);
                }
                if (HopVfs.getFileObject((String)filename).isFolder()) {
                    String fullPath = FilenameUtils.concat((String)filename, (String)this.saveFilename);
                    this.wFilename.setText(fullPath);
                    int start = fullPath.lastIndexOf(this.saveFilename);
                    int end = fullPath.lastIndexOf(".");
                    this.wFilename.getTextWidget().setSelection(start, end);
                    this.wFilename.setFocus();
                }
            }
            catch (Exception e) {
                this.wFilename.setText(filename);
            }
        }
        this.refreshBrowser();
        this.refreshStates();
        this.resizeTableColumn();
    }

    @GuiToolbarElement(root="HopVfsFileDialog-NavigateToolbar", id="0000-navigate-home", toolTip="i18n::HopVfsFileDialog.NavigateToHome.Tooltip.Message", image="ui/images/home.svg")
    public void navigateHome() {
        this.navigateTo(System.getProperty("user.home"), true);
    }

    @GuiToolbarElement(root="HopVfsFileDialog-NavigateToolbar", id="9999-refresh-all", toolTip="i18n::HopVfsFileDialog.Refresh.Tooltip.Message", image="ui/images/refresh.svg")
    public void refreshAll() {
        this.refreshBookmarks();
        this.refreshBrowser();
    }

    @GuiToolbarElement(root="HopVfsFileDialog-NavigateToolbar", id="0010-navigate-up", toolTip="i18n::HopVfsFileDialog.NavigateToParent.Tooltip.Message", image="ui/images/navigate-up.svg")
    public void navigateUp() {
        try {
            FileObject parent;
            FileObject fileObject = HopVfs.getFileObject((String)this.wFilename.getText());
            if (fileObject.isFile()) {
                fileObject = fileObject.getParent();
            }
            if ((parent = fileObject.getParent()) != null) {
                this.navigateTo(HopVfs.getFilename((FileObject)parent), true);
            }
        }
        catch (Throwable e) {
            this.showError(BaseMessages.getString(PKG, (String)"HopVfsFileDialog.NavigateFolderUp.Error.Message", (String[])new String[]{this.activeFileObject.toString()}), e);
        }
    }

    @GuiToolbarElement(root="HopVfsFileDialog-BrowserToolbar", id="0020-create-folder", toolTip="i18n::HopVfsFileDialog.CreateFolder.Tooltip.Message", image="ui/images/folder-add.svg")
    public void createFolder() {
        String folder = "";
        EnterStringDialog dialog = new EnterStringDialog(this.shell, folder, BaseMessages.getString(PKG, (String)"HopVfsFileDialog.CreateFolder.Header", (String[])new String[0]), BaseMessages.getString(PKG, (String)"HopVfsFileDialog.CreateFolder.Message", (Object[])new Object[]{this.activeFolder}));
        if ((folder = dialog.open()) != null) {
            Object newPath = this.activeFolder.toString();
            if (!((String)newPath).endsWith("/") && !((String)newPath).endsWith("\\")) {
                newPath = (String)newPath + "/";
            }
            newPath = (String)newPath + folder;
            try {
                FileObject newFolder = HopVfs.getFileObject((String)newPath);
                newFolder.createFolder();
                this.refreshBrowser();
            }
            catch (Throwable e) {
                this.showError(BaseMessages.getString(PKG, (String)"HopVfsFileDialog.FolderCreate.Error.Message", (String[])new String[]{newPath}), e);
            }
        }
    }

    @GuiToolbarElement(root="HopVfsFileDialog-BrowserToolbar", id="0110-rename", toolTip="i18n::HopVfsFileDialog.RenameFile.Tooltip.Message", image="ui/images/rename.svg")
    @GuiKeyboardShortcut(key=0x100000B)
    @GuiOsxKeyboardShortcut(key=0x100000B)
    public void renameFile() {
        FileObject file = this.getSelectedFileObject();
        if (file != null) {
            TreeItem item = this.wBrowser.getSelection()[0];
            Text text = new Text((Composite)this.wBrowser, 2048);
            text.setText(file.getName().getBaseName());
            text.addListener(16, event -> text.dispose());
            text.addListener(2, event -> {
                switch (event.keyCode) {
                    case 13: 
                    case 0x1000050: {
                        if (item.getText().equals(text.getText())) break;
                        try {
                            if (file.isFolder()) {
                                this.wFilename.setText(file.getParent().getName().getURI());
                            }
                            FileObject newFile = HopVfs.getFileObject((String)(HopVfs.getFilename((FileObject)file.getParent()) + "/" + text.getText()));
                            file.moveTo(newFile);
                            break;
                        }
                        catch (Exception e) {
                            this.showError(BaseMessages.getString(PKG, (String)"HopVfsFileDialog.RenameFile.Error.Message", (Object[])new Object[]{file}), e);
                            break;
                        }
                        finally {
                            text.dispose();
                            this.refreshBrowser();
                        }
                    }
                    case 27: {
                        text.dispose();
                    }
                }
            });
            text.selectAll();
            text.setFocus();
            this.wBrowserEditor.setEditor((Control)text, item);
        }
    }

    @GuiToolbarElement(root="HopVfsFileDialog-BrowserToolbar", id="0100-delete", toolTip="i18n::HopVfsFileDialog.DeleteFile.Tooltip.Message", image="ui/images/delete.svg")
    @GuiKeyboardShortcut(key=127)
    @GuiOsxKeyboardShortcut(key=127)
    public void deleteFile() {
        FileObject file = this.getSelectedFileObject();
        if (file != null) {
            try {
                MessageBox box = new MessageBox(this.shell, 196);
                box.setText(BaseMessages.getString(PKG, (String)"HopVfsFileDialog.DeleteFile.Confirmation.Header", (String[])new String[0]));
                box.setMessage(BaseMessages.getString(PKG, (String)"HopVfsFileDialog.DeleteFile.Confirmation.Message", (String[])new String[0]) + Const.CR + Const.CR + file.getName());
                int answer = box.open();
                if ((answer & 0x40) != 0) {
                    boolean deleted;
                    if (file.isFolder()) {
                        this.wFilename.setText(file.getParent().getName().getURI());
                    }
                    if (deleted = file.delete()) {
                        this.refreshBrowser();
                    }
                }
            }
            catch (Exception e) {
                this.showError(BaseMessages.getString(PKG, (String)"HopVfsFileDialog.DeleteFile.Error.Message", (String[])new String[]{file.toString()}), e);
            }
        }
    }

    @GuiToolbarElement(root="HopVfsFileDialog-NavigateToolbar", id="0100-navigate-previous", toolTip="i18n::HopVfsFileDialog.NavigateToPrevPath.Tooltip.Message", image="ui/images/navigate-back.svg", separator=true)
    public void navigateHistoryPrevious() {
        if (this.navigationIndex - 1 >= 0) {
            --this.navigationIndex;
            this.navigateTo(this.navigationHistory.get(this.navigationIndex), false);
        }
    }

    @GuiToolbarElement(root="HopVfsFileDialog-NavigateToolbar", id="0110-navigate-next", toolTip="i18n::HopVfsFileDialog.NavigateToNextPath.Tooltip.Message", image="ui/images/navigate-forward.svg")
    public void navigateHistoryNext() {
        if (this.navigationIndex + 1 < this.navigationHistory.size() - 1) {
            ++this.navigationIndex;
            this.navigateTo(this.navigationHistory.get(this.navigationIndex), false);
        }
    }

    @GuiToolbarElement(root="HopVfsFileDialog-BrowserToolbar", id="0200-show-hidden", toolTip="i18n::HopVfsFileDialog.ShowHiddenFiles.Tooltip.Message", image="ui/images/hide.svg", separator=true)
    public void showHideHidden() {
        this.showingHiddenFiles = !this.showingHiddenFiles;
        ToolItem toolItem = this.browserToolbarWidgets.findToolItem(BROWSER_ITEM_ID_SHOW_HIDDEN);
        if (toolItem != null) {
            if (this.showingHiddenFiles) {
                toolItem.setImage(GuiResource.getInstance().getImageShow());
            } else {
                toolItem.setImage(GuiResource.getInstance().getImageHide());
            }
        }
        this.refreshBrowser();
    }

    private void refreshStates() {
        boolean canGoUp;
        this.navigateToolbarWidgets.enableToolbarItem(NAVIGATE_ITEM_ID_NAVIGATE_PREVIOUS, this.navigationIndex > 0);
        this.navigateToolbarWidgets.enableToolbarItem(NAVIGATE_ITEM_ID_NAVIGATE_NEXT, this.navigationIndex + 1 < this.navigationHistory.size());
        try {
            FileObject fileObject = HopVfs.getFileObject((String)this.wFilename.getText());
            canGoUp = fileObject.isFile() ? fileObject.getParent().getParent() != null : fileObject.getParent() != null;
        }
        catch (Exception e) {
            canGoUp = false;
        }
        this.browserToolbarWidgets.enableToolbarItem(NAVIGATE_ITEM_ID_NAVIGATE_UP, canGoUp);
        boolean bookmarkSelected = this.getSelectedBookmark() != null;
        this.bookmarksToolbarWidgets.enableToolbarItem(BOOKMARKS_ITEM_ID_BOOKMARK_GOTO, bookmarkSelected);
        this.bookmarksToolbarWidgets.enableToolbarItem(BOOKMARKS_ITEM_ID_BOOKMARK_REMOVE, bookmarkSelected);
        this.wOk.setEnabled(StringUtils.isNotEmpty((String)this.wFilename.getText()));
    }

    private void resizeTableColumn() {
        TreeUtil.setOptimalWidthOnColumns(this.wBrowser);
    }

    public String getText() {
        return this.text;
    }

    @Override
    public void setText(String text) {
        this.text = text;
    }

    public IVariables getVariables() {
        return this.variables;
    }

    public void setVariables(IVariables variables) {
        this.variables = variables;
    }

    @Override
    public String getFileName() {
        return this.fileName;
    }

    @Override
    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public String[] getFilterExtensions() {
        return this.filterExtensions;
    }

    @Override
    public void setFilterExtensions(String[] filterExtensions) {
        this.filterExtensions = filterExtensions;
    }

    public String[] getFilterNames() {
        return this.filterNames;
    }

    @Override
    public void setFilterNames(String[] filterNames) {
        this.filterNames = filterNames;
    }

    public Map<String, String> getBookmarks() {
        return this.bookmarks;
    }

    public void setBookmarks(Map<String, String> bookmarks) {
        this.bookmarks = bookmarks;
    }

    public FileObject getActiveFileObject() {
        return this.activeFileObject;
    }

    public void setActiveFileObject(FileObject activeFileObject) {
        this.activeFileObject = activeFileObject;
    }

    public FileObject getActiveFolder() {
        return this.activeFolder;
    }

    public void setActiveFolder(FileObject activeFolder) {
        this.activeFolder = activeFolder;
    }

    @Override
    public String getFilterPath() {
        return this.filterPath;
    }

    @Override
    public void setFilterPath(String filterPath) {
        this.filterPath = this.variables.resolve(filterPath);
    }

    public boolean isShowingHiddenFiles() {
        return this.showingHiddenFiles;
    }

    public void setShowingHiddenFiles(boolean showingHiddenFiles) {
        this.showingHiddenFiles = showingHiddenFiles;
    }

    public String getMessage() {
        return this.message;
    }

    public boolean isBrowsingDirectories() {
        return this.browsingDirectories;
    }

    public void setBrowsingDirectories(boolean browsingDirectories) {
        this.browsingDirectories = browsingDirectories;
    }

    public boolean isSavingFile() {
        return this.savingFile;
    }

    public void setSavingFile(boolean savingFile) {
        this.savingFile = savingFile;
    }

    public String getSaveFilename() {
        return this.saveFilename;
    }

    public void setSaveFilename(String saveFilename) {
        this.saveFilename = saveFilename;
    }

    public void updateSelection() {
        FileObject file = this.getSelectedFileObject();
        boolean isEnabled = false;
        if (file != null) {
            try {
                if (file.getParent() != null) {
                    isEnabled = true;
                }
            }
            catch (FileSystemException fileSystemException) {
                // empty catch block
            }
        }
        this.browserToolbarWidgets.enableToolbarItem(BROWSER_ITEM_ID_DELETE, isEnabled);
        this.browserToolbarWidgets.enableToolbarItem(BROWSER_ITEM_ID_RENAME, isEnabled);
    }
}

