/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.workflow.actions.sftpput;

import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileType;
import org.apache.hop.core.Const;
import org.apache.hop.core.ICheckResult;
import org.apache.hop.core.ICheckResultSource;
import org.apache.hop.core.Result;
import org.apache.hop.core.ResultFile;
import org.apache.hop.core.RowMetaAndData;
import org.apache.hop.core.annotations.Action;
import org.apache.hop.core.encryption.Encr;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.exception.HopXmlException;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.core.vfs.HopVfs;
import org.apache.hop.core.xml.XmlHandler;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.metadata.api.IHopMetadataProvider;
import org.apache.hop.resource.IResourceHolder;
import org.apache.hop.resource.ResourceEntry;
import org.apache.hop.resource.ResourceReference;
import org.apache.hop.workflow.WorkflowMeta;
import org.apache.hop.workflow.action.ActionBase;
import org.apache.hop.workflow.action.IAction;
import org.apache.hop.workflow.action.validator.ActionValidatorUtils;
import org.apache.hop.workflow.action.validator.AndValidator;
import org.apache.hop.workflow.action.validator.IActionValidator;
import org.apache.hop.workflow.actions.sftp.SftpClient;
import org.w3c.dom.Node;

@Action(id="SFTPPUT", name="i18n::ActionSFTPPut.Name", description="i18n::ActionSFTPPut.Description", image="SFTPPut.svg", categoryDescription="i18n:org.apache.hop.workflow:ActionCategory.Category.FileTransfer", keywords={"i18n::ActionSftpPut.keyword"}, documentationUrl="/workflow/actions/sftpput.html")
public class ActionSftpPut
extends ActionBase
implements Cloneable,
IAction {
    private static final Class<?> PKG = ActionSftpPut.class;
    private static final String CONST_SPACE_SHORT = "      ";
    private static final String CONST_PASSWORD = "password";
    private int afterFtps = 0;
    public static final String[] afterFtpsDesc = new String[]{BaseMessages.getString(PKG, (String)"ActionSftpPut.AfterSFTP.DoNothing.Label", (String[])new String[0]), BaseMessages.getString(PKG, (String)"ActionSftpPut.AfterSFTP.Delete.Label", (String[])new String[0]), BaseMessages.getString(PKG, (String)"ActionSftpPut.AfterSFTP.Move.Label", (String[])new String[0])};
    public static final String[] afterFtpsCode = new String[]{"nothing", "delete", "move"};
    public static final int AFTER_FTPSPUT_NOTHING = 0;
    public static final int AFTER_FTPSPUT_DELETE = 1;
    public static final int AFTER_FTPSPUT_MOVE = 2;
    private String serverName = null;
    private String serverPort = "22";
    private String userName;
    private String password;
    private String remoteDirectory;
    private String localDirectory;
    private String wildcard;
    private boolean copyingPrevious = false;
    private boolean copyingPreviousFiles = false;
    private boolean addFilenameResut = false;
    private boolean useKeyFilename = false;
    private String keyFilename = null;
    private String keyFilePassword = null;
    private String compression = "none";
    private boolean createRemoteFolder = false;
    private String proxyType = null;
    private String proxyHost = null;
    private String proxyPort = null;
    private String proxyUsername = null;
    private String proxyPassword = null;
    private String destinationFolder = null;
    private boolean createDestinationFolder = false;
    private boolean successWhenNoFile = false;

    public ActionSftpPut(String n) {
        super(n, "");
    }

    public ActionSftpPut() {
        this("");
    }

    public Object clone() {
        ActionSftpPut je = (ActionSftpPut)super.clone();
        return je;
    }

    public String getXml() {
        StringBuilder retval = new StringBuilder(300);
        retval.append(super.getXml());
        retval.append(CONST_SPACE_SHORT).append(XmlHandler.addTagValue((String)"servername", (String)this.serverName));
        retval.append(CONST_SPACE_SHORT).append(XmlHandler.addTagValue((String)"serverport", (String)this.serverPort));
        retval.append(CONST_SPACE_SHORT).append(XmlHandler.addTagValue((String)"username", (String)this.userName));
        retval.append(CONST_SPACE_SHORT).append(XmlHandler.addTagValue((String)CONST_PASSWORD, (String)Encr.encryptPasswordIfNotUsingVariables((String)this.password)));
        retval.append(CONST_SPACE_SHORT).append(XmlHandler.addTagValue((String)"sftpdirectory", (String)this.remoteDirectory));
        retval.append(CONST_SPACE_SHORT).append(XmlHandler.addTagValue((String)"localdirectory", (String)this.localDirectory));
        retval.append(CONST_SPACE_SHORT).append(XmlHandler.addTagValue((String)"wildcard", (String)this.wildcard));
        retval.append(CONST_SPACE_SHORT).append(XmlHandler.addTagValue((String)"copyprevious", (boolean)this.copyingPrevious));
        retval.append(CONST_SPACE_SHORT).append(XmlHandler.addTagValue((String)"copypreviousfiles", (boolean)this.copyingPreviousFiles));
        retval.append(CONST_SPACE_SHORT).append(XmlHandler.addTagValue((String)"addFilenameResut", (boolean)this.addFilenameResut));
        retval.append(CONST_SPACE_SHORT).append(XmlHandler.addTagValue((String)"usekeyfilename", (boolean)this.useKeyFilename));
        retval.append(CONST_SPACE_SHORT).append(XmlHandler.addTagValue((String)"keyfilename", (String)this.keyFilename));
        retval.append(CONST_SPACE_SHORT).append(XmlHandler.addTagValue((String)"keyfilepass", (String)Encr.encryptPasswordIfNotUsingVariables((String)this.keyFilePassword)));
        retval.append(CONST_SPACE_SHORT).append(XmlHandler.addTagValue((String)"compression", (String)this.compression));
        retval.append(CONST_SPACE_SHORT).append(XmlHandler.addTagValue((String)"proxyType", (String)this.proxyType));
        retval.append(CONST_SPACE_SHORT).append(XmlHandler.addTagValue((String)"proxyHost", (String)this.proxyHost));
        retval.append(CONST_SPACE_SHORT).append(XmlHandler.addTagValue((String)"proxyPort", (String)this.proxyPort));
        retval.append(CONST_SPACE_SHORT).append(XmlHandler.addTagValue((String)"proxyUsername", (String)this.proxyUsername));
        retval.append(CONST_SPACE_SHORT).append(XmlHandler.addTagValue((String)"proxyPassword", (String)Encr.encryptPasswordIfNotUsingVariables((String)this.proxyPassword)));
        retval.append(CONST_SPACE_SHORT).append(XmlHandler.addTagValue((String)"createRemoteFolder", (boolean)this.createRemoteFolder));
        retval.append(CONST_SPACE_SHORT).append(XmlHandler.addTagValue((String)"aftersftpput", (String)ActionSftpPut.getAfterSftpPutCode(this.getAfterFtps())));
        retval.append(CONST_SPACE_SHORT).append(XmlHandler.addTagValue((String)"destinationfolder", (String)this.destinationFolder));
        retval.append(CONST_SPACE_SHORT).append(XmlHandler.addTagValue((String)"createdestinationfolder", (boolean)this.createDestinationFolder));
        retval.append(CONST_SPACE_SHORT).append(XmlHandler.addTagValue((String)"successWhenNoFile", (boolean)this.successWhenNoFile));
        return retval.toString();
    }

    public static String getAfterSftpPutCode(int i) {
        if (i < 0 || i >= afterFtpsCode.length) {
            return afterFtpsCode[0];
        }
        return afterFtpsCode[i];
    }

    public void loadXml(Node entrynode, IHopMetadataProvider metadataProvider, IVariables variables) throws HopXmlException {
        try {
            super.loadXml(entrynode);
            this.serverName = XmlHandler.getTagValue((Node)entrynode, (String)"servername");
            this.serverPort = XmlHandler.getTagValue((Node)entrynode, (String)"serverport");
            this.userName = XmlHandler.getTagValue((Node)entrynode, (String)"username");
            this.password = Encr.decryptPasswordOptionallyEncrypted((String)XmlHandler.getTagValue((Node)entrynode, (String)CONST_PASSWORD));
            this.remoteDirectory = XmlHandler.getTagValue((Node)entrynode, (String)"sftpdirectory");
            this.localDirectory = XmlHandler.getTagValue((Node)entrynode, (String)"localdirectory");
            this.wildcard = XmlHandler.getTagValue((Node)entrynode, (String)"wildcard");
            this.copyingPrevious = "Y".equalsIgnoreCase(XmlHandler.getTagValue((Node)entrynode, (String)"copyprevious"));
            this.copyingPreviousFiles = "Y".equalsIgnoreCase(XmlHandler.getTagValue((Node)entrynode, (String)"copypreviousfiles"));
            this.addFilenameResut = "Y".equalsIgnoreCase(XmlHandler.getTagValue((Node)entrynode, (String)"addFilenameResut"));
            this.useKeyFilename = "Y".equalsIgnoreCase(XmlHandler.getTagValue((Node)entrynode, (String)"usekeyfilename"));
            this.keyFilename = XmlHandler.getTagValue((Node)entrynode, (String)"keyfilename");
            this.keyFilePassword = Encr.decryptPasswordOptionallyEncrypted((String)XmlHandler.getTagValue((Node)entrynode, (String)"keyfilepass"));
            this.compression = XmlHandler.getTagValue((Node)entrynode, (String)"compression");
            this.proxyType = XmlHandler.getTagValue((Node)entrynode, (String)"proxyType");
            this.proxyHost = XmlHandler.getTagValue((Node)entrynode, (String)"proxyHost");
            this.proxyPort = XmlHandler.getTagValue((Node)entrynode, (String)"proxyPort");
            this.proxyUsername = XmlHandler.getTagValue((Node)entrynode, (String)"proxyUsername");
            this.proxyPassword = Encr.decryptPasswordOptionallyEncrypted((String)XmlHandler.getTagValue((Node)entrynode, (String)"proxyPassword"));
            this.createRemoteFolder = "Y".equalsIgnoreCase(XmlHandler.getTagValue((Node)entrynode, (String)"createRemoteFolder"));
            boolean remove = "Y".equalsIgnoreCase(XmlHandler.getTagValue((Node)entrynode, (String)"remove"));
            this.setAfterFtps(ActionSftpPut.getAfterSftpPutByCode(Const.NVL((String)XmlHandler.getTagValue((Node)entrynode, (String)"aftersftpput"), (String)"")));
            if (remove && this.getAfterFtps() == 0) {
                this.setAfterFtps(1);
            }
            this.destinationFolder = XmlHandler.getTagValue((Node)entrynode, (String)"destinationfolder");
            this.createDestinationFolder = "Y".equalsIgnoreCase(XmlHandler.getTagValue((Node)entrynode, (String)"createdestinationfolder"));
            this.successWhenNoFile = "Y".equalsIgnoreCase(XmlHandler.getTagValue((Node)entrynode, (String)"successWhenNoFile"));
        }
        catch (HopXmlException xe) {
            throw new HopXmlException("Unable to load action of type 'SFTPPUT' from XML node", (Throwable)xe);
        }
    }

    public static int getAfterSftpPutByCode(String tt) {
        if (tt == null) {
            return 0;
        }
        for (int i = 0; i < afterFtpsCode.length; ++i) {
            if (!afterFtpsCode[i].equalsIgnoreCase(tt)) continue;
            return i;
        }
        return 0;
    }

    public static String getAfterSftpPutDesc(int i) {
        if (i < 0 || i >= afterFtpsDesc.length) {
            return afterFtpsDesc[0];
        }
        return afterFtpsDesc[i];
    }

    public static int getAfterSftpPutByDesc(String tt) {
        if (tt == null) {
            return 0;
        }
        for (int i = 0; i < afterFtpsDesc.length; ++i) {
            if (!afterFtpsDesc[i].equalsIgnoreCase(tt)) continue;
            return i;
        }
        return ActionSftpPut.getAfterSftpPutByCode(tt);
    }

    public void setCreateDestinationFolder(boolean createDestinationFolder) {
        this.createDestinationFolder = createDestinationFolder;
    }

    public boolean isCreateDestinationFolder() {
        return this.createDestinationFolder;
    }

    public void setSuccessWhenNoFile(boolean successWhenNoFile) {
        this.successWhenNoFile = successWhenNoFile;
    }

    public boolean isSuccessWhenNoFile() {
        return this.successWhenNoFile;
    }

    public void setDestinationFolder(String destinationfolderin) {
        this.destinationFolder = destinationfolderin;
    }

    public String getDestinationFolder() {
        return this.destinationFolder;
    }

    public int getAfterFtps() {
        return this.afterFtps;
    }

    public void setAfterFtps(int value) {
        this.afterFtps = value;
    }

    public String getScpDirectory() {
        return this.remoteDirectory;
    }

    public void setScpDirectory(String directory) {
        this.remoteDirectory = directory;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getServerName() {
        return this.serverName;
    }

    public void setServerName(String serverName) {
        this.serverName = serverName;
    }

    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public String getWildcard() {
        return this.wildcard;
    }

    public void setWildcard(String wildcard) {
        this.wildcard = wildcard;
    }

    public String getLocalDirectory() {
        return this.localDirectory;
    }

    public void setLocalDirectory(String localDirectory) {
        this.localDirectory = localDirectory;
    }

    public boolean isCopyPrevious() {
        return this.copyingPrevious;
    }

    public void setCopyPrevious(boolean copyprevious) {
        this.copyingPrevious = copyprevious;
    }

    public boolean isCopyPreviousFiles() {
        return this.copyingPreviousFiles;
    }

    public void setCopyPreviousFiles(boolean copypreviousfiles) {
        this.copyingPreviousFiles = copypreviousfiles;
    }

    public boolean isAddFilenameResut() {
        return this.addFilenameResut;
    }

    public boolean isUseKeyFile() {
        return this.useKeyFilename;
    }

    public void setUseKeyFile(boolean value) {
        this.useKeyFilename = value;
    }

    public String getKeyFilename() {
        return this.keyFilename;
    }

    public void setKeyFilename(String value) {
        this.keyFilename = value;
    }

    public String getKeyPassPhrase() {
        return this.keyFilePassword;
    }

    public void setKeyPassPhrase(String value) {
        this.keyFilePassword = value;
    }

    public void setAddFilenameResut(boolean addFilenameResut) {
        this.addFilenameResut = addFilenameResut;
    }

    public String getCompression() {
        return this.compression;
    }

    public void setCompression(String compression) {
        this.compression = compression;
    }

    public String getServerPort() {
        return this.serverPort;
    }

    public void setServerPort(String serverPort) {
        this.serverPort = serverPort;
    }

    public String getProxyType() {
        return this.proxyType;
    }

    public void setProxyType(String value) {
        this.proxyType = value;
    }

    public String getProxyHost() {
        return this.proxyHost;
    }

    public void setProxyHost(String value) {
        this.proxyHost = value;
    }

    public String getProxyPort() {
        return this.proxyPort;
    }

    public void setProxyPort(String value) {
        this.proxyPort = value;
    }

    public String getProxyUsername() {
        return this.proxyUsername;
    }

    public void setProxyUsername(String value) {
        this.proxyUsername = value;
    }

    public String getProxyPassword() {
        return this.proxyPassword;
    }

    public void setProxyPassword(String value) {
        this.proxyPassword = value;
    }

    public boolean isCreateRemoteFolder() {
        return this.createRemoteFolder;
    }

    public void setCreateRemoteFolder(boolean value) {
        this.createRemoteFolder = value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public Result execute(Result previousResult, int nr) throws HopException {
        block92: {
            result = previousResult;
            rows = result.getRows();
            result.setResult(false);
            if (this.isDetailed()) {
                this.logDetailed(BaseMessages.getString(ActionSftpPut.PKG, (String)"ActionSftpPut.Log.StartAction", (String[])new String[0]));
            }
            myFileList = new ArrayList<FileObject>();
            if (this.copyingPrevious) {
                if (rows.isEmpty()) {
                    if (this.isDetailed()) {
                        this.logDetailed(BaseMessages.getString(ActionSftpPut.PKG, (String)"ActionSftpPut.ArgsFromPreviousNothing", (String[])new String[0]));
                    }
                    result.setResult(true);
                    return result;
                }
                try {
                    resultRow = null;
                    for (iteration = 0; iteration < rows.size(); ++iteration) {
                        resultRow = (RowMetaAndData)rows.get(iteration);
                        filePrevious = resultRow.getString(0, null);
                        if (Utils.isEmpty((CharSequence)filePrevious)) continue;
                        file = HopVfs.getFileObject((String)filePrevious);
                        if (!file.exists()) {
                            this.logError(BaseMessages.getString(ActionSftpPut.PKG, (String)"ActionSftpPut.Log.FilefromPreviousNotFound", (String[])new String[]{filePrevious}));
                            continue;
                        }
                        myFileList.add(file);
                        if (!this.isDebug()) continue;
                        this.logDebug(BaseMessages.getString(ActionSftpPut.PKG, (String)"ActionSftpPut.Log.FilenameFromResult", (String[])new String[]{filePrevious}));
                    }
                }
                catch (Exception e) {
                    this.logError(BaseMessages.getString(ActionSftpPut.PKG, (String)"ActionSftpPut.Error.ArgFromPrevious", (String[])new String[0]));
                    result.setNrErrors(1L);
                    myFileList = null;
                    return result;
                }
            }
            if (this.copyingPreviousFiles) {
                resultFiles = result.getResultFilesList();
                if (Utils.isEmpty((Collection)resultFiles)) {
                    if (this.isDetailed()) {
                        this.logDetailed(BaseMessages.getString(ActionSftpPut.PKG, (String)"ActionSftpPut.ArgsFromPreviousNothingFiles", (String[])new String[0]));
                    }
                    result.setResult(true);
                    return result;
                }
                try {
                    it = resultFiles.iterator();
                    while (it.hasNext() && !this.parentWorkflow.isStopped()) {
                        resultFile = (ResultFile)it.next();
                        file = resultFile.getFile();
                        if (file == null) continue;
                        if (!file.exists()) {
                            this.logError(BaseMessages.getString(ActionSftpPut.PKG, (String)"ActionSftpPut.Log.FilefromPreviousNotFound", (String[])new String[]{file.toString()}));
                            continue;
                        }
                        myFileList.add(file);
                        if (!this.isDebug()) continue;
                        this.logDebug(BaseMessages.getString(ActionSftpPut.PKG, (String)"ActionSftpPut.Log.FilenameFromResult", (String[])new String[]{file.toString()}));
                    }
                }
                catch (Exception e) {
                    this.logError(BaseMessages.getString(ActionSftpPut.PKG, (String)"ActionSftpPut.Error.ArgFromPrevious", (String[])new String[0]));
                    result.setNrErrors(1L);
                    myFileList = null;
                    return result;
                }
            }
            sftpclient = null;
            realServerName = this.resolve(this.serverName);
            realServerPort = this.resolve(this.serverPort);
            realUsername = this.resolve(this.userName);
            realPassword = Encr.decryptPasswordOptionallyEncrypted((String)this.resolve(this.password));
            realSftpDirString = this.resolve(this.remoteDirectory);
            realWildcard = this.resolve(this.wildcard);
            realLocalDirectory = this.resolve(this.localDirectory);
            realKeyFilename = null;
            realPassPhrase = null;
            realDestinationFolder = this.resolve(this.getDestinationFolder());
            try {
                if (this.getAfterFtps() == 2) {
                    if (Utils.isEmpty((CharSequence)realDestinationFolder)) {
                        this.logError(BaseMessages.getString(ActionSftpPut.PKG, (String)"ActionSSH2PUT.Log.DestinatFolderMissing", (String[])new String[0]));
                        result.setNrErrors(1L);
                        var17_21 = result;
                        return var17_21;
                    }
                    folder = null;
                    try {
                        folder = HopVfs.getFileObject((String)realDestinationFolder);
                        if (!folder.exists()) {
                            if (this.createDestinationFolder) {
                                folder.createFolder();
                            } else {
                                this.logError(BaseMessages.getString(ActionSftpPut.PKG, (String)"ActionSSH2PUT.Log.DestinatFolderNotExist", (String[])new String[]{realDestinationFolder}));
                                result.setNrErrors(1L);
                                var18_27 = result;
                                return var18_27;
                            }
                        }
                        realDestinationFolder = HopVfs.getFilename((FileObject)folder);
                    }
                    catch (Exception e) {
                        throw new HopException((Throwable)e);
                    }
                    finally {
                        if (folder != null) {
                            try {
                                folder.close();
                            }
                            catch (Exception var21_42) {}
                        }
                    }
                }
                if (this.isUseKeyFile()) {
                    realKeyFilename = this.resolve(this.getKeyFilename());
                    if (Utils.isEmpty((CharSequence)realKeyFilename)) {
                        this.logError(BaseMessages.getString(ActionSftpPut.PKG, (String)"ActionSftp.Error.KeyFileMissing", (String[])new String[0]));
                        result.setNrErrors(1L);
                        folder = result;
                        return folder;
                    }
                    if (!HopVfs.fileExists((String)realKeyFilename)) {
                        this.logError(BaseMessages.getString(ActionSftpPut.PKG, (String)"ActionSftp.Error.KeyFileNotFound", (String[])new String[0]));
                        result.setNrErrors(1L);
                        folder = result;
                        return folder;
                    }
                    realPassPhrase = this.resolve(this.getKeyPassPhrase());
                }
                sftpclient = new SftpClient(InetAddress.getByName(realServerName), Const.toInt((String)realServerPort, (int)22), realUsername, realKeyFilename, realPassPhrase);
                if (this.isDetailed()) {
                    this.logDetailed(BaseMessages.getString(ActionSftpPut.PKG, (String)"ActionSftpPut.Log.OpenedConnection", (String[])new String[]{realServerName, realServerPort, realUsername}));
                }
                sftpclient.setCompression(this.getCompression());
                realProxyHost = this.resolve(this.getProxyHost());
                if (!Utils.isEmpty((CharSequence)realProxyHost)) {
                    sftpclient.setProxy(realProxyHost, this.resolve(this.getProxyPort()), this.resolve(this.getProxyUsername()), this.resolve(this.getProxyPassword()), this.getProxyType());
                }
                sftpclient.login(realPassword);
                if (!Utils.isEmpty((CharSequence)realSftpDirString)) {
                    existfolder = sftpclient.folderExists(realSftpDirString);
                    if (!existfolder) {
                        if (!this.isCreateRemoteFolder()) {
                            throw new HopException(BaseMessages.getString(ActionSftpPut.PKG, (String)"ActionSftpPut.Error.CanNotFindRemoteFolder", (String[])new String[]{realSftpDirString}));
                        }
                        if (this.isDetailed()) {
                            this.logDetailed(BaseMessages.getString(ActionSftpPut.PKG, (String)"ActionSftpPut.Error.CanNotFindRemoteFolder", (String[])new String[]{realSftpDirString}));
                        }
                        sftpclient.createFolder(realSftpDirString);
                        if (this.isDetailed()) {
                            this.logDetailed(BaseMessages.getString(ActionSftpPut.PKG, (String)"ActionSftpPut.Log.RemoteFolderCreated", (String[])new String[]{realSftpDirString}));
                        }
                    }
                    sftpclient.chdir(realSftpDirString);
                    if (this.isDetailed()) {
                        this.logDetailed(BaseMessages.getString(ActionSftpPut.PKG, (String)"ActionSftpPut.Log.ChangedDirectory", (String[])new String[]{realSftpDirString}));
                    }
                }
                if (!this.copyingPrevious && !this.copyingPreviousFiles) {
                    myFileList = new ArrayList<E>();
                    localFiles = HopVfs.getFileObject((String)realLocalDirectory);
                    children = localFiles.getChildren();
                    if (children != null) {
                        for (i = 0; i < children.length; ++i) {
                            if (!children[i].getType().equals((Object)FileType.FILE)) continue;
                            myFileList.add(children[i]);
                        }
                    }
                }
                if (this.isDetailed()) {
                    this.logDetailed(BaseMessages.getString(ActionSftpPut.PKG, (String)"ActionSftpPut.Log.RowsFromPreviousResult", (Object[])new Object[]{myFileList.size()}));
                }
                pattern = null;
                if (!(this.copyingPrevious || this.copyingPreviousFiles || Utils.isEmpty((CharSequence)realWildcard))) {
                    pattern = Pattern.compile(realWildcard);
                }
                nrFilesSent = 0;
                nrFilesMatched = 0;
                it = myFileList.iterator();
lbl154:
                // 13 sources

                block54: while (it.hasNext() && !this.parentWorkflow.isStopped()) {
                    myFile = (FileObject)it.next();
                    try {
                        localFilename = myFile.toString();
                        destinationFilename = myFile.getName().getBaseName();
                        getIt = true;
                        if (pattern != null) {
                            matcher = pattern.matcher(destinationFilename);
                            getIt = matcher.matches();
                        }
                        if (!getIt) continue;
                        ++nrFilesMatched;
                        if (this.isDebug()) {
                            this.logDebug(BaseMessages.getString(ActionSftpPut.PKG, (String)"ActionSftpPut.Log.PuttingFile", (String[])new String[]{localFilename, realSftpDirString}));
                        }
                        sftpclient.put(myFile, destinationFilename);
                        ++nrFilesSent;
                        if (this.isDetailed()) {
                            this.logDetailed(BaseMessages.getString(ActionSftpPut.PKG, (String)"ActionSftpPut.Log.TransferredFile", (String[])new String[]{localFilename}));
                        }
                        switch (this.getAfterFtps()) {
                            case 1: {
                                myFile.delete();
                                if (!this.isDetailed()) continue block54;
                                this.logDetailed(BaseMessages.getString(ActionSftpPut.PKG, (String)"ActionSftpPut.Log.DeletedFile", (String[])new String[]{localFilename}));
                                ** break;
                            }
                            case 2: {
                                destination = null;
                                try {
                                    destination = HopVfs.getFileObject((String)(realDestinationFolder + Const.FILE_SEPARATOR + myFile.getName().getBaseName()));
                                    myFile.moveTo(destination);
                                    if (!this.isDetailed()) continue block54;
                                    this.logDetailed(BaseMessages.getString(ActionSftpPut.PKG, (String)"ActionSftpPut.Log.FileMoved", (Object[])new Object[]{myFile, destination}));
                                    continue block54;
                                }
                                finally {
                                    if (destination == null) continue block54;
                                    destination.close();
                                    continue block54;
                                }
                            }
                            default: {
                                if (!this.addFilenameResut) continue block54;
                                resultFile = new ResultFile(0, myFile, this.parentWorkflow.getWorkflowName(), this.toString());
                                result.getResultFiles().put(resultFile.getFile().toString(), resultFile);
                                if (!this.isDetailed()) continue block54;
                                this.logDetailed(BaseMessages.getString(ActionSftpPut.PKG, (String)"ActionSftpPut.Log.FilenameAddedToResultFilenames", (String[])new String[]{localFilename}));
                                continue block54;
                            }
                        }
                    }
                    finally {
                        if (myFile == null) continue;
                        myFile.close();
                    }
                }
                result.setResult(true);
                result.setNrFilesRetrieved((long)nrFilesSent);
                if (nrFilesMatched != 0) break block92;
                if (this.isSuccessWhenNoFile()) {
                    if (this.isBasic()) {
                        this.logBasic(BaseMessages.getString(ActionSftpPut.PKG, (String)"ActionSftpPut.Error.NoFileToSend", (String[])new String[0]));
                    }
                    break block92;
                }
                this.logError(BaseMessages.getString(ActionSftpPut.PKG, (String)"ActionSftpPut.Error.NoFileToSend", (String[])new String[0]));
                result.setNrErrors(1L);
                result.setResult(false);
                var22_44 = result;
                return var22_44;
            }
            catch (Exception e) {
                result.setNrErrors(1L);
                this.logError(BaseMessages.getString(ActionSftpPut.PKG, (String)"ActionSftpPut.Exception", (String[])new String[]{e.getMessage()}));
                this.logError(Const.getStackTracker((Throwable)e));
            }
            finally {
                try {
                    if (sftpclient != null) {
                        sftpclient.disconnect();
                    }
                }
                catch (Exception var17_25) {}
                myFileList = null;
            }
        }
        return result;
    }

    public boolean isEvaluation() {
        return true;
    }

    public List<ResourceReference> getResourceDependencies(IVariables variables, WorkflowMeta workflowMeta) {
        List references = super.getResourceDependencies(variables, workflowMeta);
        if (!Utils.isEmpty((CharSequence)this.serverName)) {
            String realServerName = this.resolve(this.serverName);
            ResourceReference reference = new ResourceReference((IResourceHolder)this);
            reference.getEntries().add(new ResourceEntry(realServerName, ResourceEntry.ResourceType.SERVER));
            references.add(reference);
        }
        return references;
    }

    public void check(List<ICheckResult> remarks, WorkflowMeta workflowMeta, IVariables variables, IHopMetadataProvider metadataProvider) {
        ActionValidatorUtils.andValidator().validate((ICheckResultSource)this, "serverName", remarks, AndValidator.putValidators((IActionValidator[])new IActionValidator[]{ActionValidatorUtils.notBlankValidator()}));
        ActionValidatorUtils.andValidator().validate((ICheckResultSource)this, "localDirectory", remarks, AndValidator.putValidators((IActionValidator[])new IActionValidator[]{ActionValidatorUtils.notBlankValidator(), ActionValidatorUtils.fileExistsValidator()}));
        ActionValidatorUtils.andValidator().validate((ICheckResultSource)this, "userName", remarks, AndValidator.putValidators((IActionValidator[])new IActionValidator[]{ActionValidatorUtils.notBlankValidator()}));
        ActionValidatorUtils.andValidator().validate((ICheckResultSource)this, CONST_PASSWORD, remarks, AndValidator.putValidators((IActionValidator[])new IActionValidator[]{ActionValidatorUtils.notNullValidator()}));
        ActionValidatorUtils.andValidator().validate((ICheckResultSource)this, "serverPort", remarks, AndValidator.putValidators((IActionValidator[])new IActionValidator[]{ActionValidatorUtils.integerValidator()}));
    }
}

