/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.workflow.actions.xml.dtdvalidator;

import java.util.List;
import lombok.Generated;
import org.apache.hop.core.ICheckResult;
import org.apache.hop.core.ICheckResultSource;
import org.apache.hop.core.Result;
import org.apache.hop.core.annotations.Action;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.metadata.api.HopMetadataProperty;
import org.apache.hop.metadata.api.IHopMetadataProvider;
import org.apache.hop.resource.IResourceHolder;
import org.apache.hop.resource.ResourceEntry;
import org.apache.hop.resource.ResourceReference;
import org.apache.hop.workflow.WorkflowMeta;
import org.apache.hop.workflow.action.ActionBase;
import org.apache.hop.workflow.action.IAction;
import org.apache.hop.workflow.action.validator.AbstractFileValidator;
import org.apache.hop.workflow.action.validator.ActionValidatorUtils;
import org.apache.hop.workflow.action.validator.AndValidator;
import org.apache.hop.workflow.action.validator.IActionValidator;
import org.apache.hop.workflow.action.validator.ValidatorContext;
import org.apache.hop.workflow.actions.xml.dtdvalidator.DtdValidatorUtil;

@Action(id="DTD_VALIDATOR", name="i18n::DTD_VALIDATOR.Name", description="i18n::DTD_VALIDATOR.Description", image="DTD.svg", categoryDescription="i18n::DTD_VALIDATOR.Category", keywords={"i18n::DtdValidator.keyword"}, documentationUrl="/workflow/actions/dtdvalidator.html")
public class DtdValidator
extends ActionBase
implements Cloneable,
IAction {
    @HopMetadataProperty(key="xmlfilename")
    private String xmlFilename = null;
    @HopMetadataProperty(key="dtdfilename")
    private String dtdFilename = null;
    @HopMetadataProperty(key="dtdintern")
    private String dtdIntern = "N";

    public DtdValidator(String n) {
        super(n, "");
    }

    public DtdValidator() {
        this("");
    }

    public Object clone() {
        DtdValidator je = (DtdValidator)super.clone();
        return je;
    }

    public String getRealxmlfilename() {
        return this.resolve(this.xmlFilename);
    }

    public String getRealDTDfilename() {
        return this.resolve(this.dtdFilename);
    }

    public Result execute(Result previousResult, int nr) {
        Result result = previousResult;
        result.setResult(true);
        String realxmlfilename = this.getRealxmlfilename();
        String realDTDfilename = this.getRealDTDfilename();
        DtdValidatorUtil validator = new DtdValidatorUtil(this.getLogChannel());
        validator.setXMLFilename(realxmlfilename);
        if ("Y".equals(this.dtdIntern)) {
            validator.setInternDTD(true);
        } else {
            validator.setDTDFilename(realDTDfilename);
        }
        boolean status = validator.validate();
        if (!status) {
            this.logError(validator.getErrorMessage());
            result.setResult(false);
            result.setNrErrors((long)validator.getNrErrors());
            result.setLogText(validator.getErrorMessage());
        }
        return result;
    }

    public boolean isEvaluation() {
        return true;
    }

    public List<ResourceReference> getResourceDependencies(IVariables variables, WorkflowMeta workflowMeta) {
        List references = super.getResourceDependencies(variables, workflowMeta);
        if (!Utils.isEmpty((CharSequence)this.dtdFilename) && !Utils.isEmpty((CharSequence)this.xmlFilename)) {
            String realXmlFileName = variables.resolve(this.xmlFilename);
            String realXsdFileName = variables.resolve(this.dtdFilename);
            ResourceReference reference = new ResourceReference((IResourceHolder)this);
            reference.getEntries().add(new ResourceEntry(realXmlFileName, ResourceEntry.ResourceType.FILE));
            reference.getEntries().add(new ResourceEntry(realXsdFileName, ResourceEntry.ResourceType.FILE));
            references.add(reference);
        }
        return references;
    }

    public void check(List<ICheckResult> remarks, WorkflowMeta jobMeta, IVariables variables, IHopMetadataProvider metadataProvider) {
        ValidatorContext ctx = new ValidatorContext();
        AbstractFileValidator.putVariableSpace((ValidatorContext)ctx, (IVariables)this.getVariables());
        AndValidator.putValidators((ValidatorContext)ctx, (IActionValidator[])new IActionValidator[]{ActionValidatorUtils.notBlankValidator(), ActionValidatorUtils.fileExistsValidator()});
        ActionValidatorUtils.andValidator().validate((ICheckResultSource)this, this.dtdFilename, remarks, ctx);
        ActionValidatorUtils.andValidator().validate((ICheckResultSource)this, this.xmlFilename, remarks, ctx);
    }

    @Generated
    public String getXmlFilename() {
        return this.xmlFilename;
    }

    @Generated
    public String getDtdFilename() {
        return this.dtdFilename;
    }

    @Generated
    public String getDtdIntern() {
        return this.dtdIntern;
    }

    @Generated
    public void setXmlFilename(String xmlFilename) {
        this.xmlFilename = xmlFilename;
    }

    @Generated
    public void setDtdFilename(String dtdFilename) {
        this.dtdFilename = dtdFilename;
    }

    @Generated
    public void setDtdIntern(String dtdIntern) {
        this.dtdIntern = dtdIntern;
    }
}

