/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.agent.tool;

import dev.langchain4j.internal.Utils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Objects;

public class JsonSchemaProperty {
    public static final JsonSchemaProperty STRING = JsonSchemaProperty.type("string");
    public static final JsonSchemaProperty INTEGER = JsonSchemaProperty.type("integer");
    public static final JsonSchemaProperty NUMBER = JsonSchemaProperty.type("number");
    public static final JsonSchemaProperty OBJECT = JsonSchemaProperty.type("object");
    public static final JsonSchemaProperty ARRAY = JsonSchemaProperty.type("array");
    public static final JsonSchemaProperty BOOLEAN = JsonSchemaProperty.type("boolean");
    public static final JsonSchemaProperty NULL = JsonSchemaProperty.type("null");
    private final String key;
    private final Object value;

    public JsonSchemaProperty(String key, Object value) {
        this.key = key;
        this.value = value;
    }

    public String key() {
        return this.key;
    }

    public Object value() {
        return this.value;
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof JsonSchemaProperty && this.equalTo((JsonSchemaProperty)another);
    }

    private boolean equalTo(JsonSchemaProperty another) {
        if (!Objects.equals(this.key, another.key)) {
            return false;
        }
        if (this.value instanceof Object[] && another.value instanceof Object[]) {
            return Arrays.equals((Object[])this.value, (Object[])another.value);
        }
        return Objects.equals(this.value, another.value);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.key);
        int v = this.value instanceof Object[] ? Arrays.hashCode((Object[])this.value) : Objects.hashCode(this.value);
        h += (h << 5) + v;
        return h;
    }

    public String toString() {
        String valueString = this.value instanceof Object[] ? Arrays.toString((Object[])this.value) : this.value.toString();
        return "JsonSchemaProperty { key = " + Utils.quoted(this.key) + ", value = " + valueString + " }";
    }

    public static JsonSchemaProperty from(String key, Object value) {
        return new JsonSchemaProperty(key, value);
    }

    public static JsonSchemaProperty property(String key, Object value) {
        return JsonSchemaProperty.from(key, value);
    }

    public static JsonSchemaProperty type(String value) {
        return JsonSchemaProperty.from("type", value);
    }

    public static JsonSchemaProperty description(String value) {
        return JsonSchemaProperty.from("description", value);
    }

    public static JsonSchemaProperty enums(String ... enumValues) {
        return JsonSchemaProperty.from("enum", enumValues);
    }

    public static JsonSchemaProperty enums(Object ... enumValues) {
        ArrayList<String> enumNames = new ArrayList<String>();
        for (Object enumValue : enumValues) {
            if (!enumValue.getClass().isEnum()) {
                throw new RuntimeException("Value " + enumValue.getClass().getName() + " should be enum");
            }
            enumNames.add(((Enum)enumValue).name());
        }
        return JsonSchemaProperty.from("enum", enumNames);
    }

    public static JsonSchemaProperty enums(Class<?> enumClass) {
        if (!enumClass.isEnum()) {
            throw new RuntimeException("Class " + enumClass.getName() + " should be enum");
        }
        return JsonSchemaProperty.enums(enumClass.getEnumConstants());
    }

    public static JsonSchemaProperty items(JsonSchemaProperty type) {
        return JsonSchemaProperty.from("items", Collections.singletonMap(type.key, type.value));
    }
}

