/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.schemas;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import org.apache.beam.sdk.annotations.Internal;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.sdk.schemas.SchemaProvider;
import org.apache.beam.sdk.transforms.ProcessFunction;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.apache.beam.sdk.transforms.SimpleFunction;
import org.apache.beam.sdk.util.Preconditions;
import org.apache.beam.sdk.values.Row;
import org.apache.beam.sdk.values.TypeDescriptor;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

@Internal
public final class RowMessages {
    private RowMessages() {
    }

    public static <T> @UnknownKeyFor @NonNull @Initialized SimpleFunction<@UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [], @UnknownKeyFor @NonNull @Initialized Row> bytesToRowFn(@UnknownKeyFor @NonNull @Initialized SchemaProvider schemaProvider, @UnknownKeyFor @NonNull @Initialized TypeDescriptor<T> typeDescriptor, @UnknownKeyFor @NonNull @Initialized ProcessFunction<@UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [], @UnknownKeyFor @NonNull @Initialized ? extends T> fromBytesFn) {
        SerializableFunction<T, Row> toRowFn = Preconditions.checkArgumentNotNull(schemaProvider.toRowFunction(typeDescriptor));
        return new BytesToRowFn(fromBytesFn, toRowFn);
    }

    public static <T> @UnknownKeyFor @NonNull @Initialized SimpleFunction<@UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [], @UnknownKeyFor @NonNull @Initialized Row> bytesToRowFn(@UnknownKeyFor @NonNull @Initialized SchemaProvider schemaProvider, @UnknownKeyFor @NonNull @Initialized TypeDescriptor<T> typeDescriptor, @UnknownKeyFor @NonNull @Initialized Coder<@UnknownKeyFor @NonNull @Initialized ? extends T> coder) {
        return RowMessages.bytesToRowFn(schemaProvider, typeDescriptor, (byte[] bytes) -> coder.decode(new ByteArrayInputStream((byte[])bytes)));
    }

    public static <T> @UnknownKeyFor @NonNull @Initialized SimpleFunction<@UnknownKeyFor @NonNull @Initialized Row, @UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized []> rowToBytesFn(@UnknownKeyFor @NonNull @Initialized SchemaProvider schemaProvider, @UnknownKeyFor @NonNull @Initialized TypeDescriptor<T> typeDescriptor, @UnknownKeyFor @NonNull @Initialized ProcessFunction<@UnknownKeyFor @Nullable @Initialized ? super T, @UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized []> toBytesFn) {
        Schema schema = Preconditions.checkArgumentNotNull(schemaProvider.schemaFor(typeDescriptor));
        SerializableFunction<Row, T> fromRowFn = Preconditions.checkArgumentNotNull(schemaProvider.fromRowFunction(typeDescriptor));
        toBytesFn = Preconditions.checkArgumentNotNull(toBytesFn);
        return new RowToBytesFn(schema, fromRowFn, toBytesFn);
    }

    public static <T> @UnknownKeyFor @NonNull @Initialized SimpleFunction<@UnknownKeyFor @NonNull @Initialized Row, @UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized []> rowToBytesFn(@UnknownKeyFor @NonNull @Initialized SchemaProvider schemaProvider, @UnknownKeyFor @NonNull @Initialized TypeDescriptor<T> typeDescriptor, @UnknownKeyFor @NonNull @Initialized Coder<@UnknownKeyFor @Nullable @Initialized ? super T> coder) {
        return RowMessages.rowToBytesFn(schemaProvider, typeDescriptor, (? super T message) -> RowMessages.toBytes(coder, message));
    }

    private static <T> @UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [] toBytes(@UnknownKeyFor @NonNull @Initialized Coder<@UnknownKeyFor @Nullable @Initialized ? super T> coder, T message) throws @UnknownKeyFor @NonNull @Initialized IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        coder.encode(message, out);
        return out.toByteArray();
    }

    private static final class RowToBytesFn<@UnknownKeyFor T>
    extends SimpleFunction<Row, byte[]> {
        private final @UnknownKeyFor @NonNull @Initialized Schema schema;
        private final @UnknownKeyFor @NonNull @Initialized SerializableFunction<@UnknownKeyFor @NonNull @Initialized Row, T> fromRowFn;
        private final @UnknownKeyFor @NonNull @Initialized ProcessFunction<@UnknownKeyFor @Nullable @Initialized ? super T, @UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized []> toBytesFn;

        private RowToBytesFn(@UnknownKeyFor @NonNull @Initialized Schema schema, @UnknownKeyFor @NonNull @Initialized SerializableFunction<@UnknownKeyFor @NonNull @Initialized Row, T> fromRowFn, @UnknownKeyFor @NonNull @Initialized ProcessFunction<@UnknownKeyFor @Nullable @Initialized ? super T, @UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized []> toBytesFn) {
            this.schema = schema;
            this.fromRowFn = fromRowFn;
            this.toBytesFn = toBytesFn;
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [] apply(@UnknownKeyFor @NonNull @Initialized Row row) {
            if (!this.schema.equivalent(row.getSchema())) {
                row = this.switchFieldsOrder(row);
            }
            T message = this.fromRowFn.apply(row);
            try {
                return this.toBytesFn.apply(message);
            }
            catch (Exception e) {
                throw new IllegalStateException("Could not encode message as bytes", e);
            }
        }

        private @UnknownKeyFor @NonNull @Initialized Row switchFieldsOrder(@UnknownKeyFor @NonNull @Initialized Row row) {
            Row.Builder convertedRow = Row.withSchema(this.schema);
            this.schema.getFields().forEach(field -> convertedRow.addValue(row.getValue(field.getName())));
            return convertedRow.build();
        }
    }

    private static final class BytesToRowFn<@UnknownKeyFor T>
    extends SimpleFunction<byte[], Row> {
        private final @UnknownKeyFor @NonNull @Initialized ProcessFunction<@UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [], @UnknownKeyFor @NonNull @Initialized ? extends T> fromBytesFn;
        private final @UnknownKeyFor @NonNull @Initialized SerializableFunction<T, @UnknownKeyFor @NonNull @Initialized Row> toRowFn;

        private BytesToRowFn(@UnknownKeyFor @NonNull @Initialized ProcessFunction<@UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [], @UnknownKeyFor @NonNull @Initialized ? extends T> fromBytesFn, @UnknownKeyFor @NonNull @Initialized SerializableFunction<T, @UnknownKeyFor @NonNull @Initialized Row> toRowFn) {
            this.fromBytesFn = fromBytesFn;
            this.toRowFn = toRowFn;
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized Row apply(@UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [] bytes) {
            T message;
            try {
                message = this.fromBytesFn.apply(bytes);
            }
            catch (Exception e) {
                throw new IllegalStateException("Could not decode bytes as message", e);
            }
            return this.toRowFn.apply(message);
        }
    }
}

